<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/asset/captcha.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;
use Joomla\CMS\Captcha\Captcha;

/**
 * @var array    $displayData
 * @var Captcha  $captcha
 * @var string   $name
 * @var Registry $params
 */

extract($displayData);

$publicKey = $params->get('public_key');
$theme     = $params->get('theme');
echo $captcha->display(null, 'sr-reservation-recaptcha', 'g-recaptcha');

?>

<script>
    (function ($) {
        var confirmBox = $('#termsandconditions');

		<?php if ('recaptcha_invisible' === $name): ?>
        confirmBox.prop('disabled', true);
        var
            captchaEl = $('#sr-reservation-recaptcha'),
            options = captchaEl.data(),
            captchaWidgetId;
        options.callback = function () {
            confirmBox.prop('disabled', false);
        };

        captchaWidgetId = grecaptcha.render(captchaEl[0], options);
        grecaptcha.execute(captchaWidgetId);

		<?php elseif($params->get('version', '2.0') === '2.0'): ?>

        confirmBox.prop('disabled', true);
        grecaptcha.render('sr-reservation-recaptcha', {
            sitekey: '<?php echo $publicKey; ?>',
            theme: '<?php echo $theme; ?>',
            callback: function (res) {
                $('#termsandconditions').prop('disabled', false);
            }
        });

		<?php else: ?>

        Recaptcha.create('<?php echo $publicKey; ?>', 'sr-reservation-recaptcha', {
            theme: '<?php echo $theme; ?>'
        });

		<?php endif; ?>
    })(Solidres.jQuery);

</script>
