<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default_login.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

$loginLink    = "javascript:void(0)";
$registerLink = JRoute::_('index.php?option=com_users&view=registration');

if (
    isset($this->item->params['disable_customer_registration'])
    &&
    $this->item->params['disable_customer_registration'] == 0
) :
    echo '<i class="fa fa-sign-in"></i> ' . JText::sprintf('SR_ASK_FOR_LOGIN_REGISTER', $loginLink, $registerLink);
else :
	echo '<i class="fa fa-sign-in"></i> ' . JText::sprintf('SR_ASK_FOR_LOGIN', $loginLink);
endif;

$uri = JUri::getInstance();
if ($this->enableAutoScroll) :
    $uri->setFragment('book-form');
else :
	$uri->setFragment('');
endif;
?>

<form action="<?php echo JRoute::_($uri->toString()); ?>" method="post" class="form-inline" style="display: none" id="solidres-inline-login-form">
	<div class="well">
		<div class="<?php echo SR_UI_INPUT_PREPEND ?>">
				<span class="add-on input-group-text">
					<span class="fa fa-user uk-user hasTooltip" title="<?php echo JText::_('SR_USERNAME') ?>"></span>
						<label for="sr-modlgn-username"
						       class="element-invisible"><?php echo JText::_('SR_USERNAME'); ?></label>
				</span>
			<input id="sr-modlgn-username" type="text" name="username" class="input-small <?php echo SR_UI != 'bs2' ? 'form-control' : '' ?>" tabindex="0" size="18"
			       placeholder="<?php echo JText::_('SR_USERNAME'); ?>"/>
		</div>
		<div class="<?php echo SR_UI_INPUT_PREPEND ?>">
				<span class="add-on input-group-text">
					<span class="fa fa-lock uk-lock hasTooltip"
					      title="<?php echo JText::_('SR_PASSWORD') ?>"></span>
					<label for="sr-modlgn-password"
					       class="element-invisible"><?php echo JText::_('SR_PASSWORD'); ?></label>
				</span>
			<input id="sr-modlgn-password" type="password" name="password" class="input-small <?php echo SR_UI != 'bs2' ? 'form-control' : '' ?>" tabindex="0"
			       size="18" placeholder="<?php echo JText::_('SR_PASSWORD'); ?>"/>
		</div>
		<button type="submit" tabindex="0" name="Submit" class="btn btn-default">
			<i class="fa fa-sign-in uk-sign-in"></i>
			<?php echo JText::_('JLOGIN') ?>
		</button>
		<input type="hidden" name="option" value="com_users"/>
		<input type="hidden" name="task" value="user.login"/>
		<input type="hidden" name="return" value="<?php echo base64_encode(JRoute::_($uri->toString(), false)); ?>"/>
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>

