-- -----------------------------------------------------
-- Table `#__sr_countries`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_countries` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(45) NOT NULL ,
  `code_2` VARCHAR(10) NOT NULL ,
  `code_3` VARCHAR(10) NOT NULL ,
  `state` TINYINT(11) NOT NULL DEFAULT 0 ,
  `checked_out` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `created_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `is_default` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0' ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_geo_states`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_geo_states` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `country_id` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `name` VARCHAR(45) NOT NULL ,
  `code_2` VARCHAR(10) NOT NULL ,
  `code_3` VARCHAR(10) NOT NULL ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_geo_states_sr_countries1_idx` (`country_id` ASC) ,
  CONSTRAINT `fk_sr_geo_states_sr_countries1`
    FOREIGN KEY (`country_id` )
    REFERENCES `#__sr_countries` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_customer_groups`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_customer_groups` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `name` VARCHAR(255) NOT NULL ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_customers`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_customers` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `customer_group_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `user_id` INT(11) UNSIGNED NOT NULL COMMENT 'The Joomla User Id' ,
  `customer_code` VARCHAR(255) NULL ,
  `firstname` VARCHAR(255) NULL ,
  `middlename` VARCHAR(255) NULL ,
  `lastname` VARCHAR(255) NULL ,
  `vat_number` VARCHAR(255) NULL DEFAULT NULL,
  `company` VARCHAR(255) NULL,
  `phonenumber` VARCHAR(45) NULL,
  `mobilephone` VARCHAR(45) NULL,
  `address1` VARCHAR(255) NULL,
  `address2` VARCHAR(255) NULL,
  `city` VARCHAR(45) NULL,
  `zipcode` VARCHAR(45) NULL,
  `country_id` INT(11) UNSIGNED NULL DEFAULT NULL,
  `geo_state_id` INT(11) UNSIGNED NULL DEFAULT NULL,
  `api_key` VARCHAR(40) NULL,
  `api_secret` VARCHAR(40) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_sr_customers_sr_customer_groups1_idx` (`customer_group_id` ASC),
  INDEX `fk_sr_customers_sr_countries1_idx` (`country_id` ASC),
  INDEX `fk_sr_customers_sr_geo_states1_idx` (`geo_state_id` ASC),
  CONSTRAINT `fk_sr_customers_sr_customer_groups1`
    FOREIGN KEY (`customer_group_id` )
    REFERENCES `#__sr_customer_groups` (`id` )
	ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_customers_sr_countries1`
    FOREIGN KEY (`country_id`)
    REFERENCES `#__sr_countries` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_customers_sr_geo_states1`
  FOREIGN KEY (`geo_state_id`)
  REFERENCES `#__sr_geo_states` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_currencies`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_currencies` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `currency_name` VARCHAR(45) NOT NULL ,
  `currency_code` VARCHAR(10) NOT NULL ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  `exchange_rate` FLOAT UNSIGNED NOT NULL DEFAULT 0 ,
  `sign` VARCHAR(10) NOT NULL ,
  `filter_range` VARCHAR(255) NULL ,
  PRIMARY KEY (`id`) )
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_taxes`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__sr_taxes` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `rate` FLOAT NOT NULL,
  `state` TINYINT(3) NOT NULL,
  `country_id` INT(11) UNSIGNED NULL,
  `geo_state_id` INT(11) UNSIGNED NULL,
  `tax_exempt_from` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  INDEX `fk_sr_taxes_sr_countries1_idx` (`country_id` ASC),
  INDEX `fk_sr_taxes_sr_geo_states1_idx` (`geo_state_id` ASC),
  CONSTRAINT `fk_sr_taxes_sr_countries1`
    FOREIGN KEY (`country_id`)
    REFERENCES `#__sr_countries` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_taxes_sr_geo_states1`
    FOREIGN KEY (`geo_state_id`)
    REFERENCES `#__sr_geo_states` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_assets`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_assets` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `asset_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `category_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `name` VARCHAR(255) NOT NULL ,
  `alias` VARCHAR(255) NOT NULL ,
  `address_1` VARCHAR(255) NOT NULL ,
  `address_2` VARCHAR(255) NOT NULL ,
  `city` VARCHAR(45) NOT NULL ,
  `postcode` VARCHAR(45) NOT NULL ,
  `phone` VARCHAR(30) NOT NULL ,
  `description` TEXT NOT NULL ,
  `email` VARCHAR(50) NOT NULL ,
  `website` VARCHAR(255) NOT NULL ,
  `featured` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `fax` VARCHAR(45) NOT NULL ,
  `rating` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `geo_state_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `country_id` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `created_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `modified_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  `checked_out` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `archived` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 ,
  `approved` TINYINT(1) UNSIGNED NOT NULL DEFAULT 1,
  `access` INT(11) UNSIGNED NOT NULL DEFAULT 1 ,
  `params` TEXT NOT NULL ,
  `language` VARCHAR(10) NOT NULL ,
  `hits` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `metatitle` VARCHAR(255) NOT NULL DEFAULT '',
  `metakey` VARCHAR(255) NOT NULL DEFAULT '',
  `metadesc` VARCHAR(255) NOT NULL DEFAULT '',
  `metadata` TEXT NOT NULL,
  `xreference` VARCHAR(50) NOT NULL ,
  `partner_id` INT(11) UNSIGNED NULL ,
  `lat` DECIMAL(10,6) NULL DEFAULT 0 ,
  `lng` DECIMAL(10,6) NULL DEFAULT 0 ,
  `default` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `deposit_required` TINYINT(3) UNSIGNED NULL DEFAULT 0 ,
  `deposit_is_percentage` TINYINT(3) UNSIGNED NULL DEFAULT 1 ,
  `deposit_amount` DECIMAL(20,6) UNSIGNED NULL ,
  `deposit_by_stay_length` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `deposit_include_extra_cost` TINYINT(3) UNSIGNED NOT NULL DEFAULT 1,
  `currency_id` INT(11) UNSIGNED NOT NULL ,
  `tax_id` INT(11) UNSIGNED NULL,
  `booking_type` TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  0,
  `price_includes_tax` TINYINT(1) UNSIGNED NOT NULL DEFAULT  0,
  `distance_from_city_centre` DECIMAL(4,2) UNSIGNED NULL DEFAULT NULL,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_reservation_assets_sr_countries1_idx` (`country_id` ASC) ,
  INDEX `fk_sr_reservation_assets_sr_geo_states1_idx` (`geo_state_id` ASC) ,
  INDEX `fk_sr_reservation_assets_sr_customers1_idx` (`partner_id` ASC) ,
  INDEX `fk_sr_reservation_assets_sr_currencies1_idx` (`currency_id` ASC) ,
  INDEX `fk_jos_sr_reservation_assets_jos_sr_taxes1_idx` (`tax_id` ASC),
  CONSTRAINT `fk_sr_reservation_assets_sr_countries1`
    FOREIGN KEY (`country_id` )
    REFERENCES `#__sr_countries` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_assets_sr_geo_states1`
    FOREIGN KEY (`geo_state_id` )
    REFERENCES `#__sr_geo_states` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_assets_sr_customers1`
    FOREIGN KEY (`partner_id` )
    REFERENCES `#__sr_customers` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_assets_sr_currencies1`
    FOREIGN KEY (`currency_id`)
    REFERENCES `#__sr_currencies` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_jos_sr_reservation_assets_jos_sr_taxes1`
    FOREIGN KEY (`tax_id`)
    REFERENCES `#__sr_taxes` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_room_types`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_room_types` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_asset_id` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `name` VARCHAR(255) NOT NULL ,
  `alias` VARCHAR(255) NOT NULL ,
  `description` TEXT NOT NULL ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  `checked_out` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `created_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `language` VARCHAR(10) NOT NULL ,
  `params` TEXT NOT NULL ,
  `featured` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `ordering` INT(11) NOT NULL DEFAULT 0 ,
  `occupancy_max` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `occupancy_adult` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `occupancy_child` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `occupancy_child_age_range` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `smoking` TINYINT(2) NOT NULL DEFAULT 0 ,
  `is_private` TINYINT(2) UNSIGNED NOT NULL DEFAULT 1,
  `is_master` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_room_types_sr_reservation_assets1_idx` (`reservation_asset_id` ASC) ,
  CONSTRAINT `fk_sr_room_types_sr_reservation_assets1`
    FOREIGN KEY (`reservation_asset_id` )
    REFERENCES `#__sr_reservation_assets` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_coupons`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_coupons` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  `coupon_name` VARCHAR(255) NOT NULL ,
  `coupon_code` VARCHAR(15) NOT NULL ,
  `amount` INT(11) NOT NULL ,
  `is_percent` TINYINT(1) NOT NULL DEFAULT 0 ,
  `valid_from` DATE NOT NULL DEFAULT '0000-00-00' ,
  `valid_to` DATE NOT NULL DEFAULT '0000-00-00' ,
  `customer_group_id` INT(11) UNSIGNED NULL ,
  `reservation_asset_id` INT(11) UNSIGNED NULL,
  `valid_from_checkin` DATE NULL DEFAULT '0000-00-00' ,
  `valid_to_checkin` DATE NULL DEFAULT '0000-00-00' ,
  `quantity` INT(11) UNSIGNED NULL DEFAULT NULL,
  `params` TEXT NOT NULL,
  `scope` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_coupons_sr_customer_groups1_idx` (`customer_group_id` ASC) ,
  INDEX `fk_sr_coupons_sr_reservation_assets1_idx` (`reservation_asset_id` ASC) ,
  CONSTRAINT `fk_sr_coupons_sr_customer_groups1`
    FOREIGN KEY (`customer_group_id` )
    REFERENCES `#__sr_customer_groups` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_coupons_sr_reservation_assets1`
    FOREIGN KEY (`reservation_asset_id` )
    REFERENCES `#__sr_reservation_assets` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_origins`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__sr_origins` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `scope` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `state` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `tax_id` INT(11) UNSIGNED NULL,
  `is_default` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `name` VARCHAR(255) NOT NULL,
  `color` VARCHAR(7) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_sr_origins_sr_taxes1_idx` (`tax_id` ASC),
  CONSTRAINT `fk_sr_origins_sr_taxes1`
    FOREIGN KEY (`tax_id`)
    REFERENCES `#__sr_taxes` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservations`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservations` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `state` TINYINT(3) NOT NULL DEFAULT 0 ,
  `customer_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `created_by` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `checked_out` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `payment_method_id` VARCHAR(50) NOT NULL DEFAULT 0 ,
  `payment_method_txn_id` VARCHAR(100) NULL DEFAULT NULL ,
  `payment_method_surcharge` DECIMAL(20,6) UNSIGNED NOT NULL DEFAULT 0,
  `payment_method_discount` DECIMAL(20,6) UNSIGNED NOT NULL DEFAULT 0,
  `payment_status` TINYINT(2) NULL DEFAULT 0 COMMENT '0 is Unpaid, 1 is Completed, 2 is Cancelled, 3 is Pending' ,
  `payment_data` TEXT NULL ,
  `code` VARCHAR(100) NOT NULL ,
  `coupon_id` INT(11) UNSIGNED NULL ,
  `coupon_code` VARCHAR(15) NULL DEFAULT NULL ,
  `customer_title` VARCHAR(45) NULL ,
  `customer_firstname` VARCHAR(255) NULL ,
  `customer_middlename` VARCHAR(255) NULL ,
  `customer_lastname` VARCHAR(255) NULL ,
  `customer_email` VARCHAR(255) NULL ,
  `customer_phonenumber` VARCHAR(45) NULL ,
  `customer_mobilephone` VARCHAR(45) NULL ,
  `customer_company` VARCHAR(45) NULL ,
  `customer_address1` VARCHAR(45) NULL ,
  `customer_address2` VARCHAR(45) NULL ,
  `customer_city` VARCHAR(45) NULL ,
  `customer_zipcode` VARCHAR(45) NULL ,
  `customer_country_id` INT(11) NULL ,
  `customer_geo_state_id` INT(11) NULL ,
  `customer_vat_number` VARCHAR(50) NULL DEFAULT NULL,
  `customer_ip` VARCHAR(50) NULL DEFAULT NULL,
  `customer_coordinates` TEXT NULL DEFAULT NULL,
  `customer_language` VARCHAR(7) NULL,
  `customer_ua` VARCHAR(255) NOT NULL DEFAULT '',
  `customer_ismobile` TINYINT(1) UNSIGNED NULL DEFAULT NULL,
  `checkin` DATE NOT NULL DEFAULT '0000-00-00' ,
  `checkout` DATE NOT NULL DEFAULT '0000-00-00' ,
  `currency_id` INT(11) UNSIGNED NULL ,
  `currency_code` VARCHAR(10) NULL ,
  `total_price` DECIMAL(20,6) UNSIGNED NULL ,
  `total_price_tax_incl` DECIMAL(20,6) UNSIGNED NULL ,
  `total_price_tax_excl` DECIMAL(20,6) UNSIGNED NULL ,
  `total_extra_price` DECIMAL(20,6) UNSIGNED NULL ,
  `total_extra_price_tax_incl` DECIMAL(20,6) UNSIGNED NULL ,
  `total_extra_price_tax_excl` DECIMAL(20,6) UNSIGNED NULL ,
  `total_discount` DECIMAL(20,6) UNSIGNED NULL ,
  `note` TEXT NULL DEFAULT NULL ,
  `reservation_asset_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `reservation_asset_name` VARCHAR(255) NULL DEFAULT NULL ,
  `deposit_amount` DECIMAL(20,6) UNSIGNED NULL DEFAULT NULL ,
  `total_paid` DECIMAL(20,6) UNSIGNED NULL,
  `discount_pre_tax` TINYINT( 3 ) UNSIGNED NULL DEFAULT NULL ,
  `tax_amount` DECIMAL(20,6) UNSIGNED NULL ,
  `tourist_tax_amount` DECIMAL(20,6) UNSIGNED NOT NULL ,
  `booking_type` TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  0,
  `total_single_supplement` DECIMAL(20,6) UNSIGNED NULL DEFAULT NULL,
  `token` VARCHAR(40) NULL DEFAULT NULL ,
  `origin` VARCHAR(50) NULL DEFAULT NULL ,
  `origin_id` INT(11) UNSIGNED NULL DEFAULT NULL,
  `accessed_date` DATETIME NULL DEFAULT NULL ,
  `target` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `cm_provider` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0 ,
  `cm_id` VARCHAR(45) NULL ,
  `cm_creation_date` DATETIME NULL ,
  `cm_modification_date` DATETIME NULL ,
  `cm_channel_order_id` VARCHAR(45) NULL ,
  `cm_payment_collect` TINYINT(1) UNSIGNED NULL DEFAULT NULL,
  `is_approved` TINYINT(2) UNSIGNED NOT NULL DEFAULT 1 ,
  `checkinout_status` TINYINT(1) UNSIGNED NULL DEFAULT NULL ,
  `checked_in_date` DATETIME NULL ,
  `checked_out_date` DATETIME NULL ,
  `reservation_meta` TEXT NULL ,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `code_UNIQUE` (`code` ASC),
  INDEX `fk_sr_reservations_sr_coupons1_idx` (`coupon_id` ASC),
  INDEX `fk_sr_reservations_sr_reservation_assets1_idx` (`reservation_asset_id` ASC),
  UNIQUE INDEX `payment_method_txn_id_UNIQUE` (`payment_method_txn_id` ASC),
  INDEX `fk_sr_reservations_sr_origins1_idx` (`origin_id` ASC),
  CONSTRAINT `fk_sr_reservations_sr_coupons1`
  FOREIGN KEY (`coupon_id`)
  REFERENCES `#__sr_coupons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservations_sr_reservation_assets1`
  FOREIGN KEY (`reservation_asset_id`)
  REFERENCES `#__sr_reservation_assets` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservations_sr_origins1`
    FOREIGN KEY (`origin_id`)
    REFERENCES `#__sr_origins` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_media`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_media` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `type` VARCHAR(45) NOT NULL ,
  `value` TEXT NOT NULL ,
  `name` VARCHAR(255) NOT NULL ,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00' ,
  `created_by` INT(11) NOT NULL DEFAULT 0 ,
  `modified_by` INT(11) NOT NULL DEFAULT 0 ,
  `mime_type` VARCHAR(255) NOT NULL ,
  `size` INT(11) NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`id`) )
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_extras`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__sr_extras` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `state` TINYINT(3) NOT NULL DEFAULT 0,
  `description` TEXT NOT NULL,
  `created_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `modified_by` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `price` DECIMAL(20,6) UNSIGNED NOT NULL DEFAULT 0,
  `price_adult` DECIMAL(20,6) UNSIGNED NOT NULL DEFAULT 0,
  `price_child` DECIMAL(20,6) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `max_quantity` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `daily_chargable` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
  `reservation_asset_id` INT(11) UNSIGNED NULL,
  `experience_id` INT(11) UNSIGNED NULL,
  `mandatory` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
  `charge_type` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
  `tax_id` INT(11) UNSIGNED NULL,
  `params` TEXT NOT NULL,
  `scope` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `access` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `price_includes_tax` TINYINT(1) UNSIGNED NOT NULL DEFAULT  0,
  PRIMARY KEY (`id`),
  INDEX `fk_sr_extras_sr_reservation_assets1_idx` (`reservation_asset_id` ASC),
  INDEX `fk_sr_extras_sr_taxes1_idx` (`tax_id` ASC),
  CONSTRAINT `fk_sr_extras_sr_reservation_assets1`
  FOREIGN KEY (`reservation_asset_id`)
  REFERENCES `#__sr_reservation_assets` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_extras_sr_taxes1`
  FOREIGN KEY (`tax_id`)
  REFERENCES `#__sr_taxes` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_tariffs`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__sr_tariffs` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `currency_id` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `customer_group_id` INT(11) UNSIGNED NULL DEFAULT NULL COMMENT 'price for each user groups',
  `valid_from` DATE NOT NULL,
  `valid_to` DATE NOT NULL,
  `room_type_id` INT(11) UNSIGNED NULL,
  `title` TEXT NULL,
  `description` TEXT NULL,
  `d_min` SMALLINT NULL,
  `d_max` SMALLINT NULL,
  `d_interval` TINYINT UNSIGNED NULL DEFAULT 0,
  `p_min` TINYINT NULL,
  `p_max` TINYINT NULL,
  `type` TINYINT UNSIGNED NOT NULL DEFAULT 0,
  `limit_checkin` VARCHAR(45) NOT NULL,
  `state` TINYINT(3) NOT NULL DEFAULT 0,
  `mode` TINYINT(3) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0,
  `cm_id` VARCHAR(45) NULL,
  `q_min` SMALLINT NULL,
  `q_max` SMALLINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_sr_prices_sr_currencies1_idx` (`currency_id` ASC),
  INDEX `fk_sr_prices_sr_room_types1_idx` (`room_type_id` ASC),
  INDEX `fk_sr_prices_sr_customer_groups1_idx` (`customer_group_id` ASC),
  CONSTRAINT `fk_sr_prices_sr_currencies1`
    FOREIGN KEY (`currency_id`)
    REFERENCES `#__sr_currencies` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_prices_sr_room_types1`
    FOREIGN KEY (`room_type_id`)
    REFERENCES `#__sr_room_types` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_prices_sr_customer_groups1`
    FOREIGN KEY (`customer_group_id`)
    REFERENCES `#__sr_customer_groups` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_rooms`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_rooms` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `label` VARCHAR(255) NOT NULL ,
  `room_type_id` INT(11) UNSIGNED NOT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_rooms_sr_room_types1_idx` (`room_type_id` ASC) ,
  CONSTRAINT `fk_sr_rooms_sr_room_types1`
  FOREIGN KEY (`room_type_id` )
  REFERENCES `#__sr_room_types` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_room_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_room_xref` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_id` INT(11) UNSIGNED NOT NULL ,
  `room_id` INT(11) UNSIGNED NULL ,
  `room_label` VARCHAR(255) NULL ,
  `adults_number` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `children_number` TINYINT(2) UNSIGNED NOT NULL DEFAULT 0 ,
  `guest_fullname` VARCHAR(500) NULL ,
  `room_price` DECIMAL(20,6) UNSIGNED NULL DEFAULT NULL,
  `room_price_tax_incl` DECIMAL(20,6) UNSIGNED NULL,
  `room_price_tax_excl` DECIMAL(20,6) UNSIGNED NULL,
  `tariff_id` INT(11) UNSIGNED NULL,
  `tariff_title` TEXT NULL DEFAULT NULL,
  `tariff_description` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`id`) ,
  INDEX `fk_reservations_rooms_xref_reservations1_idx` (`reservation_id` ASC) ,
  INDEX `fk_sr_reservation_room_coupon_extra_xref_sr_rooms1_idx` (`room_id` ASC) ,
  INDEX `fk_sr_reservation_room_xref_sr_tariffs1_idx` (`tariff_id` ASC),
  CONSTRAINT `fk_reservations_rooms_xref_reservations1`
  FOREIGN KEY (`reservation_id` )
  REFERENCES `#__sr_reservations` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_room_coupon_extra_xref_sr_rooms1`
  FOREIGN KEY (`room_id` )
  REFERENCES `#__sr_rooms` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_room_xref_sr_tariffs1`
  FOREIGN KEY (`tariff_id`)
  REFERENCES `#__sr_tariffs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB
  COMMENT = '\nit include extra optionaly.\n';


-- -----------------------------------------------------
-- Table `#__sr_media_reservation_assets_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_media_reservation_assets_xref` (
  `media_id` INT(11) UNSIGNED NOT NULL ,
  `reservation_asset_id` INT(11) UNSIGNED NOT NULL ,
  `weight` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`media_id`, `reservation_asset_id`) ,
  INDEX `fk_sr_media_ref_reservation_assets_sr_media1_idx` (`media_id` ASC) ,
  INDEX `fk_sr_media_ref_reservation_assets_sr_reservation1_idx` (`reservation_asset_id` ASC) ,
  CONSTRAINT `fk_sr_media_ref_reservation_assets_sr_media1`
  FOREIGN KEY (`media_id` )
  REFERENCES `#__sr_media` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_media_ref_reservation_assets_sr_reservation1`
  FOREIGN KEY (`reservation_asset_id` )
  REFERENCES `#__sr_reservation_assets` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_media_roomtype_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_media_roomtype_xref` (
  `media_id` INT(11) UNSIGNED NOT NULL ,
  `room_type_id` INT(11) UNSIGNED NOT NULL ,
  `weight` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  INDEX `fk_sr_media_ref_roomtype_sr_media1_idx` (`media_id` ASC) ,
  INDEX `fk_sr_media_ref_roomtype_sr_room_types1_idx` (`room_type_id` ASC) ,
  CONSTRAINT `fk_sr_media_ref_roomtype_sr_media1`
  FOREIGN KEY (`media_id` )
  REFERENCES `#__sr_media` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_media_ref_roomtype_sr_room_types1`
  FOREIGN KEY (`room_type_id` )
  REFERENCES `#__sr_room_types` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_asset_fields`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_asset_fields` (
  `reservation_asset_id` INT(11) UNSIGNED NOT NULL ,
  `field_key` VARCHAR(100) NOT NULL ,
  `field_value` TEXT NULL ,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`field_key`, `reservation_asset_id`) ,
  INDEX `fk_sr_reservation_asset_fields_sr_reservation_assets1_idx` (`reservation_asset_id` ASC) ,
  CONSTRAINT `fk_sr_reservation_asset_fields_sr_reservation_assets1`
  FOREIGN KEY (`reservation_asset_id` )
  REFERENCES `#__sr_reservation_assets` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_customer_fields`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_customer_fields` (
  `user_id` INT(11) UNSIGNED NOT NULL ,
  `field_key` VARCHAR(100) NOT NULL ,
  `field_value` VARCHAR(255) NULL ,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`field_key`) ,
  INDEX `fk_sr_customer_fields_sr_customers1_idx` (`user_id` ASC) ,
  CONSTRAINT `fk_sr_customer_fields_sr_customers1`
  FOREIGN KEY (`user_id` )
  REFERENCES `#__sr_customers` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_room_type_coupon_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_room_type_coupon_xref` (
  `room_type_id` INT(11) UNSIGNED NOT NULL ,
  `coupon_id` INT(11) UNSIGNED NOT NULL ,
  PRIMARY KEY (`room_type_id`, `coupon_id`) ,
  INDEX `fk_sr_room_type_coupon_xref_sr_coupons1_idx` (`coupon_id` ASC) ,
  INDEX `fk_sr_room_type_coupon_xref_sr_room_types1_idx` (`room_type_id` ASC) ,
  CONSTRAINT `fk_sr_room_type_coupon_xref_sr_coupons1`
  FOREIGN KEY (`coupon_id` )
  REFERENCES `#__sr_coupons` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_room_type_coupon_xref_sr_room_types1`
  FOREIGN KEY (`room_type_id` )
  REFERENCES `#__sr_room_types` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_room_type_extra_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_room_type_extra_xref` (
  `room_type_id` INT(11) UNSIGNED NOT NULL ,
  `extra_id` INT(11) UNSIGNED NOT NULL ,
  PRIMARY KEY (`room_type_id`, `extra_id`) ,
  INDEX `fk_sr_room_type_extra_xref_sr_extras1_idx` (`extra_id` ASC) ,
  INDEX `fk_sr_room_type_extra_xref_sr_room_types1_idx` (`room_type_id` ASC) ,
  CONSTRAINT `fk_sr_room_type_extra_xref_sr_extras1`
  FOREIGN KEY (`extra_id` )
  REFERENCES `#__sr_extras` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_room_type_extra_xref_sr_room_types1`
  FOREIGN KEY (`room_type_id` )
  REFERENCES `#__sr_room_types` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_room_extra_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_room_extra_xref` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_id` INT(11) UNSIGNED NOT NULL ,
  `room_id` INT(11) UNSIGNED NULL ,
  `room_label` VARCHAR(255) NULL ,
  `extra_id` INT(11) UNSIGNED NULL ,
  `extra_name` VARCHAR(255) NULL ,
  `extra_quantity` INT(11) UNSIGNED NULL ,
  `extra_price` DECIMAL(20,6) UNSIGNED NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_reservation_room_extra_xref_sr_reservations1_idx` (`reservation_id` ASC) ,
  INDEX `fk_sr_reservation_room_extra_xref_sr_rooms1_idx` (`room_id` ASC) ,
  INDEX `fk_sr_reservation_room_extra_xref_sr_extras1_idx` (`extra_id` ASC) ,
  CONSTRAINT `fk_sr_reservation_room_extra_xref_sr_reservations1`
  FOREIGN KEY (`reservation_id` )
  REFERENCES `#__sr_reservations` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_room_extra_xref_sr_rooms1`
  FOREIGN KEY (`room_id` )
  REFERENCES `#__sr_rooms` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_room_extra_xref_sr_extras1`
  FOREIGN KEY (`extra_id` )
  REFERENCES `#__sr_extras` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_room_type_fields`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_room_type_fields` (
  `room_type_id` INT(11) UNSIGNED NOT NULL ,
  `field_key` VARCHAR(100) NOT NULL ,
  `field_value` TEXT NULL ,
  `ordering` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  PRIMARY KEY (`room_type_id`, `field_key`) ,
  INDEX `fk_sr_room_type_fields_sr_room_types1_idx` (`room_type_id` ASC) ,
  CONSTRAINT `fk_sr_room_type_fields_sr_room_types1`
  FOREIGN KEY (`room_type_id` )
  REFERENCES `#__sr_room_types` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_notes`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_notes` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_id` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `text` TEXT NULL DEFAULT NULL ,
  `created_date` DATETIME NULL DEFAULT '0000-00-00 00:00:00' ,
  `created_by` INT(11) UNSIGNED NULL DEFAULT NULL ,
  `notify_customer` TINYINT(3) UNSIGNED NULL DEFAULT 0 ,
  `visible_in_frontend` TINYINT(3) UNSIGNED NULL DEFAULT 0 ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_jos_sr_reservation_notes_jos_sr_reservations1_idx` (`reservation_id` ASC) ,
  CONSTRAINT `fk_jos_sr_reservation_notes_jos_sr_reservations1`
  FOREIGN KEY (`reservation_id` )
  REFERENCES `#__sr_reservations` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_config_data`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_config_data` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `scope_id` INT(11) UNSIGNED NOT NULL DEFAULT 0 ,
  `data_key` VARCHAR(255) NOT NULL ,
  `data_value` TEXT NULL DEFAULT NULL ,
  PRIMARY KEY (`id`) )
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_tariff_details`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__sr_tariff_details` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `tariff_id` INT(11) UNSIGNED NOT NULL,
  `price` DECIMAL(20,6) UNSIGNED NULL,
  `price_extras` DECIMAL(20,6) UNSIGNED NULL,
  `w_day` TINYINT UNSIGNED NULL,
  `guest_type` VARCHAR(10) NULL,
  `from_age` TINYINT UNSIGNED NULL DEFAULT NULL,
  `to_age` TINYINT UNSIGNED NULL DEFAULT NULL,
  `date` DATE NULL DEFAULT NULL,
  `min_los` INT(11) UNSIGNED NULL DEFAULT NULL,
  `max_los` INT(11) UNSIGNED NULL DEFAULT NULL,
  `d_interval` TINYINT UNSIGNED NULL DEFAULT 0,
  `limit_checkin` VARCHAR(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  INDEX `fk_sr_tariff_details_sr_tariffs1_idx` (`tariff_id` ASC),
  CONSTRAINT `fk_sr_tariff_details_sr_tariffs1`
    FOREIGN KEY (`tariff_id`)
    REFERENCES `#__sr_tariffs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_room_details`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_room_details` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_room_id` INT(11) UNSIGNED NOT NULL ,
  `key` VARCHAR(255) NULL ,
  `value` TEXT NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_reservation_room_details_sr_reservation_room_xr1_idx` (`reservation_room_id` ASC) ,
  CONSTRAINT `fk_sr_reservation_room_details_sr_reservation_room_xr1`
    FOREIGN KEY (`reservation_room_id` )
    REFERENCES `#__sr_reservation_room_xref` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `#__sr_reservation_extra_xref`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `#__sr_reservation_extra_xref` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `reservation_id` INT(11) UNSIGNED NOT NULL ,
  `extra_id` INT(11) UNSIGNED NULL ,
  `extra_name` VARCHAR(255) NULL ,
  `extra_quantity` INT(11) NULL ,
  `extra_price` DECIMAL(20,6) NULL ,
  PRIMARY KEY (`id`) ,
  INDEX `fk_sr_reservation_extra_xref_sr_reservations1_idx` (`reservation_id` ASC) ,
  INDEX `fk_sr_reservation_extra_xref_sr_extras1` (`extra_id` ASC) ,
  CONSTRAINT `fk_sr_reservation_extra_xref_sr_reservations1`
    FOREIGN KEY (`reservation_id` )
    REFERENCES `#__sr_reservations` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_sr_reservation_extra_xref_sr_sr_extras1`
    FOREIGN KEY (`extra_id` )
    REFERENCES `#__sr_extras` (`id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


CREATE TABLE IF NOT EXISTS `#__sr_extra_coupon_xref` (
  `extra_id` INT(11) UNSIGNED NOT NULL,
  `coupon_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`extra_id`, `coupon_id`),
  INDEX `fk_extra_coupon_xref_coupons1_idx` (`coupon_id` ASC),
  CONSTRAINT `fk_extra_coupon_xref_coupons1`
  FOREIGN KEY (`coupon_id`)
  REFERENCES `#__sr_coupons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_extra_coupon_xref_extras1`
  FOREIGN KEY (`extra_id`)
  REFERENCES `#__sr_extras` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sr_coupon_item_xref` (
  `coupon_id` INT(11) UNSIGNED NOT NULL,
  `item_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`coupon_id`, `item_id`)
)
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__sr_countries`
--
INSERT INTO `#__sr_countries` (`id`, `name`, `code_2`, `code_3`, `state`, `checked_out`, `checked_out_time`, `created_by`, `created_date`, `modified_by`, `modified_date`) VALUES
(2, 'Afghanistan', 'AF', 'AFG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(3, 'Albania', 'AL', 'ALB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(4, 'Algeria', 'DZ', 'DZA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(5, 'American Samoa', 'AS', 'ASM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(6, 'Andorra', 'AD', 'AND', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(7, 'Angola', 'AO', 'AGO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(8, 'Anguilla', 'AI', 'AIA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(9, 'Antarctica', 'AQ', 'ATA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(10, 'Antigua and Barbuda', 'AG', 'ATG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(11, 'Argentina', 'AR', 'ARG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(12, 'Armenia', 'AM', 'ARM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(13, 'Aruba', 'AW', 'ABW', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(14, 'Australia', 'AU', 'AUS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(15, 'Austria', 'AT', 'AUT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(16, 'Azerbaijan', 'AZ', 'AZE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(17, 'Bahamas', 'BS', 'BHS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(18, 'Bahrain', 'BH', 'BHR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(19, 'Bangladesh', 'BD', 'BGD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(20, 'Barbados', 'BB', 'BRB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(21, 'Belarus', 'BY', 'BLR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(22, 'Belgium', 'BE', 'BEL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(23, 'Belize', 'BZ', 'BLZ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(24, 'Benin', 'BJ', 'BEN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(25, 'Bermuda', 'BM', 'BMU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(26, 'Bhutan', 'BT', 'BTN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(27, 'Bolivia', 'BO', 'BOL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(28, 'Bosnia and Herzegowina', 'BA', 'BIH', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(29, 'Botswana', 'BW', 'BWA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(30, 'Bouvet Island', 'BV', 'BVT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(31, 'Brazil', 'BR', 'BRA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(32, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(33, 'Brunei Darussalam', 'BN', 'BRN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(34, 'Bulgaria', 'BG', 'BGR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(35, 'Burkina Faso', 'BF', 'BFA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(36, 'Burundi', 'BI', 'BDI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(37, 'Cambodia', 'KH', 'KHM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(38, 'Cameroon', 'CM', 'CMR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(39, 'Canada', 'CA', 'CAN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(40, 'Cape Verde', 'CV', 'CPV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(41, 'Cayman Islands', 'KY', 'CYM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(42, 'Central African Republic', 'CF', 'CAF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(43, 'Chad', 'TD', 'TCD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(44, 'Chile', 'CL', 'CHL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(45, 'China', 'CN', 'CHN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(46, 'Christmas Island', 'CX', 'CXR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(47, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(48, 'Colombia', 'CO', 'COL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(49, 'Comoros', 'KM', 'COM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(50, 'Congo', 'CG', 'COG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(51, 'Cook Islands', 'CK', 'COK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(52, 'Costa Rica', 'CR', 'CRI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(53, 'Cote D''Ivoire', 'CI', 'CIV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(54, 'Croatia', 'HR', 'HRV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(55, 'Cuba', 'CU', 'CUB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(56, 'Cyprus', 'CY', 'CYP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(57, 'Czech Republic', 'CZ', 'CZE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(58, 'Denmark', 'DK', 'DNK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(59, 'Djibouti', 'DJ', 'DJI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(60, 'Dominica', 'DM', 'DMA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(61, 'Dominican Republic', 'DO', 'DOM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(62, 'East Timor', 'TP', 'TMP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(63, 'Ecuador', 'EC', 'ECU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(64, 'Egypt', 'EG', 'EGY', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(65, 'El Salvador', 'SV', 'SLV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(66, 'Equatorial Guinea', 'GQ', 'GNQ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(67, 'Eritrea', 'ER', 'ERI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(68, 'Estonia', 'EE', 'EST', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(69, 'Ethiopia', 'ET', 'ETH', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(70, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(71, 'Faroe Islands', 'FO', 'FRO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(72, 'Fiji', 'FJ', 'FJI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(73, 'Finland', 'FI', 'FIN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(74, 'France', 'FR', 'FRA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(75, 'France, Metropolitan', 'FX', 'FXX', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(76, 'French Guiana', 'GF', 'GUF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(77, 'French Polynesia', 'PF', 'PYF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(78, 'French Southern Territories', 'TF', 'ATF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(79, 'Gabon', 'GA', 'GAB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(80, 'Gambia', 'GM', 'GMB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(81, 'Georgia', 'GE', 'GEO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(82, 'Germany', 'DE', 'DEU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(83, 'Ghana', 'GH', 'GHA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(84, 'Gibraltar', 'GI', 'GIB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(85, 'Greece', 'GR', 'GRC', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(86, 'Greenland', 'GL', 'GRL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(87, 'Grenada', 'GD', 'GRD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(88, 'Guadeloupe', 'GP', 'GLP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(89, 'Guam', 'GU', 'GUM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(90, 'Guatemala', 'GT', 'GTM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(91, 'Guinea', 'GN', 'GIN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(92, 'Guinea-bissau', 'GW', 'GNB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(93, 'Guyana', 'GY', 'GUY', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(94, 'Haiti', 'HT', 'HTI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(95, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(96, 'Honduras', 'HN', 'HND', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(97, 'Hong Kong', 'HK', 'HKG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(98, 'Hungary', 'HU', 'HUN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(99, 'Iceland', 'IS', 'ISL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(100, 'India', 'IN', 'IND', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(101, 'Indonesia', 'ID', 'IDN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(102, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(103, 'Iraq', 'IQ', 'IRQ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(104, 'Ireland', 'IE', 'IRL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(105, 'Israel', 'IL', 'ISR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(106, 'Italy', 'IT', 'ITA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(107, 'Jamaica', 'JM', 'JAM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(108, 'Japan', 'JP', 'JPN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(109, 'Jordan', 'JO', 'JOR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(110, 'Kazakhstan', 'KZ', 'KAZ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(111, 'Kenya', 'KE', 'KEN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(112, 'Kiribati', 'KI', 'KIR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(113, 'Korea, Democratic People''s Republic of', 'KP', 'PRK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(114, 'Korea, Republic of', 'KR', 'KOR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(115, 'Kuwait', 'KW', 'KWT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(116, 'Kyrgyzstan', 'KG', 'KGZ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(117, 'Lao People''s Democratic Republic', 'LA', 'LAO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(118, 'Latvia', 'LV', 'LVA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(119, 'Lebanon', 'LB', 'LBN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(120, 'Lesotho', 'LS', 'LSO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(121, 'Liberia', 'LR', 'LBR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(122, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(123, 'Liechtenstein', 'LI', 'LIE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(124, 'Lithuania', 'LT', 'LTU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(125, 'Luxembourg', 'LU', 'LUX', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(126, 'Macau', 'MO', 'MAC', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(127, 'Macedonia, The Former Yugoslav Republic of', 'MK', 'MKD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(128, 'Madagascar', 'MG', 'MDG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(129, 'Malawi', 'MW', 'MWI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(130, 'Malaysia', 'MY', 'MYS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(131, 'Maldives', 'MV', 'MDV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(132, 'Mali', 'ML', 'MLI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(133, 'Malta', 'MT', 'MLT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(134, 'Marshall Islands', 'MH', 'MHL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(135, 'Martinique', 'MQ', 'MTQ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(136, 'Mauritania', 'MR', 'MRT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(137, 'Mauritius', 'MU', 'MUS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(138, 'Mayotte', 'YT', 'MYT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(139, 'Mexico', 'MX', 'MEX', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(140, 'Micronesia, Federated States of', 'FM', 'FSM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(141, 'Moldova, Republic of', 'MD', 'MDA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(142, 'Monaco', 'MC', 'MCO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(143, 'Mongolia', 'MN', 'MNG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(144, 'Montserrat', 'MS', 'MSR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(145, 'Morocco', 'MA', 'MAR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(146, 'Mozambique', 'MZ', 'MOZ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(147, 'Myanmar', 'MM', 'MMR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(148, 'Namibia', 'NA', 'NAM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(149, 'Nauru', 'NR', 'NRU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(150, 'Nepal', 'NP', 'NPL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(151, 'Netherlands', 'NL', 'NLD', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(152, 'Netherlands Antilles', 'AN', 'ANT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(153, 'New Caledonia', 'NC', 'NCL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(154, 'New Zealand', 'NZ', 'NZL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(155, 'Nicaragua', 'NI', 'NIC', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(156, 'Niger', 'NE', 'NER', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(157, 'Nigeria', 'NG', 'NGA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(158, 'Niue', 'NU', 'NIU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(159, 'Norfolk Island', 'NF', 'NFK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(160, 'Northern Mariana Islands', 'MP', 'MNP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(161, 'Norway', 'NO', 'NOR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(162, 'Oman', 'OM', 'OMN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(163, 'Pakistan', 'PK', 'PAK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(164, 'Palau', 'PW', 'PLW', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(165, 'Panama', 'PA', 'PAN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(166, 'Papua New Guinea', 'PG', 'PNG', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(167, 'Paraguay', 'PY', 'PRY', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(168, 'Peru', 'PE', 'PER', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(169, 'Philippines', 'PH', 'PHL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(170, 'Pitcairn', 'PN', 'PCN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(171, 'Poland', 'PL', 'POL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(172, 'Portugal', 'PT', 'PRT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(173, 'Puerto Rico', 'PR', 'PRI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(174, 'Qatar', 'QA', 'QAT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(175, 'Reunion', 'RE', 'REU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(176, 'Romania', 'RO', 'ROM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(177, 'Russian Federation', 'RU', 'RUS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(178, 'Rwanda', 'RW', 'RWA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(179, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(180, 'Saint Lucia', 'LC', 'LCA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(181, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(182, 'Samoa', 'WS', 'WSM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(183, 'San Marino', 'SM', 'SMR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(184, 'Sao Tome and Principe', 'ST', 'STP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(185, 'Saudi Arabia', 'SA', 'SAU', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(186, 'Senegal', 'SN', 'SEN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(187, 'Seychelles', 'SC', 'SYC', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(188, 'Sierra Leone', 'SL', 'SLE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(189, 'Singapore', 'SG', 'SGP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(190, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(191, 'Slovenia', 'SI', 'SVN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(192, 'Solomon Islands', 'SB', 'SLB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(193, 'Somalia', 'SO', 'SOM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(194, 'South Africa', 'ZA', 'ZAF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(195, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(196, 'Spain', 'ES', 'ESP', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(197, 'Sri Lanka', 'LK', 'LKA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(198, 'St. Helena', 'SH', 'SHN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(199, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(200, 'Sudan', 'SD', 'SDN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(201, 'Suriname', 'SR', 'SUR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(202, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(203, 'Swaziland', 'SZ', 'SWZ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(204, 'Sweden', 'SE', 'SWE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(205, 'Switzerland', 'CH', 'CHE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(206, 'Syrian Arab Republic', 'SY', 'SYR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(207, 'Taiwan', 'TW', 'TWN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(208, 'Tajikistan', 'TJ', 'TJK', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(209, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(210, 'Thailand', 'TH', 'THA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(211, 'Togo', 'TG', 'TGO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(212, 'Tokelau', 'TK', 'TKL', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(213, 'Tonga', 'TO', 'TON', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(214, 'Trinidad and Tobago', 'TT', 'TTO', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(215, 'Tunisia', 'TN', 'TUN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(216, 'Turkey', 'TR', 'TUR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(217, 'Turkmenistan', 'TM', 'TKM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(218, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(219, 'Tuvalu', 'TV', 'TUV', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(220, 'Uganda', 'UG', 'UGA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(221, 'Ukraine', 'UA', 'UKR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(222, 'United Arab Emirates', 'AE', 'ARE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(223, 'United Kingdom', 'GB', 'GBR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(224, 'United States', 'US', 'USA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(225, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(226, 'Uruguay', 'UY', 'URY', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(227, 'Uzbekistan', 'UZ', 'UZB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(228, 'Vanuatu', 'VU', 'VUT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(229, 'Vatican City State (Holy See)', 'VA', 'VAT', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(230, 'Venezuela', 'VE', 'VEN', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(231, 'Viet Nam', 'VN', 'VNM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(232, 'Virgin Islands (British)', 'VG', 'VGB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(233, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(234, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(235, 'Western Sahara', 'EH', 'ESH', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(236, 'Yemen', 'YE', 'YEM', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(237, 'Serbia', 'RS', 'SRB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(238, 'The Democratic Republic of Congo', 'DC', 'DRC', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(239, 'Zambia', 'ZM', 'ZMB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(240, 'Zimbabwe', 'ZW', 'ZWE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(242, 'Jersey', 'XJ', 'XJE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(243, 'St. Barthelemy', 'XB', 'XSB', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(244, 'St. Eustatius', 'XU', 'XSE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(245, 'Canary Islands', 'XC', 'XCA', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(246, 'Montenegro', 'ME', 'MNE', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');


--
-- Dumping data for table `#__sr_geo_states`
--
INSERT INTO `#__sr_geo_states` (`id`, `country_id`, `name`, `code_2`, `code_3`, `state`) VALUES
(2, 224, 'Alabama', 'AL', 'ALA', 1),
(3, 224, 'Alaska', 'AK', 'ALK', 1),
(4, 224, 'Arizona', 'AZ', 'ARZ', 1),
(5, 224, 'Arkansas', 'AR', 'ARK', 1),
(6, 224, 'California', 'CA', 'CAL', 1),
(7, 224, 'Colorado', 'CO', 'COL', 1),
(8, 224, 'Connecticut', 'CT', 'CCT', 1),
(9, 224, 'Delaware', 'DE', 'DEL', 1),
(10, 224, 'District Of Columbia', 'DC', 'DOC', 1),
(11, 224, 'Florida', 'FL', 'FLO', 1),
(12, 224, 'Georgia', 'GA', 'GEA', 1),
(13, 224, 'Hawaii', 'HI', 'HWI', 1),
(14, 224, 'Idaho', 'ID', 'IDA', 1),
(15, 224, 'Illinois', 'IL', 'ILL', 1),
(16, 224, 'Indiana', 'IN', 'IND', 1),
(17, 224, 'Iowa', 'IA', 'IOA', 1),
(18, 224, 'Kansas', 'KS', 'KAS', 1),
(19, 224, 'Kentucky', 'KY', 'KTY', 1),
(20, 224, 'Louisiana', 'LA', 'LOA', 1),
(21, 224, 'Maine', 'ME', 'MAI', 1),
(22, 224, 'Maryland', 'MD', 'MLD', 1),
(23, 224, 'Massachusetts', 'MA', 'MSA', 1),
(24, 224, 'Michigan', 'MI', 'MIC', 1),
(25, 224, 'Minnesota', 'MN', 'MIN', 1),
(26, 224, 'Mississippi', 'MS', 'MIS', 1),
(27, 224, 'Missouri', 'MO', 'MIO', 1),
(28, 224, 'Montana', 'MT', 'MOT', 1),
(29, 224, 'Nebraska', 'NE', 'NEB', 1),
(30, 224, 'Nevada', 'NV', 'NEV', 1),
(31, 224, 'New Hampshire', 'NH', 'NEH', 1),
(32, 224, 'New Jersey', 'NJ', 'NEJ', 1),
(33, 224, 'New Mexico', 'NM', 'NEM', 1),
(34, 224, 'New York', 'NY', 'NEY', 1),
(35, 224, 'North Carolina', 'NC', 'NOC', 1),
(36, 224, 'North Dakota', 'ND', 'NOD', 1),
(37, 224, 'Ohio', 'OH', 'OHI', 1),
(38, 224, 'Oklahoma', 'OK', 'OKL', 1),
(39, 224, 'Oregon', 'OR', 'ORN', 1),
(40, 224, 'Pennsylvania', 'PA', 'PEA', 1),
(41, 224, 'Rhode Island', 'RI', 'RHI', 1),
(42, 224, 'South Carolina', 'SC', 'SOC', 1),
(43, 224, 'South Dakota', 'SD', 'SOD', 1),
(44, 224, 'Tennessee', 'TN', 'TEN', 1),
(45, 224, 'Texas', 'TX', 'TXS', 1),
(46, 224, 'Utah', 'UT', 'UTA', 1),
(47, 224, 'Vermont', 'VT', 'VMT', 1),
(48, 224, 'Virginia', 'VA', 'VIA', 1),
(49, 224, 'Washington', 'WA', 'WAS', 1),
(50, 224, 'West Virginia', 'WV', 'WEV', 1),
(51, 224, 'Wisconsin', 'WI', 'WIS', 1),
(52, 224, 'Wyoming', 'WY', 'WYO', 1),
(53, 39, 'Alberta', 'AB', 'ALB', 1),
(54, 39, 'British Columbia', 'BC', 'BRC', 1),
(55, 39, 'Manitoba', 'MB', 'MAB', 1),
(56, 39, 'New Brunswick', 'NB', 'NEB', 1),
(57, 39, 'Newfoundland and Labrador', 'NL', 'NFL', 1),
(58, 39, 'Northwest Territories', 'NT', 'NWT', 1),
(59, 39, 'Nova Scotia', 'NS', 'NOS', 1),
(60, 39, 'Nunavut', 'NU', 'NUT', 1),
(61, 39, 'Ontario', 'ON', 'ONT', 1),
(62, 39, 'Prince Edward Island', 'PE', 'PEI', 1),
(63, 39, 'Quebec', 'QC', 'QEC', 1),
(64, 39, 'Saskatchewan', 'SK', 'SAK', 1),
(65, 39, 'Yukon', 'YT', 'YUT', 1),
(66, 223, 'England', 'EN', 'ENG', 1),
(67, 223, 'Northern Ireland', 'NI', 'NOI', 1),
(68, 223, 'Scotland', 'SD', 'SCO', 1),
(69, 223, 'Wales', 'WS', 'WLS', 1),
(70, 14, 'Australian Capital Territory', 'AC', 'ACT', 1),
(71, 14, 'New South Wales', 'NS', 'NSW', 1),
(72, 14, 'Northern Territory', 'NT', 'NOT', 1),
(73, 14, 'Queensland', 'QL', 'QLD', 1),
(74, 14, 'South Australia', 'SA', 'SOA', 1),
(75, 14, 'Tasmania', 'TS', 'TAS', 1),
(76, 14, 'Victoria', 'VI', 'VIC', 1),
(77, 14, 'Western Australia', 'WA', 'WEA', 1),
(78, 139, 'Aguascalientes', 'AG', 'AGS', 1),
(79, 139, 'Baja California', 'BN', 'BCN', 1),
(80, 139, 'Baja California Sur', 'BS', 'BCS', 1),
(81, 139, 'Campeche', 'CA', 'CAM', 1),
(82, 139, 'Chiapas', 'CS', 'CHI', 1),
(83, 139, 'Chihuahua', 'CH', 'CHA', 1),
(84, 139, 'Coahuila', 'CO', 'COA', 1),
(85, 139, 'Colima', 'CM', 'COL', 1),
(86, 139, 'Distrito Federal', 'DF', 'DFM', 1),
(87, 139, 'Durango', 'DO', 'DGO', 1),
(88, 139, 'Guanajuato', 'GO', 'GTO', 1),
(89, 139, 'Guerrero', 'GU', 'GRO', 1),
(90, 139, 'Hidalgo', 'HI', 'HGO', 1),
(91, 139, 'Jalisco', 'JA', 'JAL', 1),
(92, 139, 'México (Estado de)', 'EM', 'EDM', 1),
(93, 139, 'Michoacán', 'MI', 'MCN', 1),
(94, 139, 'Morelos', 'MO', 'MOR', 1),
(95, 139, 'Nayarit', 'NY', 'NAY', 1),
(96, 139, 'Nuevo León', 'NL', 'NUL', 1),
(97, 139, 'Oaxaca', 'OA', 'OAX', 1),
(98, 139, 'Puebla', 'PU', 'PUE', 1),
(99, 139, 'Querétaro', 'QU', 'QRO', 1),
(100, 139, 'Quintana Roo', 'QR', 'QUR', 1),
(101, 139, 'San Luis Potosí', 'SP', 'SLP', 1),
(102, 139, 'Sinaloa', 'SI', 'SIN', 1),
(103, 139, 'Sonora', 'SO', 'SON', 1),
(104, 139, 'Tabasco', 'TA', 'TAB', 1),
(105, 139, 'Tamaulipas', 'TM', 'TAM', 1),
(106, 139, 'Tlaxcala', 'TX', 'TLX', 1),
(107, 139, 'Veracruz', 'VZ', 'VER', 1),
(108, 139, 'Yucatán', 'YU', 'YUC', 1),
(109, 139, 'Zacatecas', 'ZA', 'ZAC', 1),
(110, 31, 'Acre', 'AC', 'ACR', 1),
(111, 31, 'Alagoas', 'AL', 'ALG', 1),
(112, 31, 'Amapá', 'AP', 'AMP', 1),
(113, 31, 'Amazonas', 'AM', 'AMZ', 1),
(114, 31, 'Bahia', 'BA', 'BAH', 1),
(115, 31, 'Ceará', 'CE', 'CEA', 1),
(116, 31, 'Distrito Federal', 'DF', 'DFB', 1),
(117, 31, 'Espirito Santo', 'ES', 'ESS', 1),
(118, 31, 'Goiás', 'GO', 'GOI', 1),
(119, 31, 'Maranhão', 'MA', 'MAR', 1),
(120, 31, 'Mato Grosso', 'MT', 'MAT', 1),
(121, 31, 'Mato Grosso do Sul', 'MS', 'MGS', 1),
(122, 31, 'Minas Gerais', 'MG', 'MIG', 1),
(123, 31, 'Pará', 'PR', 'PAR', 1),
(124, 31, 'Paraíba', 'PB', 'PRB', 1),
(125, 31, 'Paraná', 'PA', 'PAB', 1),
(126, 31, 'Pernambuco', 'PE', 'PER', 1),
(127, 31, 'Piauí', 'PI', 'PIA', 1),
(128, 31, 'Rio Grande do Norte', 'RN', 'RGN', 1),
(129, 31, 'Rio Grande do Sul', 'RS', 'RGS', 1),
(130, 31, 'Rio de Janeiro', 'RJ', 'RDJ', 1),
(131, 31, 'Rondônia', 'RO', 'RON', 1),
(132, 31, 'Roraima', 'RR', 'ROR', 1),
(133, 31, 'Santa Catarina', 'SC', 'SAC', 1),
(134, 31, 'Sergipe', 'SE', 'SER', 1),
(135, 31, 'São Paulo', 'SP', 'SAP', 1),
(136, 31, 'Tocantins', 'TO', 'TOC', 1),
(137, 45, 'Anhui', '34', 'ANH', 1),
(138, 45, 'Beijing', '11', 'BEI', 1),
(139, 45, 'Chongqing', '50', 'CHO', 1),
(140, 45, 'Fujian', '35', 'FUJ', 1),
(141, 45, 'Gansu', '62', 'GAN', 1),
(142, 45, 'Guangdong', '44', 'GUA', 1),
(143, 45, 'Guangxi Zhuang', '45', 'GUZ', 1),
(144, 45, 'Guizhou', '52', 'GUI', 1),
(145, 45, 'Hainan', '46', 'HAI', 1),
(146, 45, 'Hebei', '13', 'HEB', 1),
(147, 45, 'Heilongjiang', '23', 'HEI', 1),
(148, 45, 'Henan', '41', 'HEN', 1),
(149, 45, 'Hubei', '42', 'HUB', 1),
(150, 45, 'Hunan', '43', 'HUN', 1),
(151, 45, 'Jiangsu', '32', 'JIA', 1),
(152, 45, 'Jiangxi', '36', 'JIX', 1),
(153, 45, 'Jilin', '22', 'JIL', 1),
(154, 45, 'Liaoning', '21', 'LIA', 1),
(155, 45, 'Nei Mongol', '15', 'NML', 1),
(156, 45, 'Ningxia Hui', '64', 'NIH', 1),
(157, 45, 'Qinghai', '63', 'QIN', 1),
(158, 45, 'Shandong', '37', 'SNG', 1),
(159, 45, 'Shanghai', '31', 'SHH', 1),
(160, 45, 'Shaanxi', '61', 'SHX', 1),
(161, 45, 'Sichuan', '51', 'SIC', 1),
(162, 45, 'Tianjin', '12', 'TIA', 1),
(163, 45, 'Xinjiang Uygur', '65', 'XIU', 1),
(164, 45, 'Xizang', '54', 'XIZ', 1),
(165, 45, 'Yunnan', '53', 'YUN', 1),
(166, 45, 'Zhejiang', '33', 'ZHE', 1),
(167, 105, 'Israel', 'IL', 'ISL', 1),
(168, 105, 'Gaza Strip', 'GZ', 'GZS', 1),
(169, 105, 'West Bank', 'WB', 'WBK', 1),
(170, 152, 'St. Maarten', 'SM', 'STM', 1),
(171, 152, 'Bonaire', 'BN', 'BNR', 1),
(172, 152, 'Curacao', 'CR', 'CUR', 1),
(173, 176, 'Alba', 'AB', 'ABA', 1),
(174, 176, 'Arad', 'AR', 'ARD', 1),
(175, 176, 'Arges', 'AG', 'ARG', 1),
(176, 176, 'Bacau', 'BC', 'BAC', 1),
(177, 176, 'Bihor', 'BH', 'BIH', 1),
(178, 176, 'Bistrita-Nasaud', 'BN', 'BIS', 1),
(179, 176, 'Botosani', 'BT', 'BOT', 1),
(180, 176, 'Braila', 'BR', 'BRL', 1),
(181, 176, 'Brasov', 'BV', 'BRA', 1),
(182, 176, 'Bucuresti', 'B', 'BUC', 1),
(183, 176, 'Buzau', 'BZ', 'BUZ', 1),
(184, 176, 'Calarasi', 'CL', 'CAL', 1),
(185, 176, 'Caras Severin', 'CS', 'CRS', 1),
(186, 176, 'Cluj', 'CJ', 'CLJ', 1),
(187, 176, 'Constanta', 'CT', 'CST', 1),
(188, 176, 'Covasna', 'CV', 'COV', 1),
(189, 176, 'Dambovita', 'DB', 'DAM', 1),
(190, 176, 'Dolj', 'DJ', 'DLJ', 1),
(191, 176, 'Galati', 'GL', 'GAL', 1),
(192, 176, 'Giurgiu', 'GR', 'GIU', 1),
(193, 176, 'Gorj', 'GJ', 'GOR', 1),
(194, 176, 'Hargita', 'HR', 'HRG', 1),
(195, 176, 'Hunedoara', 'HD', 'HUN', 1),
(196, 176, 'Ialomita', 'IL', 'IAL', 1),
(197, 176, 'Iasi', 'IS', 'IAS', 1),
(198, 176, 'Ilfov', 'IF', 'ILF', 1),
(199, 176, 'Maramures', 'MM', 'MAR', 1),
(200, 176, 'Mehedinti', 'MH', 'MEH', 1),
(201, 176, 'Mures', 'MS', 'MUR', 1),
(202, 176, 'Neamt', 'NT', 'NEM', 1),
(203, 176, 'Olt', 'OT', 'OLT', 1),
(204, 176, 'Prahova', 'PH', 'PRA', 1),
(205, 176, 'Salaj', 'SJ', 'SAL', 1),
(206, 176, 'Satu Mare', 'SM', 'SAT', 1),
(207, 176, 'Sibiu', 'SB', 'SIB', 1),
(208, 176, 'Suceava', 'SV', 'SUC', 1),
(209, 176, 'Teleorman', 'TR', 'TEL', 1),
(210, 176, 'Timis', 'TM', 'TIM', 1),
(211, 176, 'Tulcea', 'TL', 'TUL', 1),
(212, 176, 'Valcea', 'VL', 'VAL', 1),
(213, 176, 'Vaslui', 'VS', 'VAS', 1),
(214, 176, 'Vrancea', 'VN', 'VRA', 1),
(215, 106, 'Agrigento', 'AG', 'AGR', 1),
(216, 106, 'Alessandria', 'AL', 'ALE', 1),
(217, 106, 'Ancona', 'AN', 'ANC', 1),
(218, 106, 'Aosta', 'AO', 'AOS', 1),
(219, 106, 'Arezzo', 'AR', 'ARE', 1),
(220, 106, 'Ascoli Piceno', 'AP', 'API', 1),
(221, 106, 'Asti', 'AT', 'AST', 1),
(222, 106, 'Avellino', 'AV', 'AVE', 1),
(223, 106, 'Bari', 'BA', 'BAR', 1),
(224, 106, 'Belluno', 'BL', 'BEL', 1),
(225, 106, 'Benevento', 'BN', 'BEN', 1),
(226, 106, 'Bergamo', 'BG', 'BEG', 1),
(227, 106, 'Biella', 'BI', 'BIE', 1),
(228, 106, 'Bologna', 'BO', 'BOL', 1),
(229, 106, 'Bolzano', 'BZ', 'BOZ', 1),
(230, 106, 'Brescia', 'BS', 'BRE', 1),
(231, 106, 'Brindisi', 'BR', 'BRI', 1),
(232, 106, 'Cagliari', 'CA', 'CAG', 1),
(233, 106, 'Caltanissetta', 'CL', 'CAL', 1),
(234, 106, 'Campobasso', 'CB', 'CBO', 1),
(235, 106, 'Carbonia-Iglesias', 'CI', 'CAR', 1),
(236, 106, 'Caserta', 'CE', 'CAS', 1),
(237, 106, 'Catania', 'CT', 'CAT', 1),
(238, 106, 'Catanzaro', 'CZ', 'CTZ', 1),
(239, 106, 'Chieti', 'CH', 'CHI', 1),
(240, 106, 'Como', 'CO', 'COM', 1),
(241, 106, 'Cosenza', 'CS', 'COS', 1),
(242, 106, 'Cremona', 'CR', 'CRE', 1),
(243, 106, 'Crotone', 'KR', 'CRO', 1),
(244, 106, 'Cuneo', 'CN', 'CUN', 1),
(245, 106, 'Enna', 'EN', 'ENN', 1),
(246, 106, 'Ferrara', 'FE', 'FER', 1),
(247, 106, 'Firenze', 'FI', 'FIR', 1),
(248, 106, 'Foggia', 'FG', 'FOG', 1),
(249, 106, 'Forli-Cesena', 'FC', 'FOC', 1),
(250, 106, 'Frosinone', 'FR', 'FRO', 1),
(251, 106, 'Genova', 'GE', 'GEN', 1),
(252, 106, 'Gorizia', 'GO', 'GOR', 1),
(253, 106, 'Grosseto', 'GR', 'GRO', 1),
(254, 106, 'Imperia', 'IM', 'IMP', 1),
(255, 106, 'Isernia', 'IS', 'ISE', 1),
(256, 106, 'L\'Aquila', 'AQ', 'AQU', 1),
(257, 106, 'La Spezia', 'SP', 'LAS', 1),
(258, 106, 'Latina', 'LT', 'LAT', 1),
(259, 106, 'Lecce', 'LE', 'LEC', 1),
(260, 106, 'Lecco', 'LC', 'LCC', 1),
(261, 106, 'Livorno', 'LI', 'LIV', 1),
(262, 106, 'Lodi', 'LO', 'LOD', 1),
(263, 106, 'Lucca', 'LU', 'LUC', 1),
(264, 106, 'Macerata', 'MC', 'MAC', 1),
(265, 106, 'Mantova', 'MN', 'MAN', 1),
(266, 106, 'Massa-Carrara', 'MS', 'MAS', 1),
(267, 106, 'Matera', 'MT', 'MAA', 1),
(268, 106, 'Medio Campidano', 'VS', 'MED', 1),
(269, 106, 'Messina', 'ME', 'MES', 1),
(270, 106, 'Milano', 'MI', 'MIL', 1),
(271, 106, 'Modena', 'MO', 'MOD', 1),
(272, 106, 'Napoli', 'NA', 'NAP', 1),
(273, 106, 'Novara', 'NO', 'NOV', 1),
(274, 106, 'Nuoro', 'NU', 'NUR', 1),
(275, 106, 'Ogliastra', 'OG', 'OGL', 1),
(276, 106, 'Olbia-Tempio', 'OT', 'OLB', 1),
(277, 106, 'Oristano', 'OR', 'ORI', 1),
(278, 106, 'Padova', 'PD', 'PDA', 1),
(279, 106, 'Palermo', 'PA', 'PAL', 1),
(280, 106, 'Parma', 'PR', 'PAA', 1),
(281, 106, 'Pavia', 'PV', 'PAV', 1),
(282, 106, 'Perugia', 'PG', 'PER', 1),
(283, 106, 'Pesaro e Urbino', 'PU', 'PES', 1),
(284, 106, 'Pescara', 'PE', 'PSC', 1),
(285, 106, 'Piacenza', 'PC', 'PIA', 1),
(286, 106, 'Pisa', 'PI', 'PIS', 1),
(287, 106, 'Pistoia', 'PT', 'PIT', 1),
(288, 106, 'Pordenone', 'PN', 'POR', 1),
(289, 106, 'Potenza', 'PZ', 'PTZ', 1),
(290, 106, 'Prato', 'PO', 'PRA', 1),
(291, 106, 'Ragusa', 'RG', 'RAG', 1),
(292, 106, 'Ravenna', 'RA', 'RAV', 1),
(293, 106, 'Reggio Calabria', 'RC', 'REG', 1),
(294, 106, 'Reggio Emilia', 'RE', 'REE', 1),
(295, 106, 'Rieti', 'RI', 'RIE', 1),
(296, 106, 'Rimini', 'RN', 'RIM', 1),
(297, 106, 'Roma', 'RM', 'ROM', 1),
(298, 106, 'Rovigo', 'RO', 'ROV', 1),
(299, 106, 'Salerno', 'SA', 'SAL', 1),
(300, 106, 'Sassari', 'SS', 'SAS', 1),
(301, 106, 'Savona', 'SV', 'SAV', 1),
(302, 106, 'Siena', 'SI', 'SIE', 1),
(303, 106, 'Siracusa', 'SR', 'SIR', 1),
(304, 106, 'Sondrio', 'SO', 'SOO', 1),
(305, 106, 'Taranto', 'TA', 'TAR', 1),
(306, 106, 'Teramo', 'TE', 'TER', 1),
(307, 106, 'Terni', 'TR', 'TRN', 1),
(308, 106, 'Torino', 'TO', 'TOR', 1),
(309, 106, 'Trapani', 'TP', 'TRA', 1),
(310, 106, 'Trento', 'TN', 'TRE', 1),
(311, 106, 'Treviso', 'TV', 'TRV', 1),
(312, 106, 'Trieste', 'TS', 'TRI', 1),
(313, 106, 'Udine', 'UD', 'UDI', 1),
(314, 106, 'Varese', 'VA', 'VAR', 1),
(315, 106, 'Venezia', 'VE', 'VEN', 1),
(316, 106, 'Verbano Cusio Ossola', 'VB', 'VCO', 1),
(317, 106, 'Vercelli', 'VC', 'VER', 1),
(318, 106, 'Verona', 'VR', 'VRN', 1),
(319, 106, 'Vibo Valenzia', 'VV', 'VIV', 1),
(320, 106, 'Vicenza', 'VI', 'VII', 1),
(321, 106, 'Viterbo', 'VT', 'VIT', 1),
(322, 196, 'A Coruña', '15', 'ACO', 1),
(323, 196, 'Alava', '01', 'ALA', 1),
(324, 196, 'Albacete', '02', 'ALB', 1),
(325, 196, 'Alicante', '03', 'ALI', 1),
(326, 196, 'Almeria', '04', 'ALM', 1),
(327, 196, 'Asturias', '33', 'AST', 1),
(328, 196, 'Avila', '05', 'AVI', 1),
(329, 196, 'Badajoz', '06', 'BAD', 1),
(330, 196, 'Baleares', '07', 'BAL', 1),
(331, 196, 'Barcelona', '08', 'BAR', 1),
(332, 196, 'Burgos', '09', 'BUR', 1),
(333, 196, 'Caceres', '10', 'CAC', 1),
(334, 196, 'Cadiz', '11', 'CAD', 1),
(335, 196, 'Cantabria', '39', 'CAN', 1),
(336, 196, 'Castellon', '12', 'CAS', 1),
(337, 196, 'Ceuta', '51', 'CEU', 1),
(338, 196, 'Ciudad Real', '13', 'CIU', 1),
(339, 196, 'Cordoba', '14', 'COR', 1),
(340, 196, 'Cuenca', '16', 'CUE', 1),
(341, 196, 'Girona', '17', 'GIR', 1),
(342, 196, 'Granada', '18', 'GRA', 1),
(343, 196, 'Guadalajara', '19', 'GUA', 1),
(344, 196, 'Guipuzcoa', '20', 'GUI', 1),
(345, 196, 'Huelva', '21', 'HUL', 1),
(346, 196, 'Huesca', '22', 'HUS', 1),
(347, 196, 'Jaen', '23', 'JAE', 1),
(348, 196, 'La Rioja', '26', 'LRI', 1),
(349, 196, 'Las Palmas', '35', 'LPA', 1),
(350, 196, 'Leon', '24', 'LEO', 1),
(351, 196, 'Lleida', '25', 'LLE', 1),
(352, 196, 'Lugo', '27', 'LUG', 1),
(353, 196, 'Madrid', '28', 'MAD', 1),
(354, 196, 'Malaga', '29', 'MAL', 1),
(355, 196, 'Melilla', '52', 'MEL', 1),
(356, 196, 'Murcia', '30', 'MUR', 1),
(357, 196, 'Navarra', '31', 'NAV', 1),
(358, 196, 'Ourense', '32', 'OUR', 1),
(359, 196, 'Palencia', '34', 'PAL', 1),
(360, 196, 'Pontevedra', '36', 'PON', 1),
(361, 196, 'Salamanca', '37', 'SAL', 1),
(362, 196, 'Santa Cruz de Tenerife', '38', 'SCT', 1),
(363, 196, 'Segovia', '40', 'SEG', 1),
(364, 196, 'Sevilla', '41', 'SEV', 1),
(365, 196, 'Soria', '42', 'SOR', 1),
(366, 196, 'Tarragona', '43', 'TAR', 1),
(367, 196, 'Teruel', '44', 'TER', 1),
(368, 196, 'Toledo', '45', 'TOL', 1),
(369, 196, 'Valencia', '46', 'VAL', 1),
(370, 196, 'Valladolid', '47', 'VLL', 1),
(371, 196, 'Vizcaya', '48', 'VIZ', 1),
(372, 196, 'Zamora', '49', 'ZAM', 1),
(373, 196, 'Zaragoza', '50', 'ZAR', 1),
(374, 12, 'Aragatsotn', 'AG', 'ARG', 1),
(375, 12, 'Ararat', 'AR', 'ARR', 1),
(376, 12, 'Armavir', 'AV', 'ARM', 1),
(377, 12, 'Gegharkunik', 'GR', 'GEG', 1),
(378, 12, 'Kotayk', 'KT', 'KOT', 1),
(379, 12, 'Lori', 'LO', 'LOR', 1),
(380, 12, 'Shirak', 'SH', 'SHI', 1),
(381, 12, 'Syunik', 'SU', 'SYU', 1),
(382, 12, 'Tavush', 'TV', 'TAV', 1),
(383, 12, 'Vayots-Dzor', 'VD', 'VAD', 1),
(384, 12, 'Yerevan', 'ER', 'YER', 1),
(385, 100, 'Andaman & Nicobar Islands', 'AI', 'ANI', 1),
(386, 100, 'Andhra Pradesh', 'AN', 'AND', 1),
(387, 100, 'Arunachal Pradesh', 'AR', 'ARU', 1),
(388, 100, 'Assam', 'AS', 'ASS', 1),
(389, 100, 'Bihar', 'BI', 'BIH', 1),
(390, 100, 'Chandigarh', 'CA', 'CHA', 1),
(391, 100, 'Chhatisgarh', 'CH', 'CHH', 1),
(392, 100, 'Dadra & Nagar Haveli', 'DD', 'DAD', 1),
(393, 100, 'Daman & Diu', 'DA', 'DAM', 1),
(394, 100, 'Delhi', 'DE', 'DEL', 1),
(395, 100, 'Goa', 'GO', 'GOA', 1),
(396, 100, 'Gujarat', 'GU', 'GUJ', 1),
(397, 100, 'Haryana', 'HA', 'HAR', 1),
(398, 100, 'Himachal Pradesh', 'HI', 'HIM', 1),
(399, 100, 'Jammu & Kashmir', 'JA', 'JAM', 1),
(400, 100, 'Jharkhand', 'JH', 'JHA', 1),
(401, 100, 'Karnataka', 'KA', 'KAR', 1),
(402, 100, 'Kerala', 'KE', 'KER', 1),
(403, 100, 'Lakshadweep', 'LA', 'LAK', 1),
(404, 100, 'Madhya Pradesh', 'MD', 'MAD', 1),
(405, 100, 'Maharashtra', 'MH', 'MAH', 1),
(406, 100, 'Manipur', 'MN', 'MAN', 1),
(407, 100, 'Meghalaya', 'ME', 'MEG', 1),
(408, 100, 'Mizoram', 'MI', 'MIZ', 1),
(409, 100, 'Nagaland', 'NA', 'NAG', 1),
(410, 100, 'Odisha', 'OR', 'ORI', 1),
(411, 100, 'Puducherry', 'PO', 'PON', 1),
(412, 100, 'Punjab', 'PU', 'PUN', 1),
(413, 100, 'Rajasthan', 'RA', 'RAJ', 1),
(414, 100, 'Sikkim', 'SI', 'SIK', 1),
(415, 100, 'Tamil Nadu', 'TA', 'TAM', 1),
(416, 100, 'Tripura', 'TR', 'TRI', 1),
(417, 100, 'Uttarakhand', 'UA', 'UAR', 1),
(418, 100, 'Uttar Pradesh', 'UT', 'UTT', 1),
(419, 100, 'West Bengal', 'WE', 'WES', 1),
(420, 102, 'Ahmadi va Kohkiluyeh', 'BO', 'BOK', 1),
(421, 102, 'Ardabil', 'AR', 'ARD', 1),
(422, 102, 'Azarbayjan-e Gharbi', 'AG', 'AZG', 1),
(423, 102, 'Azarbayjan-e Sharqi', 'AS', 'AZS', 1),
(424, 102, 'Bushehr', 'BU', 'BUS', 1),
(425, 102, 'Chaharmahal va Bakhtiari', 'CM', 'CMB', 1),
(426, 102, 'Esfahan', 'ES', 'ESF', 1),
(427, 102, 'Fars', 'FA', 'FAR', 1),
(428, 102, 'Gilan', 'GI', 'GIL', 1),
(429, 102, 'Gorgan', 'GO', 'GOR', 1),
(430, 102, 'Hamadan', 'HA', 'HAM', 1),
(431, 102, 'Hormozgan', 'HO', 'HOR', 1),
(432, 102, 'Ilam', 'IL', 'ILA', 1),
(433, 102, 'Kerman', 'KE', 'KER', 1),
(434, 102, 'Kermanshah', 'BA', 'BAK', 1),
(435, 102, 'Khorasan-e Junoubi', 'KJ', 'KHJ', 1),
(436, 102, 'Khorasan-e Razavi', 'KR', 'KHR', 1),
(437, 102, 'Khorasan-e Shomali', 'KS', 'KHS', 1),
(438, 102, 'Khuzestan', 'KH', 'KHU', 1),
(439, 102, 'Kordestan', 'KO', 'KOR', 1),
(440, 102, 'Lorestan', 'LO', 'LOR', 1),
(441, 102, 'Markazi', 'MR', 'MAR', 1),
(442, 102, 'Mazandaran', 'MZ', 'MAZ', 1),
(443, 102, 'Qazvin', 'QA', 'QAS', 1),
(444, 102, 'Qom', 'QO', 'QOM', 1),
(445, 102, 'Semnan', 'SE', 'SEM', 1),
(446, 102, 'Sistan va Baluchestan', 'SB', 'SBA', 1),
(447, 102, 'Tehran', 'TE', 'TEH', 1),
(448, 102, 'Yazd', 'YA', 'YAZ', 1),
(449, 102, 'Zanjan', 'ZA', 'ZAN', 1),
(450, 85, 'Άρτας', 'ΑΑ', 'ΑΡΤ', 1),
(451, 85, 'Αιτωλοακαρνανίας', 'ΑΙ', 'ΑΙΤ', 1),
(452, 85, 'Αρκαδίας', 'ΑΚ', 'ΑΡΚ', 1),
(453, 85, 'Αργολίδας', 'ΑΡ', 'ΑΡΓ', 1),
(454, 85, 'Αττικής', 'ΑΤ', 'ΑΤΤ', 1),
(455, 85, 'Αχαΐας', 'ΑΧ', 'ΑΧΑ', 1),
(456, 85, 'Βοιωτίας', 'ΒΟ', 'ΒΟΙ', 1),
(457, 85, 'Γρεβενών', 'ΓΡ', 'ΓΡΕ', 1),
(458, 85, 'Δράμας', 'ΔΡ', 'ΔΡΑ', 1),
(459, 85, 'Δωδεκάνησου', 'ΔΩ', 'ΔΩΔ', 1),
(460, 85, 'Εβραίου', 'ΕΒ', 'ΕΒΡ', 1),
(461, 85, 'Ευρυτανίας', 'ΕΡ', 'ΕΥΡ', 1),
(462, 85, 'Ευβοίας', 'ΕΥ', 'ΕΥΒ', 1),
(463, 85, 'Ζακύνθου', 'ΖΑ', 'ΖΑΚ', 1),
(464, 85, 'Ηλείας', 'ΗΛ', 'ΗΛΕ', 1),
(465, 85, 'Ημαθίας', 'ΗΜ', 'ΗΜΑ', 1),
(466, 85, 'Ηράκλειου', 'ΗΡ', 'ΗΡΑ', 1),
(467, 85, 'Θεσσαλονίκης', 'ΘΕ', 'ΘΕΣ', 1),
(468, 85, 'Θεσπρωτίας', 'ΘΠ', 'ΘΕΠ', 1),
(469, 85, 'Ιωαννίνων', 'ΙΩ', 'ΙΩΑ', 1),
(470, 85, 'Κοζάνης', 'ΚZ', 'ΚΟΖ', 1),
(471, 85, 'Καβάλας', 'ΚΒ', 'ΚΑΒ', 1),
(472, 85, 'Κέρκυρας', 'ΚΕ', 'ΚΕΡ', 1),
(473, 85, 'Κιλκίς', 'ΚΙ', 'ΚΙΛ', 1),
(474, 85, 'Κορινθίας', 'ΚΟ', 'ΚΟΡ', 1),
(475, 85, 'Καρδίτσας', 'ΚΡ', 'ΚΑΡ', 1),
(476, 85, 'Καστοριάς', 'ΚΣ', 'ΚΑΣ', 1),
(477, 85, 'Κυκλάδων', 'ΚΥ', 'ΚΥΚ', 1),
(478, 85, 'Κεφαλληνίας', 'ΚΦ', 'ΚΕΦ', 1),
(479, 85, 'Λακωνίας', 'ΛK', 'ΛΑΚ', 1),
(480, 85, 'Λασιθίου', 'ΛΑ', 'ΛΑΣ', 1),
(481, 85, 'Λευκάδας', 'ΛΕ', 'ΛΕΥ', 1),
(482, 85, 'Λάρισας', 'ΛΡ', 'ΛΑΡ', 1),
(483, 85, 'Λέσβου', 'ΛΣ', 'ΛΕΣ', 1),
(484, 85, 'Μαγνησίας', 'ΜΑ', 'ΜΑΓ', 1),
(485, 85, 'Μεσσηνίας', 'ΜΕ', 'ΜΕΣ', 1),
(486, 85, 'Ξάνθης', 'ΞΑ', 'ΞΑΝ', 1),
(487, 85, 'Πέλλης', 'ΠΕ', 'ΠΕΛ', 1),
(488, 85, 'Πιερίας', 'ΠΙ', 'ΠΙΕ', 1),
(489, 85, 'Πρέβεζας', 'ΠΡ', 'ΠΡΕ', 1),
(490, 85, 'Ρεθύμνης', 'ΡΕ', 'ΡΕΘ', 1),
(491, 85, 'Ροδόπης', 'ΡΟ', 'ΡΟΔ', 1),
(492, 85, 'Σάμου', 'ΣΑ', 'ΣΑΜ', 1),
(493, 85, 'Σερρών', 'ΣΕ', 'ΣΕΡ', 1),
(494, 85, 'Τρικάλων', 'ΤΡ', 'ΤΡΙ', 1),
(495, 85, 'Φθιώτιδας', 'ΦΘ', 'ΦΘΙ', 1),
(496, 85, 'Φλώρινας', 'ΦΛ', 'ΦΛΩ', 1),
(497, 85, 'Φωκίδας', 'ΦΩ', 'ΦΩΚ', 1),
(498, 85, 'Χαλκιδικής', 'ΧΑ', 'ΧΑΛ', 1),
(499, 85, 'Χίου', 'ΧΙ', 'ΧΙΟ', 1),
(500, 85, 'Χανίων', 'ΧΝ', 'ΧΑΝ', 1),
(501, 82, 'Freie und Hansestadt Hamburg', 'HH', 'HAM', 1),
(502, 82, 'Niedersachsen', 'NI', 'NIS', 1),
(503, 82, 'Freie Hansestadt Bremen', 'HB', 'HBR', 1),
(504, 82, 'Nordrhein-Westfalen', 'NW', 'NRW', 1),
(505, 82, 'Hessen', 'HE', 'HES', 1),
(506, 82, 'Rheinland-Pfalz', 'RP', 'RLP', 1),
(507, 82, 'Baden-Württemberg', 'BW', 'BWÜ', 1),
(508, 82, 'Freistaat Bayern', 'BY', 'BAV', 1),
(509, 82, 'Saarland', 'SL', 'SLA', 1),
(510, 82, 'Berlin', 'BE', 'BER', 1),
(511, 82, 'Brandenburg', 'BB', 'BRB', 1),
(512, 82, 'Mecklenburg-Vorpommern', 'MV', 'MVO', 1),
(513, 82, 'Freistaat Sachsen', 'SN', 'SAC', 1),
(514, 82, 'Sachsen-Anhalt', 'ST', 'SAA', 1),
(515, 82, 'Freistaat Thüringen', 'TH', 'THÜ', 1),
(516, 82, 'Schleswig-Holstein', 'SH', 'SHO', 1),
(517, 56, 'Λευκωσίας', 'NI', 'NIC', 1),
(518, 56, 'Αμμοχώστου', 'AM', 'AMO', 1),
(519, 56, 'Πάφου', 'PA', 'PAF', 1),
(520, 56, 'Λεμεσού', 'LE', 'LEM', 1),
(521, 56, 'Λάρνακας', 'LA', 'LAR', 1),
(522, 56, 'Κερύνειας', 'KE', 'KER', 1),
(523, 169, 'Abra', 'AB', 'ABR', 1),
(524, 169, 'Agusan del Norte', 'AG', 'AGN', 1),
(525, 169, 'Agusan del Sur', 'AG', 'AGS', 1),
(526, 169, 'Aklan', 'AK', 'AKL', 1),
(527, 169, 'Albay', 'AL', 'ALB', 1),
(528, 169, 'Antique', 'AN', 'ANT', 1),
(529, 169, 'Apayao', 'AP', 'APA', 1),
(530, 169, 'Aurora', 'AU', 'AUR', 1),
(531, 169, 'Basilan', 'BA', 'BAS', 1),
(532, 169, 'Bataan', 'BA', 'BAN', 1),
(533, 169, 'Batanes', 'BT', 'BTN', 1),
(534, 169, 'Batangas', 'BT', 'BTG', 1),
(535, 169, 'Benguet', 'BE', 'BEN', 1),
(536, 169, 'Biliran', 'BI', 'BIL', 1),
(537, 169, 'Bohol', 'BO', 'BOH', 1),
(538, 169, 'Bukidnon', 'BU', 'BUK', 1),
(539, 169, 'Bulacan', 'BU', 'BUL', 1),
(540, 169, 'Cagayan', 'CA', 'CAG', 1),
(541, 169, 'Camarines Norte', 'CA', 'CAN', 1),
(542, 169, 'Camarines Sur', 'CA', 'CAS', 1),
(543, 169, 'Camiguin', 'CA', 'CAM', 1),
(544, 169, 'Capiz', 'CA', 'CAP', 1),
(545, 169, 'Catanduanes', 'CA', 'CAT', 1),
(546, 169, 'Cavite', 'CA', 'CAV', 1),
(547, 169, 'Cebu', 'CE', 'CEB', 1),
(548, 169, 'Compostela Valley', 'CO', 'COM', 1),
(549, 169, 'Cotabato', 'NC', 'NCO', 1),
(550, 169, 'Davao del Norte', 'DA', 'DAV', 1),
(551, 169, 'Davao del Sur', 'DA', 'DAS', 1),
(552, 169, 'Davao Occidental', 'DV', 'DVO', 1),
(553, 169, 'Davao Oriental', 'DA', 'DAO', 1),
(554, 169, 'Dinagat Islands', 'DI', 'DIN', 1),
(555, 169, 'Eastern Samar', 'EA', 'EAS', 1),
(556, 169, 'Guimaras', 'GU', 'GUI', 1),
(557, 169, 'Ifugao', 'IF', 'IFU', 1),
(558, 169, 'Ilocos Norte', 'IL', 'ILN', 1),
(559, 169, 'Ilocos Sur', 'IL', 'ILS', 1),
(560, 169, 'Iloilo', 'IL', 'ILI', 1),
(561, 169, 'Isabela', 'IS', 'ISA', 1),
(562, 169, 'Kalinga', 'KA', 'KAL', 1),
(563, 169, 'Laguna', 'LA', 'LAG', 1),
(564, 169, 'Lanao del Norte', 'LA', 'LAN', 1),
(565, 169, 'Lanao del Su', 'LA', 'LAS', 1),
(566, 169, 'La Union', 'LU', 'LUN', 1),
(567, 169, 'Leyte', 'LE', 'LEY', 1),
(568, 169, 'Maguindanao', 'MA', 'MAG', 1),
(569, 169, 'Marinduque', 'MA', 'MAD', 1),
(570, 169, 'Masbate', 'MA', 'MAS', 1),
(571, 169, 'Metropolitan Manila', '00', '00', 1),
(572, 169, 'Misamis Occidental', 'MS', 'MSC', 1),
(573, 169, 'Misamis Oriental', 'MS', 'MSR', 1),
(574, 169, 'Mountain', 'MO', 'MOU', 1),
(575, 169, 'Negros Occidental', 'NE', 'NEC', 1),
(576, 169, 'Negros Oriental', 'NE', 'NER', 1),
(577, 169, 'Northern Samar', 'NS', 'NSA', 1),
(578, 169, 'Nueva Ecija', 'NU', 'NUE', 1),
(579, 169, 'Nueva Vizcaya', 'NU', 'NUV', 1),
(580, 169, 'Occidental Mindoro', 'MD', 'MDC', 1),
(581, 169, 'Oriental Mindoro', 'MD', 'MDR', 1),
(582, 169, 'Palawan', 'PL', 'PLW', 1),
(583, 169, 'Pampanga', 'PA', 'PAM', 1),
(584, 169, 'Pangasinan', 'PA', 'PAN', 1),
(585, 169, 'Quezon', 'QU', 'QUE', 1),
(586, 169, 'Quirino', 'QU', 'QUI', 1),
(587, 169, 'Rizal', 'Ri', 'RIZ', 1),
(588, 169, 'Romblon', 'RO', 'ROM', 1),
(589, 169, 'Samar', 'WS', 'WSA', 1),
(590, 169, 'Sarangani', 'SA', 'SAR', 1),
(591, 169, 'Siquijor', 'SI', 'SIG', 1),
(592, 169, 'Sorsogon', 'SO', 'SOR', 1),
(593, 169, 'South Cotabato', 'SC', 'SCO', 1),
(594, 169, 'Southern Leyte', 'SL', 'SLE', 1),
(595, 169, 'Sultan Kudarat', 'SU', 'SUK', 1),
(596, 169, 'Sulu', 'SL', 'SLU', 1),
(597, 169, 'Surigao del Norte', 'SU', 'SUN', 1),
(598, 169, 'Surigao del Sur', 'SU', 'SUR', 1),
(599, 169, 'Tarlac', 'TA', 'TAR', 1),
(600, 169, 'Tawi-Tawi', 'TA', 'TAW', 1),
(601, 169, 'Zambales', 'ZM', 'ZMB', 1),
(602, 169, 'Zamboanga del Norte', 'ZA', 'ZAN', 1),
(603, 169, 'Zamboanga del Sur', 'ZA', 'ZAS', 1),
(604, 169, 'Zamboanga-Sibugay', 'ZS', 'ZSI', 1),
(605, 165, 'Bocas del Toro', 'PA-1', 'PA-1', 1),
(606, 165, 'Coclé', 'PA-2', 'PA-2', 1),
(607, 165, 'Colón', 'PA-3', 'PA-3', 1),
(608, 165, 'Chiriquí', 'PA-4', 'PA-4', 1),
(609, 165, 'Darién', 'PA-5', 'PA-5', 1),
(610, 165, 'Herrera', 'PA-6', 'PA-6', 1),
(611, 165, 'Los Santos', 'PA-7', 'PA-7', 1),
(612, 165, 'Panamá', 'PA-8', 'PA-8', 1),
(613, 165, 'Veraguas', 'PA-9', 'PA-9', 1),
(614, 165, 'Panamá Oeste', 'PA-10', 'PA-10', 1),
(615, 165, 'Emberá', 'PA-EM', 'PA-EM', 1),
(616, 165, 'Guna Yala', 'PA-KY', 'PA-KY', 1),
(617, 165, 'Ngäbe-Buglé', 'PA-NB', 'PA-NB', 1),
(618, 2, 'بد خشان', '', '', 1),
(619, 2, 'بادغیس', '', '', 1),
(620, 2, 'بغلان', '', '', 1),
(621, 2, 'بلخ', '', '', 1),
(622, 2, 'بامیان', '', '', 1),
(623, 2, 'دایکندی', '', '', 1),
(624, 2, 'فراه', '', '', 1),
(625, 2, 'فارياب', '', '', 1),
(626, 2, 'غزنى', '', '', 1),
(627, 2, 'غور', '', '', 1),
(628, 2, 'هلمند', '', '', 1),
(629, 2, 'هرات', '', '', 1),
(630, 2, 'جوزجان', '', '', 1),
(631, 2, 'کابل', '', '', 1),
(632, 2, 'قندھار', '', '', 1),
(633, 2, 'کاپيسا', '', '', 1),
(634, 2, 'خوست', '', '', 1),
(635, 2, 'کُنَر', '', '', 1),
(636, 2, 'كندوز', '', '', 1),
(637, 2, 'لغمان', '', '', 1),
(638, 2, 'لوګر', '', '', 1),
(639, 2, 'ننگرهار', '', '', 1),
(640, 2, 'نیمروز', '', '', 1),
(641, 2, 'نورستان', '', '', 1),
(642, 2, 'ؤروزگان', '', '', 1),
(643, 2, 'پکتیا', '', '', 1),
(644, 2, 'پکتيکا', '', '', 1),
(645, 2, 'پنج شیر', '', '', 1),
(646, 2, 'پروان', '', '', 1),
(647, 2, 'سمنگان', '', '', 1),
(648, 2, 'سر پل', '', '', 1),
(649, 2, 'تخار', '', '', 1),
(650, 2, 'وردک', '', '', 1),
(651, 2, 'زابل', '', '', 1),
(652, 3, 'Beratit', '', '', 1),
(653, 3, 'Bulqizës', '', '', 1),
(654, 3, 'Dibrës', '', '', 1),
(655, 3, 'Delvinës', '', '', 1),
(656, 3, 'Durrësit', '', '', 1),
(657, 3, 'Devollit', '', '', 1),
(658, 3, 'Elbasanit', '', '', 1),
(659, 3, 'Kolonjës', '', '', 1),
(660, 3, 'Fierit', '', '', 1),
(661, 3, 'Gjirokastrës', '', '', 1),
(662, 3, 'Gramshit', '', '', 1),
(663, 3, 'Hasit', '', '', 1),
(664, 3, 'Kavajës', '', '', 1),
(665, 3, 'Kurbinit', '', '', 1),
(666, 3, 'Kuçovës', '', '', 1),
(667, 3, 'Korçës', '', '', 1),
(668, 3, 'Krujës', '', '', 1),
(669, 3, 'Kukësit', '', '', 1),
(670, 3, 'Librazhdit', '', '', 1),
(671, 3, 'Lezhës', '', '', 1),
(672, 3, 'Lushnjës', '', '', 1),
(673, 3, 'Mallakastrës', '', '', 1),
(674, 3, 'Malësisë së Madhe', '', '', 1),
(675, 3, 'Mirditës', '', '', 1),
(676, 3, 'Matit', '', '', 1),
(677, 3, 'Pogradecit', '', '', 1),
(678, 3, 'Peqinit', '', '', 1),
(679, 3, 'Përmetit', '', '', 1),
(680, 3, 'Pukës', '', '', 1),
(681, 3, 'Shkodrës', '', '', 1),
(682, 3, 'Skraparit', '', '', 1),
(683, 3, 'Sarandës', '', '', 1),
(684, 3, 'Tepelenës', '', '', 1),
(685, 3, 'Tropojës', '', '', 1),
(686, 3, 'Tiranës', '', '', 1),
(687, 3, 'Vlorës', '', '', 1),
(688, 4, 'ولاية أدرار', '', '', 1),
(689, 4, 'ولاية الشلف', '', '', 1),
(690, 4, 'ولاية الأغواط', '', '', 1),
(691, 4, 'ولاية أم البواقي', '', '', 1),
(692, 4, 'ولاية باتنة', '', '', 1),
(693, 4, 'ولاية بجاية', '', '', 1),
(694, 4, 'ولاية بسكرة', '', '', 1),
(695, 4, 'ولاية بشار', '', '', 1),
(696, 4, 'البليدة‎', '', '', 1),
(697, 4, 'ولاية البويرة', '', '', 1),
(698, 4, 'ولاية تمنراست', '', '', 1),
(699, 4, 'ولاية تبسة', '', '', 1),
(700, 4, 'تلمسان', '', '', 1),
(701, 4, 'ولاية تيارت', '', '', 1),
(702, 4, 'تيزي وزو', '', '', 1),
(703, 4, 'ولاية الجزائر', '', '', 1),
(704, 4, 'ولاية عين الدفلى', '', '', 1),
(705, 4, 'ولاية جيجل', '', '', 1),
(706, 4, 'ولاية سطيف', '', '', 1),
(707, 4, 'ولاية سعيدة', '', '', 1),
(708, 4, 'السكيكدة', '', '', 1),
(709, 4, 'ولاية سيدي بلعباس', '', '', 1),
(710, 4, 'ولاية عنابة', '', '', 1),
(711, 4, 'ولاية قالمة', '', '', 1),
(712, 4, 'قسنطينة', '', '', 1),
(713, 4, 'ولاية المدية', '', '', 1),
(714, 4, 'ولاية مستغانم', '', '', 1),
(715, 4, 'ولاية المسيلة', '', '', 1),
(716, 4, 'ولاية معسكر', '', '', 1),
(717, 4, 'ورقلة', '', '', 1),
(718, 4, 'وهران', '', '', 1),
(719, 4, 'ولاية البيض', '', '', 1),
(720, 4, 'ولاية اليزي', '', '', 1),
(721, 4, 'ولاية برج بوعريريج', '', '', 1),
(722, 4, 'ولاية بومرداس', '', '', 1),
(723, 4, 'ولاية الطارف', '', '', 1),
(724, 4, 'تندوف', '', '', 1),
(725, 4, 'ولاية تسمسيلت', '', '', 1),
(726, 4, 'ولاية الوادي', '', '', 1),
(727, 4, 'ولاية خنشلة', '', '', 1),
(728, 4, 'ولاية سوق أهراس', '', '', 1),
(729, 4, 'ولاية تيبازة', '', '', 1),
(730, 4, 'ولاية ميلة', '', '', 1),
(731, 4, 'ولاية عين الدفلى', '', '', 1),
(732, 4, 'ولاية النعامة', '', '', 1),
(733, 4, 'ولاية عين تموشنت', '', '', 1),
(734, 4, 'ولاية غرداية', '', '', 1),
(735, 4, 'ولاية غليزان', '', '', 1),
(736, 5, 'Eastern', '', '', 1),
(737, 5, 'Manu\'a', '', '', 1),
(738, 5, 'Rose Island', '', '', 1),
(739, 5, 'Swains Island', '', '', 1),
(740, 5, 'Western', '', '', 1),
(741, 6, 'Andorra la Vella', '', '', 1),
(742, 6, 'Canillo', '', '', 1),
(743, 6, 'Encamp', '', '', 1),
(744, 6, 'Escaldes-Engordany', '', '', 1),
(745, 6, 'La Massana', '', '', 1),
(746, 6, 'Ordino', '', '', 1),
(747, 6, 'Sant Juliá de Lória', '', '', 1),
(748, 7, 'Bengo', '', '', 1),
(749, 7, 'Benguela', '', '', 1),
(750, 7, 'Bié', '', '', 1),
(751, 7, 'Cabinda', '', '', 1),
(752, 7, 'Cuando Cubango', '', '', 1),
(753, 7, 'Cuanza Norte', '', '', 1),
(754, 7, 'Cuanza Sul', '', '', 1),
(755, 7, 'Cunene', '', '', 1),
(756, 7, 'Huambo', '', '', 1),
(757, 7, 'Huíla', '', '', 1),
(758, 7, 'Luanda', '', '', 1),
(759, 7, 'Lunda Norte', '', '', 1),
(760, 7, 'Lunda Sul', '', '', 1),
(761, 7, 'Malanje', '', '', 1),
(762, 7, 'Moxico', '', '', 1),
(763, 7, 'Namibe', '', '', 1),
(764, 7, 'Uíge', '', '', 1),
(765, 7, 'Zaire', '', '', 1),
(766, 10, 'Barbuda', '', '', 1),
(767, 10, 'Saint George', '', '', 1),
(768, 10, 'Saint John', '', '', 1),
(769, 10, 'Saint Mary', '', '', 1),
(770, 10, 'Saint Paul', '', '', 1),
(771, 10, 'Saint Peter', '', '', 1),
(772, 10, 'Saint Philip', '', '', 1),
(773, 11, 'Salta', '', '', 1),
(774, 11, 'Buenos Aires Province', '', '', 1),
(775, 11, 'Capital Federal', '', '', 1),
(776, 11, 'San Luis', '', '', 1),
(777, 11, 'Entre Ríos', '', '', 1),
(778, 11, 'La Rioja', '', '', 1),
(779, 11, 'Santiago del Estero', '', '', 1),
(780, 11, 'Chaco', '', '', 1),
(781, 11, 'San Juan', '', '', 1),
(782, 11, 'Catamarca', '', '', 1),
(783, 11, 'La Pampa', '', '', 1),
(784, 11, 'Mendoza', '', '', 1),
(785, 11, 'Misiones', '', '', 1),
(786, 11, 'Formosa', '', '', 1),
(787, 11, 'Neuquén', '', '', 1),
(788, 11, 'Río Negro', '', '', 1),
(789, 11, 'Santa Fe', '', '', 1),
(790, 11, 'Tucumán', '', '', 1),
(791, 11, 'Chubut', '', '', 1),
(792, 11, 'Tierra del Fuego', '', '', 1),
(793, 11, 'Corrientes', '', '', 1),
(794, 11, 'Córdoba', '', '', 1),
(795, 11, 'Jujuy', '', '', 1),
(796, 11, 'Santa Cruz', '', '', 1),
(797, 12, 'Արագածոտն', '', '', 1),
(798, 12, 'Արարատ', '', '', 1),
(799, 12, 'Արմավիր', '', '', 1),
(800, 12, 'Երևան', '', '', 1),
(801, 12, 'Գեղարքունիք', '', '', 1),
(802, 12, 'Կոտայք', '', '', 1),
(803, 12, 'Լոռի', '', '', 1),
(804, 12, 'Շիրակ', '', '', 1),
(805, 12, 'Սյունիք', '', '', 1),
(806, 12, 'Տավուշ', '', '', 1),
(807, 12, 'Վայոց Ձոր', '', '', 1),
(808, 15, 'Burgenland', '', '', 1),
(809, 15, 'Kärnten', '', '', 1),
(810, 15, 'Niederösterreich', '', '', 1),
(811, 15, 'Oberösterreich', '', '', 1),
(812, 15, 'Salzburg', '', '', 1),
(813, 15, 'Steiermark', '', '', 1),
(814, 15, 'Tirol', '', '', 1),
(815, 15, 'Voralberg', '', '', 1),
(816, 15, 'Wien', '', '', 1),
(817, 16, 'Əli Bayramlı', '', '', 1),
(818, 16, 'Abşeron', '', '', 1),
(819, 16, 'Ağcabədi', '', '', 1),
(820, 16, 'Ağdam', '', '', 1),
(821, 16, 'Ağdaş', '', '', 1),
(822, 16, 'Ağstafa', '', '', 1),
(823, 16, 'Ağsu', '', '', 1),
(824, 16, 'Astara', '', '', 1),
(825, 16, 'Bakı', '', '', 1),
(826, 16, 'Babək', '', '', 1),
(827, 16, 'Balakən', '', '', 1),
(828, 16, 'Bərdə', '', '', 1),
(829, 16, 'Beyləqan', '', '', 1),
(830, 16, 'Biləsuvar', '', '', 1),
(831, 16, 'Cəbrayıl', '', '', 1),
(832, 16, 'Cəlilabab', '', '', 1),
(833, 16, 'Julfa', '', '', 1),
(834, 16, 'Daşkəsən', '', '', 1),
(835, 16, 'Dəvəçi', '', '', 1),
(836, 16, 'Füzuli', '', '', 1),
(837, 16, 'Gəncə', '', '', 1),
(838, 16, 'Gədəbəy', '', '', 1),
(839, 16, 'Goranboy', '', '', 1),
(840, 16, 'Göyçay', '', '', 1),
(841, 16, 'Hacıqabul', '', '', 1),
(842, 16, 'İmişli', '', '', 1),
(843, 16, 'İsmayıllı', '', '', 1),
(844, 16, 'Kəlbəcər', '', '', 1),
(845, 16, 'Kürdəmir', '', '', 1),
(846, 16, 'Lənkəran', '', '', 1),
(847, 16, 'Laçın', '', '', 1),
(848, 16, 'Lənkəran', '', '', 1),
(849, 16, 'Lerik', '', '', 1),
(850, 16, 'Masallı', '', '', 1),
(851, 16, 'Mingəçevir', '', '', 1),
(852, 16, 'Naftalan', '', '', 1),
(853, 16, 'Neftçala', '', '', 1),
(854, 16, 'Oğuz', '', '', 1),
(855, 16, 'Ordubad', '', '', 1),
(856, 16, 'Qəbələ', '', '', 1),
(857, 16, 'Qax', '', '', 1),
(858, 16, 'Qazax', '', '', 1),
(859, 16, 'Qobustan', '', '', 1),
(860, 16, 'Quba', '', '', 1),
(861, 16, 'Qubadlı', '', '', 1),
(862, 16, 'Qusar', '', '', 1),
(863, 16, 'Şəki', '', '', 1),
(864, 16, 'Saatlı', '', '', 1),
(865, 16, 'Sabirabad', '', '', 1),
(866, 16, 'Sədərək', '', '', 1),
(867, 16, 'Şahbuz', '', '', 1),
(868, 16, 'Şəki', '', '', 1),
(869, 16, 'Salyan', '', '', 1),
(870, 16, 'Sumqayıt', '', '', 1),
(871, 16, 'Şamaxı', '', '', 1),
(872, 16, 'Şəmkir', '', '', 1),
(873, 16, 'Samux', '', '', 1),
(874, 16, 'Şərur', '', '', 1),
(875, 16, 'Siyəzən', '', '', 1),
(876, 16, 'Şuşa (City)', '', '', 1),
(877, 16, 'Şuşa', '', '', 1),
(878, 16, 'Tərtər', '', '', 1),
(879, 16, 'Tovuz', '', '', 1),
(880, 16, 'Ucar', '', '', 1),
(881, 16, 'Xankəndi', '', '', 1),
(882, 16, 'Xaçmaz', '', '', 1),
(883, 16, 'Xanlar', '', '', 1),
(884, 16, 'Xızı', '', '', 1),
(885, 16, 'Xocalı', '', '', 1),
(886, 16, 'Xocavənd', '', '', 1),
(887, 16, 'Yardımlı', '', '', 1),
(888, 16, 'Yevlax (City)', '', '', 1),
(889, 16, 'Yevlax', '', '', 1),
(890, 16, 'Zəngilan', '', '', 1),
(891, 16, 'Zaqatala', '', '', 1),
(892, 16, 'Zərdab', '', '', 1),
(893, 16, 'Nakhichevan', '', '', 1),
(894, 17, 'Acklins and Crooked Islands', '', '', 1),
(895, 17, 'Bimini', '', '', 1),
(896, 17, 'Cat Island', '', '', 1),
(897, 17, 'Exuma', '', '', 1),
(898, 17, 'Freeport', '', '', 1),
(899, 17, 'Fresh Creek', '', '', 1),
(900, 17, 'Governor\'s Harbour', '', '', 1),
(901, 17, 'Green Turtle Cay', '', '', 1),
(902, 17, 'Harbour Island', '', '', 1),
(903, 17, 'High Rock', '', '', 1),
(904, 17, 'Inagua', '', '', 1),
(905, 17, 'Kemps Bay', '', '', 1),
(906, 17, 'Long Island', '', '', 1),
(907, 17, 'Marsh Harbour', '', '', 1),
(908, 17, 'Mayaguana', '', '', 1),
(909, 17, 'New Providence', '', '', 1),
(910, 17, 'Nicholls Town and Berry Islands', '', '', 1),
(911, 17, 'Ragged Island', '', '', 1),
(912, 17, 'Rock Sound', '', '', 1),
(913, 17, 'San Salvador and Rum Cay', '', '', 1),
(914, 17, 'Sandy Point', '', '', 1),
(915, 18, 'الحد', '', '', 1),
(916, 18, 'المحرق', '', '', 1),
(917, 18, 'المنامة', '', '', 1),
(918, 18, 'جد حفص', '', '', 1),
(919, 18, 'المنطقة الشمالية', '', '', 1),
(920, 18, 'سترة', '', '', 1),
(921, 18, 'المنطقة الوسطى', '', '', 1),
(922, 18, 'مدينة عيسى', '', '', 1),
(923, 18, 'الرفاع والمنطقة الجنوبية', '', '', 1),
(924, 18, 'المنطقة الغربية', '', '', 1),
(925, 18, 'جزر حوار', '', '', 1),
(926, 18, 'مدينة حمد', '', '', 1),
(927, 19, 'Bandarban', '', '', 1),
(928, 19, 'Barguna', '', '', 1),
(929, 19, 'Bogra', '', '', 1),
(930, 19, 'Brahmanbaria', '', '', 1),
(931, 19, 'Bagerhat', '', '', 1),
(932, 19, 'Barisal', '', '', 1),
(933, 19, 'Bhola', '', '', 1),
(934, 19, 'Comilla', '', '', 1),
(935, 19, 'Chandpur', '', '', 1),
(936, 19, 'Chittagong', '', '', 1),
(937, 19, 'Cox\'s Bazar', '', '', 1),
(938, 19, 'Chuadanga', '', '', 1),
(939, 19, 'Dhaka', '', '', 1),
(940, 19, 'Dinajpur', '', '', 1),
(941, 19, 'Faridpur', '', '', 1),
(942, 19, 'Feni', '', '', 1),
(943, 19, 'Gopalganj', '', '', 1),
(944, 19, 'Gazipur', '', '', 1),
(945, 19, 'Gaibandha', '', '', 1),
(946, 19, 'Habiganj', '', '', 1),
(947, 19, 'Jamalpur', '', '', 1),
(948, 19, 'Jessore', '', '', 1),
(949, 19, 'Jhenaidah', '', '', 1),
(950, 19, 'Jaipurhat', '', '', 1),
(951, 19, 'Jhalakati', '', '', 1),
(952, 19, 'Kishoreganj', '', '', 1),
(953, 19, 'Khulna', '', '', 1),
(954, 19, 'Kurigram', '', '', 1),
(955, 19, 'Khagrachari', '', '', 1),
(956, 19, 'Kushtia', '', '', 1),
(957, 19, 'Lakshmipur', '', '', 1),
(958, 19, 'Lalmonirhat', '', '', 1),
(959, 19, 'Manikganj', '', '', 1),
(960, 19, 'Mymensingh', '', '', 1),
(961, 19, 'Munshiganj', '', '', 1),
(962, 19, 'Madaripur', '', '', 1),
(963, 19, 'Magura', '', '', 1),
(964, 19, 'Moulvibazar', '', '', 1),
(965, 19, 'Meherpur', '', '', 1),
(966, 19, 'Narayanganj', '', '', 1),
(967, 19, 'Netrakona', '', '', 1),
(968, 19, 'Narsingdi', '', '', 1),
(969, 19, 'Narail', '', '', 1),
(970, 19, 'Natore', '', '', 1),
(971, 19, 'Nawabganj', '', '', 1),
(972, 19, 'Nilphamari', '', '', 1),
(973, 19, 'Noakhali', '', '', 1),
(974, 19, 'Naogaon', '', '', 1),
(975, 19, 'Pabna', '', '', 1),
(976, 19, 'Pirojpur', '', '', 1),
(977, 19, 'Patuakhali', '', '', 1),
(978, 19, 'Panchagarh', '', '', 1),
(979, 19, 'Rajbari', '', '', 1),
(980, 19, 'Rajshahi', '', '', 1),
(981, 19, 'Rangpur', '', '', 1),
(982, 19, 'Rangamati', '', '', 1),
(983, 19, 'Sherpur', '', '', 1),
(984, 19, 'Satkhira', '', '', 1),
(985, 19, 'Sirajganj', '', '', 1),
(986, 19, 'Sylhet', '', '', 1),
(987, 19, 'Sunamganj', '', '', 1),
(988, 19, 'Shariatpur', '', '', 1),
(989, 19, 'Tangail', '', '', 1),
(990, 19, 'Thakurgaon', '', '', 1),
(991, 20, 'Saint Andrew', '', '', 1),
(992, 20, 'Christ Church', '', '', 1),
(993, 20, 'Saint Peter', '', '', 1),
(994, 20, 'Saint George', '', '', 1),
(995, 20, 'Saint John', '', '', 1),
(996, 20, 'Saint Lucy', '', '', 1),
(997, 20, 'Saint Michael', '', '', 1),
(998, 20, 'Saint Joseph', '', '', 1),
(999, 20, 'Saint Philip', '', '', 1),
(1000, 20, 'Saint James', '', '', 1),
(1001, 20, 'Saint Thomas', '', '', 1),
(1002, 21, 'Брэ́сцкая во́бласць', '', '', 1),
(1003, 21, 'Го́мельская во́бласць', '', '', 1),
(1004, 21, 'Гро́дзенская во́бласць', '', '', 1),
(1005, 21, 'Магілёўская во́бласць', '', '', 1),
(1006, 21, 'Мі́нская во́бласць', '', '', 1),
(1007, 21, 'Ві́цебская во́бласць', '', '', 1),
(1008, 22, 'Brussel', '', '', 1),
(1009, 22, 'Antwerpen', '', '', 1),
(1010, 22, 'Vlaams-Brabant', '', '', 1),
(1011, 22, 'Limburg', '', '', 1),
(1012, 22, 'Oost-Vlaanderen', '', '', 1),
(1013, 22, 'West-Vlaanderen', '', '', 1),
(1014, 22, 'Brabant Wallon', '', '', 1),
(1015, 22, 'Hainaut', '', '', 1),
(1016, 22, 'Liège/Lüttich', '', '', 1),
(1017, 22, 'Luxembourg', '', '', 1),
(1018, 22, 'Namur', '', '', 1),
(1019, 23, 'Belize District', '', '', 1),
(1020, 23, 'Cayo District', '', '', 1),
(1021, 23, 'Corozal District', '', '', 1),
(1022, 23, 'Orange Walk District', '', '', 1),
(1023, 23, 'Stann Creek District', '', '', 1),
(1024, 23, 'Toledo District', '', '', 1),
(1025, 24, 'Alibori', '', '', 1),
(1026, 24, 'Atakora', '', '', 1),
(1027, 24, 'Atlantique', '', '', 1),
(1028, 24, 'Borgou', '', '', 1),
(1029, 24, 'Collines', '', '', 1),
(1030, 24, 'Donga', '', '', 1),
(1031, 24, 'Kouffo', '', '', 1),
(1032, 24, 'Littoral', '', '', 1),
(1033, 24, 'Mono', '', '', 1),
(1034, 24, 'Ouémé', '', '', 1),
(1035, 24, 'Plateau', '', '', 1),
(1036, 24, 'Zou', '', '', 1),
(1037, 25, 'Devonshire', '', '', 1),
(1038, 25, 'Hamilton City', '', '', 1),
(1039, 25, 'Hamilton', '', '', 1),
(1040, 25, 'Paget', '', '', 1),
(1041, 25, 'Pembroke', '', '', 1),
(1042, 25, 'Sandys', '', '', 1),
(1043, 25, 'Saint George City', '', '', 1),
(1044, 25, 'Saint George\'s', '', '', 1),
(1045, 25, 'Smiths', '', '', 1),
(1046, 25, 'Southampton', '', '', 1),
(1047, 25, 'Warwick', '', '', 1),
(1048, 26, 'Paro', '', '', 1),
(1049, 26, 'Chukha', '', '', 1),
(1050, 26, 'Haa', '', '', 1),
(1051, 26, 'Samtse', '', '', 1),
(1052, 26, 'Thimphu', '', '', 1),
(1053, 26, 'Tsirang', '', '', 1),
(1054, 26, 'Dagana', '', '', 1),
(1055, 26, 'Punakha', '', '', 1),
(1056, 26, 'Wangdue Phodrang', '', '', 1),
(1057, 26, 'Sarpang', '', '', 1),
(1058, 26, 'Trongsa', '', '', 1),
(1059, 26, 'Bumthang', '', '', 1),
(1060, 26, 'Zhemgang', '', '', 1),
(1061, 26, 'Trashigang', '', '', 1),
(1062, 26, 'Mongar', '', '', 1),
(1063, 26, 'Pemagatshel', '', '', 1),
(1064, 26, 'Luentse', '', '', 1),
(1065, 26, 'Samdrup Jongkhar', '', '', 1),
(1066, 26, 'Gasa', '', '', 1),
(1067, 26, 'Trashiyangse', '', '', 1),
(1068, 27, 'El Beni', '', '', 1),
(1069, 27, 'Cochabamba', '', '', 1),
(1070, 27, 'Chuquisaca', '', '', 1),
(1071, 27, 'La Paz', '', '', 1),
(1072, 27, 'Pando', '', '', 1),
(1073, 27, 'Oruro', '', '', 1),
(1074, 27, 'Potosí', '', '', 1),
(1075, 27, 'Santa Cruz', '', '', 1),
(1076, 27, 'Tarija', '', '', 1),
(1077, 29, 'Central', '', '', 1),
(1078, 29, 'Ghanzi', '', '', 1),
(1079, 29, 'Kgalagadi', '', '', 1),
(1080, 29, 'Kgatleng', '', '', 1),
(1081, 29, 'Kweneng', '', '', 1),
(1082, 29, 'North-East', '', '', 1),
(1083, 29, 'North-West', '', '', 1),
(1084, 29, 'South-East', '', '', 1),
(1085, 29, 'Southern', '', '', 1),
(1086, 31, 'Amazônia', '', '', 1),
(1087, 31, 'Amapá', '', '', 1),
(1088, 31, 'Bahia', '', '', 1),
(1089, 31, 'Ceará', '', '', 1),
(1090, 31, 'Goiás', '', '', 1),
(1091, 31, 'Maranhão', '', '', 1),
(1092, 31, 'Minas Gerais', '', '', 1),
(1093, 31, 'Pará', '', '', 1),
(1094, 31, 'Paraíba', '', '', 1),
(1095, 31, 'Piauí', '', '', 1),
(1096, 31, 'Paraná', '', '', 1),
(1097, 31, 'Rondônia', '', '', 1),
(1098, 31, 'São Paulo', '', '', 1),
(1099, 32, 'Peros Banhos', '', '', 1),
(1100, 32, 'Salomon Islands', '', '', 1),
(1101, 32, 'Nelsons Island', '', '', 1),
(1102, 32, 'Three Brothers', '', '', 1),
(1103, 32, 'Eagle Islands', '', '', 1),
(1104, 32, 'Danger Island', '', '', 1),
(1105, 32, 'Egmont Islands', '', '', 1),
(1106, 32, 'Diego Garcia', '', '', 1),
(1107, 33, 'Belait', '', '', 1),
(1108, 33, 'Brunei-Muara', '', '', 1),
(1109, 33, 'Temburong', '', '', 1),
(1110, 33, 'Tutong', '', '', 1),
(1111, 34, 'Blagoevgrad', '', '', 1),
(1112, 34, 'Burgas', '', '', 1),
(1113, 34, 'Varna', '', '', 1),
(1114, 34, 'Veliko Tarnovo', '', '', 1),
(1115, 34, 'Vidin', '', '', 1),
(1116, 34, 'Vratsa', '', '', 1),
(1117, 34, 'Gabrovo', '', '', 1),
(1118, 34, 'Dobrich', '', '', 1),
(1119, 34, 'Kardzhali', '', '', 1),
(1120, 34, 'Kyustendil', '', '', 1),
(1121, 34, 'Lovech', '', '', 1),
(1122, 34, 'Montana', '', '', 1),
(1123, 34, 'Pazardzhik', '', '', 1),
(1124, 34, 'Pernik', '', '', 1),
(1125, 34, 'Pleven', '', '', 1),
(1126, 34, 'Plovdiv', '', '', 1),
(1127, 34, 'Razgrad', '', '', 1),
(1128, 34, 'Ruse', '', '', 1),
(1129, 34, 'Silistra', '', '', 1),
(1130, 34, 'Sliven', '', '', 1),
(1131, 34, 'Smolyan', '', '', 1),
(1132, 34, 'Sofia', '', '', 1),
(1133, 34, 'Sofia Province', '', '', 1),
(1134, 34, 'Stara Zagora', '', '', 1),
(1135, 34, 'Targovishte', '', '', 1),
(1136, 34, 'Haskovo', '', '', 1),
(1137, 34, 'Shumen', '', '', 1),
(1138, 34, 'Yambol', '', '', 1),
(1139, 35, 'Balé', '', '', 1),
(1140, 35, 'Bam', '', '', 1),
(1141, 35, 'Banwa', '', '', 1),
(1142, 35, 'Bazèga', '', '', 1),
(1143, 35, 'Bougouriba', '', '', 1),
(1144, 35, 'Boulgou', '', '', 1),
(1145, 35, 'Boulkiemdé', '', '', 1),
(1146, 35, 'Komoé', '', '', 1),
(1147, 35, 'Ganzourgou', '', '', 1),
(1148, 35, 'Gnagna', '', '', 1),
(1149, 35, 'Gourma', '', '', 1),
(1150, 35, 'Houet', '', '', 1),
(1151, 35, 'Ioba', '', '', 1),
(1152, 35, 'Kadiogo', '', '', 1),
(1153, 35, 'Kénédougou', '', '', 1),
(1154, 35, 'Komondjari', '', '', 1),
(1155, 35, 'Kompienga', '', '', 1),
(1156, 35, 'Koulpélogo', '', '', 1),
(1157, 35, 'Kossi', '', '', 1),
(1158, 35, 'Kouritenga', '', '', 1),
(1159, 35, 'Kourwéogo', '', '', 1),
(1160, 35, 'Léraba', '', '', 1),
(1161, 35, 'Loroum', '', '', 1),
(1162, 35, 'Mouhoun', '', '', 1),
(1163, 35, 'Namentenga', '', '', 1),
(1164, 35, 'Naouri', '', '', 1),
(1165, 35, 'Nayala', '', '', 1),
(1166, 35, 'Noumbiel', '', '', 1),
(1167, 35, 'Oubritenga', '', '', 1),
(1168, 35, 'Oudalan', '', '', 1),
(1169, 35, 'Passoré', '', '', 1),
(1170, 35, 'Poni', '', '', 1),
(1171, 35, 'Séno', '', '', 1),
(1172, 35, 'Sissili', '', '', 1),
(1173, 35, 'Sanmatenga', '', '', 1),
(1174, 35, 'Sanguié', '', '', 1),
(1175, 35, 'Soum', '', '', 1),
(1176, 35, 'Sourou', '', '', 1),
(1177, 35, 'Tapoa', '', '', 1),
(1178, 35, 'Tui', '', '', 1),
(1179, 35, 'Yagha', '', '', 1),
(1180, 35, 'Yatenga', '', '', 1),
(1181, 35, 'Ziro', '', '', 1),
(1182, 35, 'Zondoma', '', '', 1),
(1183, 35, 'Zoundwéogo', '', '', 1),
(1184, 36, 'Bubanza', '', '', 1),
(1185, 36, 'Bujumbura Mairie', '', '', 1),
(1186, 36, 'Bururi', '', '', 1),
(1187, 36, 'Cankuzo', '', '', 1),
(1188, 36, 'Cibitoke', '', '', 1),
(1189, 36, 'Gitega', '', '', 1),
(1190, 36, 'Karuzi', '', '', 1),
(1191, 36, 'Kayanza', '', '', 1),
(1192, 36, 'Kirundo', '', '', 1),
(1193, 36, 'Makamba', '', '', 1),
(1194, 36, 'Muramvya', '', '', 1),
(1195, 36, 'Muyinga', '', '', 1),
(1196, 36, 'Mwaro', '', '', 1),
(1197, 36, 'Ngozi', '', '', 1),
(1198, 36, 'Rutana', '', '', 1),
(1199, 36, 'Ruyigi', '', '', 1),
(1200, 38, 'Adamaoua', '', '', 1),
(1201, 38, 'Centre', '', '', 1),
(1202, 38, 'Extrême-Nord', '', '', 1),
(1203, 38, 'Est', '', '', 1),
(1204, 38, 'Littoral', '', '', 1),
(1205, 38, 'Nord', '', '', 1),
(1206, 38, 'Nord-Ouest', '', '', 1),
(1207, 38, 'Ouest', '', '', 1),
(1208, 38, 'Sud', '', '', 1),
(1209, 38, 'Sud-Ouest', '', '', 1),
(1210, 39, 'Yukon Territory', '', '', 1),
(1211, 40, 'Brava', '', '', 1),
(1212, 40, 'Boa Vista', '', '', 1),
(1213, 40, 'Santa Catarina', '', '', 1),
(1214, 40, 'Santa Cruz', '', '', 1),
(1215, 40, 'Calheta de São Miguel', '', '', 1),
(1216, 40, 'Maio', '', '', 1),
(1217, 40, 'Mosteiros', '', '', 1),
(1218, 40, 'Paúl', '', '', 1),
(1219, 40, 'Porto Novo', '', '', 1),
(1220, 40, 'Praia', '', '', 1),
(1221, 40, 'Ribeira Grande', '', '', 1),
(1222, 40, 'São Domingos', '', '', 1),
(1223, 40, 'São Filipe', '', '', 1),
(1224, 40, 'Sal', '', '', 1),
(1225, 40, 'São Nicolau', '', '', 1),
(1226, 40, 'São Vicente', '', '', 1),
(1227, 40, 'Tarrafal', '', '', 1),
(1228, 41, 'Creek', '', '', 1),
(1229, 41, 'Midland', '', '', 1),
(1230, 41, 'South Town', '', '', 1),
(1231, 41, 'Spot Bay', '', '', 1),
(1232, 41, 'Stake Bay', '', '', 1),
(1233, 41, 'West End', '', '', 1),
(1234, 41, 'Western', '', '', 1),
(1235, 42, 'Ouham', '', '', 1),
(1236, 42, 'Bamingui-Bangoran', '', '', 1),
(1237, 42, 'Bangui', '', '', 1),
(1238, 42, 'Basse-Kotto', '', '', 1),
(1239, 42, 'Haute-Kotto', '', '', 1),
(1240, 42, 'Haut-Mbomou', '', '', 1),
(1241, 42, 'Mambéré-Kadéï', '', '', 1),
(1242, 42, 'Nana-Grébizi', '', '', 1),
(1243, 42, 'Kémo', '', '', 1),
(1244, 42, 'Lobaye', '', '', 1),
(1245, 42, 'Mbomou', '', '', 1),
(1246, 42, 'Ombella-M\'Poko', '', '', 1),
(1247, 42, 'Nana-Mambéré', '', '', 1),
(1248, 42, 'Ouham-Pendé', '', '', 1),
(1249, 42, 'Sangha-Mbaéré', '', '', 1),
(1250, 42, 'Ouaka', '', '', 1),
(1251, 42, 'Vakaga', '', '', 1),
(1252, 43, 'Batha', '', '', 1),
(1253, 43, 'Borkou-Ennedi-Tibesti', '', '', 1),
(1254, 43, 'Biltine', '', '', 1),
(1255, 43, 'Chari-Baguirmi', '', '', 1),
(1256, 43, 'Guéra', '', '', 1),
(1257, 43, 'Kanem', '', '', 1),
(1258, 43, 'Lac', '', '', 1),
(1259, 43, 'Logone-Oriental', '', '', 1),
(1260, 43, 'Logone-Occidental', '', '', 1),
(1261, 43, 'Moyen-Chari', '', '', 1),
(1262, 43, 'Mayo-Kébbi', '', '', 1),
(1263, 43, 'Ouaddaï', '', '', 1),
(1264, 43, 'Salamat', '', '', 1),
(1265, 43, 'Tandjilé', '', '', 1),
(1266, 44, 'Aisén del General Carlos Ibañez', '', '', 1),
(1267, 44, 'Antofagasta', '', '', 1),
(1268, 44, 'La Araucanía', '', '', 1),
(1269, 44, 'Atacama', '', '', 1),
(1270, 44, 'Biobío', '', '', 1),
(1271, 44, 'Coquimbo', '', '', 1),
(1272, 44, 'Libertador Bernardo O\'Higgins', '', '', 1),
(1273, 44, 'Los Lagos', '', '', 1),
(1274, 44, 'Magallanes y de la Antartica', '', '', 1),
(1275, 44, 'Maule', '', '', 1),
(1276, 44, 'Metropolitana de Santiago', '', '', 1),
(1277, 44, 'Tarapacá', '', '', 1),
(1278, 44, 'Valparaíso', '', '', 1),
(1279, 45, '北京', '', '', 1),
(1280, 45, '天津', '', '', 1),
(1281, 45, '河北', '', '', 1),
(1282, 45, '山西', '', '', 1),
(1283, 45, '内蒙古自治区', '', '', 1),
(1284, 45, '辽宁', '', '', 1),
(1285, 45, '吉林', '', '', 1),
(1286, 45, '黑龙江省', '', '', 1),
(1287, 45, '上海', '', '', 1),
(1288, 45, '江苏', '', '', 1),
(1289, 45, '浙江', '', '', 1),
(1290, 45, '安徽', '', '', 1),
(1291, 45, '福建', '', '', 1),
(1292, 45, '江西', '', '', 1),
(1293, 45, '山东', '', '', 1),
(1294, 45, '河南', '', '', 1),
(1295, 45, '湖北', '', '', 1),
(1296, 45, '湖南', '', '', 1),
(1297, 45, '广东', '', '', 1),
(1298, 45, '广西壮族自治区', '', '', 1),
(1299, 45, '海南', '', '', 1),
(1300, 45, '重庆', '', '', 1),
(1301, 45, '四川', '', '', 1),
(1302, 45, '贵州', '', '', 1),
(1303, 45, '云南', '', '', 1),
(1304, 45, '西藏自治区', '', '', 1),
(1305, 45, '陕西', '', '', 1),
(1306, 45, '甘肃', '', '', 1),
(1307, 45, '青海', '', '', 1),
(1308, 45, '宁夏', '', '', 1),
(1309, 45, '新疆', '', '', 1),
(1310, 45, '臺灣', '', '', 1),
(1311, 45, '香港', '', '', 1),
(1312, 45, '澳門', '', '', 1),
(1313, 47, 'Direction Island', '', '', 1),
(1314, 47, 'Home Island', '', '', 1),
(1315, 47, 'Horsburgh Island', '', '', 1),
(1316, 47, 'South Island', '', '', 1),
(1317, 47, 'West Island', '', '', 1),
(1318, 48, 'Amazonas', '', '', 1),
(1319, 48, 'Antioquia', '', '', 1),
(1320, 48, 'Arauca', '', '', 1),
(1321, 48, 'Atlántico', '', '', 1),
(1322, 48, 'Bolívar', '', '', 1),
(1323, 48, 'Boyacá', '', '', 1),
(1324, 48, 'Caldas', '', '', 1),
(1325, 48, 'Caquetá', '', '', 1),
(1326, 48, 'Casanare', '', '', 1),
(1327, 48, 'Cauca', '', '', 1),
(1328, 48, 'Cesar', '', '', 1),
(1329, 48, 'Chocó', '', '', 1),
(1330, 48, 'Córdoba', '', '', 1),
(1331, 48, 'Cundinamarca', '', '', 1),
(1332, 48, 'Bogotá Distrito Capital', '', '', 1),
(1333, 48, 'Guainía', '', '', 1),
(1334, 48, 'Guaviare', '', '', 1),
(1335, 48, 'La Guajira', '', '', 1),
(1336, 48, 'Magdalena', '', '', 1),
(1337, 48, 'Meta', '', '', 1),
(1338, 48, 'Nariño', '', '', 1),
(1339, 48, 'Norte de Santander', '', '', 1),
(1340, 48, 'Putumayo', '', '', 1),
(1341, 48, 'Quindío', '', '', 1),
(1342, 48, 'Risaralda', '', '', 1),
(1343, 48, 'Santander', '', '', 1),
(1344, 48, 'San Andrés y Providencia', '', '', 1),
(1345, 48, 'Sucre', '', '', 1),
(1346, 48, 'Tolima', '', '', 1),
(1347, 48, 'Valle del Cauca', '', '', 1),
(1348, 48, 'Vaupés', '', '', 1),
(1349, 48, 'Vichada', '', '', 1),
(1350, 49, 'Anjouan', '', '', 1),
(1351, 49, 'Grande Comore', '', '', 1),
(1352, 49, 'Mohéli', '', '', 1),
(1353, 50, 'Congo-Central', '', '', 1),
(1354, 50, 'Bandundu', '', '', 1),
(1355, 50, 'Équateur', '', '', 1),
(1356, 50, 'Katanga', '', '', 1),
(1357, 50, 'Kasai-Oriental', '', '', 1),
(1358, 50, 'Kinshasa', '', '', 1),
(1359, 50, 'Kasai-Occidental', '', '', 1),
(1360, 50, 'Maniema', '', '', 1),
(1361, 50, 'Nord-Kivu', '', '', 1),
(1362, 50, 'Orientale', '', '', 1),
(1363, 50, 'Sud-Kivu', '', '', 1),
(1364, 51, 'Pukapuka', '', '', 1),
(1365, 51, 'Rakahanga', '', '', 1),
(1366, 51, 'Manihiki', '', '', 1),
(1367, 51, 'Penrhyn', '', '', 1),
(1368, 51, 'Nassau Island', '', '', 1),
(1369, 51, 'Surwarrow', '', '', 1),
(1370, 51, 'Palmerston', '', '', 1),
(1371, 51, 'Aitutaki', '', '', 1),
(1372, 51, 'Manuae', '', '', 1),
(1373, 51, 'Takutea', '', '', 1),
(1374, 51, 'Mitiaro', '', '', 1),
(1375, 51, 'Atiu', '', '', 1),
(1376, 51, 'Mauke', '', '', 1),
(1377, 51, 'Rarotonga', '', '', 1),
(1378, 51, 'Mangaia', '', '', 1),
(1379, 52, 'Alajuela', '', '', 1),
(1380, 52, 'Cartago', '', '', 1),
(1381, 52, 'Guanacaste', '', '', 1),
(1382, 52, 'Heredia', '', '', 1),
(1383, 52, 'Limón', '', '', 1),
(1384, 52, 'Puntarenas', '', '', 1),
(1385, 52, 'San José', '', '', 1),
(1386, 53, 'Lagunes', '', '', 1),
(1387, 53, 'Haut-Sassandra', '', '', 1),
(1388, 53, 'Savanes', '', '', 1),
(1389, 53, 'Vallée du Bandama', '', '', 1),
(1390, 53, 'Moyen-Comoé', '', '', 1),
(1391, 53, 'Dix-Huit', '', '', 1),
(1392, 53, 'Lacs', '', '', 1),
(1393, 53, 'Zanzan', '', '', 1),
(1394, 53, 'Bas-Sassandra', '', '', 1),
(1395, 53, 'Denguélé', '', '', 1),
(1396, 53, 'N\'zi-Comoé', '', '', 1),
(1397, 53, 'Marahoué', '', '', 1),
(1398, 53, 'Sud-Comoé', '', '', 1),
(1399, 53, 'Worodouqou', '', '', 1),
(1400, 53, 'Sud-Bandama', '', '', 1),
(1401, 53, 'Agnébi', '', '', 1),
(1402, 53, 'Bafing', '', '', 1),
(1403, 53, 'Fromager', '', '', 1),
(1404, 53, 'Moyen-Cavally', '', '', 1),
(1405, 54, 'Zagrebačka županija', '', '', 1),
(1406, 54, 'Krapinsko-zagorska županija', '', '', 1),
(1407, 54, 'Sisačko-moslavačka županija', '', '', 1),
(1408, 54, 'Karlovačka županija', '', '', 1),
(1409, 54, 'Varaždinska županija', '', '', 1),
(1410, 54, 'Koprivničko-križevačka županija', '', '', 1),
(1411, 54, 'Bjelovarsko-bilogorska županija', '', '', 1),
(1412, 54, 'Primorsko-goranska županija', '', '', 1),
(1413, 54, 'Ličko-senjska županija', '', '', 1),
(1414, 54, 'Virovitičko-podravska županija', '', '', 1),
(1415, 54, 'Požeško-slavonska županija', '', '', 1),
(1416, 54, 'Brodsko-posavska županija', '', '', 1),
(1417, 54, 'Zadarska županija', '', '', 1),
(1418, 54, 'Osječko-baranjska županija', '', '', 1),
(1419, 54, 'Šibensko-kninska županija', '', '', 1),
(1420, 54, 'Vukovarsko-srijemska županija', '', '', 1),
(1421, 54, 'Splitsko-dalmatinska županija', '', '', 1),
(1422, 54, 'Istarska županija', '', '', 1),
(1423, 54, 'Dubrovačko-neretvanska županija', '', '', 1),
(1424, 54, 'Međimurska županija', '', '', 1),
(1425, 54, 'Zagreb', '', '', 1),
(1426, 55, 'Pinar del Río', '', '', 1),
(1427, 55, 'La Habana', '', '', 1),
(1428, 55, 'Ciudad de La Habana', '', '', 1),
(1429, 55, 'Matanzas', '', '', 1),
(1430, 55, 'Villa Clara', '', '', 1),
(1431, 55, 'Cienfuegos', '', '', 1),
(1432, 55, 'Sancti Spíritus', '', '', 1),
(1433, 55, 'Ciego de Ávila', '', '', 1),
(1434, 55, 'Camagüey', '', '', 1),
(1435, 55, 'Las Tunas', '', '', 1),
(1436, 55, 'Holguín', '', '', 1),
(1437, 55, 'Granma', '', '', 1),
(1438, 55, 'Santiago de Cuba', '', '', 1),
(1439, 55, 'Guantánamo', '', '', 1),
(1440, 55, 'Isla de la Juventud', '', '', 1),
(1441, 56, 'Κερύvεια', '', '', 1),
(1442, 56, 'Λευκωσία', '', '', 1),
(1443, 56, 'Αμμόχωστος', '', '', 1),
(1444, 56, 'Λάρνακα', '', '', 1),
(1445, 56, 'Λεμεσός', '', '', 1),
(1446, 56, 'Πάφος', '', '', 1),
(1447, 57, 'Jihočeský kraj', '', '', 1),
(1448, 57, 'Jihomoravský kraj', '', '', 1),
(1449, 57, 'Karlovarský kraj', '', '', 1),
(1450, 57, 'Vysočina kraj', '', '', 1),
(1451, 57, 'Královéhradecký kraj', '', '', 1),
(1452, 57, 'Liberecký kraj', '', '', 1),
(1453, 57, 'Moravskoslezský kraj', '', '', 1),
(1454, 57, 'Olomoucký kraj', '', '', 1),
(1455, 57, 'Pardubický kraj', '', '', 1),
(1456, 57, 'Plzeňský kraj', '', '', 1),
(1457, 57, 'Hlavní město Praha', '', '', 1),
(1458, 57, 'Středočeský kraj', '', '', 1),
(1459, 57, 'Ústecký kraj', '', '', 1),
(1460, 57, 'Zlínský kraj', '', '', 1),
(1461, 58, 'Hovedstaden', '', '', 1),
(1462, 58, 'Midtjylland', '', '', 1),
(1463, 58, 'Nordjylland', '', '', 1),
(1464, 58, 'Sjælland', '', '', 1),
(1465, 58, 'Syddanmark', '', '', 1),
(1466, 59, 'Region d\'Ali Sabieh', '', '', 1),
(1467, 59, 'Region d\'Arta', '', '', 1),
(1468, 59, 'Region de Dikhil', '', '', 1),
(1469, 59, 'Ville de Djibouti', '', '', 1),
(1470, 59, 'Region d\'Obock', '', '', 1),
(1471, 59, 'Region de Tadjourah', '', '', 1),
(1472, 60, 'Saint Andrew Parish', '', '', 1),
(1473, 60, 'Saint David Parish', '', '', 1),
(1474, 60, 'Saint George Parish', '', '', 1),
(1475, 60, 'Saint John Parish', '', '', 1),
(1476, 60, 'Saint Joseph Parish', '', '', 1),
(1477, 60, 'Saint Luke Parish', '', '', 1),
(1478, 60, 'Saint Mark Parish', '', '', 1),
(1479, 60, 'Saint Patrick Parish', '', '', 1),
(1480, 60, 'Saint Paul Parish', '', '', 1),
(1481, 60, 'Saint Peter Parish', '', '', 1),
(1482, 61, 'Distrito Nacional', '', '', 1),
(1483, 61, 'Ázua', '', '', 1),
(1484, 61, 'Baoruco', '', '', 1),
(1485, 61, 'Barahona', '', '', 1),
(1486, 61, 'Dajabón', '', '', 1),
(1487, 61, 'Duarte', '', '', 1),
(1488, 61, 'Elías Piña', '', '', 1),
(1489, 61, 'El Seibo', '', '', 1),
(1490, 61, 'Espaillat', '', '', 1),
(1491, 61, 'Independencia', '', '', 1),
(1492, 61, 'La Altagracia', '', '', 1),
(1493, 61, 'La Romana', '', '', 1),
(1494, 61, 'La Vega', '', '', 1),
(1495, 61, 'María Trinidad Sánchez', '', '', 1),
(1496, 61, 'Monte Cristi', '', '', 1),
(1497, 61, 'Pedernales', '', '', 1),
(1498, 61, 'Peravia', '', '', 1),
(1499, 61, 'Puerto Plata', '', '', 1),
(1500, 61, 'Salcedo', '', '', 1),
(1501, 61, 'Samaná', '', '', 1),
(1502, 61, 'San Cristóbal', '', '', 1),
(1503, 61, 'San Juan', '', '', 1),
(1504, 61, 'San Pedro de Macorís', '', '', 1),
(1505, 61, 'Sánchez Ramírez', '', '', 1),
(1506, 61, 'Santiago', '', '', 1),
(1507, 61, 'Santiago Rodríguez', '', '', 1),
(1508, 61, 'Valverde', '', '', 1),
(1509, 61, 'Monseñor Nouel', '', '', 1),
(1510, 61, 'Monte Plata', '', '', 1),
(1511, 61, 'Hato Mayor', '', '', 1),
(1512, 62, 'Aileu', '', '', 1),
(1513, 62, 'Ainaro', '', '', 1),
(1514, 62, 'Baucau', '', '', 1),
(1515, 62, 'Bobonaro', '', '', 1),
(1516, 62, 'Cova-Lima', '', '', 1),
(1517, 62, 'Dili', '', '', 1),
(1518, 62, 'Ermera', '', '', 1),
(1519, 62, 'Lautem', '', '', 1),
(1520, 62, 'Liquiçá', '', '', 1),
(1521, 62, 'Manufahi', '', '', 1),
(1522, 62, 'Manatuto', '', '', 1),
(1523, 62, 'Oecussi', '', '', 1),
(1524, 62, 'Viqueque', '', '', 1),
(1525, 63, 'Azuay', '', '', 1),
(1526, 63, 'Bolívar', '', '', 1),
(1527, 63, 'Carchi', '', '', 1),
(1528, 63, 'Orellana', '', '', 1),
(1529, 63, 'Esmeraldas', '', '', 1),
(1530, 63, 'Cañar', '', '', 1),
(1531, 63, 'Guayas', '', '', 1),
(1532, 63, 'Chimborazo', '', '', 1),
(1533, 63, 'Imbabura', '', '', 1),
(1534, 63, 'Loja', '', '', 1),
(1535, 63, 'Manabí', '', '', 1),
(1536, 63, 'Napo', '', '', 1),
(1537, 63, 'El Oro', '', '', 1),
(1538, 63, 'Pichincha', '', '', 1),
(1539, 63, 'Los Ríos', '', '', 1),
(1540, 63, 'Morona-Santiago', '', '', 1),
(1541, 63, 'Tungurahua', '', '', 1),
(1542, 63, 'Sucumbíos', '', '', 1),
(1543, 63, 'Galápagos', '', '', 1),
(1544, 63, 'Cotopaxi', '', '', 1),
(1545, 63, 'Pastaza', '', '', 1),
(1546, 63, 'Zamora-Chinchipe', '', '', 1),
(1547, 64, 'الإسكندرية', '', '', 1),
(1548, 64, 'أسوان', '', '', 1),
(1549, 64, 'أسيوط', '', '', 1),
(1550, 64, 'البحر الأحمر', '', '', 1),
(1551, 64, 'البحيرة', '', '', 1),
(1552, 64, 'بني سويف', '', '', 1),
(1553, 64, 'القاهرة', '', '', 1),
(1554, 64, 'الدقهلية', '', '', 1),
(1555, 64, 'دمياط', '', '', 1),
(1556, 64, 'الفيوم', '', '', 1),
(1557, 64, 'الغربية', '', '', 1),
(1558, 64, 'الجيزة', '', '', 1),
(1559, 64, 'الإسماعيلية', '', '', 1),
(1560, 64, 'جنوب سيناء', '', '', 1),
(1561, 64, 'القليوبية', '', '', 1),
(1562, 64, 'كفر الشيخ', '', '', 1),
(1563, 64, 'قنا', '', '', 1),
(1564, 64, 'محافظة المنيا', '', '', 1),
(1565, 64, 'المنوفية', '', '', 1),
(1566, 64, 'مطروح', '', '', 1),
(1567, 64, 'محافظة بور سعيد', '', '', 1),
(1568, 64, 'محافظة سوهاج', '', '', 1),
(1569, 64, 'المحافظة الشرقيّة', '', '', 1),
(1570, 64, 'شمال سيناء', '', '', 1),
(1571, 64, 'السويس', '', '', 1),
(1572, 64, 'الوادى الجديد', '', '', 1),
(1573, 65, 'Ahuachapán', '', '', 1),
(1574, 65, 'Cabañas', '', '', 1),
(1575, 65, 'Chalatenango', '', '', 1),
(1576, 65, 'Cuscatlán', '', '', 1),
(1577, 65, 'La Libertad', '', '', 1),
(1578, 65, 'Morazán', '', '', 1),
(1579, 65, 'La Paz', '', '', 1),
(1580, 65, 'Santa Ana', '', '', 1),
(1581, 65, 'San Miguel', '', '', 1),
(1582, 65, 'Sonsonate', '', '', 1),
(1583, 65, 'San Salvador', '', '', 1),
(1584, 65, 'San Vicente', '', '', 1),
(1585, 65, 'La Unión', '', '', 1),
(1586, 65, 'Usulután', '', '', 1),
(1587, 66, 'Annobón', '', '', 1),
(1588, 66, 'Bioko Norte', '', '', 1),
(1589, 66, 'Bioko Sur', '', '', 1),
(1590, 66, 'Centro Sur', '', '', 1),
(1591, 66, 'Kié-Ntem', '', '', 1),
(1592, 66, 'Litoral', '', '', 1),
(1593, 66, 'Wele-Nzas', '', '', 1),
(1594, 67, 'Zoba Anseba', '', '', 1),
(1595, 67, 'Zoba Debubawi Keyih Bahri', '', '', 1),
(1596, 67, 'Zoba Debub', '', '', 1),
(1597, 67, 'Zoba Gash-Barka', '', '', 1),
(1598, 67, 'Zoba Ma\'akel', '', '', 1),
(1599, 67, 'Zoba Semienawi Keyih Bahri', '', '', 1),
(1600, 68, 'Harju maakond', '', '', 1),
(1601, 68, 'Hiiu maakond', '', '', 1),
(1602, 68, 'Ida-Viru maakond', '', '', 1),
(1603, 68, 'Jõgeva maakond', '', '', 1),
(1604, 68, 'Järva maakond', '', '', 1),
(1605, 68, 'Lääne maakond', '', '', 1),
(1606, 68, 'Lääne-Viru maakond', '', '', 1),
(1607, 68, 'Põlva maakond', '', '', 1),
(1608, 68, 'Pärnu maakond', '', '', 1),
(1609, 68, 'Rapla maakond', '', '', 1),
(1610, 68, 'Saare maakond', '', '', 1),
(1611, 68, 'Tartu maakond', '', '', 1),
(1612, 68, 'Valga maakond', '', '', 1),
(1613, 68, 'Viljandi maakond', '', '', 1),
(1614, 68, 'Võru maakond', '', '', 1),
(1615, 69, 'አዲስ አበባ', '', '', 1),
(1616, 69, 'አፋር', '', '', 1),
(1617, 69, 'አማራ', '', '', 1),
(1618, 69, 'ቤንሻንጉል-ጉምዝ', '', '', 1),
(1619, 69, 'ድሬዳዋ', '', '', 1),
(1620, 69, 'ጋምቤላ ሕዝቦች', '', '', 1),
(1621, 69, 'ሀረሪ ሕዝብ', '', '', 1),
(1622, 69, 'ኦሮሚያ', '', '', 1),
(1623, 69, 'ሶማሌ', '', '', 1),
(1624, 69, 'ደቡብ ብሔሮች ብሔረሰቦችና ሕዝቦች', '', '', 1),
(1625, 69, 'ትግራይ', '', '', 1),
(1626, 72, 'Central', '', '', 1),
(1627, 72, 'Northern', '', '', 1),
(1628, 72, 'Eastern', '', '', 1),
(1629, 72, 'Rotuma', '', '', 1),
(1630, 72, 'Western', '', '', 1),
(1631, 73, 'Ahvenanmaan maakunta', '', '', 1),
(1632, 73, 'Etelä-Suomen lääni', '', '', 1),
(1633, 73, 'Itä-Suomen lääni', '', '', 1),
(1634, 73, 'Lapin lääni', '', '', 1),
(1635, 73, 'Länsi-Suomen lääni', '', '', 1),
(1636, 73, 'Oulun lääni', '', '', 1),
(1637, 74, 'Guadeloupe', '', '', 1),
(1638, 74, 'Martinique', '', '', 1),
(1639, 74, 'Reunion', '', '', 1),
(1640, 74, 'Ain', '', '', 1),
(1641, 74, 'Aisne', '', '', 1),
(1642, 74, 'Allier', '', '', 1),
(1643, 74, 'Alpes-de-Haute-Provence', '', '', 1),
(1644, 74, 'Hautes-Alpes', '', '', 1),
(1645, 74, 'Alpes-Maritimes', '', '', 1),
(1646, 74, 'Ardèche', '', '', 1),
(1647, 74, 'Ardennes', '', '', 1),
(1648, 74, 'Ariège', '', '', 1),
(1649, 74, 'Aube', '', '', 1),
(1650, 74, 'Aude', '', '', 1),
(1651, 74, 'Aveyron', '', '', 1),
(1652, 74, 'Bouches-du-Rhône', '', '', 1),
(1653, 74, 'Calvados', '', '', 1),
(1654, 74, 'Cantal', '', '', 1),
(1655, 74, 'Charente', '', '', 1),
(1656, 74, 'Charente-Maritime', '', '', 1),
(1657, 74, 'Cher', '', '', 1),
(1658, 74, 'Corrèze', '', '', 1),
(1659, 74, 'Côte-d\'Or', '', '', 1),
(1660, 74, 'Côtes-d\'Armor', '', '', 1),
(1661, 74, 'Creuse', '', '', 1),
(1662, 74, 'Dordogne', '', '', 1),
(1663, 74, 'Doubs', '', '', 1),
(1664, 74, 'Drôme', '', '', 1),
(1665, 74, 'Eure', '', '', 1),
(1666, 74, 'Eure-et-Loir', '', '', 1),
(1667, 74, 'Finistère', '', '', 1),
(1668, 74, 'Corse-du-Sud', '', '', 1),
(1669, 74, 'Haute-Corse', '', '', 1),
(1670, 74, 'Gard', '', '', 1),
(1671, 74, 'Haute-Garonne', '', '', 1),
(1672, 74, 'Gers', '', '', 1),
(1673, 74, 'Gironde', '', '', 1),
(1674, 74, 'Hérault', '', '', 1),
(1675, 74, 'Ille-et-Vilaine', '', '', 1),
(1676, 74, 'Indre', '', '', 1),
(1677, 74, 'Indre-et-Loire', '', '', 1),
(1678, 74, 'Isère', '', '', 1),
(1679, 74, 'Jura', '', '', 1),
(1680, 74, 'Landes', '', '', 1),
(1681, 74, 'Loir-et-Cher', '', '', 1),
(1682, 74, 'Loire', '', '', 1),
(1683, 74, 'Haute-Loire', '', '', 1),
(1684, 74, 'Loire-Atlantique', '', '', 1),
(1685, 74, 'Loiret', '', '', 1),
(1686, 74, 'Lot', '', '', 1),
(1687, 74, 'Lot-et-Garonne', '', '', 1),
(1688, 74, 'Lozère', '', '', 1),
(1689, 74, 'Maine-et-Loire', '', '', 1),
(1690, 74, 'Manche', '', '', 1),
(1691, 74, 'Marne', '', '', 1),
(1692, 74, 'Haute-Marne', '', '', 1),
(1693, 74, 'Mayenne', '', '', 1),
(1694, 74, 'Meurthe-et-Moselle', '', '', 1),
(1695, 74, 'Meuse', '', '', 1),
(1696, 74, 'Morbihan', '', '', 1),
(1697, 74, 'Moselle', '', '', 1),
(1698, 74, 'Nièvre', '', '', 1),
(1699, 74, 'Nord', '', '', 1),
(1700, 74, 'Oise', '', '', 1),
(1701, 74, 'Orne', '', '', 1),
(1702, 74, 'Pas-de-Calais', '', '', 1),
(1703, 74, 'Puy-de-Dôme', '', '', 1),
(1704, 74, 'Pyrénées-Atlantiques', '', '', 1),
(1705, 74, 'Hautes-Pyrénées', '', '', 1),
(1706, 74, 'Pyrénées-Orientales', '', '', 1),
(1707, 74, 'Bas-Rhin', '', '', 1),
(1708, 74, 'Haut-Rhin', '', '', 1),
(1709, 74, 'Rhône', '', '', 1),
(1710, 74, 'Haute-Saône', '', '', 1),
(1711, 74, 'Saône-et-Loire', '', '', 1),
(1712, 74, 'Sarthe', '', '', 1),
(1713, 74, 'Savoie', '', '', 1),
(1714, 74, 'Haute-Savoie', '', '', 1),
(1715, 74, 'Paris', '', '', 1),
(1716, 74, 'Seine-Maritime', '', '', 1),
(1717, 74, 'Seine-et-Marne', '', '', 1),
(1718, 74, 'Yvelines', '', '', 1),
(1719, 74, 'Deux-Sèvres', '', '', 1),
(1720, 74, 'Somme', '', '', 1),
(1721, 74, 'Tarn', '', '', 1),
(1722, 74, 'Tarn-et-Garonne', '', '', 1),
(1723, 74, 'Var', '', '', 1),
(1724, 74, 'Vaucluse', '', '', 1),
(1725, 74, 'Vendée', '', '', 1),
(1726, 74, 'Vienne', '', '', 1),
(1727, 74, 'Haute-Vienne', '', '', 1),
(1728, 74, 'Vosges', '', '', 1),
(1729, 74, 'Yonne', '', '', 1),
(1730, 74, 'Territoire de Belfort', '', '', 1),
(1731, 74, 'Essonne', '', '', 1),
(1732, 74, 'Hauts-de-Seine', '', '', 1),
(1733, 74, 'Seine-Saint-Denis', '', '', 1),
(1734, 74, 'Val-de-Marne', '', '', 1),
(1735, 74, 'Val-d\'Oise', '', '', 1),
(1736, 74, 'Territoire des Nouvelle-Calédonie et Dependan', '', '', 1),
(1737, 74, 'Polynésie Française', '', '', 1),
(1738, 74, 'Saint-Pierre et Miquelon', '', '', 1),
(1739, 74, 'Terres australes et antarctiques françaises', '', '', 1),
(1740, 74, 'Mayotte', '', '', 1),
(1741, 74, 'Territoire des îles Wallis et Futuna', '', '', 1),
(1742, 77, 'Archipel des Marquises', '', '', 1),
(1743, 77, 'Archipel des Tuamotu', '', '', 1),
(1744, 77, 'Archipel des Tubuai', '', '', 1),
(1745, 77, 'Iles du Vent', '', '', 1),
(1746, 77, 'Iles Sous-le-Vent ', '', '', 1),
(1747, 78, 'Iles Crozet', '', '', 1),
(1748, 78, 'Iles Kerguelen', '', '', 1),
(1749, 78, 'Ile Amsterdam', '', '', 1),
(1750, 78, 'Ile Saint-Paul', '', '', 1),
(1751, 78, 'Adelie Land', '', '', 1),
(1752, 79, 'Estuaire', '', '', 1),
(1753, 79, 'Haut-Ogooue', '', '', 1),
(1754, 79, 'Moyen-Ogooue', '', '', 1),
(1755, 79, 'Ngounie', '', '', 1),
(1756, 79, 'Nyanga', '', '', 1),
(1757, 79, 'Ogooue-Ivindo', '', '', 1),
(1758, 79, 'Ogooue-Lolo', '', '', 1),
(1759, 79, 'Ogooue-Maritime', '', '', 1),
(1760, 79, 'Woleu-Ntem', '', '', 1),
(1761, 80, 'Ashanti', '', '', 1),
(1762, 80, 'Brong-Ahafo', '', '', 1),
(1763, 80, 'Central', '', '', 1),
(1764, 80, 'Eastern', '', '', 1),
(1765, 80, 'Greater Accra', '', '', 1),
(1766, 80, 'Northern', '', '', 1),
(1767, 80, 'Upper East', '', '', 1),
(1768, 80, 'Upper West', '', '', 1),
(1769, 80, 'Volta', '', '', 1),
(1770, 80, 'Western', '', '', 1),
(1771, 81, 'აფხაზეთი', '', '', 1),
(1772, 81, 'აჭარა', '', '', 1),
(1773, 81, 'გურია', '', '', 1),
(1774, 81, 'იმერეთი', '', '', 1),
(1775, 81, 'კახეთი', '', '', 1),
(1776, 81, 'ქვემო ქართლი', '', '', 1),
(1777, 81, 'მცხეთა-მთიანეთი', '', '', 1),
(1778, 81, 'რაჭა-ლეჩხუმი და ქვემო სვანეთი', '', '', 1),
(1779, 81, 'სამცხე-ჯავახეთი', '', '', 1),
(1780, 81, 'შიდა ქართლი', '', '', 1),
(1781, 81, 'სამეგრელო-ზემო სვანეთი', '', '', 1),
(1782, 81, 'თბილისი', '', '', 1),
(1783, 82, 'Bayern', '', '', 1),
(1784, 82, 'Bremen', '', '', 1),
(1785, 82, 'Hamburg', '', '', 1),
(1786, 82, 'Sachsen', '', '', 1),
(1787, 82, 'Thüringen', '', '', 1),
(1788, 85, 'Αιτωλοακαρνανία', '', '', 1),
(1789, 85, 'Βοιωτία', '', '', 1),
(1790, 85, 'Εύβοια', '', '', 1),
(1791, 85, 'Ευρυτανία', '', '', 1),
(1792, 85, 'Φθιώτιδα', '', '', 1),
(1793, 85, 'Φωκίδα', '', '', 1),
(1794, 85, 'Αργολίδα', '', '', 1),
(1795, 85, 'Αρκαδία', '', '', 1),
(1796, 85, 'Ἀχαΐα', '', '', 1),
(1797, 85, 'Ηλεία', '', '', 1),
(1798, 85, 'Κορινθία', '', '', 1),
(1799, 85, 'Λακωνία', '', '', 1),
(1800, 85, 'Μεσσηνία', '', '', 1),
(1801, 85, 'Ζάκυνθος', '', '', 1),
(1802, 85, 'Κέρκυρα', '', '', 1),
(1803, 85, 'Κεφαλλονιά', '', '', 1),
(1804, 85, 'Λευκάδα', '', '', 1),
(1805, 85, 'Άρτα', '', '', 1),
(1806, 85, 'Θεσπρωτία', '', '', 1),
(1807, 85, 'Ιωάννινα', '', '', 1),
(1808, 85, 'Πρεβεζα', '', '', 1),
(1809, 85, 'Καρδίτσα', '', '', 1),
(1810, 85, 'Λάρισα', '', '', 1),
(1811, 85, 'Μαγνησία', '', '', 1),
(1812, 85, 'Τρίκαλα', '', '', 1),
(1813, 85, 'Γρεβενά', '', '', 1),
(1814, 85, 'Δράμα', '', '', 1),
(1815, 85, 'Ημαθία', '', '', 1),
(1816, 85, 'Θεσσαλονίκη', '', '', 1),
(1817, 85, 'Καβάλα', '', '', 1),
(1818, 85, 'Καστοριά', '', '', 1),
(1819, 85, 'Κοζάνη', '', '', 1),
(1820, 85, 'Πέλλα', '', '', 1),
(1821, 85, 'Πιερία', '', '', 1),
(1822, 85, 'Φλώρινα', '', '', 1),
(1823, 85, 'Χαλκιδική', '', '', 1),
(1824, 85, 'Όρος Άθως', '', '', 1),
(1825, 85, 'Έβρος', '', '', 1),
(1826, 85, 'Ξάνθη', '', '', 1),
(1827, 85, 'Ροδόπη', '', '', 1),
(1828, 85, 'Δωδεκάνησα', '', '', 1),
(1829, 85, 'Κυκλάδες', '', '', 1),
(1830, 85, 'Σάμος', '', '', 1),
(1831, 85, 'Χίος', '', '', 1),
(1832, 85, 'Ηράκλειο', '', '', 1),
(1833, 85, 'Λασίθι', '', '', 1),
(1834, 85, 'Ρεθύμνο', '', '', 1),
(1835, 85, 'Αττική', '', '', 1),
(1836, 86, 'Avannaa', '', '', 1),
(1837, 86, 'Tunu ', '', '', 1),
(1838, 86, 'Kitaa', '', '', 1),
(1839, 87, 'Saint David', '', '', 1),
(1840, 87, 'Saint Mark', '', '', 1),
(1841, 87, 'Saint Patrick', '', '', 1),
(1842, 90, 'Alta Verapaz', '', '', 1),
(1843, 90, 'Baja Verapaz', '', '', 1),
(1844, 90, 'Chimaltenango', '', '', 1),
(1845, 90, 'Chiquimula', '', '', 1),
(1846, 90, 'Escuintla', '', '', 1),
(1847, 90, 'Guatemala', '', '', 1),
(1848, 90, 'Huehuetenango', '', '', 1),
(1849, 90, 'Izabal', '', '', 1),
(1850, 90, 'Jalapa', '', '', 1),
(1851, 90, 'Jutiapa', '', '', 1),
(1852, 90, 'El Petén', '', '', 1),
(1853, 90, 'El Progreso', '', '', 1),
(1854, 90, 'El Quiché', '', '', 1),
(1855, 90, 'Quetzaltenango', '', '', 1),
(1856, 90, 'Retalhuleu', '', '', 1),
(1857, 90, 'Sacatepéquez', '', '', 1),
(1858, 90, 'San Marcos', '', '', 1),
(1859, 90, 'Sololá', '', '', 1),
(1860, 90, 'Santa Rosa', '', '', 1),
(1861, 90, 'Suchitepéquez', '', '', 1),
(1862, 90, 'Totonicapán', '', '', 1),
(1863, 90, 'Zacapa', '', '', 1),
(1864, 91, 'Beyla', '', '', 1),
(1865, 91, 'Boffa', '', '', 1),
(1866, 91, 'Boké', '', '', 1),
(1867, 91, 'Coyah', '', '', 1),
(1868, 91, 'Dabola', '', '', 1),
(1869, 91, 'Dinguiraye', '', '', 1),
(1870, 91, 'Dalaba', '', '', 1),
(1871, 91, 'Dubréka', '', '', 1),
(1872, 91, 'Faranah', '', '', 1),
(1873, 91, 'Forécariah', '', '', 1),
(1874, 91, 'Fria', '', '', 1),
(1875, 91, 'Gaoual', '', '', 1),
(1876, 91, 'Guékédou', '', '', 1),
(1877, 91, 'Kankan', '', '', 1),
(1878, 91, 'Koubia', '', '', 1),
(1879, 91, 'Kindia', '', '', 1),
(1880, 91, 'Kérouané', '', '', 1),
(1881, 91, 'Koundara', '', '', 1),
(1882, 91, 'Kouroussa', '', '', 1),
(1883, 91, 'Kissidougou', '', '', 1),
(1884, 91, 'Labé', '', '', 1),
(1885, 91, 'Lélouma', '', '', 1),
(1886, 91, 'Lola', '', '', 1),
(1887, 91, 'Macenta', '', '', 1),
(1888, 91, 'Mandiana', '', '', 1),
(1889, 91, 'Mali', '', '', 1),
(1890, 91, 'Mamou', '', '', 1),
(1891, 91, 'Nzérékoré', '', '', 1),
(1892, 91, 'Pita', '', '', 1),
(1893, 91, 'Siguiri', '', '', 1),
(1894, 91, 'Télimélé', '', '', 1),
(1895, 91, 'Tougué', '', '', 1),
(1896, 91, 'Yomou', '', '', 1),
(1897, 92, 'Bafata', '', '', 1),
(1898, 92, 'Biombo', '', '', 1),
(1899, 92, 'Bissau', '', '', 1),
(1900, 92, 'Bolama', '', '', 1),
(1901, 92, 'Cacheu', '', '', 1),
(1902, 92, 'Gabu', '', '', 1),
(1903, 92, 'Oio', '', '', 1),
(1904, 92, 'Quinara', '', '', 1),
(1905, 92, 'Tombali', '', '', 1),
(1906, 93, 'Barima-Waini', '', '', 1),
(1907, 93, 'Cuyuni-Mazaruni', '', '', 1),
(1908, 93, 'Demerara-Mahaica', '', '', 1),
(1909, 93, 'East Berbice-Corentyne', '', '', 1),
(1910, 93, 'Essequibo Islands-West Demerara', '', '', 1),
(1911, 93, 'Mahaica-Berbice', '', '', 1),
(1912, 93, 'Pomeroon-Supenaam', '', '', 1),
(1913, 93, 'Potaro-Siparuni', '', '', 1),
(1914, 93, 'Upper Demerara-Berbice', '', '', 1),
(1915, 93, 'Upper Takutu-Upper Essequibo', '', '', 1),
(1916, 94, 'Artibonite', '', '', 1),
(1917, 94, 'Grand\'Anse', '', '', 1),
(1918, 94, 'Nippes', '', '', 1),
(1919, 94, 'Nord', '', '', 1),
(1920, 94, 'Nord-Est', '', '', 1),
(1921, 94, 'Nord-Ouest', '', '', 1),
(1922, 94, 'Sud', '', '', 1),
(1923, 94, 'Sud-Est', '', '', 1),
(1924, 95, 'Flat Island', '', '', 1),
(1925, 95, 'McDonald Island', '', '', 1),
(1926, 95, 'Shag Island', '', '', 1),
(1927, 95, 'Heard Island', '', '', 1),
(1928, 96, 'Atlántida', '', '', 1),
(1929, 96, 'Choluteca', '', '', 1),
(1930, 96, 'Colón', '', '', 1),
(1931, 96, 'Comayagua', '', '', 1),
(1932, 96, 'Copán', '', '', 1),
(1933, 96, 'Cortés', '', '', 1),
(1934, 96, 'El Paraíso', '', '', 1),
(1935, 96, 'Francisco Morazán', '', '', 1),
(1936, 96, 'Gracias a Dios', '', '', 1),
(1937, 96, 'Islas de la Bahía', '', '', 1),
(1938, 96, 'Intibucá', '', '', 1),
(1939, 96, 'Lempira', '', '', 1),
(1940, 96, 'La Paz', '', '', 1),
(1941, 96, 'Ocotepeque', '', '', 1),
(1942, 96, 'Olancho', '', '', 1),
(1943, 96, 'Santa Bárbara', '', '', 1),
(1944, 96, 'Valle', '', '', 1),
(1945, 96, 'Yoro', '', '', 1),
(1946, 97, '中西區', '', '', 1),
(1947, 97, '東區', '', '', 1),
(1948, 97, '南區', '', '', 1),
(1949, 97, '灣仔區', '', '', 1),
(1950, 97, '九龍城區', '', '', 1),
(1951, 97, '觀塘區', '', '', 1),
(1952, 97, '深水埗區', '', '', 1),
(1953, 97, '黃大仙區', '', '', 1),
(1954, 97, '油尖旺區', '', '', 1),
(1955, 97, '離島區', '', '', 1),
(1956, 97, '葵青區', '', '', 1),
(1957, 97, '北區', '', '', 1),
(1958, 97, '西貢區', '', '', 1),
(1959, 97, '沙田區', '', '', 1),
(1960, 97, '大埔區', '', '', 1),
(1961, 97, '荃灣區', '', '', 1),
(1962, 97, '屯門區', '', '', 1),
(1963, 97, '元朗區', '', '', 1),
(1964, 98, 'Baranja megye', '', '', 1),
(1965, 98, 'Békéscsaba', '', '', 1),
(1966, 98, 'Békés megye', '', '', 1),
(1967, 98, 'Bács-Kiskun megye', '', '', 1),
(1968, 98, 'Budapest', '', '', 1),
(1969, 98, 'Borsod-Abaúj-Zemplén megye', '', '', 1),
(1970, 98, 'Csongrád megye', '', '', 1),
(1971, 98, 'Debrecen', '', '', 1),
(1972, 98, 'Dunaújváros', '', '', 1),
(1973, 98, 'Eger', '', '', 1),
(1974, 98, 'Fejér megye', '', '', 1),
(1975, 98, 'Győr-Moson-Sopron megye', '', '', 1),
(1976, 98, 'Győr', '', '', 1),
(1977, 98, 'Hajdú-Bihar megye', '', '', 1),
(1978, 98, 'Heves megye', '', '', 1),
(1979, 98, 'Hódmezővásárhely', '', '', 1),
(1980, 98, 'Jász-Nagykun-Szolnok megye', '', '', 1),
(1981, 98, 'Komárom-Esztergom megye', '', '', 1),
(1982, 98, 'Kecskemét', '', '', 1),
(1983, 98, 'Kaposvár', '', '', 1),
(1984, 98, 'Miskolc', '', '', 1),
(1985, 98, 'Nagykanizsa', '', '', 1),
(1986, 98, 'Nógrád megye', '', '', 1),
(1987, 98, 'Nyíregyháza', '', '', 1),
(1988, 98, 'Pest megye', '', '', 1),
(1989, 98, 'Pécs', '', '', 1),
(1990, 98, 'Szeged', '', '', 1),
(1991, 98, 'Székesfehérvár', '', '', 1),
(1992, 98, 'Szombathely', '', '', 1),
(1993, 98, 'Szolnok', '', '', 1),
(1994, 98, 'Sopron', '', '', 1),
(1995, 98, 'Somogy megye', '', '', 1),
(1996, 98, 'Szekszárd', '', '', 1),
(1997, 98, 'Salgótarján', '', '', 1),
(1998, 98, 'Szabolcs-Szatmár-Bereg megye', '', '', 1),
(1999, 98, 'Tatabánya', '', '', 1),
(2000, 98, 'Tolna megye', '', '', 1),
(2001, 98, 'Vas megye', '', '', 1),
(2002, 98, 'Veszprém megye', '', '', 1),
(2003, 98, 'Veszprém', '', '', 1),
(2004, 98, 'Zala megye', '', '', 1),
(2005, 98, 'Zalaegerszeg', '', '', 1),
(2006, 99, 'Höfuðborgarsvæðið', '', '', 1),
(2007, 99, 'Suðurnes', '', '', 1),
(2008, 99, 'Vesturland', '', '', 1),
(2009, 99, 'Vestfirðir', '', '', 1),
(2010, 99, 'Norðurland vestra', '', '', 1),
(2011, 99, 'Norðurland eystra', '', '', 1),
(2012, 99, 'Austfirðir', '', '', 1),
(2013, 99, 'Suðurland', '', '', 1),
(2017, 100, 'National Capital Territory of India', '', '', 1),
(2024, 101, 'Aceh', '', '', 1),
(2025, 101, 'Bali', '', '', 1),
(2026, 101, 'Bangka-Belitung', '', '', 1),
(2027, 101, 'Bengkulu', '', '', 1),
(2028, 101, 'Banten', '', '', 1),
(2029, 101, 'Gorontalo', '', '', 1),
(2030, 101, 'Papua', '', '', 1),
(2031, 101, 'Jambi', '', '', 1),
(2032, 101, 'Jawa Timur', '', '', 1),
(2033, 101, 'Jakarta Raya', '', '', 1),
(2034, 101, 'Jawa Barat', '', '', 1),
(2035, 101, 'Jawa Tengah', '', '', 1),
(2036, 101, 'Kalimantan Barat', '', '', 1),
(2037, 101, 'Kalimantan Timur', '', '', 1),
(2038, 101, 'Kalimantan Selatan', '', '', 1),
(2039, 101, 'Kalimantan Tengah', '', '', 1),
(2040, 101, 'Lampung', '', '', 1),
(2041, 101, 'Maluku', '', '', 1),
(2042, 101, 'Maluku Utara', '', '', 1),
(2043, 101, 'Nusa Tenggara Barat', '', '', 1),
(2044, 101, 'Nusa Tenggara Timur', '', '', 1),
(2045, 101, 'Riau', '', '', 1),
(2046, 101, 'Sumatera Barat', '', '', 1),
(2047, 101, 'Sulawesi Tenggara', '', '', 1),
(2048, 101, 'Sumatera Selatan', '', '', 1),
(2049, 101, 'Sulawesi Selatan', '', '', 1),
(2050, 101, 'Sulawesi Tengah', '', '', 1),
(2051, 101, 'Sulawesi Utara', '', '', 1),
(2052, 101, 'Sumatera Utara', '', '', 1),
(2053, 101, 'Yogyakarta', '', '', 1),
(2054, 102, 'محافظة آذربایجان شرقي', '', '', 1),
(2055, 102, 'محافظة آذربایجان غربي', '', '', 1),
(2056, 102, 'محافظة اردبیل', '', '', 1),
(2057, 102, 'محافظة اصفهان', '', '', 1),
(2058, 102, 'محافظة ایلام', '', '', 1),
(2059, 102, 'محافظة بوشهر', '', '', 1),
(2060, 102, 'محافظة طهران', '', '', 1),
(2061, 102, 'محافظة چهارمحل و بختیاري', '', '', 1),
(2062, 102, 'محافظة خراسان رضوي', '', '', 1),
(2063, 102, 'محافظة خوزستان', '', '', 1),
(2064, 102, 'محافظة زنجان', '', '', 1),
(2065, 102, 'محافظة سمنان', '', '', 1),
(2066, 102, 'محافظة سيستان وبلوتشستان', '', '', 1),
(2067, 102, 'محافظة فارس', '', '', 1),
(2068, 102, 'محافظة کرمان', '', '', 1),
(2069, 102, 'محافظة کردستان', '', '', 1),
(2070, 102, 'محافظة کرمانشاه', '', '', 1),
(2071, 102, 'محافظة کهکیلویه و بویر أحمد', '', '', 1),
(2072, 102, 'محافظة گیلان', '', '', 1),
(2073, 102, 'محافظة لرستان', '', '', 1),
(2074, 102, 'محافظة مازندران', '', '', 1),
(2075, 102, 'محافظة مرکزي', '', '', 1),
(2076, 102, 'محافظة هرمزگان', '', '', 1),
(2077, 102, 'محافظة همدان', '', '', 1),
(2078, 102, 'محافظة یزد', '', '', 1),
(2079, 102, 'محافظة قم', '', '', 1),
(2080, 102, 'محافظة گلستان', '', '', 1),
(2081, 102, 'محافظة قزوين', '', '', 1),
(2082, 103, 'محافظة الأنبار', '', '', 1),
(2083, 103, 'أربيل', '', '', 1),
(2084, 103, 'محافظة البصرة', '', '', 1),
(2085, 103, 'بابل', '', '', 1),
(2086, 103, 'محافظة بغداد', '', '', 1),
(2087, 103, 'دهوك', '', '', 1),
(2088, 103, 'ديالى', '', '', 1),
(2089, 103, 'ذي قار', '', '', 1),
(2090, 103, 'كربلاء', '', '', 1),
(2091, 103, 'ميسان', '', '', 1),
(2092, 103, 'المثنى', '', '', 1),
(2093, 103, 'النجف', '', '', 1),
(2094, 103, 'نینوى', '', '', 1),
(2095, 103, 'القادسية', '', '', 1),
(2096, 103, 'صلاح الدين', '', '', 1),
(2097, 103, 'محافظة السليمانية', '', '', 1),
(2098, 103, 'التأمیم', '', '', 1),
(2099, 103, 'واسط', '', '', 1),
(2100, 104, 'County Cork', '', '', 1),
(2101, 104, 'County Clare', '', '', 1),
(2102, 104, 'County Cavan', '', '', 1),
(2103, 104, 'County Carlow', '', '', 1),
(2104, 104, 'County Dublin', '', '', 1),
(2105, 104, 'County Donegal', '', '', 1),
(2106, 104, 'County Galway', '', '', 1),
(2107, 104, 'County Kildare', '', '', 1),
(2108, 104, 'County Kilkenny', '', '', 1),
(2109, 104, 'County Kerry', '', '', 1),
(2110, 104, 'County Longford', '', '', 1),
(2111, 104, 'County Louth', '', '', 1),
(2112, 104, 'County Limerick', '', '', 1),
(2113, 104, 'County Leitrim', '', '', 1),
(2114, 104, 'County Laois', '', '', 1),
(2115, 104, 'County Meath', '', '', 1),
(2116, 104, 'County Mayo', '', '', 1),
(2117, 104, 'County Monaghan', '', '', 1),
(2118, 104, 'County Offaly', '', '', 1),
(2119, 104, 'County Roscommon', '', '', 1),
(2120, 104, 'County Sligo', '', '', 1),
(2121, 104, 'County Tipperary', '', '', 1),
(2122, 104, 'County Waterford', '', '', 1),
(2123, 104, 'County Westmeath', '', '', 1),
(2124, 104, 'County Wicklow', '', '', 1),
(2125, 104, 'County Wexford', '', '', 1),
(2126, 105, 'מחוז הדרום', '', '', 1),
(2127, 105, 'מחוז חיפה', '', '', 1),
(2128, 105, 'ירושלים', '', '', 1),
(2129, 105, 'מחוז המרכז', '', '', 1),
(2130, 105, 'תל אביב-יפו', '', '', 1),
(2131, 105, 'מחוז הצפון', '', '', 1),
(2132, 106, 'Valle d\'Aosta', '', '', 1),
(2133, 106, 'Barletta-Andria-Trani', '', '', 1),
(2134, 106, 'Alto Adige', '', '', 1),
(2135, 106, 'Fermo', '', '', 1),
(2136, 106, 'Monza e Brianza', '', '', 1),
(2137, 106, 'Verbano-Cusio-Ossola', '', '', 1),
(2138, 106, 'Vibo Valentia', '', '', 1),
(2139, 107, 'Hanover', '', '', 1),
(2140, 107, 'Saint Elizabeth', '', '', 1),
(2141, 107, 'Saint James', '', '', 1),
(2142, 107, 'Trelawny', '', '', 1),
(2143, 107, 'Westmoreland', '', '', 1),
(2144, 107, 'Clarendon', '', '', 1),
(2145, 107, 'Manchester', '', '', 1),
(2146, 107, 'Saint Ann', '', '', 1),
(2147, 107, 'Saint Catherine', '', '', 1),
(2148, 107, 'Saint Mary', '', '', 1),
(2149, 107, 'Kingston', '', '', 1),
(2150, 107, 'Portland', '', '', 1),
(2151, 107, 'Saint Andrew', '', '', 1),
(2152, 107, 'Saint Thomas', '', '', 1),
(2153, 109, 'محافظة عجلون', '', '', 1),
(2154, 109, 'محافظة العاصمة', '', '', 1),
(2155, 109, 'محافظة العقبة', '', '', 1),
(2156, 109, 'محافظة الطفيلة', '', '', 1),
(2157, 109, 'محافظة الزرقاء', '', '', 1),
(2158, 109, 'محافظة البلقاء', '', '', 1),
(2159, 109, 'محافظة جرش', '', '', 1),
(2160, 109, 'محافظة إربد', '', '', 1),
(2161, 109, 'محافظة الكرك', '', '', 1),
(2162, 109, 'محافظة المفرق', '', '', 1),
(2163, 109, 'محافظة مادبا', '', '', 1),
(2164, 109, 'محافظة معان', '', '', 1),
(2165, 110, 'Алматы', '', '', 1),
(2166, 110, 'Almaty City', '', '', 1),
(2167, 110, 'Ақмола', '', '', 1),
(2168, 110, 'Ақтөбе', '', '', 1),
(2169, 110, 'Астана', '', '', 1),
(2170, 110, 'Атырау', '', '', 1),
(2171, 110, 'Батыс Қазақстан', '', '', 1),
(2172, 110, 'Байқоңыр', '', '', 1),
(2173, 110, 'Маңғыстау', '', '', 1),
(2174, 110, 'Оңтүстік Қазақстан', '', '', 1),
(2175, 110, 'Павлодар', '', '', 1),
(2176, 110, 'Қарағанды', '', '', 1),
(2177, 110, 'Қостанай', '', '', 1),
(2178, 110, 'Қызылорда', '', '', 1),
(2179, 110, 'Шығыс Қазақстан', '', '', 1),
(2180, 110, 'Солтүстік Қазақстан', '', '', 1),
(2181, 110, 'Жамбыл', '', '', 1),
(2182, 111, 'Nairobi', '', '', 1),
(2183, 111, 'Central', '', '', 1),
(2184, 111, 'Mombasa', '', '', 1),
(2185, 111, 'Eastern', '', '', 1),
(2186, 111, 'North Eastern', '', '', 1),
(2187, 111, 'Nyanza', '', '', 1),
(2188, 111, 'Rift Valley', '', '', 1),
(2189, 111, 'Western', '', '', 1),
(2190, 112, 'Gilbert Islands', '', '', 1),
(2191, 112, 'Line Islands', '', '', 1),
(2192, 112, 'Phoenix Islands', '', '', 1),
(2193, 113, '자강도', '', '', 1),
(2194, 113, '함경 북도', '', '', 1),
(2195, 113, '함경 남도', '', '', 1),
(2196, 113, '황해 북도', '', '', 1),
(2197, 113, '황해 남도', '', '', 1),
(2198, 113, '강원도', '', '', 1),
(2199, 113, '개성시', '', '', 1),
(2200, 113, '라선 직할시', '', '', 1),
(2201, 113, '남포 특급시', '', '', 1),
(2202, 113, '평안 북도', '', '', 1),
(2203, 113, '평안 남도', '', '', 1),
(2204, 113, '평양 직할시', '', '', 1),
(2205, 113, '량강도', '', '', 1),
(2206, 114, '서울특별시', '', '', 1),
(2207, 114, '부산 광역시', '', '', 1),
(2208, 114, '대구 광역시', '', '', 1),
(2209, 114, '인천광역시', '', '', 1),
(2210, 114, '광주 광역시', '', '', 1),
(2211, 114, '대전 광역시', '', '', 1),
(2212, 114, '울산 광역시', '', '', 1),
(2213, 114, '경기도', '', '', 1),
(2214, 114, '강원도', '', '', 1),
(2215, 114, '충청 북도', '', '', 1),
(2216, 114, '충청 남도', '', '', 1),
(2217, 114, '전라 북도', '', '', 1),
(2218, 114, '전라 남도', '', '', 1),
(2219, 114, '경상 북도', '', '', 1),
(2220, 114, '경상 남도', '', '', 1),
(2221, 114, '제주특별자치도', '', '', 1),
(2222, 115, 'الاحمدي', '', '', 1),
(2223, 115, 'الفروانية', '', '', 1),
(2224, 115, 'الجهراء', '', '', 1),
(2225, 115, 'ألعاصمه', '', '', 1),
(2226, 115, 'حولي', '', '', 1),
(2227, 115, 'مبارك الكبير', '', '', 1),
(2228, 116, 'Баткен областы', '', '', 1),
(2229, 116, 'Чүй областы', '', '', 1),
(2230, 116, 'Бишкек', '', '', 1),
(2231, 116, 'Жалал-Абад областы', '', '', 1),
(2232, 116, 'Нарын областы', '', '', 1),
(2233, 116, 'Ош областы', '', '', 1),
(2234, 116, 'Талас областы', '', '', 1),
(2235, 116, 'Ысык-Көл областы', '', '', 1),
(2236, 117, 'ອັດຕະປື', '', '', 1),
(2237, 117, 'ບໍ່ແກ້ວ', '', '', 1),
(2238, 117, 'ບໍລິຄໍາໄຊ', '', '', 1),
(2239, 117, 'ຈໍາປາສັກ', '', '', 1),
(2240, 117, 'ຫົວພັນ', '', '', 1),
(2241, 117, 'ຄໍາມ່ວນ', '', '', 1),
(2242, 117, 'ຫລວງນໍ້າທາ', '', '', 1),
(2243, 117, 'ຫລວງພະບາງ', '', '', 1),
(2244, 117, 'ອຸດົມໄຊ', '', '', 1),
(2245, 117, 'ຜົງສາລີ', '', '', 1),
(2246, 117, 'ສາລະວັນ', '', '', 1),
(2247, 117, 'ສະຫວັນນະເຂດ', '', '', 1),
(2248, 117, 'ວຽງຈັນ', '', '', 1),
(2249, 117, 'ວຽງຈັນ', '', '', 1),
(2250, 117, 'ໄຊຍະບູລີ', '', '', 1),
(2251, 117, 'ເຊກອງ', '', '', 1),
(2252, 117, 'ຊຽງຂວາງ', '', '', 1),
(2253, 117, 'ໄຊສົມບູນ', '', '', 1),
(2254, 118, 'Aizkraukles rajons', '', '', 1),
(2255, 118, 'Alūksnes rajons', '', '', 1),
(2256, 118, 'Balvu rajons', '', '', 1),
(2257, 118, 'Bauskas rajons', '', '', 1),
(2258, 118, 'Cēsu rajons', '', '', 1),
(2259, 118, 'Daugavpils rajons', '', '', 1),
(2260, 118, 'Daugpilis', '', '', 1),
(2261, 118, 'Dobeles rajons', '', '', 1),
(2262, 118, 'Gulbenes rajons', '', '', 1),
(2263, 118, 'Jelgava', '', '', 1),
(2264, 118, 'Jēkabpils rajons', '', '', 1),
(2265, 118, 'Jelgavas rajons', '', '', 1),
(2266, 118, 'Jūrmala', '', '', 1),
(2267, 118, 'Krāslavas rajons', '', '', 1),
(2268, 118, 'Kuldīgas rajons', '', '', 1),
(2269, 118, 'Liepājas rajons', '', '', 1),
(2270, 118, 'Limbažu rajons', '', '', 1),
(2271, 118, 'Liepoja', '', '', 1),
(2272, 118, 'Ludzas rajons', '', '', 1),
(2273, 118, 'Madonas rajons', '', '', 1),
(2274, 118, 'Ogres rajons', '', '', 1),
(2275, 118, 'Preiļu rajons', '', '', 1),
(2276, 118, 'Rēzeknes rajons', '', '', 1),
(2277, 118, 'Rēzekne', '', '', 1),
(2278, 118, 'Rīgas rajons', '', '', 1),
(2279, 118, 'Rīga', '', '', 1),
(2280, 118, 'Saldus rajons', '', '', 1),
(2281, 118, 'Talsu rajons', '', '', 1),
(2282, 118, 'Tukuma rajons', '', '', 1),
(2283, 118, 'Ventspils rajons', '', '', 1),
(2284, 118, 'Ventspils', '', '', 1),
(2285, 118, 'Valkas rajons', '', '', 1),
(2286, 118, 'Valmieras rajons', '', '', 1),
(2287, 120, 'Maseru', '', '', 1),
(2288, 120, 'Butha-Buthe', '', '', 1),
(2289, 120, 'Leribe', '', '', 1),
(2290, 120, 'Berea', '', '', 1),
(2291, 120, 'Mafeteng', '', '', 1),
(2292, 120, 'Mohale\'s Hoek', '', '', 1),
(2293, 120, 'Quthing', '', '', 1),
(2294, 120, 'Qacha\'s Nek', '', '', 1),
(2295, 120, 'Mokhotlong', '', '', 1),
(2296, 120, 'Thaba-Tseka', '', '', 1),
(2297, 121, 'Bong', '', '', 1),
(2298, 121, 'Bomi', '', '', 1),
(2299, 121, 'Grand Cape Mount', '', '', 1),
(2300, 121, 'Grand Bassa', '', '', 1),
(2301, 121, 'Grand Gedeh', '', '', 1),
(2302, 121, 'Grand Kru', '', '', 1),
(2303, 121, 'Gbarpolu', '', '', 1),
(2304, 121, 'Lofa', '', '', 1),
(2305, 121, 'Margibi', '', '', 1),
(2306, 121, 'Montserrado', '', '', 1),
(2307, 121, 'Maryland', '', '', 1),
(2308, 121, 'Nimba', '', '', 1),
(2309, 121, 'River Gee', '', '', 1),
(2310, 121, 'Rivercess', '', '', 1),
(2311, 121, 'Sinoe', '', '', 1),
(2312, 122, 'Ajdābiyā', '', '', 1),
(2313, 122, 'Banghāzī', '', '', 1),
(2314, 122, 'Al Buţnān', '', '', 1),
(2315, 122, 'Banī Walīd', '', '', 1),
(2316, 122, 'Darnah', '', '', 1),
(2317, 122, 'Ghadāmis', '', '', 1),
(2318, 122, 'Gharyān', '', '', 1),
(2319, 122, 'Ghāt', '', '', 1),
(2320, 122, 'Al Ḩizām al Akhḑar', '', '', 1),
(2321, 122, 'Al Jabal al Akhḑar', '', '', 1),
(2322, 122, 'Jaghbūb', '', '', 1),
(2323, 122, 'Al Jifārah', '', '', 1),
(2324, 122, 'Al Jufrah', '', '', 1),
(2325, 122, 'Al Kufrah', '', '', 1),
(2326, 122, 'Al Marqab', '', '', 1),
(2327, 122, 'Mişrātah', '', '', 1),
(2328, 122, 'Al Marj', '', '', 1),
(2329, 122, 'Murzuq', '', '', 1),
(2330, 122, 'Mizdah', '', '', 1),
(2331, 122, 'Nālūt', '', '', 1),
(2332, 122, 'An Nuqaţ al Khams', '', '', 1),
(2333, 122, 'Al Qubbah', '', '', 1),
(2334, 122, 'Al Qaţrūn', '', '', 1),
(2335, 122, 'Sabhā', '', '', 1),
(2336, 122, 'Ash Shāţi', '', '', 1),
(2337, 122, 'Surt', '', '', 1),
(2338, 122, 'Şabrātah Şurmān', '', '', 1),
(2339, 122, 'Ţarābulus', '', '', 1),
(2340, 122, 'Tarhūnah-Masallātah', '', '', 1),
(2341, 122, 'Tājūrā wa an Nawāḩī al Arbāʻ', '', '', 1),
(2342, 122, 'Al Wāḩah', '', '', 1),
(2343, 122, 'Wādī al Ḩayāt', '', '', 1),
(2344, 122, 'Yafran-Jādū', '', '', 1),
(2345, 122, 'Az Zāwiyah', '', '', 1),
(2346, 123, 'Balzers', '', '', 1),
(2347, 123, 'Eschen', '', '', 1),
(2348, 123, 'Gamprin', '', '', 1),
(2349, 123, 'Mauren', '', '', 1),
(2350, 123, 'Planken', '', '', 1),
(2351, 123, 'Ruggell', '', '', 1),
(2352, 123, 'Schaan', '', '', 1),
(2353, 123, 'Schellenberg', '', '', 1),
(2354, 123, 'Triesen', '', '', 1),
(2355, 123, 'Triesenberg', '', '', 1),
(2356, 123, 'Vaduz', '', '', 1),
(2357, 124, 'Alytaus Apskritis', '', '', 1),
(2358, 124, 'Klaipėdos Apskritis', '', '', 1),
(2359, 124, 'Kauno Apskritis', '', '', 1),
(2360, 124, 'Marijampolės Apskritis', '', '', 1),
(2361, 124, 'Panevėžio Apskritis', '', '', 1),
(2362, 124, 'Šiaulių Apskritis', '', '', 1),
(2363, 124, 'Tauragės Apskritis', '', '', 1),
(2364, 124, 'Telšių Apskritis', '', '', 1),
(2365, 124, 'Utenos Apskritis', '', '', 1),
(2366, 124, 'Vilniaus Apskritis', '', '', 1),
(2367, 125, 'Diekirch', '', '', 1),
(2368, 125, 'Grevenmacher', '', '', 1),
(2369, 125, 'Luxemburg', '', '', 1),
(2370, 126, '海島市', '', '', 1),
(2371, 126, '澳門市', '', '', 1),
(2372, 127, 'Berovo', '', '', 1),
(2373, 127, 'Чешиново-Облешево', '', '', 1),
(2374, 127, 'Делчево', '', '', 1),
(2375, 127, 'Карбинци', '', '', 1),
(2376, 127, 'Кочани', '', '', 1),
(2377, 127, 'Лозово', '', '', 1),
(2378, 127, 'Македонска каменица', '', '', 1),
(2379, 127, 'Пехчево', '', '', 1),
(2380, 127, 'Пробиштип', '', '', 1),
(2381, 127, 'Штип', '', '', 1),
(2382, 127, 'Свети Николе', '', '', 1),
(2383, 127, 'Виница', '', '', 1),
(2384, 127, 'Зрновци', '', '', 1),
(2385, 127, 'Кратово', '', '', 1),
(2386, 127, 'Крива Паланка', '', '', 1),
(2387, 127, 'Куманово', '', '', 1),
(2388, 127, 'Липково', '', '', 1),
(2389, 127, 'Ранковце', '', '', 1),
(2390, 127, 'Старо Нагоричане', '', '', 1),
(2391, 127, 'Битола', '', '', 1),
(2392, 127, 'Демир Хисар', '', '', 1),
(2393, 127, 'Долнени', '', '', 1),
(2394, 127, 'Кривогаштани', '', '', 1),
(2395, 127, 'Крушево', '', '', 1),
(2396, 127, 'Могила', '', '', 1),
(2397, 127, 'Новаци', '', '', 1),
(2398, 127, 'Прилеп', '', '', 1),
(2399, 127, 'Ресен', '', '', 1),
(2400, 127, 'Боговиње', '', '', 1),
(2401, 127, 'Брвеница', '', '', 1),
(2402, 127, 'Гостивар', '', '', 1),
(2403, 127, 'Јегуновце', '', '', 1),
(2404, 127, 'Маврово и Ростуша', '', '', 1),
(2405, 127, 'Теарце', '', '', 1),
(2406, 127, 'Тетово', '', '', 1),
(2407, 127, 'Врапчиште', '', '', 1),
(2408, 127, 'Желино', '', '', 1),
(2409, 127, 'Аеродром', '', '', 1),
(2410, 127, 'Арачиново', '', '', 1),
(2411, 127, 'Бутел', '', '', 1),
(2412, 127, 'Чаир', '', '', 1),
(2413, 127, 'Центар', '', '', 1),
(2414, 127, 'Чучер Сандево', '', '', 1),
(2415, 127, 'Гази Баба', '', '', 1),
(2416, 127, 'Ѓорче Петров', '', '', 1),
(2417, 127, 'Илинден', '', '', 1),
(2418, 127, 'Карпош', '', '', 1),
(2419, 127, 'Кисела Вода', '', '', 1),
(2420, 127, 'Петровец', '', '', 1),
(2421, 127, 'Сарај', '', '', 1),
(2422, 127, 'Сопиште', '', '', 1),
(2423, 127, 'Студеничани', '', '', 1),
(2424, 127, 'Шуто Оризари', '', '', 1),
(2425, 127, 'Зелениково', '', '', 1),
(2426, 127, 'Богданци', '', '', 1),
(2427, 127, 'Босилово', '', '', 1),
(2428, 127, 'Гевгелија', '', '', 1),
(2429, 127, 'Конче', '', '', 1),
(2430, 127, 'Ново Село', '', '', 1),
(2431, 127, 'Радовиш', '', '', 1),
(2432, 127, 'Стар Дојран', '', '', 1),
(2433, 127, 'Струмица', '', '', 1),
(2434, 127, 'Валандово', '', '', 1),
(2435, 127, 'Василево', '', '', 1),
(2436, 127, 'Центар Жупа', '', '', 1),
(2437, 127, 'Дебар', '', '', 1),
(2438, 127, 'Дебарца', '', '', 1),
(2439, 127, 'Другово', '', '', 1),
(2440, 127, 'Кичево', '', '', 1),
(2441, 127, 'Македонски Брод', '', '', 1),
(2442, 127, 'Охрид', '', '', 1),
(2443, 127, 'Осломеј', '', '', 1),
(2444, 127, 'Пласница', '', '', 1),
(2445, 127, 'Струга', '', '', 1),
(2446, 127, 'Вевчани', '', '', 1),
(2447, 127, 'Вранештица', '', '', 1),
(2448, 127, 'Зајас', '', '', 1),
(2449, 127, 'Чашка', '', '', 1),
(2450, 127, 'Демир Капија', '', '', 1),
(2451, 127, 'Градско', '', '', 1),
(2452, 127, 'Кавадарци', '', '', 1),
(2453, 127, 'Неготино', '', '', 1),
(2454, 127, 'Росоман', '', '', 1),
(2455, 127, 'Велес', '', '', 1),
(2456, 128, 'Toamasina', '', '', 1),
(2457, 128, 'Antsiranana', '', '', 1),
(2458, 128, 'Fianarantsoa', '', '', 1),
(2459, 128, 'Mahajanga', '', '', 1),
(2460, 128, 'Antananarivo', '', '', 1),
(2461, 128, 'Toliara', '', '', 1),
(2462, 129, 'Balaka', '', '', 1),
(2463, 129, 'Blantyre', '', '', 1),
(2464, 129, 'Chikwawa', '', '', 1),
(2465, 129, 'Chiradzulu', '', '', 1),
(2466, 129, 'Chitipa', '', '', 1),
(2467, 129, 'Dedza', '', '', 1),
(2468, 129, 'Dowa', '', '', 1),
(2469, 129, 'Karonga', '', '', 1),
(2470, 129, 'Kasungu', '', '', 1),
(2471, 129, 'Likoma Island', '', '', 1),
(2472, 129, 'Lilongwe', '', '', 1),
(2473, 129, 'Machinga', '', '', 1),
(2474, 129, 'Mangochi', '', '', 1),
(2475, 129, 'Mchinji', '', '', 1),
(2476, 129, 'Mulanje', '', '', 1),
(2477, 129, 'Mwanza', '', '', 1),
(2478, 129, 'Mzimba', '', '', 1),
(2479, 129, 'Northern', '', '', 1),
(2480, 129, 'Nkhata', '', '', 1),
(2481, 129, 'Nkhotakota', '', '', 1),
(2482, 129, 'Nsanje', '', '', 1),
(2483, 129, 'Ntcheu', '', '', 1),
(2484, 129, 'Ntchisi', '', '', 1),
(2485, 129, 'Phalombe', '', '', 1),
(2486, 129, 'Rumphi', '', '', 1),
(2487, 129, 'Southern', '', '', 1),
(2488, 129, 'Salima', '', '', 1),
(2489, 129, 'Thyolo', '', '', 1),
(2490, 129, 'Zomba', '', '', 1),
(2491, 130, 'Johor Darul Takzim', '', '', 1),
(2492, 130, 'Kedah Darul Aman', '', '', 1),
(2493, 130, 'Kelantan Darul Naim', '', '', 1),
(2494, 130, 'Melaka Negeri Bersejarah', '', '', 1),
(2495, 130, 'Negeri Sembilan Darul Khusus', '', '', 1),
(2496, 130, 'Pahang Darul Makmur', '', '', 1),
(2497, 130, 'Pulau Pinang', '', '', 1),
(2498, 130, 'Perak Darul Ridzuan', '', '', 1),
(2499, 130, 'Perlis Indera Kayangan', '', '', 1),
(2500, 130, 'Selangor Darul Ehsan', '', '', 1),
(2501, 130, 'Terengganu Darul Iman', '', '', 1),
(2502, 130, 'Sabah Negeri Di Bawah Bayu', '', '', 1),
(2503, 130, 'Sarawak Bumi Kenyalang', '', '', 1),
(2504, 130, 'Wilayah Persekutuan Kuala Lumpur', '', '', 1),
(2505, 130, 'Wilayah Persekutuan Labuan', '', '', 1),
(2506, 130, 'Wilayah Persekutuan Putrajaya', '', '', 1),
(2507, 131, 'Thiladhunmathi Uthuru', '', '', 1),
(2508, 131, 'Thiladhunmathi Dhekunu', '', '', 1),
(2509, 131, 'Miladhunmadulu Uthuru', '', '', 1),
(2510, 131, 'Miladhunmadulu Dhekunu', '', '', 1),
(2511, 131, 'Maalhosmadulu Uthuru', '', '', 1),
(2512, 131, 'Maalhosmadulu Dhekunu', '', '', 1),
(2513, 131, 'Faadhippolhu', '', '', 1),
(2514, 131, 'Male Atoll', '', '', 1),
(2515, 131, 'Ari Atoll Uthuru', '', '', 1),
(2516, 131, 'Ari Atoll Dheknu', '', '', 1),
(2517, 131, 'Felidhe Atoll', '', '', 1),
(2518, 131, 'Mulaku Atoll', '', '', 1),
(2519, 131, 'Nilandhe Atoll Uthuru', '', '', 1),
(2520, 131, 'Nilandhe Atoll Dhekunu', '', '', 1),
(2521, 131, 'Kolhumadulu', '', '', 1),
(2522, 131, 'Hadhdhunmathi', '', '', 1),
(2523, 131, 'Huvadhu Atoll Uthuru', '', '', 1),
(2524, 131, 'Huvadhu Atoll Dhekunu', '', '', 1),
(2525, 131, 'Fua Mulaku', '', '', 1),
(2526, 131, 'Addu', '', '', 1),
(2527, 132, 'Kayes', '', '', 1),
(2528, 132, 'Koulikoro', '', '', 1),
(2529, 132, 'Sikasso', '', '', 1),
(2530, 132, 'Ségou', '', '', 1),
(2531, 132, 'Mopti', '', '', 1),
(2532, 132, 'Tombouctou', '', '', 1),
(2533, 132, 'Gao', '', '', 1),
(2534, 132, 'Kidal', '', '', 1),
(2535, 132, 'Bamako', '', '', 1),
(2536, 133, 'Gozo', '', '', 1),
(2537, 134, 'Ailuk', '', '', 1),
(2538, 134, 'Ailinglapalap', '', '', 1),
(2539, 134, 'Arno', '', '', 1),
(2540, 134, 'Aur', '', '', 1),
(2541, 134, 'Ebon', '', '', 1),
(2542, 134, 'Eniwetok', '', '', 1),
(2543, 134, 'Jabat', '', '', 1),
(2544, 134, 'Jaluit', '', '', 1),
(2545, 134, 'Kili', '', '', 1),
(2546, 134, 'Kwajalein', '', '', 1),
(2547, 134, 'Lae', '', '', 1),
(2548, 134, 'Lib', '', '', 1),
(2549, 134, 'Likiep', '', '', 1),
(2550, 134, 'Majuro', '', '', 1),
(2551, 134, 'Maloelap', '', '', 1),
(2552, 134, 'Mejit', '', '', 1),
(2553, 134, 'Mili', '', '', 1),
(2554, 134, 'Namorik', '', '', 1),
(2555, 134, 'Namu', '', '', 1),
(2556, 134, 'Rongelap', '', '', 1),
(2557, 134, 'Ujae', '', '', 1),
(2558, 134, 'Ujelang', '', '', 1),
(2559, 134, 'Utirik', '', '', 1),
(2560, 134, 'Wotje', '', '', 1),
(2561, 134, 'Wotho', '', '', 1),
(2562, 136, 'ولاية الحوض الشرقي', '', '', 1),
(2563, 136, 'ولاية الحوض الغربي', '', '', 1),
(2564, 136, 'ولاية العصابة', '', '', 1),
(2565, 136, 'ولاية كركول', '', '', 1),
(2566, 136, 'ولاية البراكنة', '', '', 1),
(2567, 136, 'ولاية الترارزة', '', '', 1),
(2568, 136, 'ولاية آدرار', '', '', 1),
(2569, 136, 'ولاية داخلت نواذيبو', '', '', 1),
(2570, 136, 'ولاية تكانت', '', '', 1),
(2571, 136, 'ولاية كيدي ماغة', '', '', 1),
(2572, 136, 'ولاية تيرس زمور', '', '', 1),
(2573, 136, 'ولاية إينشيري', '', '', 1),
(2574, 136, 'نواكشوط', '', '', 1),
(2575, 137, 'Agalega Islands', '', '', 1),
(2576, 137, 'Black River', '', '', 1),
(2577, 137, 'Beau Bassin-Rose Hill', '', '', 1),
(2578, 137, 'Cargados Carajos Shoals', '', '', 1),
(2579, 137, 'Curepipe', '', '', 1),
(2580, 137, 'Flacq', '', '', 1),
(2581, 137, 'Grand Port', '', '', 1),
(2582, 137, 'Moka', '', '', 1),
(2583, 137, 'Pamplemousses', '', '', 1),
(2584, 137, 'Port Louis', '', '', 1),
(2585, 137, 'Port Louis City', '', '', 1),
(2586, 137, 'Plaines Wilhems', '', '', 1),
(2587, 137, 'Quatre Bornes', '', '', 1),
(2588, 137, 'Rodrigues', '', '', 1),
(2589, 137, 'Riviere du Rempart', '', '', 1),
(2590, 137, 'Savanne', '', '', 1),
(2591, 137, 'Vacoas-Phoenix', '', '', 1),
(2599, 140, 'Kosrae', '', '', 1),
(2600, 140, 'Pohnpei', '', '', 1),
(2601, 140, 'Chuuk', '', '', 1),
(2602, 140, 'Yap', '', '', 1),
(2603, 141, 'Bălţi', '', '', 1),
(2604, 141, 'Cahul', '', '', 1),
(2605, 141, 'Chişinău', '', '', 1),
(2606, 141, 'Edineţ', '', '', 1),
(2607, 141, 'Găgăuzia', '', '', 1),
(2608, 141, 'Lăpuşna', '', '', 1),
(2609, 141, 'Orhei', '', '', 1),
(2610, 141, 'Stânga Nistrului', '', '', 1),
(2611, 141, 'Soroca', '', '', 1),
(2612, 141, 'Tighina', '', '', 1),
(2613, 141, 'Ungheni', '', '', 1),
(2614, 142, 'Monte Carlo', '', '', 1),
(2615, 142, 'La Rousse', '', '', 1),
(2616, 142, 'Larvotto', '', '', 1),
(2617, 142, 'Monaco Ville', '', '', 1),
(2618, 142, 'Saint Michel', '', '', 1),
(2619, 142, 'Condamine', '', '', 1),
(2620, 142, 'La Colle', '', '', 1),
(2621, 142, 'Les Révoires', '', '', 1),
(2622, 142, 'Moneghetti', '', '', 1),
(2623, 142, 'Fontvieille', '', '', 1),
(2624, 143, 'Улаанбаатар', '', '', 1),
(2625, 143, 'Орхон аймаг', '', '', 1),
(2626, 143, 'Дархан-Уул аймаг', '', '', 1),
(2627, 143, 'Хэнтий аймаг', '', '', 1),
(2628, 143, 'Хөвсгөл аймаг', '', '', 1),
(2629, 143, 'Ховд аймаг', '', '', 1),
(2630, 143, 'Увс аймаг', '', '', 1),
(2631, 143, 'Төв аймаг', '', '', 1),
(2632, 143, 'Сэлэнгэ аймаг', '', '', 1),
(2633, 143, 'Сүхбаатар аймаг', '', '', 1),
(2634, 143, 'Өмнөговь аймаг', '', '', 1),
(2635, 143, 'Өвөрхангай аймаг', '', '', 1),
(2636, 143, 'Завхан аймаг', '', '', 1),
(2637, 143, 'Дундговь аймаг', '', '', 1),
(2638, 143, 'Дорнод аймаг', '', '', 1),
(2639, 143, 'Дорноговь аймаг', '', '', 1),
(2640, 143, 'Говьсүмбэр аймаг', '', '', 1),
(2641, 143, 'Говь-Алтай аймаг', '', '', 1),
(2642, 143, 'Булган аймаг', '', '', 1),
(2643, 143, 'Баянхонгор аймаг', '', '', 1),
(2644, 143, 'Баян Өлгий аймаг', '', '', 1),
(2645, 143, 'Архангай аймаг', '', '', 1),
(2646, 144, 'Saint Anthony', '', '', 1),
(2647, 144, 'Saint Georges', '', '', 1),
(2648, 144, 'Saint Peter', '', '', 1),
(2649, 146, 'Niassa', '', '', 1),
(2650, 146, 'Manica', '', '', 1),
(2651, 146, 'Gaza', '', '', 1),
(2652, 146, 'Inhambane', '', '', 1),
(2653, 146, 'Maputo', '', '', 1),
(2654, 146, 'Maputo cidade', '', '', 1),
(2655, 146, 'Nampula', '', '', 1),
(2656, 146, 'Cabo Delgado', '', '', 1),
(2657, 146, 'Zambézia', '', '', 1),
(2658, 146, 'Sofala', '', '', 1),
(2659, 146, 'Tete', '', '', 1),
(2660, 147, 'ဧရာ၀တီတိုင္‌း', '', '', 1),
(2661, 147, 'ပဲခူးတုိင္‌း', '', '', 1),
(2662, 147, 'မကေ္ဝးတိုင္‌း', '', '', 1),
(2663, 147, 'မန္တလေးတုိင္‌း', '', '', 1),
(2664, 147, 'စစ္‌ကုိင္‌း‌တုိင္‌း', '', '', 1),
(2665, 147, 'တနင္သာရိတုိင္‌း', '', '', 1),
(2666, 147, 'ရန္‌ကုန္‌တုိင္‌း', '', '', 1),
(2667, 147, 'ခ္ယင္‌းပ္ရည္‌နယ္‌', '', '', 1),
(2668, 147, 'ကခ္ယင္‌ပ္ရည္‌နယ္‌', '', '', 1),
(2669, 147, 'ကယား‌ပ္ရည္‌နယ္‌', '', '', 1),
(2670, 147, 'ကရင္‌‌ပ္ရည္‌နယ္‌', '', '', 1),
(2671, 147, 'မ္ဝန္‌ပ္ရည္‌နယ္‌', '', '', 1),
(2672, 147, 'ရခုိင္‌ပ္ရည္‌နယ္‌', '', '', 1),
(2673, 147, 'ရုမ္‌းပ္ရည္‌နယ္‌', '', '', 1),
(2674, 148, 'Caprivi', '', '', 1),
(2675, 148, 'Erongo', '', '', 1),
(2676, 148, 'Hardap', '', '', 1),
(2677, 148, 'Karas', '', '', 1),
(2678, 148, 'Khomas', '', '', 1),
(2679, 148, 'Kunene', '', '', 1),
(2680, 148, 'Otjozondjupa', '', '', 1),
(2681, 148, 'Omaheke', '', '', 1),
(2682, 148, 'Okavango', '', '', 1),
(2683, 148, 'Oshana', '', '', 1),
(2684, 148, 'Omusati', '', '', 1),
(2685, 148, 'Oshikoto', '', '', 1),
(2686, 148, 'Ohangwena', '', '', 1),
(2687, 149, 'Aiwo', '', '', 1),
(2688, 149, 'Anabar', '', '', 1),
(2689, 149, 'Anetan', '', '', 1),
(2690, 149, 'Anibare', '', '', 1),
(2691, 149, 'Baiti', '', '', 1),
(2692, 149, 'Boe', '', '', 1),
(2693, 149, 'Buada', '', '', 1),
(2694, 149, 'Denigomodu', '', '', 1),
(2695, 149, 'Ewa', '', '', 1),
(2696, 149, 'Ijuw', '', '', 1),
(2697, 149, 'Meneng', '', '', 1),
(2698, 149, 'Nibok', '', '', 1),
(2699, 149, 'Uaboe', '', '', 1),
(2700, 149, 'Yaren', '', '', 1),
(2701, 150, 'Bagmati', '', '', 1),
(2702, 150, 'Bheri', '', '', 1),
(2703, 150, 'Dhawalagiri', '', '', 1),
(2704, 150, 'Gandaki', '', '', 1),
(2705, 150, 'Janakpur', '', '', 1),
(2706, 150, 'Karnali', '', '', 1),
(2707, 150, 'Kosi', '', '', 1),
(2708, 150, 'Lumbini', '', '', 1),
(2709, 150, 'Mahakali', '', '', 1),
(2710, 150, 'Mechi', '', '', 1),
(2711, 150, 'Narayani', '', '', 1),
(2712, 150, 'Rapti', '', '', 1),
(2713, 150, 'Sagarmatha', '', '', 1),
(2714, 150, 'Seti', '', '', 1),
(2715, 151, 'Drenthe', '', '', 1),
(2716, 151, 'Flevoland', '', '', 1),
(2717, 151, 'Friesland', '', '', 1),
(2718, 151, 'Gelderland', '', '', 1),
(2719, 151, 'Groningen', '', '', 1),
(2720, 151, 'Limburg', '', '', 1),
(2721, 151, 'Noord-Brabant', '', '', 1),
(2722, 151, 'Noord-Holland', '', '', 1),
(2723, 151, 'Overijssel', '', '', 1),
(2724, 151, 'Utrecht', '', '', 1),
(2725, 151, 'Zeeland', '', '', 1),
(2726, 151, 'Zuid-Holland', '', '', 1),
(2727, 153, 'Province des Îles', '', '', 1),
(2728, 153, 'Province Nord', '', '', 1),
(2729, 153, 'Province Sud', '', '', 1),
(2730, 154, 'Auckland', '', '', 1),
(2731, 154, 'Bay of Plenty', '', '', 1),
(2732, 154, 'Canterbury', '', '', 1),
(2733, 154, 'Gisborne', '', '', 1),
(2734, 154, 'Hawke\'s Bay', '', '', 1),
(2735, 154, 'Marlborough', '', '', 1),
(2736, 154, 'Manawatu-Wanganui', '', '', 1),
(2737, 154, 'Nelson', '', '', 1),
(2738, 154, 'Northland', '', '', 1),
(2739, 154, 'Otago', '', '', 1),
(2740, 154, 'Southland', '', '', 1),
(2741, 154, 'Tasman', '', '', 1),
(2742, 154, 'Taranaki', '', '', 1),
(2743, 154, 'Wellington', '', '', 1),
(2744, 154, 'Waikato', '', '', 1),
(2745, 154, 'West Coast', '', '', 1),
(2746, 155, 'Atlántico Norte', '', '', 1),
(2747, 155, 'Atlántico Sur', '', '', 1),
(2748, 155, 'Boaco', '', '', 1),
(2749, 155, 'Carazo', '', '', 1),
(2750, 155, 'Chinandega', '', '', 1),
(2751, 155, 'Chontales', '', '', 1),
(2752, 155, 'Estelí', '', '', 1),
(2753, 155, 'Granada', '', '', 1),
(2754, 155, 'Jinotega', '', '', 1),
(2755, 155, 'León', '', '', 1),
(2756, 155, 'Madriz', '', '', 1),
(2757, 155, 'Managua', '', '', 1),
(2758, 155, 'Masaya', '', '', 1),
(2759, 155, 'Matagalpa', '', '', 1),
(2760, 155, 'Nueva Segovia', '', '', 1),
(2761, 155, 'Rivas', '', '', 1),
(2762, 155, 'Río San Juan', '', '', 1),
(2763, 156, 'Agadez', '', '', 1),
(2764, 156, 'Daffa', '', '', 1),
(2765, 156, 'Dosso', '', '', 1),
(2766, 156, 'Maradi', '', '', 1),
(2767, 156, 'Tahoua', '', '', 1),
(2768, 156, 'Tillabéry', '', '', 1),
(2769, 156, 'Zinder', '', '', 1),
(2770, 156, 'Niamey', '', '', 1),
(2771, 157, 'Abia State', '', '', 1),
(2772, 157, 'Adamawa State', '', '', 1),
(2773, 157, 'Akwa Ibom State', '', '', 1),
(2774, 157, 'Anambra State', '', '', 1),
(2775, 157, 'Bauchi State', '', '', 1),
(2776, 157, 'Benue State', '', '', 1),
(2777, 157, 'Borno State', '', '', 1),
(2778, 157, 'Bayelsa State', '', '', 1),
(2779, 157, 'Cross River State', '', '', 1),
(2780, 157, 'Delta State', '', '', 1),
(2781, 157, 'Ebonyi State', '', '', 1),
(2782, 157, 'Edo State', '', '', 1),
(2783, 157, 'Ekiti State', '', '', 1),
(2784, 157, 'Enugu State', '', '', 1),
(2785, 157, 'Gombe State', '', '', 1),
(2786, 157, 'Imo State', '', '', 1),
(2787, 157, 'Jigawa State', '', '', 1),
(2788, 157, 'Kebbi State', '', '', 1),
(2789, 157, 'Kaduna State', '', '', 1),
(2790, 157, 'Kano State', '', '', 1),
(2791, 157, 'Kogi State', '', '', 1),
(2792, 157, 'Katsina State', '', '', 1),
(2793, 157, 'Kwara State', '', '', 1),
(2794, 157, 'Lagos State', '', '', 1),
(2795, 157, 'Nassarawa State', '', '', 1),
(2796, 157, 'Niger State', '', '', 1),
(2797, 157, 'Ogun State', '', '', 1),
(2798, 157, 'Ondo State', '', '', 1),
(2799, 157, 'Osun State', '', '', 1),
(2800, 157, 'Oyo State', '', '', 1),
(2801, 157, 'Plateau State', '', '', 1),
(2802, 157, 'Rivers State', '', '', 1),
(2803, 157, 'Sokoto State', '', '', 1),
(2804, 157, 'Taraba State', '', '', 1),
(2805, 157, 'Zamfara State', '', '', 1),
(2806, 160, 'Northern Islands', '', '', 1),
(2807, 160, 'Rota', '', '', 1),
(2808, 160, 'Saipan', '', '', 1),
(2809, 160, 'Tinian', '', '', 1),
(2810, 161, 'Østfold fylke', '', '', 1),
(2811, 161, 'Akershus fylke', '', '', 1),
(2812, 161, 'Oslo fylke', '', '', 1),
(2813, 161, 'Hedmark fylke', '', '', 1),
(2814, 161, 'Oppland fylke', '', '', 1),
(2815, 161, 'Buskerud fylke', '', '', 1),
(2816, 161, 'Vestfold fylke', '', '', 1),
(2817, 161, 'Telemark fylke', '', '', 1),
(2818, 161, 'Aust-Agder fylke', '', '', 1),
(2819, 161, 'Vest-Agder fylke', '', '', 1),
(2820, 161, 'Rogaland fylke', '', '', 1),
(2821, 161, 'Hordaland fylke', '', '', 1),
(2822, 161, 'Sogn og Fjordane fylke', '', '', 1),
(2823, 161, 'Møre og Romsdal fylke', '', '', 1),
(2824, 161, 'Sør-Trøndelag fylke', '', '', 1),
(2825, 161, 'Nord-Trøndelag fylke', '', '', 1),
(2826, 161, 'Nordland fylke', '', '', 1),
(2827, 161, 'Troms fylke', '', '', 1),
(2828, 161, 'Finnmark fylke', '', '', 1),
(2829, 162, 'الباطنة', '', '', 1),
(2830, 162, 'الداخلية', '', '', 1),
(2831, 162, 'ظفار', '', '', 1),
(2832, 162, 'مسقط', '', '', 1),
(2833, 162, 'مسندم', '', '', 1),
(2834, 162, 'الشرقية', '', '', 1),
(2835, 162, 'الوسطى', '', '', 1),
(2836, 162, 'الظاهرة', '', '', 1),
(2837, 163, 'بلوچستان', '', '', 1),
(2838, 163, 'وفاقی دارالحکومت', '', '', 1),
(2839, 163, 'آزاد کشمیر', '', '', 1),
(2840, 163, 'شمالی علاقہ جات', '', '', 1),
(2841, 163, 'شمال مغربی سرحدی صوبہ', '', '', 1),
(2842, 163, 'پنجاب', '', '', 1),
(2843, 163, 'سندھ', '', '', 1),
(2844, 163, 'وفاقی قبائلی علاقہ جات', '', '', 1),
(2845, 164, 'Aimeliik', '', '', 1),
(2846, 164, 'Airai', '', '', 1),
(2847, 164, 'Angaur', '', '', 1),
(2848, 164, 'Hatohobei', '', '', 1),
(2849, 164, 'Kayangel', '', '', 1),
(2850, 164, 'Koror', '', '', 1),
(2851, 164, 'Melekeok', '', '', 1),
(2852, 164, 'Ngaraard', '', '', 1),
(2853, 164, 'Ngarchelong', '', '', 1),
(2854, 164, 'Ngardmau', '', '', 1),
(2855, 164, 'Ngatpang', '', '', 1),
(2856, 164, 'Ngchesar', '', '', 1),
(2857, 164, 'Ngeremlengui', '', '', 1),
(2858, 164, 'Ngiwal', '', '', 1),
(2859, 164, 'Peleliu', '', '', 1),
(2860, 164, 'Sonsorol', '', '', 1),
(2861, 165, 'Kuna Yala', '', '', 1),
(2862, 166, 'Chimbu', '', '', 1),
(2863, 166, 'Central', '', '', 1),
(2864, 166, 'East New Britain', '', '', 1),
(2865, 166, 'Eastern Highlands', '', '', 1),
(2866, 166, 'Enga', '', '', 1),
(2867, 166, 'East Sepik', '', '', 1),
(2868, 166, 'Gulf', '', '', 1),
(2869, 166, 'Milne Bay', '', '', 1),
(2870, 166, 'Morobe', '', '', 1),
(2871, 166, 'Madang', '', '', 1),
(2872, 166, 'Manus', '', '', 1),
(2873, 166, 'National Capital District', '', '', 1),
(2874, 166, 'New Ireland', '', '', 1),
(2875, 166, 'Northern', '', '', 1),
(2876, 166, 'North Solomons', '', '', 1),
(2877, 166, 'Sandaun', '', '', 1),
(2878, 166, 'Southern Highlands', '', '', 1),
(2879, 166, 'West New Britain', '', '', 1),
(2880, 166, 'Western Highlands', '', '', 1),
(2881, 166, 'Western', '', '', 1),
(2882, 167, 'Concepción', '', '', 1),
(2883, 167, 'San Pedro', '', '', 1),
(2884, 167, 'Cordillera', '', '', 1),
(2885, 167, 'Guairá', '', '', 1),
(2886, 167, 'Caaguazú', '', '', 1),
(2887, 167, 'Caazapá', '', '', 1),
(2888, 167, 'Itapúa', '', '', 1),
(2889, 167, 'Misiones', '', '', 1),
(2890, 167, 'Paraguarí', '', '', 1),
(2891, 167, 'Alto Paraná', '', '', 1),
(2892, 167, 'Central', '', '', 1),
(2893, 167, 'Ñeembucú', '', '', 1),
(2894, 167, 'Amambay', '', '', 1),
(2895, 167, 'Canindeyú', '', '', 1),
(2896, 167, 'Presidente Hayes', '', '', 1),
(2897, 167, 'Alto Paraguay', '', '', 1),
(2898, 167, 'Boquerón', '', '', 1),
(2899, 167, 'Asunción', '', '', 1),
(2900, 168, 'Ancash', '', '', 1),
(2901, 168, 'Apurímac', '', '', 1),
(2902, 168, 'Arequipa', '', '', 1),
(2903, 168, 'Ayacucho', '', '', 1),
(2904, 168, 'Cajamarca', '', '', 1),
(2905, 168, 'Callao', '', '', 1),
(2906, 168, 'Cuzco', '', '', 1),
(2907, 168, 'Huánuco', '', '', 1),
(2908, 168, 'Huancavelica', '', '', 1),
(2909, 168, 'Ica', '', '', 1),
(2910, 168, 'Junín', '', '', 1),
(2911, 168, 'La Libertad', '', '', 1),
(2912, 168, 'Lambayeque', '', '', 1),
(2913, 168, 'Lima', '', '', 1),
(2914, 168, 'Loreto', '', '', 1),
(2915, 168, 'Madre de Dios', '', '', 1),
(2916, 168, 'Moquegua', '', '', 1),
(2917, 168, 'Pasco', '', '', 1),
(2918, 168, 'Piura', '', '', 1),
(2919, 168, 'Puno', '', '', 1),
(2920, 168, 'San Martín', '', '', 1),
(2921, 168, 'Tacna', '', '', 1),
(2922, 168, 'Tumbes', '', '', 1),
(2923, 168, 'Ucayali', '', '', 1),
(2924, 169, 'Lanao del Sur', '', '', 1),
(2925, 169, 'Mindoro Occidental', '', '', 1),
(2926, 169, 'Mindoro Oriental', '', '', 1),
(2927, 169, 'Mountain Province', '', '', 1),
(2928, 169, 'Zamboanga Sibugay', '', '', 1),
(2929, 171, 'Dolnośląskie', '', '', 1),
(2930, 171, 'Kujawsko-Pomorskie', '', '', 1),
(2931, 171, 'Lubelskie', '', '', 1),
(2932, 171, 'Lubuskie', '', '', 1),
(2933, 171, 'Łódzkie', '', '', 1),
(2934, 171, 'Małopolskie', '', '', 1),
(2935, 171, 'Mazowieckie', '', '', 1),
(2936, 171, 'Opolskie', '', '', 1),
(2937, 171, 'Podkarpackie', '', '', 1),
(2938, 171, 'Podlaskie', '', '', 1),
(2939, 171, 'Pomorskie', '', '', 1),
(2940, 171, 'Śląskie', '', '', 1),
(2941, 171, 'Świętokrzyskie', '', '', 1),
(2942, 171, 'Warmińsko-Mazurskie', '', '', 1),
(2943, 171, 'Wielkopolskie', '', '', 1),
(2944, 171, 'Zachodniopomorskie', '', '', 1),
(2945, 172, 'Aveiro', '', '', 1),
(2946, 172, 'Beja', '', '', 1),
(2947, 172, 'Braga', '', '', 1),
(2948, 172, 'Bragança', '', '', 1),
(2949, 172, 'Castelo Branco', '', '', 1),
(2950, 172, 'Coimbra', '', '', 1),
(2951, 172, 'Évora', '', '', 1),
(2952, 172, 'Faro', '', '', 1),
(2953, 172, 'Guarda', '', '', 1),
(2954, 172, 'Leiria', '', '', 1),
(2955, 172, 'Lisboa', '', '', 1),
(2956, 172, 'Portalegre', '', '', 1),
(2957, 172, 'Porto', '', '', 1),
(2958, 172, 'Santarém', '', '', 1),
(2959, 172, 'Setúbal', '', '', 1),
(2960, 172, 'Viana do Castelo', '', '', 1),
(2961, 172, 'Vila Real', '', '', 1),
(2962, 172, 'Viseu', '', '', 1),
(2963, 172, 'Região Autónoma dos Açores', '', '', 1),
(2964, 172, 'Região Autónoma da Madeira', '', '', 1),
(2965, 174, 'الدوحة', '', '', 1),
(2966, 174, 'الغويرية', '', '', 1),
(2967, 174, 'جريان الباطنة', '', '', 1),
(2968, 174, 'الجميلية', '', '', 1),
(2969, 174, 'الخور', '', '', 1),
(2970, 174, 'مسيعيد', '', '', 1),
(2971, 174, 'الشمال', '', '', 1),
(2972, 174, 'الريان', '', '', 1),
(2973, 174, 'أم صلال', '', '', 1),
(2974, 174, 'الوكرة', '', '', 1),
(2975, 176, 'Caraş-Severin', '', '', 1),
(2976, 176, 'Harghita', '', '', 1),
(2977, 177, 'Адыгея Республика', '', '', 1),
(2978, 177, 'Агинский-Бурятский автономный округ', '', '', 1),
(2979, 177, 'Алтай Республика', '', '', 1),
(2980, 177, 'Алтайский край', '', '', 1),
(2981, 177, 'Амурская область', '', '', 1),
(2982, 177, 'Архангельская область', '', '', 1),
(2983, 177, 'Астраханская область', '', '', 1),
(2984, 177, 'Башкортостан Республика', '', '', 1),
(2985, 177, 'Белгородская область', '', '', 1),
(2986, 177, 'Брянская область', '', '', 1),
(2987, 177, 'Бурятия Республика', '', '', 1),
(2988, 177, 'Чеченская Республика', '', '', 1),
(2989, 177, 'Челябинская область', '', '', 1),
(2990, 177, 'Читинская область', '', '', 1),
(2991, 177, 'Чукотский автономный округ', '', '', 1),
(2992, 177, 'Чувашская Республика', '', '', 1),
(2993, 177, 'Дагестан Республика', '', '', 1),
(2994, 177, 'Эвенкийский автономный округ', '', '', 1),
(2995, 177, 'Ингушетия Республика', '', '', 1),
(2996, 177, 'Иркутская область', '', '', 1),
(2997, 177, 'Ивановская область', '', '', 1),
(2998, 177, 'Камчатская область', '', '', 1),
(2999, 177, 'Кабардино-Балкарская Республика', '', '', 1),
(3000, 177, 'Карачаево-Черкесская Республика', '', '', 1),
(3001, 177, 'Краснодарский край', '', '', 1),
(3002, 177, 'Кемеровская область', '', '', 1),
(3003, 177, 'Калининградская область', '', '', 1),
(3004, 177, 'Курганская область', '', '', 1),
(3005, 177, 'Хабаровский край', '', '', 1),
(3006, 177, 'Ханты-Мансийский автономный округ—Югра', '', '', 1),
(3007, 177, 'Красноярский край', '', '', 1),
(3008, 177, 'Кировская область', '', '', 1),
(3009, 177, 'Хакасия', '', '', 1),
(3010, 177, 'Калмыкия Республика', '', '', 1),
(3011, 177, 'Калужская область', '', '', 1),
(3012, 177, 'Коми Республика', '', '', 1),
(3013, 177, 'Корякский автономный округ', '', '', 1),
(3014, 177, 'Костромская область', '', '', 1),
(3015, 177, 'Карелия Республика', '', '', 1),
(3016, 177, 'Курская область', '', '', 1),
(3017, 177, 'Ленинградская область', '', '', 1),
(3018, 177, 'Липецкая область', '', '', 1),
(3019, 177, 'Магаданская область', '', '', 1),
(3020, 177, 'Марий Эл Республика', '', '', 1),
(3021, 177, 'Мордовия Республика', '', '', 1),
(3022, 177, 'Московская область', '', '', 1),
(3023, 177, 'Москва', '', '', 1),
(3024, 177, 'Мурманская область', '', '', 1),
(3025, 177, 'Ненецкий автономный округ', '', '', 1),
(3026, 177, 'Новгородская область', '', '', 1),
(3027, 177, 'Нижегородская область', '', '', 1),
(3028, 177, 'Новосибирская область', '', '', 1),
(3029, 177, 'Омская область', '', '', 1),
(3030, 177, 'Оренбургская область', '', '', 1),
(3031, 177, 'Орловская область', '', '', 1),
(3032, 177, 'Пензенская область', '', '', 1),
(3033, 177, 'Приморский край', '', '', 1),
(3034, 177, 'Псковская область', '', '', 1),
(3035, 177, 'Ростовская область', '', '', 1),
(3036, 177, 'Рязанская область', '', '', 1),
(3037, 177, 'Саха (Якутия) Республика', '', '', 1),
(3038, 177, 'Сахалинская область', '', '', 1),
(3039, 177, 'Самарская область', '', '', 1),
(3040, 177, 'Саратовская область', '', '', 1),
(3041, 177, 'Северная Осетия–Алания Республика', '', '', 1),
(3042, 177, 'Смоленская область', '', '', 1),
(3043, 177, 'Санкт-Петербург', '', '', 1),
(3044, 177, 'Ставропольский край', '', '', 1),
(3045, 177, 'Свердловская область', '', '', 1),
(3046, 177, 'Республика Татарстан', '', '', 1),
(3047, 177, 'Тамбовская область', '', '', 1),
(3048, 177, 'Таймырский автономный округ', '', '', 1),
(3049, 177, 'Томская область', '', '', 1),
(3050, 177, 'Тульская область', '', '', 1),
(3051, 177, 'Тверская область', '', '', 1),
(3052, 177, 'Тыва Республика', '', '', 1),
(3053, 177, 'Тюменская область', '', '', 1),
(3054, 177, 'Удмуртская Республика', '', '', 1),
(3055, 177, 'Ульяновская область', '', '', 1),
(3056, 177, 'Усть-Ордынский Бурятский автономный округ', '', '', 1),
(3057, 177, 'Волгоградская область', '', '', 1),
(3058, 177, 'Владимирская область', '', '', 1),
(3059, 177, 'Вологодская область', '', '', 1),
(3060, 177, 'Воронежская область', '', '', 1),
(3061, 177, 'Пермский край', '', '', 1),
(3062, 177, 'Ямало-Ненецкий автономный округ', '', '', 1),
(3063, 177, 'Ярославская область', '', '', 1),
(3064, 177, 'Еврейская автономная область', '', '', 1),
(3065, 178, 'Nord', '', '', 1),
(3066, 178, 'Est', '', '', 1),
(3067, 178, 'Sud', '', '', 1),
(3068, 178, 'Ouest', '', '', 1),
(3069, 178, 'Kigali', '', '', 1),
(3070, 179, 'Saint Kitts', '', '', 1),
(3071, 179, 'Nevis', '', '', 1),
(3072, 180, 'Anse-la-Raye', '', '', 1),
(3073, 180, 'Castries', '', '', 1),
(3074, 180, 'Choiseul', '', '', 1),
(3075, 180, 'Dauphin', '', '', 1),
(3076, 180, 'Dennery', '', '', 1),
(3077, 180, 'Gros-Islet', '', '', 1),
(3078, 180, 'Laborie', '', '', 1),
(3079, 180, 'Micoud', '', '', 1),
(3080, 180, 'Praslin', '', '', 1),
(3081, 180, 'Soufriere', '', '', 1),
(3082, 180, 'Vieux-Fort', '', '', 1),
(3083, 181, 'Charlotte', '', '', 1),
(3084, 181, 'Grenadines', '', '', 1),
(3085, 182, 'A\'ana', '', '', 1),
(3086, 182, 'Aiga-i-le-Tai', '', '', 1),
(3087, 182, 'Atua', '', '', 1),
(3088, 182, 'Fa\'asaleleaga', '', '', 1),
(3089, 182, 'Gaga\'emauga', '', '', 1),
(3090, 182, 'Gaga\'ifomauga', '', '', 1),
(3091, 182, 'Palauli', '', '', 1),
(3092, 182, 'Satupa\'itea', '', '', 1),
(3093, 182, 'Tuamasaga', '', '', 1),
(3094, 182, 'Va\'a-o-Fonoti', '', '', 1),
(3095, 182, 'Vaisigano', '', '', 1),
(3096, 183, 'Acquaviva', '', '', 1),
(3097, 183, 'Borgo Maggiore', '', '', 1),
(3098, 183, 'Chiesanuova', '', '', 1),
(3099, 183, 'Domagnano', '', '', 1),
(3100, 183, 'Faetano', '', '', 1),
(3101, 183, 'Fiorentino', '', '', 1),
(3102, 183, 'Montegiardino', '', '', 1),
(3103, 183, 'Citta di San Marino', '', '', 1),
(3104, 183, 'Serravalle', '', '', 1),
(3105, 184, 'Príncipe', '', '', 1),
(3106, 184, 'São Tomé', '', '', 1),
(3107, 185, 'الرياض', '', '', 1),
(3108, 185, 'مكة المكرمة', '', '', 1),
(3109, 185, 'المدينه', '', '', 1),
(3110, 185, 'الشرقية', '', '', 1),
(3111, 185, 'القصيم', '', '', 1),
(3112, 185, 'حائل', '', '', 1),
(3113, 185, 'تبوك', '', '', 1),
(3114, 185, 'الحدود الشمالية', '', '', 1),
(3115, 185, 'جيزان', '', '', 1),
(3116, 185, 'نجران', '', '', 1),
(3117, 185, 'الباحة', '', '', 1),
(3118, 185, 'الجوف', '', '', 1),
(3119, 185, 'عسير', '', '', 1),
(3120, 186, 'Dakar', '', '', 1),
(3121, 186, 'Diourbel', '', '', 1),
(3122, 186, 'Fatick', '', '', 1),
(3123, 186, 'Kaolack', '', '', 1),
(3124, 186, 'Kolda', '', '', 1),
(3125, 186, 'Louga', '', '', 1),
(3126, 186, 'Matam', '', '', 1),
(3127, 186, 'Saint-Louis', '', '', 1),
(3128, 186, 'Tambacounda', '', '', 1),
(3129, 186, 'Thies ', '', '', 1),
(3130, 186, 'Ziguinchor', '', '', 1),
(3131, 187, 'Anse aux Pins', '', '', 1),
(3132, 187, 'Anse Boileau', '', '', 1),
(3133, 187, 'Anse Etoile', '', '', 1),
(3134, 187, 'Anse Louis', '', '', 1),
(3135, 187, 'Anse Royale', '', '', 1),
(3136, 187, 'Baie Lazare', '', '', 1),
(3137, 187, 'Baie Sainte Anne', '', '', 1),
(3138, 187, 'Beau Vallon', '', '', 1),
(3139, 187, 'Bel Air', '', '', 1),
(3140, 187, 'Bel Ombre', '', '', 1),
(3141, 187, 'Cascade', '', '', 1),
(3142, 187, 'Glacis', '', '', 1),
(3143, 187, 'Grand\' Anse (on Mahe)', '', '', 1),
(3144, 187, 'Grand\' Anse (on Praslin)', '', '', 1),
(3145, 187, 'La Digue', '', '', 1),
(3146, 187, 'La Riviere Anglaise', '', '', 1),
(3147, 187, 'Mont Buxton', '', '', 1),
(3148, 187, 'Mont Fleuri', '', '', 1),
(3149, 187, 'Plaisance', '', '', 1),
(3150, 187, 'Pointe La Rue', '', '', 1),
(3151, 187, 'Port Glaud', '', '', 1),
(3152, 187, 'Saint Louis', '', '', 1),
(3153, 187, 'Takamaka', '', '', 1),
(3154, 188, 'Eastern', '', '', 1),
(3155, 190, 'Banskobystrický kraj', '', '', 1),
(3156, 190, 'Bratislavský kraj', '', '', 1),
(3157, 190, 'Košický kraj', '', '', 1),
(3158, 190, 'Nitrianský kraj', '', '', 1),
(3159, 190, 'Prešovský kraj', '', '', 1),
(3160, 190, 'Trnavský kraj', '', '', 1),
(3161, 190, 'Trenčianský kraj', '', '', 1),
(3162, 190, 'Žilinský kraj', '', '', 1),
(3163, 191, 'Ajdovščina', '', '', 1),
(3164, 191, 'Beltinci', '', '', 1),
(3165, 191, 'Bled', '', '', 1),
(3166, 191, 'Bohinj', '', '', 1),
(3167, 191, 'Borovnica', '', '', 1),
(3168, 191, 'Bovec', '', '', 1),
(3169, 191, 'Brda', '', '', 1),
(3170, 191, 'Brezovica', '', '', 1),
(3171, 191, 'Brežice', '', '', 1),
(3172, 191, 'Tišina', '', '', 1),
(3173, 191, 'Celje', '', '', 1),
(3174, 191, 'Cerklje na Gorenjskem', '', '', 1),
(3175, 191, 'Cerknica', '', '', 1),
(3176, 191, 'Cerkno', '', '', 1),
(3177, 191, 'Črenšovci', '', '', 1),
(3178, 191, 'Črna na Koroškem', '', '', 1),
(3179, 191, 'Črnomelj', '', '', 1),
(3180, 191, 'Destrnik', '', '', 1),
(3181, 191, 'Divača', '', '', 1),
(3182, 191, 'Dobrepolje', '', '', 1),
(3183, 191, 'Dobrova-Polhov Gradec', '', '', 1),
(3184, 191, 'Dol pri Ljubljani', '', '', 1),
(3185, 191, 'Domžale', '', '', 1),
(3186, 191, 'Dornava', '', '', 1),
(3187, 191, 'Dravograd', '', '', 1),
(3188, 191, 'Duplek', '', '', 1),
(3189, 191, 'Gorenja vas-Poljane', '', '', 1),
(3190, 191, 'Gorišnica', '', '', 1),
(3191, 191, 'Gornja Radgona', '', '', 1),
(3192, 191, 'Gornji Grad', '', '', 1),
(3193, 191, 'Gornji Petrovci', '', '', 1),
(3194, 191, 'Grosuplje', '', '', 1),
(3195, 191, 'Šalovci', '', '', 1),
(3196, 191, 'Hrastnik', '', '', 1),
(3197, 191, 'Hrpelje-Kozina', '', '', 1),
(3198, 191, 'Idrija', '', '', 1),
(3199, 191, 'Ig', '', '', 1),
(3200, 191, 'Ilirska Bistrica', '', '', 1),
(3201, 191, 'Ivančna Gorica', '', '', 1),
(3202, 191, 'Izola', '', '', 1),
(3203, 191, 'Jesenice', '', '', 1),
(3204, 191, 'Juršinci', '', '', 1),
(3205, 191, 'Kamnik', '', '', 1),
(3206, 191, 'Kanal ob Soči', '', '', 1),
(3207, 191, 'Kidričevo', '', '', 1),
(3208, 191, 'Kobarid', '', '', 1),
(3209, 191, 'Kobilje', '', '', 1),
(3210, 191, 'Kočevje', '', '', 1),
(3211, 191, 'Komen', '', '', 1),
(3212, 191, 'Koper', '', '', 1),
(3213, 191, 'Kozje', '', '', 1),
(3214, 191, 'Kranj', '', '', 1),
(3215, 191, 'Kranjska Gora', '', '', 1),
(3216, 191, 'Krško', '', '', 1),
(3217, 191, 'Kungota', '', '', 1),
(3218, 191, 'Kuzma', '', '', 1),
(3219, 191, 'Laško', '', '', 1),
(3220, 191, 'Lenart', '', '', 1),
(3221, 191, 'Lendava', '', '', 1),
(3222, 191, 'Litija', '', '', 1),
(3223, 191, 'Ljubljana', '', '', 1),
(3224, 191, 'Ljubno', '', '', 1),
(3225, 191, 'Ljutomer', '', '', 1),
(3226, 191, 'Logatec', '', '', 1),
(3227, 191, 'Loška Dolina', '', '', 1),
(3228, 191, 'Loški Potok', '', '', 1),
(3229, 191, 'Luče', '', '', 1),
(3230, 191, 'Lukovica', '', '', 1),
(3231, 191, 'Majšperk', '', '', 1),
(3232, 191, 'Maribor', '', '', 1),
(3233, 191, 'Medvode', '', '', 1),
(3234, 191, 'Mengeš', '', '', 1),
(3235, 191, 'Metlika', '', '', 1),
(3236, 191, 'Mežica', '', '', 1),
(3237, 191, 'Miren-Kostanjevica', '', '', 1),
(3238, 191, 'Mislinja', '', '', 1),
(3239, 191, 'Moravče', '', '', 1),
(3240, 191, 'Moravske Toplice', '', '', 1),
(3241, 191, 'Mozirje', '', '', 1),
(3242, 191, 'Murska Sobota', '', '', 1),
(3243, 191, 'Muta', '', '', 1),
(3244, 191, 'Naklo', '', '', 1),
(3245, 191, 'Nazarje', '', '', 1),
(3246, 191, 'Nova Gorica', '', '', 1),
(3247, 191, 'Novo mesto', '', '', 1),
(3248, 191, 'Odranci', '', '', 1),
(3249, 191, 'Ormož', '', '', 1),
(3250, 191, 'Osilnica', '', '', 1),
(3251, 191, 'Pesnica', '', '', 1),
(3252, 191, 'Piran', '', '', 1),
(3253, 191, 'Pivka', '', '', 1),
(3254, 191, 'Podčetrtek', '', '', 1),
(3255, 191, 'Podvelka', '', '', 1),
(3256, 191, 'Postojna', '', '', 1),
(3257, 191, 'Preddvor', '', '', 1),
(3258, 191, 'Ptuj', '', '', 1),
(3259, 191, 'Puconci', '', '', 1),
(3260, 191, 'Rače-Fram', '', '', 1),
(3261, 191, 'Radeče', '', '', 1),
(3262, 191, 'Radenci', '', '', 1),
(3263, 191, 'Radlje ob Dravi', '', '', 1),
(3264, 191, 'Radovljica', '', '', 1),
(3265, 191, 'Ravne na Koroškem', '', '', 1),
(3266, 191, 'Ribnica', '', '', 1),
(3267, 191, 'Rogaška Slatina', '', '', 1),
(3268, 191, 'Rogašovci', '', '', 1),
(3269, 191, 'Rogatec', '', '', 1),
(3270, 191, 'Ruše', '', '', 1),
(3271, 191, 'Semič', '', '', 1),
(3272, 191, 'Sevnica', '', '', 1),
(3273, 191, 'Sežana', '', '', 1),
(3274, 191, 'Slovenj Gradec', '', '', 1),
(3275, 191, 'Slovenska Bistrica', '', '', 1),
(3276, 191, 'Slovenske Konjice', '', '', 1),
(3277, 191, 'Starše', '', '', 1),
(3278, 191, 'Sveti Jurij', '', '', 1),
(3279, 191, 'Šenčur', '', '', 1),
(3280, 191, 'Šentilj', '', '', 1),
(3281, 191, 'Šentjernej', '', '', 1),
(3282, 191, 'Šentjur pri Celju', '', '', 1),
(3283, 191, 'Škocjan', '', '', 1),
(3284, 191, 'Škofja Loka', '', '', 1),
(3285, 191, 'Škofljica', '', '', 1),
(3286, 191, 'Šmarje pri Jelšah', '', '', 1),
(3287, 191, 'Šmartno ob Paki', '', '', 1),
(3288, 191, 'Šoštanj', '', '', 1),
(3289, 191, 'Štore', '', '', 1),
(3290, 191, 'Tolmin', '', '', 1),
(3291, 191, 'Trbovlje', '', '', 1),
(3292, 191, 'Trebnje', '', '', 1),
(3293, 191, 'Tržič', '', '', 1),
(3294, 191, 'Turnišče', '', '', 1),
(3295, 191, 'Velenje', '', '', 1),
(3296, 191, 'Velike Lašče', '', '', 1),
(3297, 191, 'Videm', '', '', 1),
(3298, 191, 'Vipava', '', '', 1),
(3299, 191, 'Vitanje', '', '', 1),
(3300, 191, 'Vodice', '', '', 1),
(3301, 191, 'Vojnik', '', '', 1),
(3302, 191, 'Vrhnika', '', '', 1),
(3303, 191, 'Vuzenica', '', '', 1),
(3304, 191, 'Zagorje ob Savi', '', '', 1),
(3305, 191, 'Zavrč', '', '', 1),
(3306, 191, 'Zreče', '', '', 1),
(3307, 191, 'Železniki', '', '', 1),
(3308, 191, 'Žiri', '', '', 1),
(3309, 191, 'Benedikt', '', '', 1),
(3310, 191, 'Bistrica ob Sotli', '', '', 1),
(3311, 191, 'Bloke', '', '', 1),
(3312, 191, 'Braslovče', '', '', 1),
(3313, 191, 'Cankova', '', '', 1),
(3314, 191, 'Cerkvenjak', '', '', 1),
(3315, 191, 'Dobje', '', '', 1),
(3316, 191, 'Dobrna', '', '', 1),
(3317, 191, 'Dobrovnik', '', '', 1),
(3318, 191, 'Dolenjske Toplice', '', '', 1),
(3319, 191, 'Grad', '', '', 1),
(3320, 191, 'Hajdina', '', '', 1),
(3321, 191, 'Hoče-Slivnica', '', '', 1),
(3322, 191, 'Hodoš', '', '', 1),
(3323, 191, 'Horjul', '', '', 1),
(3324, 191, 'Jezersko', '', '', 1),
(3325, 191, 'Komenda', '', '', 1),
(3326, 191, 'Kostel', '', '', 1),
(3327, 191, 'Križevci', '', '', 1),
(3328, 191, 'Lovrenc na Pohorju', '', '', 1),
(3329, 191, 'Markovci', '', '', 1),
(3330, 191, 'Miklavž na Dravskem polju', '', '', 1),
(3331, 191, 'Mirna Peč', '', '', 1),
(3332, 191, 'Oplotnica', '', '', 1),
(3333, 191, 'Podlehnik', '', '', 1),
(3334, 191, 'Polzela', '', '', 1),
(3335, 191, 'Prebold', '', '', 1),
(3336, 191, 'Prevalje', '', '', 1),
(3337, 191, 'Razkrižje', '', '', 1),
(3338, 191, 'Ribnica na Pohorju', '', '', 1),
(3339, 191, 'Selnica ob Dravi', '', '', 1),
(3340, 191, 'Sodražica', '', '', 1),
(3341, 191, 'Solčava', '', '', 1),
(3342, 191, 'Sveta Ana', '', '', 1),
(3343, 191, 'Sveti Andraž v Slovenskih goricah', '', '', 1),
(3344, 191, 'Šempeter-Vrtojba', '', '', 1),
(3345, 191, 'Tabor', '', '', 1),
(3346, 191, 'Trnovska vas', '', '', 1),
(3347, 191, 'Trzin', '', '', 1),
(3348, 191, 'Velika Polana', '', '', 1),
(3349, 191, 'Veržej', '', '', 1),
(3350, 191, 'Vransko', '', '', 1),
(3351, 191, 'Žalec', '', '', 1),
(3352, 191, 'Žetale', '', '', 1),
(3353, 191, 'Žirovnica', '', '', 1),
(3354, 191, 'Žužemberk', '', '', 1),
(3355, 191, 'Šmartno pri Litiji', '', '', 1),
(3356, 192, 'Guadalcanal', '', '', 1),
(3357, 192, 'Honiara', '', '', 1),
(3358, 192, 'Isabel', '', '', 1),
(3359, 192, 'Makira', '', '', 1),
(3360, 192, 'Malaita', '', '', 1),
(3361, 192, 'Rennell and Bellona', '', '', 1),
(3362, 192, 'Temotu', '', '', 1),
(3363, 193, 'Awdal', '', '', 1),
(3364, 193, 'Bakool', '', '', 1),
(3365, 193, 'Banaadir', '', '', 1),
(3366, 193, 'Bari', '', '', 1),
(3367, 193, 'Bay', '', '', 1),
(3368, 193, 'Gedo', '', '', 1),
(3369, 193, 'Galguduud', '', '', 1),
(3370, 193, 'Hiiraan', '', '', 1),
(3371, 193, 'Jubbada Dhexe', '', '', 1),
(3372, 193, 'Jubbada Hoose', '', '', 1),
(3373, 193, 'Mudug', '', '', 1),
(3374, 193, 'Nugaal', '', '', 1),
(3375, 193, 'Shabeellaha Dhexe', '', '', 1),
(3376, 193, 'Sanaag', '', '', 1),
(3377, 193, 'Shabeellaha Hoose', '', '', 1),
(3378, 193, 'Sool', '', '', 1),
(3379, 193, 'Togdheer', '', '', 1),
(3380, 193, 'Woqooyi Galbeed', '', '', 1),
(3381, 194, 'Eastern Cape', '', '', 1),
(3382, 194, 'Free State', '', '', 1),
(3383, 194, 'Gauteng', '', '', 1),
(3384, 194, 'Limpopo', '', '', 1),
(3385, 194, 'Mpumalanga', '', '', 1),
(3386, 194, 'Northern Cape', '', '', 1),
(3387, 194, 'KwaZulu-Natal', '', '', 1),
(3388, 194, 'Western Cape', '', '', 1),
(3389, 194, 'North West', '', '', 1),
(3391, 196, 'Islas Baleares', '', '', 1),
(3392, 197, 'North Central', '', '', 1),
(3393, 197, 'North', '', '', 1),
(3394, 197, 'North Western', '', '', 1),
(3395, 197, 'Uva', '', '', 1),
(3396, 197, 'Sabaragamuwa', '', '', 1),
(3397, 200, 'أعالي النيل', '', '', 1),
(3398, 200, 'البحر الأحمر', '', '', 1),
(3399, 200, 'البحيرات', '', '', 1),
(3400, 200, 'ولاية الجزيرة', '', '', 1),
(3401, 200, 'الخرطوم', '', '', 1),
(3402, 200, 'القضارف', '', '', 1),
(3403, 200, 'الوحدة', '', '', 1),
(3404, 200, 'النيل الأبيض', '', '', 1),
(3405, 200, 'النيل الأزرق', '', '', 1),
(3406, 200, 'الشمالية', '', '', 1),
(3407, 200, 'الاستوائية الوسطى', '', '', 1),
(3408, 200, 'غرب الاستوائية', '', '', 1),
(3409, 200, 'غرب بحر الغزال', '', '', 1),
(3410, 200, 'غرب دارفور', '', '', 1),
(3411, 200, 'غرب كردفان', '', '', 1),
(3412, 200, 'جنوب دارفور', '', '', 1),
(3413, 200, 'جنوب كردفان', '', '', 1),
(3414, 200, 'جونقلي', '', '', 1),
(3415, 200, 'كسلا', '', '', 1),
(3416, 200, 'ولاية نهر النيل', '', '', 1),
(3417, 200, 'شمال بحر الغزال', '', '', 1),
(3418, 200, 'شمال دارفور', '', '', 1),
(3419, 200, 'شمال كردفان', '', '', 1),
(3420, 200, 'شرق الاستوائية', '', '', 1),
(3421, 200, 'سنار', '', '', 1),
(3422, 200, 'واراب', '', '', 1),
(3423, 201, 'Brokopondo', '', '', 1),
(3424, 201, 'Commewijne', '', '', 1),
(3425, 201, 'Coronie', '', '', 1),
(3426, 201, 'Marowijne', '', '', 1),
(3427, 201, 'Nickerie', '', '', 1),
(3428, 201, 'Paramaribo', '', '', 1),
(3429, 201, 'Para', '', '', 1),
(3430, 201, 'Saramacca', '', '', 1),
(3431, 201, 'Sipaliwini', '', '', 1),
(3432, 201, 'Wanica', '', '', 1),
(3433, 203, 'Hhohho', '', '', 1),
(3434, 203, 'Lubombo', '', '', 1),
(3435, 203, 'Manzini', '', '', 1),
(3436, 203, 'Shiselweni', '', '', 1),
(3437, 204, 'Stockholms län', '', '', 1),
(3438, 204, 'Uppsala län', '', '', 1),
(3439, 204, 'Södermanlands län', '', '', 1),
(3440, 204, 'Östergötlands län', '', '', 1),
(3441, 204, 'Jönköpings län', '', '', 1),
(3442, 204, 'Kronobergs län', '', '', 1),
(3443, 204, 'Kalmar län', '', '', 1),
(3444, 204, 'Gotlands län', '', '', 1),
(3445, 204, 'Blekinge län', '', '', 1),
(3446, 204, 'Skåne län', '', '', 1),
(3447, 204, 'Hallands län', '', '', 1),
(3448, 204, 'Västra Götalands län', '', '', 1),
(3449, 204, 'Värmlands län;', '', '', 1),
(3450, 204, 'Örebro län', '', '', 1),
(3451, 204, 'Västmanlands län;', '', '', 1),
(3452, 204, 'Dalarnas län', '', '', 1),
(3453, 204, 'Gävleborgs län', '', '', 1),
(3454, 204, 'Västernorrlands län', '', '', 1),
(3455, 204, 'Jämtlands län', '', '', 1),
(3456, 204, 'Västerbottens län', '', '', 1),
(3457, 204, 'Norrbottens län', '', '', 1),
(3458, 205, 'Zürich', '', '', 1),
(3459, 205, 'Bern', '', '', 1),
(3460, 205, 'Luzern', '', '', 1),
(3461, 205, 'Uri', '', '', 1),
(3462, 205, 'Schwyz', '', '', 1),
(3463, 205, 'Obwalden', '', '', 1),
(3464, 205, 'Nidwalden', '', '', 1),
(3465, 205, 'Glarus', '', '', 1),
(3466, 205, 'Zug', '', '', 1),
(3467, 205, 'Fribourg', '', '', 1),
(3468, 205, 'Solothurn', '', '', 1),
(3469, 205, 'Basel-Stadt', '', '', 1),
(3470, 205, 'Basel-Landschaft', '', '', 1),
(3471, 205, 'Schaffhausen', '', '', 1),
(3472, 205, 'Appenzell Ausserrhoden', '', '', 1),
(3473, 205, 'Appenzell Innerrhoden', '', '', 1),
(3474, 205, 'St. Gallen', '', '', 1),
(3475, 205, 'Graubünden', '', '', 1),
(3476, 205, 'Aargau', '', '', 1),
(3477, 205, 'Thurgau', '', '', 1),
(3478, 205, 'Ticino', '', '', 1),
(3479, 205, 'Vaud', '', '', 1),
(3480, 205, 'Valais', '', '', 1),
(3481, 205, 'Neuchâtel', '', '', 1),
(3482, 205, 'Genève', '', '', 1),
(3483, 205, 'Jura', '', '', 1),
(3484, 206, 'دمشق', '', '', 1),
(3485, 206, 'درعا', '', '', 1),
(3486, 206, 'دير الزور', '', '', 1),
(3487, 206, 'الحسكة', '', '', 1),
(3488, 206, 'حمص', '', '', 1),
(3489, 206, 'حلب', '', '', 1),
(3490, 206, 'حماه', '', '', 1),
(3491, 206, 'ادلب', '', '', 1),
(3492, 206, 'اللاذقية', '', '', 1),
(3493, 206, 'القنيطرة', '', '', 1),
(3494, 206, 'الرقة', '', '', 1),
(3495, 206, 'ریف دمشق', '', '', 1),
(3496, 206, 'السويداء', '', '', 1),
(3497, 206, 'طرطوس', '', '', 1),
(3498, 207, 'Changhua County', '', '', 1),
(3499, 207, 'Chiayi City', '', '', 1),
(3500, 207, 'Chiayi County', '', '', 1),
(3501, 207, 'Hsinchu County', '', '', 1),
(3502, 207, 'Hsinchu City', '', '', 1),
(3503, 207, 'Hualien County', '', '', 1),
(3504, 207, 'Yilan County', '', '', 1),
(3505, 207, 'Keelung City', '', '', 1),
(3506, 207, 'Kaohsiung City', '', '', 1),
(3507, 207, 'Jinmen County', '', '', 1),
(3508, 207, 'Miaoli County', '', '', 1),
(3509, 207, 'Nantou County', '', '', 1),
(3510, 207, 'Penghu County', '', '', 1),
(3511, 207, 'Pingtung County', '', '', 1),
(3512, 207, 'Taoyuan County', '', '', 1),
(3513, 207, 'Tainan City', '', '', 1),
(3514, 207, 'Lianjiang County', '', '', 1),
(3515, 207, 'Taipei City', '', '', 1),
(3516, 207, 'New Taipei City', '', '', 1),
(3517, 207, 'Taitung County', '', '', 1),
(3518, 207, 'Taichung City', '', '', 1),
(3519, 207, 'Yunlin County', '', '', 1),
(3520, 208, 'کوهستان بدخشان', '', '', 1),
(3521, 208, 'ختلان', '', '', 1),
(3522, 208, 'سغد', '', '', 1),
(3523, 209, 'Arusha', '', '', 1),
(3524, 209, 'Dar es Salaam', '', '', 1),
(3525, 209, 'Dodoma', '', '', 1),
(3526, 209, 'Iringa', '', '', 1),
(3527, 209, 'Kagera', '', '', 1),
(3528, 209, 'Pemba Sever', '', '', 1),
(3529, 209, 'Zanzibar Sever', '', '', 1),
(3530, 209, 'Kigoma', '', '', 1),
(3531, 209, 'Kilimanjaro', '', '', 1),
(3532, 209, 'Pemba Jih', '', '', 1),
(3533, 209, 'Zanzibar Jih', '', '', 1),
(3534, 209, 'Lindi', '', '', 1),
(3535, 209, 'Mara', '', '', 1),
(3536, 209, 'Mbeya', '', '', 1),
(3537, 209, 'Zanzibar Západ', '', '', 1),
(3538, 209, 'Morogoro', '', '', 1),
(3539, 209, 'Mtwara', '', '', 1),
(3540, 209, 'Mwanza', '', '', 1),
(3541, 209, 'Pwani', '', '', 1),
(3542, 209, 'Rukwa', '', '', 1),
(3543, 209, 'Ruvuma', '', '', 1),
(3544, 209, 'Shinyanga', '', '', 1),
(3545, 209, 'Singida', '', '', 1),
(3546, 209, 'Tabora', '', '', 1),
(3547, 209, 'Tanga', '', '', 1),
(3548, 209, 'Manyara', '', '', 1),
(3549, 210, 'กรุงเทพมหานคร', '', '', 1),
(3550, 210, 'สมุทรปราการ', '', '', 1),
(3551, 210, 'นนทบุรี', '', '', 1),
(3552, 210, 'ปทุมธานี', '', '', 1),
(3553, 210, 'พระนครศรีอยุธยา', '', '', 1),
(3554, 210, 'อ่างทอง', '', '', 1),
(3555, 210, 'ลพบุรี', '', '', 1),
(3556, 210, 'สิงห์บุรี', '', '', 1),
(3557, 210, 'ชัยนาท', '', '', 1),
(3558, 210, 'สระบุรี', '', '', 1),
(3559, 210, 'ชลบุรี', '', '', 1),
(3560, 210, 'ระยอง', '', '', 1),
(3561, 210, 'จันทบุรี', '', '', 1),
(3562, 210, 'ตราด', '', '', 1),
(3563, 210, 'ฉะเชิงเทรา', '', '', 1),
(3564, 210, 'ปราจีนบุรี', '', '', 1),
(3565, 210, 'นครนายก', '', '', 1),
(3566, 210, 'สระแก้ว', '', '', 1),
(3567, 210, 'นครราชสีมา', '', '', 1),
(3568, 210, 'บุรีรัมย์', '', '', 1),
(3569, 210, 'สุรินทร์', '', '', 1),
(3570, 210, 'ศรีสะเกษ', '', '', 1),
(3571, 210, 'อุบลราชธานี', '', '', 1),
(3572, 210, 'ยโสธร', '', '', 1),
(3573, 210, 'ชัยภูมิ', '', '', 1),
(3574, 210, 'อำนาจเจริญ', '', '', 1),
(3575, 210, 'หนองบัวลำภู', '', '', 1),
(3576, 210, 'ขอนแก่น', '', '', 1),
(3577, 210, 'อุดรธานี', '', '', 1),
(3578, 210, 'เลย', '', '', 1),
(3579, 210, 'หนองคาย', '', '', 1),
(3580, 210, 'มหาสารคาม', '', '', 1),
(3581, 210, 'ร้อยเอ็ด', '', '', 1),
(3582, 210, 'กาฬสินธุ์', '', '', 1),
(3583, 210, 'สกลนคร', '', '', 1),
(3584, 210, 'นครพนม', '', '', 1),
(3585, 210, 'มุกดาหาร', '', '', 1),
(3586, 210, 'เชียงใหม่', '', '', 1),
(3587, 210, 'ลำพูน', '', '', 1),
(3588, 210, 'ลำปาง', '', '', 1),
(3589, 210, 'อุตรดิตถ์', '', '', 1),
(3590, 210, 'น่าน', '', '', 1),
(3591, 210, 'พะเยา', '', '', 1),
(3592, 210, 'เชียงราย', '', '', 1),
(3593, 210, 'แม่ฮ่องสอน', '', '', 1),
(3594, 210, 'นครสวรรค์', '', '', 1),
(3595, 210, 'อุทัยธานี', '', '', 1),
(3596, 210, 'กำแพงเพชร', '', '', 1),
(3597, 210, 'ตาก', '', '', 1),
(3598, 210, 'สุโขทัย', '', '', 1),
(3599, 210, 'ชุมพร', '', '', 1),
(3600, 210, 'พิจิตร', '', '', 1),
(3601, 210, 'ราชบุรี', '', '', 1),
(3602, 210, 'กาญจนบุรี', '', '', 1),
(3603, 210, 'สุพรรณบุรี', '', '', 1),
(3604, 210, 'นครปฐม', '', '', 1),
(3605, 210, 'สมุทรสาคร', '', '', 1),
(3606, 210, 'สมุทรสงคราม', '', '', 1),
(3607, 210, 'เพชรบุรี', '', '', 1),
(3608, 210, 'ประจวบคีรีขันธ์', '', '', 1),
(3609, 210, 'นครศรีธรรมราช', '', '', 1),
(3610, 210, 'กระบี่', '', '', 1),
(3611, 210, 'พังงา', '', '', 1),
(3612, 210, 'ภูเก็ต', '', '', 1),
(3613, 210, 'สุราษฎร์ธานี', '', '', 1),
(3614, 210, 'ระนอง', '', '', 1),
(3615, 210, 'ชุมพร', '', '', 1),
(3616, 210, 'สงขลา', '', '', 1),
(3617, 210, 'สตูล', '', '', 1),
(3618, 210, 'ตรัง', '', '', 1),
(3619, 210, 'พัทลุง', '', '', 1),
(3620, 210, 'ปัตตานี', '', '', 1),
(3621, 210, 'ยะลา', '', '', 1),
(3622, 210, 'นราธิวาส', '', '', 1),
(3623, 211, 'Centrale', '', '', 1),
(3624, 211, 'Kara', '', '', 1),
(3625, 211, 'Maritime', '', '', 1),
(3626, 211, 'Plateaux', '', '', 1),
(3627, 211, 'Savanes', '', '', 1),
(3628, 212, 'Atafu', '', '', 1),
(3629, 212, 'Fakaofo', '', '', 1),
(3630, 212, 'Nukunonu', '', '', 1),
(3631, 213, 'Ha\'apai', '', '', 1),
(3632, 213, 'Tongatapu', '', '', 1),
(3633, 213, 'Vava\'u', '', '', 1),
(3634, 214, 'Arima', '', '', 1),
(3635, 214, 'Chaguanas', '', '', 1),
(3636, 214, 'Couva-Tabaquite-Talparo', '', '', 1),
(3637, 214, 'Diego Martin', '', '', 1),
(3638, 214, 'Eastern Tobago', '', '', 1),
(3639, 214, 'Rio Claro-Mayaro', '', '', 1),
(3640, 214, 'Penal-Debe', '', '', 1),
(3641, 214, 'Point Fortin', '', '', 1),
(3642, 214, 'Port of Spain', '', '', 1),
(3643, 214, 'Princes Town', '', '', 1),
(3644, 214, 'San Fernando', '', '', 1),
(3645, 214, 'Sangre Grande', '', '', 1),
(3646, 214, 'San Juan-Laventille', '', '', 1),
(3647, 214, 'Siparia', '', '', 1),
(3648, 214, 'Tunapuna-Piarco', '', '', 1),
(3649, 214, 'Western Tobago', '', '', 1),
(3650, 215, 'ولاية تونس', '', '', 1),
(3651, 215, 'ولاية أريانة', '', '', 1),
(3652, 215, 'ولاية بن عروس', '', '', 1),
(3653, 215, 'ولاية منوبة', '', '', 1),
(3654, 215, 'ولاية نابل', '', '', 1),
(3655, 215, 'ولاية زغوان', '', '', 1),
(3656, 215, 'ولاية بنزرت', '', '', 1),
(3657, 215, 'ولاية باجة', '', '', 1),
(3658, 215, 'ولاية جندوبة', '', '', 1),
(3659, 215, 'ولاية الكاف', '', '', 1),
(3660, 215, 'ولاية سليانة', '', '', 1),
(3661, 215, 'ولاية القيروان', '', '', 1),
(3662, 215, 'ولاية القصرين', '', '', 1),
(3663, 215, 'ولاية سيدي بوزيد', '', '', 1),
(3664, 215, 'ولاية سوسة', '', '', 1),
(3665, 215, 'ولاية المنستير', '', '', 1),
(3666, 215, 'ولاية المهدية', '', '', 1),
(3667, 215, 'ولاية صفاقس', '', '', 1),
(3668, 215, 'ولاية قفصة', '', '', 1),
(3669, 215, 'ولاية توزر', '', '', 1),
(3670, 215, 'ولاية قبلي', '', '', 1),
(3671, 215, 'ولاية قابس', '', '', 1),
(3672, 215, 'ولاية مدنين', '', '', 1),
(3673, 215, 'ولاية تطاوين', '', '', 1),
(3674, 216, 'Adana', '', '', 1),
(3675, 216, 'Adıyaman', '', '', 1),
(3676, 216, 'Afyonkarahisar', '', '', 1),
(3677, 216, 'Ağrı', '', '', 1),
(3678, 216, 'Amasya', '', '', 1),
(3679, 216, 'Ankara', '', '', 1),
(3680, 216, 'Antalya', '', '', 1),
(3681, 216, 'Artvin', '', '', 1),
(3682, 216, 'Aydın', '', '', 1),
(3683, 216, 'Balıkesir', '', '', 1),
(3684, 216, 'Bilecik', '', '', 1),
(3685, 216, 'Bingöl', '', '', 1),
(3686, 216, 'Bitlis', '', '', 1),
(3687, 216, 'Bolu', '', '', 1),
(3688, 216, 'Burdur', '', '', 1),
(3689, 216, 'Bursa', '', '', 1),
(3690, 216, 'Çanakkale', '', '', 1),
(3691, 216, 'Çankırı', '', '', 1),
(3692, 216, 'Çorum', '', '', 1),
(3693, 216, 'Denizli', '', '', 1),
(3694, 216, 'Diyarbakır', '', '', 1),
(3695, 216, 'Edirne', '', '', 1),
(3696, 216, 'Elazığ', '', '', 1),
(3697, 216, 'Erzincan', '', '', 1),
(3698, 216, 'Erzurum', '', '', 1),
(3699, 216, 'Eskişehir', '', '', 1),
(3700, 216, 'Gaziantep', '', '', 1),
(3701, 216, 'Giresun', '', '', 1),
(3702, 216, 'Gümüşhane', '', '', 1),
(3703, 216, 'Hakkari', '', '', 1),
(3704, 216, 'Hatay', '', '', 1),
(3705, 216, 'Isparta', '', '', 1),
(3706, 216, 'Mersin', '', '', 1),
(3707, 216, 'İstanbul', '', '', 1),
(3708, 216, 'İzmir', '', '', 1),
(3709, 216, 'Kars', '', '', 1),
(3710, 216, 'Kastamonu', '', '', 1),
(3711, 216, 'Kayseri', '', '', 1),
(3712, 216, 'Kırklareli', '', '', 1),
(3713, 216, 'Kırşehir', '', '', 1),
(3714, 216, 'Kocaeli', '', '', 1),
(3715, 216, 'Konya', '', '', 1),
(3716, 216, 'Kütahya', '', '', 1),
(3717, 216, 'Malatya', '', '', 1),
(3718, 216, 'Manisa', '', '', 1),
(3719, 216, 'Kahramanmaraş', '', '', 1),
(3720, 216, 'Mardin', '', '', 1),
(3721, 216, 'Muğla', '', '', 1),
(3722, 216, 'Muş', '', '', 1),
(3723, 216, 'Nevşehir', '', '', 1),
(3724, 216, 'Niğde', '', '', 1),
(3725, 216, 'Ordu', '', '', 1),
(3726, 216, 'Rize', '', '', 1),
(3727, 216, 'Sakarya', '', '', 1),
(3728, 216, 'Samsun', '', '', 1),
(3729, 216, 'Siirt', '', '', 1),
(3730, 216, 'Sinop', '', '', 1),
(3731, 216, 'Sivas', '', '', 1),
(3732, 216, 'Tekirdağ', '', '', 1),
(3733, 216, 'Tokat', '', '', 1),
(3734, 216, 'Trabzon', '', '', 1),
(3735, 216, 'Tunceli', '', '', 1),
(3736, 216, 'Şanlıurfa', '', '', 1),
(3737, 216, 'Uşak', '', '', 1),
(3738, 216, 'Van', '', '', 1),
(3739, 216, 'Yozgat', '', '', 1),
(3740, 216, 'Zonguldak', '', '', 1),
(3741, 216, 'Aksaray', '', '', 1),
(3742, 216, 'Bayburt', '', '', 1),
(3743, 216, 'Karaman', '', '', 1),
(3744, 216, 'Kırıkkale', '', '', 1),
(3745, 216, 'Batman', '', '', 1),
(3746, 216, 'Şırnak', '', '', 1),
(3747, 216, 'Bartın', '', '', 1),
(3748, 216, 'Ardahan', '', '', 1),
(3749, 216, 'Iğdır', '', '', 1),
(3750, 216, 'Yalova', '', '', 1),
(3751, 216, 'Karabük', '', '', 1),
(3752, 216, 'Kilis', '', '', 1),
(3753, 216, 'Osmaniye', '', '', 1),
(3754, 216, 'Düzce', '', '', 1),
(3755, 217, 'Ahal welaýaty', '', '', 1),
(3756, 217, 'Balkan welaýaty', '', '', 1),
(3757, 217, 'Daşoguz welaýaty', '', '', 1),
(3758, 217, 'Lebap welaýaty', '', '', 1),
(3759, 217, 'Mary welaýaty', '', '', 1),
(3760, 218, 'Ambergris Cays', '', '', 1),
(3761, 218, 'Dellis Cay', '', '', 1),
(3762, 218, 'French Cay', '', '', 1),
(3763, 218, 'Little Water Cay', '', '', 1),
(3764, 218, 'Parrot Cay', '', '', 1),
(3765, 218, 'Pine Cay', '', '', 1),
(3766, 218, 'Salt Cay', '', '', 1),
(3767, 218, 'Grand Turk', '', '', 1),
(3768, 218, 'South Caicos', '', '', 1),
(3769, 218, 'East Caicos', '', '', 1),
(3770, 218, 'Middle Caicos', '', '', 1),
(3771, 218, 'North Caicos', '', '', 1),
(3772, 218, 'Providenciales', '', '', 1),
(3773, 218, 'West Caicos', '', '', 1),
(3774, 219, 'Funafuti', '', '', 1),
(3775, 219, 'Nanumea', '', '', 1),
(3776, 219, 'Nanumanga', '', '', 1),
(3777, 219, 'Niutao', '', '', 1),
(3778, 219, 'Nui', '', '', 1),
(3779, 219, 'Nukufetau', '', '', 1),
(3780, 219, 'Nukulaelae', '', '', 1),
(3781, 219, 'Vaitupu', '', '', 1),
(3782, 220, 'Kalangala', '', '', 1),
(3783, 220, 'Kampala', '', '', 1),
(3784, 220, 'Kiboga', '', '', 1),
(3785, 220, 'Luwero', '', '', 1),
(3786, 220, 'Masaka', '', '', 1),
(3787, 220, 'Mpigi', '', '', 1),
(3788, 220, 'Mubende', '', '', 1),
(3789, 220, 'Mukono', '', '', 1),
(3790, 220, 'Nakasongola', '', '', 1),
(3791, 220, 'Rakai', '', '', 1),
(3792, 220, 'Sembabule', '', '', 1),
(3793, 220, 'Kayunga', '', '', 1),
(3794, 220, 'Wakiso', '', '', 1),
(3795, 220, 'Bugiri', '', '', 1),
(3796, 220, 'Busia', '', '', 1),
(3797, 220, 'Iganga', '', '', 1),
(3798, 220, 'Jinja', '', '', 1),
(3799, 220, 'Kamuli', '', '', 1),
(3800, 220, 'Kapchorwa', '', '', 1),
(3801, 220, 'Katakwi', '', '', 1),
(3802, 220, 'Kumi', '', '', 1),
(3803, 220, 'Mbale', '', '', 1),
(3804, 220, 'Pallisa', '', '', 1),
(3805, 220, 'Soroti', '', '', 1),
(3806, 220, 'Tororo', '', '', 1),
(3807, 220, 'Kaberamaido', '', '', 1),
(3808, 220, 'Mayuge', '', '', 1),
(3809, 220, 'Sironko', '', '', 1),
(3810, 220, 'Adjumani', '', '', 1),
(3811, 220, 'Apac', '', '', 1),
(3812, 220, 'Arua', '', '', 1),
(3813, 220, 'Gulu', '', '', 1),
(3814, 220, 'Kitgum', '', '', 1),
(3815, 220, 'Kotido', '', '', 1),
(3816, 220, 'Lira', '', '', 1),
(3817, 220, 'Moroto', '', '', 1),
(3818, 220, 'Moyo', '', '', 1),
(3819, 220, 'Nebbi', '', '', 1),
(3820, 220, 'Nakapiripirit', '', '', 1),
(3821, 220, 'Pader', '', '', 1),
(3822, 220, 'Yumbe', '', '', 1),
(3823, 220, 'Bundibugyo', '', '', 1),
(3824, 220, 'Bushenyi', '', '', 1),
(3825, 220, 'Hoima', '', '', 1),
(3826, 220, 'Kabale', '', '', 1),
(3827, 220, 'Kabarole', '', '', 1),
(3828, 220, 'Kasese', '', '', 1),
(3829, 220, 'Kibale', '', '', 1),
(3830, 220, 'Kisoro', '', '', 1),
(3831, 220, 'Masindi', '', '', 1),
(3832, 220, 'Mbarara', '', '', 1),
(3833, 220, 'Ntungamo', '', '', 1),
(3834, 220, 'Rukungiri', '', '', 1),
(3835, 220, 'Kamwenge', '', '', 1),
(3836, 220, 'Kanungu', '', '', 1),
(3837, 220, 'Kyenjojo', '', '', 1),
(3838, 221, 'Вінницька область', '', '', 1),
(3839, 221, 'Волинська область', '', '', 1),
(3840, 221, 'Луганська область', '', '', 1),
(3841, 221, 'Дніпропетровська область', '', '', 1),
(3842, 221, 'Донецька область', '', '', 1),
(3843, 221, 'Житомирська область', '', '', 1),
(3844, 221, 'Рівненська область', '', '', 1),
(3845, 221, 'Закарпатська область', '', '', 1),
(3846, 221, 'Запорізька область', '', '', 1),
(3847, 221, 'Івано-Франківська область', '', '', 1),
(3848, 221, 'Київ', '', '', 1),
(3849, 221, 'Київська область', '', '', 1),
(3850, 221, 'Кіровоградська область', '', '', 1),
(3851, 221, 'Севастополь', '', '', 1),
(3852, 221, 'Автономная Республика Крым', '', '', 1),
(3853, 221, 'Львівська область', '', '', 1),
(3854, 221, 'Миколаївська область', '', '', 1),
(3855, 221, 'Одеська область', '', '', 1),
(3856, 221, 'Полтавська область', '', '', 1),
(3857, 221, 'Сумська область', '', '', 1),
(3858, 221, 'Тернопільська область', '', '', 1),
(3859, 221, 'Харківська область', '', '', 1),
(3860, 221, 'Херсонська область', '', '', 1),
(3861, 221, 'Хмельницька область', '', '', 1),
(3862, 221, 'Черкаська область', '', '', 1),
(3863, 221, 'Чернігівська область', '', '', 1),
(3864, 221, 'Чернівецька область', '', '', 1),
(3865, 223, 'Argyll and Bute', '', '', 1),
(3866, 223, 'Bath and North East Somerset', '', '', 1),
(3867, 223, 'Bedfordshire', '', '', 1),
(3868, 223, 'Berkshire', '', '', 1),
(3869, 223, 'Blaenau Gwent', '', '', 1),
(3870, 223, 'Borders', '', '', 1),
(3871, 223, 'Bristol', '', '', 1),
(3872, 223, 'Buckinghamshire', '', '', 1),
(3873, 223, 'Cambridgeshire', '', '', 1),
(3874, 223, 'Carmarthenshire', '', '', 1),
(3875, 223, 'Ceredigion', '', '', 1),
(3876, 223, 'Cheshire', '', '', 1),
(3877, 223, 'Conwy', '', '', 1),
(3878, 223, 'Cornwall', '', '', 1),
(3879, 223, 'County Antrim', '', '', 1),
(3880, 223, 'County Down', '', '', 1),
(3881, 223, 'County Durham', '', '', 1),
(3882, 223, 'County Fermanagh', '', '', 1),
(3883, 223, 'County Londonderry', '', '', 1),
(3884, 223, 'County Tyrone', '', '', 1),
(3885, 223, 'Cumbria', '', '', 1),
(3886, 223, 'Denbighshire', '', '', 1),
(3887, 223, 'Derbyshire', '', '', 1),
(3888, 223, 'Devon', '', '', 1),
(3889, 223, 'Dorset', '', '', 1),
(3890, 223, 'Dumbarton and Clydebank', '', '', 1),
(3891, 223, 'Dumfries and Galloway', '', '', 1),
(3892, 223, 'Dyfed', '', '', 1),
(3893, 223, 'East Ayrshire', '', '', 1),
(3894, 223, 'East Dunbartonshire', '', '', 1),
(3895, 223, 'East Renfrewshire', '', '', 1),
(3896, 223, 'East Riding of Yorkshire', '', '', 1),
(3897, 223, 'East Sussex', '', '', 1),
(3898, 223, 'Edinburgh', '', '', 1),
(3899, 223, 'Essex', '', '', 1),
(3900, 223, 'Fife', '', '', 1),
(3901, 223, 'Flintshire', '', '', 1),
(3902, 223, 'Glamorgan', '', '', 1),
(3903, 223, 'Glasgow', '', '', 1),
(3904, 223, 'Gloucestershire', '', '', 1),
(3905, 223, 'Grampian', '', '', 1),
(3906, 223, 'Greater Manchester', '', '', 1),
(3907, 223, 'Gwent', '', '', 1),
(3908, 223, 'Gwynedd', '', '', 1),
(3909, 223, 'Hampshire', '', '', 1),
(3910, 223, 'Herefordshire', '', '', 1),
(3911, 223, 'Hertfordshire', '', '', 1),
(3912, 223, 'Inverclyde', '', '', 1),
(3913, 223, 'Isle of Wight', '', '', 1),
(3914, 223, 'Kent', '', '', 1),
(3915, 223, 'Lancashire', '', '', 1),
(3916, 223, 'Leicestershire', '', '', 1),
(3917, 223, 'Lincolnshire', '', '', 1),
(3918, 223, 'London', '', '', 1),
(3919, 223, 'Manchester', '', '', 1),
(3920, 223, 'Middlesex', '', '', 1),
(3921, 223, 'Merseyside', '', '', 1),
(3922, 223, 'Norfolk', '', '', 1),
(3923, 223, 'North Ayrshire', '', '', 1),
(3924, 223, 'North Lanarkshire', '', '', 1),
(3925, 223, 'North West Highlands', '', '', 1),
(3926, 223, 'North Yorkshire', '', '', 1),
(3927, 223, 'Northamptonshire', '', '', 1),
(3928, 223, 'Northumberland', '', '', 1),
(3929, 223, 'Nottinghamshire', '', '', 1),
(3930, 223, 'Oxfordshire', '', '', 1),
(3931, 223, 'Pembrokeshire', '', '', 1),
(3932, 223, 'Powys', '', '', 1),
(3933, 223, 'Renfrewshire', '', '', 1),
(3934, 223, 'Rhondda Cynon Taf', '', '', 1),
(3935, 223, 'Shropshire', '', '', 1),
(3936, 223, 'Somerset', '', '', 1),
(3937, 223, 'South Ayrshire', '', '', 1),
(3938, 223, 'South Gloucestershire', '', '', 1),
(3939, 223, 'South Lanarkshire', '', '', 1),
(3940, 223, 'South Yorkshire', '', '', 1),
(3941, 223, 'Staffordshire', '', '', 1),
(3942, 223, 'Suffolk', '', '', 1),
(3943, 223, 'Surrey', '', '', 1),
(3944, 223, 'Tayside', '', '', 1),
(3945, 223, 'Torfaen', '', '', 1),
(3946, 223, 'Tyne & Wear', '', '', 1),
(3947, 223, 'Warwickshire', '', '', 1),
(3948, 223, 'West Lothian', '', '', 1),
(3949, 223, 'West Midlands', '', '', 1),
(3950, 223, 'West Sussex', '', '', 1),
(3951, 223, 'West Yorkshire', '', '', 1),
(3952, 223, 'Wiltshire', '', '', 1),
(3953, 223, 'Worcestershire', '', '', 1),
(3954, 223, 'Aberdeenshire', '', '', 1),
(3955, 223, 'Anglesey', '', '', 1),
(3956, 223, 'Angus', '', '', 1),
(3957, 223, 'Argyllshire', '', '', 1),
(3958, 223, 'Ayrshire', '', '', 1),
(3959, 223, 'Banffshire', '', '', 1),
(3960, 223, 'Berwickshire', '', '', 1),
(3961, 223, 'Brecknockshire', '', '', 1),
(3962, 223, 'Buteshire', '', '', 1),
(3963, 223, 'Caernarfonshire', '', '', 1),
(3964, 223, 'Caithness', '', '', 1),
(3965, 223, 'Cardiganshire', '', '', 1),
(3966, 223, 'Channel Isles', '', '', 1),
(3967, 223, 'Clackmannanshire', '', '', 1),
(3968, 223, 'County Armagh', '', '', 1),
(3969, 223, 'Cumberland', '', '', 1),
(3970, 223, 'Dumfriesshire', '', '', 1),
(3971, 223, 'Dunbartonshire', '', '', 1),
(3972, 223, 'East Lothian', '', '', 1),
(3973, 223, 'Huntingdonshire', '', '', 1),
(3974, 223, 'Inverness-shire', '', '', 1),
(3975, 223, 'Isle of Islay', '', '', 1),
(3976, 223, 'Isle of Lewis', '', '', 1),
(3977, 223, 'Isle of Man', '', '', 1),
(3978, 223, 'Isle of Skye', '', '', 1),
(3979, 223, 'Isles of Scilly', '', '', 1),
(3980, 223, 'Kincardineshire', '', '', 1),
(3981, 223, 'Kinross-Shire', '', '', 1),
(3982, 223, 'Kirkcudbrightshire', '', '', 1),
(3983, 223, 'Lanarkshire', '', '', 1),
(3984, 223, 'Merioneth', '', '', 1),
(3985, 223, 'Midlothian', '', '', 1),
(3986, 223, 'Monmouthshire', '', '', 1),
(3987, 223, 'Montgomeryshire', '', '', 1),
(3988, 223, 'Morayshire', '', '', 1),
(3989, 223, 'Nairnshire', '', '', 1),
(3990, 223, 'Orkney', '', '', 1),
(3991, 223, 'Peeblesshire', '', '', 1),
(3992, 223, 'Perthshire', '', '', 1),
(3993, 223, 'Radnorshire', '', '', 1),
(3994, 223, 'Ross-shire', '', '', 1),
(3995, 223, 'Roxburghshire', '', '', 1),
(3996, 223, 'Rutland', '', '', 1),
(3997, 223, 'Selkirkshire', '', '', 1),
(3998, 223, 'Shetland', '', '', 1),
(3999, 223, 'Stirlingshire', '', '', 1),
(4000, 223, 'Sussex', '', '', 1),
(4001, 223, 'Sutherland', '', '', 1),
(4002, 223, 'Westmorland', '', '', 1),
(4003, 223, 'Wigtownshire', '', '', 1),
(4004, 224, 'American Samoa', '', '', 1),
(4005, 224, 'Guam', '', '', 1),
(4006, 224, 'Northern Mariana Islands', '', '', 1),
(4007, 224, 'Puerto Rico', '', '', 1),
(4008, 224, 'U.S. Minor Outlying Islands', '', '', 1),
(4009, 224, 'Virgin Islands of the U.S.', '', '', 1),
(4010, 225, 'Baker Island', '', '', 1),
(4011, 225, 'Howland Island', '', '', 1),
(4012, 225, 'Jarvis Island', '', '', 1),
(4013, 225, 'Johnston Atoll', '', '', 1),
(4014, 225, 'Kingman Reef', '', '', 1),
(4015, 225, 'Midway Atoll', '', '', 1),
(4016, 225, 'Navassa Island', '', '', 1),
(4017, 225, 'Palmyra Atoll', '', '', 1),
(4018, 225, 'Wake Island', '', '', 1),
(4019, 226, 'Artigas', '', '', 1),
(4020, 226, 'Canelones', '', '', 1),
(4021, 226, 'Cerro Largo', '', '', 1),
(4022, 226, 'Colonia', '', '', 1),
(4023, 226, 'Durazno', '', '', 1),
(4024, 226, 'Florida', '', '', 1),
(4025, 226, 'Flores', '', '', 1),
(4026, 226, 'Lavalleja', '', '', 1),
(4027, 226, 'Maldonado', '', '', 1),
(4028, 226, 'Montevideo', '', '', 1),
(4029, 226, 'Paysandu', '', '', 1),
(4030, 226, 'Río Negro', '', '', 1),
(4031, 226, 'Rocha', '', '', 1),
(4032, 226, 'Rivera', '', '', 1),
(4033, 226, 'Salto', '', '', 1),
(4034, 226, 'Soriano', '', '', 1),
(4035, 226, 'Tacuarembó', '', '', 1),
(4036, 226, 'Treinta y Tres', '', '', 1),
(4037, 227, 'Andijon viloyati', '', '', 1),
(4038, 227, 'Buxoro viloyati', '', '', 1),
(4039, 227, 'Farg\'ona viloyati', '', '', 1),
(4040, 227, 'Jizzax viloyati', '', '', 1),
(4041, 227, 'Namangan viloyati', '', '', 1),
(4042, 227, 'Navoiy viloyati', '', '', 1),
(4043, 227, 'Qashqadaryo viloyati', '', '', 1),
(4044, 227, 'Qoraqalpog\'iston Respublikasi', '', '', 1),
(4045, 227, 'Samarqand viloyati', '', '', 1),
(4046, 227, 'Sirdaryo viloyati', '', '', 1),
(4047, 227, 'Surxondaryo viloyati', '', '', 1),
(4048, 227, 'Toshkent', '', '', 1),
(4049, 227, 'Toshkent viloyati', '', '', 1),
(4050, 227, 'Xorazm viloyati', '', '', 1),
(4051, 228, 'Malampa', '', '', 1),
(4052, 228, 'Pénama', '', '', 1),
(4053, 228, 'Sanma', '', '', 1),
(4054, 228, 'Shéfa', '', '', 1),
(4055, 228, 'Taféa', '', '', 1),
(4056, 228, 'Torba', '', '', 1),
(4057, 230, 'Distrito Capital', '', '', 1),
(4058, 230, 'Anzoátegui', '', '', 1),
(4059, 230, 'Apure', '', '', 1),
(4060, 230, 'Aragua', '', '', 1),
(4061, 230, 'Barinas', '', '', 1),
(4062, 230, 'Bolívar', '', '', 1),
(4063, 230, 'Carabobo', '', '', 1),
(4064, 230, 'Cojedes', '', '', 1),
(4065, 230, 'Falcón', '', '', 1),
(4066, 230, 'Guárico', '', '', 1),
(4067, 230, 'Lara', '', '', 1),
(4068, 230, 'Mérida', '', '', 1),
(4069, 230, 'Miranda', '', '', 1),
(4070, 230, 'Monagas', '', '', 1),
(4071, 230, 'Nueva Esparta', '', '', 1),
(4072, 230, 'Portuguesa', '', '', 1),
(4073, 230, 'Sucre', '', '', 1),
(4074, 230, 'Tachira', '', '', 1),
(4075, 230, 'Trujillo', '', '', 1),
(4076, 230, 'Yaracuy', '', '', 1),
(4077, 230, 'Zulia', '', '', 1),
(4078, 230, 'Capital Dependencia', '', '', 1),
(4079, 230, 'Vargas', '', '', 1),
(4080, 230, 'Delta Amacuro', '', '', 1),
(4081, 230, 'Amazonas', '', '', 1),
(4082, 231, 'Lai Châu', '', '', 1),
(4083, 231, 'Lào Cai', '', '', 1),
(4084, 231, 'Hà Giang', '', '', 1),
(4085, 231, 'Cao Bằng', '', '', 1),
(4086, 231, 'Sơn La', '', '', 1),
(4087, 231, 'Yên Bái', '', '', 1),
(4088, 231, 'Tuyên Quang', '', '', 1),
(4089, 231, 'Lạng Sơn', '', '', 1),
(4090, 231, 'Quảng Ninh', '', '', 1),
(4091, 231, 'Hòa Bình', '', '', 1),
(4092, 231, 'Hà Tây', '', '', 1),
(4093, 231, 'Ninh Bình', '', '', 1),
(4094, 231, 'Thái Bình', '', '', 1),
(4095, 231, 'Thanh Hóa', '', '', 1),
(4096, 231, 'Nghệ An', '', '', 1),
(4097, 231, 'Hà Tĩnh', '', '', 1),
(4098, 231, 'Quảng Bình', '', '', 1),
(4099, 231, 'Quảng Trị', '', '', 1),
(4100, 231, 'Thừa Thiên-Huế', '', '', 1),
(4101, 231, 'Quảng Nam', '', '', 1),
(4102, 231, 'Kon Tum', '', '', 1),
(4103, 231, 'Quảng Ngãi', '', '', 1),
(4104, 231, 'Gia Lai', '', '', 1),
(4105, 231, 'Bình Định', '', '', 1),
(4106, 231, 'Phú Yên', '', '', 1),
(4107, 231, 'Đắk Lắk', '', '', 1),
(4108, 231, 'Khánh Hòa', '', '', 1),
(4109, 231, 'Lâm Đồng', '', '', 1),
(4110, 231, 'Ninh Thuận', '', '', 1),
(4111, 231, 'Tây Ninh', '', '', 1),
(4112, 231, 'Đồng Nai', '', '', 1),
(4113, 231, 'Bình Thuận', '', '', 1),
(4114, 231, 'Long An', '', '', 1),
(4115, 231, 'Bà Rịa-Vũng Tàu', '', '', 1),
(4116, 231, 'An Giang', '', '', 1),
(4117, 231, 'Đồng Tháp', '', '', 1),
(4118, 231, 'Tiền Giang', '', '', 1),
(4119, 231, 'Kiên Giang', '', '', 1),
(4120, 231, 'Cần Thơ', '', '', 1),
(4121, 231, 'Vĩnh Long', '', '', 1),
(4122, 231, 'Bến Tre', '', '', 1),
(4123, 231, 'Trà Vinh', '', '', 1),
(4124, 231, 'Sóc Trăng', '', '', 1),
(4125, 231, 'Bắc Kạn', '', '', 1),
(4126, 231, 'Bắc Giang', '', '', 1),
(4127, 231, 'Bạc Liêu', '', '', 1),
(4128, 231, 'Bắc Ninh', '', '', 1),
(4129, 231, 'Bình Dương', '', '', 1),
(4130, 231, 'Bình Phước', '', '', 1),
(4131, 231, 'Cà Mau', '', '', 1),
(4132, 231, 'Đà Nẵng', '', '', 1),
(4133, 231, 'Hải Dương', '', '', 1),
(4134, 231, 'Hải Phòng', '', '', 1),
(4135, 231, 'Hà Nam', '', '', 1),
(4136, 231, 'Hà Nội', '', '', 1),
(4137, 231, 'TP Hồ Chí Minh', '', '', 1),
(4138, 231, 'Hưng Yên', '', '', 1),
(4139, 231, 'Nam Định', '', '', 1),
(4140, 231, 'Phú Thọ', '', '', 1),
(4141, 231, 'Thái Nguyên', '', '', 1),
(4142, 231, 'Vĩnh Phúc', '', '', 1),
(4143, 231, 'Điện Biên', '', '', 1),
(4144, 231, 'Đắk Nông', '', '', 1),
(4145, 231, 'Hậu Giang', '', '', 1),
(4146, 233, 'Saint Croix', '', '', 1),
(4147, 234, 'Alo', '', '', 1),
(4148, 234, 'Sigave', '', '', 1),
(4149, 234, 'Wallis', '', '', 1),
(4150, 236, 'أبين‎', '', '', 1),
(4151, 236, 'عدن', '', '', 1),
(4152, 236, 'عمران', '', '', 1),
(4153, 236, 'البيضاء', '', '', 1),
(4154, 236, 'الضالع', '', '', 1),
(4155, 236, 'ذمار', '', '', 1),
(4156, 236, 'حضرموت', '', '', 1),
(4157, 236, 'حجة', '', '', 1),
(4158, 236, 'الحديدة', '', '', 1),
(4159, 236, 'إب', '', '', 1),
(4160, 236, 'الجوف', '', '', 1),
(4161, 236, 'لحج', '', '', 1),
(4162, 236, 'مأرب', '', '', 1),
(4163, 236, 'المهرة', '', '', 1),
(4164, 236, 'المحويت', '', '', 1),
(4165, 236, 'صعدة', '', '', 1),
(4166, 236, 'صنعاء', '', '', 1),
(4167, 236, 'شبوة', '', '', 1),
(4168, 236, 'تعز', '', '', 1),
(4169, 239, 'Western', '', '', 1),
(4170, 239, 'Central', '', '', 1),
(4171, 239, 'Eastern', '', '', 1),
(4172, 239, 'Luapula', '', '', 1),
(4173, 239, 'Northern', '', '', 1),
(4174, 239, 'North-Western', '', '', 1),
(4175, 239, 'Southern', '', '', 1),
(4176, 239, 'Copperbelt', '', '', 1),
(4177, 239, 'Lusaka', '', '', 1),
(4178, 240, 'Manicaland', '', '', 1),
(4179, 240, 'Mashonaland Central', '', '', 1),
(4180, 240, 'Mashonaland East', '', '', 1),
(4181, 240, 'Midlands', '', '', 1),
(4182, 240, 'Matabeleland North', '', '', 1),
(4183, 240, 'Matabeleland South', '', '', 1),
(4184, 240, 'Masvingo', '', '', 1),
(4185, 240, 'Mashonaland West', '', '', 1);

CREATE TABLE IF NOT EXISTS `#__sr_statuses` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `label` VARCHAR(255) NOT NULL,
  `code` INT(11) NOT NULL,
  `state` TINYINT(1) NOT NULL DEFAULT 0,
  `color_code` CHAR(7) NOT NULL,
  `scope` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` INT(11) NOT NULL DEFAULT 0,
  `readonly` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `type` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`))
  ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (1,'Pending',3,1,'#f57a27',1,1,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (2,'Confirmed',1,1,'#3c763d',1,2,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (3,'Cancelled',2,1,'#a94442',1,3,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (4,'Closed',0,1,'#777777',1,4,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (5,'Trashed',-2,1,'#000000',1,5,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (6,'Unpaid',0,1,'#ff0000',1,1,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (7,'Paid',1,1,'#3c763d',1,2,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (8,'Cancelled',2,0,'#a94442',1,3,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (9,'Pending',3,1,'#3a62d1',1,4,1,1);

INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (10,'Pending',0,1,'#8a6d3b',0,1,1,0);
-- INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (11,'Checkin',1,1,'#31708f',0,2,1,0);
-- INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (12,'Checkout',2,1,'#333333',0,3,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (13,'Closed',3,1,'#999999',0,4,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (14,'Cancelled',4,1,'#f89406',0,5,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (15,'Confirmed',5,1,'#3c763d',0,6,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (16,'Trashed',-2,1,'#000000',0,7,1,0);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (17,'Unpaid',0,1,'#a94442',0,1,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (18,'Completed',1,1,'#3c763d',0,2,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (19,'Cancelled',2,1,'#a94442',0,3,1,1);
INSERT INTO `#__sr_statuses` (`id`, `label`, `code`, `state`, `color_code`, `scope`, `ordering`, `readonly`, `type`) VALUES (20,'Pending',3,1,'#8a6d3b',0,4,1,1);

CREATE TABLE IF NOT EXISTS `#__sr_payment_history` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `reservation_id` INT(11) UNSIGNED NOT NULL,
  `scope` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `payment_date` DATETIME NULL,
  `payment_status` TINYINT(2) DEFAULT 0,
  `payment_method_id` VARCHAR(50) NULL,
  `payment_method_txn_id` VARCHAR(100) NULL,
  `payment_method_surcharge` DECIMAL(20,6) UNSIGNED NOT NULL,
  `payment_method_discount` DECIMAL(20,6) UNSIGNED NOT NULL,
  `payment_data` TEXT NULL,
  `payment_amount` DECIMAL(20,6) UNSIGNED NOT NULL,
  `currency_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `payment_method_txn_id_UNIQUE` (`payment_method_txn_id` ASC))
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sr_wishlist` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) UNSIGNED NULL DEFAULT '0',
  `scope` TEXT NULL DEFAULT NULL,
  `history` MEDIUMTEXT NULL DEFAULT NULL,
  `created_date` DATETIME NULL DEFAULT NULL,
  `modified_date` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sr_property_staff_xref` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) UNSIGNED NOT NULL,
  `staff_id` INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `idx_property_id` (`property_id`),
  INDEX `idx_staff_id` (`staff_id`)
)
ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES (0, 'Solidres Property', 'com_solidres.property', '{"special":{"dbtable":"#__sr_reservation_assets","key":"id","type":"ReservationAsset","prefix":"SolidresTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"state","core_alias":"alias","core_created_time":"created_date","core_modified_time":"modified_date","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"category_id", "core_xreference":"xreference", "asset_id":"asset_id"}, "special":{}}', 'SolidresHelperRoute::getReservationAssetRoute', '');
