<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

HTMLHelper::_('behavior.formvalidator');

$lang            = JFactory::getLanguage();
$paymentMethodId = $this->form->getValue('payment_method_id', '');
$isMobile        = $this->form->getValue('customer_ismobile', null);
$user            = JFactory::getUser();
$canEdit         = $user->authorise('core.edit', 'com_solidres');

if (!empty($paymentMethodId))
{
	$lang->load('plg_solidrespayment_' . $paymentMethodId, JPATH_PLUGINS . '/solidrespayment/' . $paymentMethodId);
}

$isDiscountPreTax = $this->form->getValue('discount_pre_tax');

$baseCurrency           = new SRCurrency(0, $this->form->getValue('currency_id'));
$totalExtraPriceTaxIncl = $this->form->getValue('total_extra_price_tax_incl');
$totalExtraPriceTaxExcl = $this->form->getValue('total_extra_price_tax_excl');
$totalExtraTaxAmount    = $totalExtraPriceTaxIncl - $totalExtraPriceTaxExcl;
$totalPaid              = $this->form->getValue('total_paid', 0);
$deposit                = $this->form->getValue('deposit_amount', 0);

$subTotal = clone $baseCurrency;
$subTotal->setValue($this->form->getValue('total_price_tax_excl') - $this->form->getValue('total_single_supplement'));

$totalSingleSupplement = clone $baseCurrency;
$totalSingleSupplement->setValue($this->form->getValue('total_single_supplement'));

$totalDiscount = clone $baseCurrency;
$totalDiscount->setValue($this->form->getValue('total_discount'));

$tax = clone $baseCurrency;
$tax->setValue($this->form->getValue('tax_amount'));
$touristTax = clone $baseCurrency;
$touristTax->setValue($this->form->getValue('tourist_tax_amount'));
$paymentMethodSurcharge = clone $baseCurrency;
$paymentMethodSurcharge->setValue($this->form->getValue('payment_method_surcharge'));
$paymentMethodDiscount = clone $baseCurrency;
$paymentMethodDiscount->setValue($this->form->getValue('payment_method_discount'));
$totalExtraPriceTaxExclDisplay = clone $baseCurrency;
$totalExtraPriceTaxExclDisplay->setValue($totalExtraPriceTaxExcl);
$totalExtraTaxAmountDisplay = clone $baseCurrency;
$totalExtraTaxAmountDisplay->setValue($totalExtraTaxAmount);

$grandTotal = clone $baseCurrency;
if ($isDiscountPreTax) :
	$grandTotalAmount = $this->form->getValue('total_price_tax_excl') - $this->form->getValue('total_discount') + $this->form->getValue('tax_amount') + $totalExtraPriceTaxIncl;
else :
	$grandTotalAmount = $this->form->getValue('total_price_tax_excl') + $this->form->getValue('tax_amount') - $this->form->getValue('total_discount') + $totalExtraPriceTaxIncl;
endif;
$grandTotalAmount += $this->form->getValue('tourist_tax_amount', 0);
/*$grandTotalAmount += $this->form->getValue('payment_method_surcharge', 0);
$grandTotalAmount -= $this->form->getValue('payment_method_discount', 0);*/
$grandTotal->setValue($grandTotalAmount);

$depositAmount = clone $baseCurrency;
$depositAmount->setValue(isset($deposit) ? $deposit : 0);
$totalPaidAmount = clone $baseCurrency;
$totalPaidAmount->setValue($totalPaid);
$totalDueAmount = clone $baseCurrency;
$totalDueAmount->setValue($grandTotalAmount - $totalPaid);

$couponCode       = $this->form->getValue('coupon_code');
$reservationId    = $this->form->getValue('id');
$reservationState = $this->form->getValue('state');
$paymentStatus    = $this->form->getValue('payment_status');
$bookingType      = $this->form->getValue('booking_type', 0);

$reservationStatusesList = SolidresHelper::getStatusesList(0);
$paymentStatusesList     = SolidresHelper::getStatusesList(1);
$statuses                = $paymentStatuses = $statusesColor = $paymentsColor = $source = $originsList = [];

foreach ($reservationStatusesList as $status)
{
	$statuses[$status->value]      = $status->text;
	$statusesColor[$status->value] = $status->color_code;
}

foreach ($paymentStatusesList as $status)
{
	$paymentStatuses[$status->value] = $status->text;
	$paymentsColor[$status->value]   = $status->color_code;
}

$originId = $this->form->getValue('origin_id', null, 0);

foreach(SolidresHelper::getOriginsList() as $originItem)
{
	$originsList[$originItem->id] = [
		'value' => $originItem->id,
		'text'  => $originItem->name,
	];
}

if (isset($originsList[$originId]))
{
    $originValue = $originsList[$originId]['value'];
    $originText  = $originsList[$originId]['text'];
}
else
{
	$originValue = $originText = $this->form->getValue('origin');
}

SRHtml::_('jquery.editable');

$script =
	' Solidres.jQuery(function($) {
		$.fn.editable.defaults.mode = "inline";
		$.fn.editable.defaults.emptytext = "' . Text::_('SR_EMPTY') . '";
		$("#state").editable({
			url: Joomla.getOptions("system.paths").base + "/index.php?option=com_solidres&task=reservationbase.save&format=json",
			source: ' . json_encode($reservationStatusesList) . ',
		});

		$("#state").on("save", function(e, params) {
		    ' . ((SRPlugin::isEnabled('channelmanager')) ? 'showARIUpdateStatus(' . $this->form->getValue('reservation_asset_id') . ')' : '') . ';
		});

		$( "#payment_status" ).editable({
			url: Joomla.getOptions("system.paths").base + "/index.php?option=com_solidres&task=reservationbase.save&format=json",
			source: ' . json_encode($paymentStatusesList) . '
		});

		$( "#total_paid" ).editable({
			url: Joomla.getOptions("system.paths").base + "/index.php?option=com_solidres&task=reservationbase.save&format=json",
			display: function (value, response) {
				if (response) {
					if (response.success == true) {
						$(this).text(response.newValue);
					}
				}
			}
		});
		$( "#payment_method_txn_id" ).editable({
			url: Joomla.getOptions("system.paths").base + "/index.php?option=com_solidres&task=reservationbase.save&format=json",
			display: function (value, response) {
				if (response) {
					if (response.success == true) {
						$(this).text(response.newValue);
					}
				}
			}
		});
		$( "#origin" ).editable({
			url: Joomla.getOptions("system.paths").base + "/index.php?option=com_solidres&task=reservationbase.save&format=json",
			source: ' . json_encode(array_values($originsList)) . ',
		});
	});';
JFactory::getDocument()->addScriptDeclaration($script);

$config             = JFactory::getConfig();
$timezone           = new DateTimeZone($config->get('offset'));
$id                 = $this->form->getValue('id');
$paymentMethodTxnId = $this->form->getValue('payment_method_txn_id');

JFactory::getDocument()->addScriptDeclaration('
	Joomla.submitbutton = function(task)
	{
		if (task == "reservationbase.cancel" || task == "reservationbase.amend")
		{
			Joomla.submitform(task, document.getElementById("item-form"));
		}
	}
');

$paymentMethodLabel = Text::_('SR_PAYMENT_METHOD_' . $paymentMethodId);
$fieldEnabled       = SRPlugin::isEnabled('customfield');
$cid                = isset($this->reservationAsset->category_id) ? [(int) $this->reservationAsset->category_id] : [];

if ($fieldEnabled)
{
	$roomFields = SRCustomFieldHelper::findFields(['context' => 'com_solidres.room'], $cid, $this->form->getValue('customer_language') ?: null);
}
else
{
	$roomFields = false;
}

$reservationMeta = [];
if (!empty($this->form->getValue('reservation_meta')))
{
	$reservationMeta = json_decode($this->form->getValue('reservation_meta'), true);
}

$appliedDiscountHtml = '';
if ($this->form->getValue('total_discount') > 0 && isset($reservationMeta['applied_discounts']))
{
    foreach ($reservationMeta['applied_discounts'] as $appliedDiscount)
    {
	    if (!isset($appliedDiscount['amount']))
	    {
            continue;
        }

        $appliedDiscountLine = clone $baseCurrency;
	    $appliedDiscountLine->setValue($appliedDiscount['amount']);
	    $appliedDiscountHtml .= '<li class="sub-line-item" style="display: none"><label>|- ' . $appliedDiscount['title'] . '</label><span>' . $appliedDiscountLine->format() . '</span></li>';
    }
}

?>

<div id="solidres">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
		<?php echo SolidresHelperSideNavigation::getSideNavigation($this->getName()); ?>
        <div id="sr_panel_right" class="sr_form_view <?php echo SR_UI_GRID_COL_10 ?>">
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                    <h3><?php echo Text::_("SR_GENERAL_INFO") ?></h3>
                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                        <div class="<?php echo SR_UI_GRID_COL_6 ?>">

                            <ul class="reservation-details">
                                <li>
                                    <label><?php echo Text::_("SR_CODE") ?></label>
                                    <strong style="color: <?php echo $statusesColor[$this->form->getValue('state')] ?>; font-weight: bold">
		                                <?php echo $this->form->getValue('code') ?>
                                    </strong>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_RESERVATION_ASSET_NAME") ?></label>
									<?php
									$assetLink = Route::_('index.php?option=com_solidres&view=reservationasset&layout=edit&id=' . $this->form->getValue('reservation_asset_id'));
									echo "<a href=\"$assetLink\">" . $this->form->getValue('reservation_asset_name') . "</a>" ?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_CHECKIN") ?></label>
									<?php echo HTMLHelper::_('date', $this->form->getValue('checkin'), $this->dateFormat, null); ?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_CHECKOUT") ?></label>
									<?php echo HTMLHelper::_('date', $this->form->getValue('checkout'), $this->dateFormat, null); ?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_LENGTH_OF_STAY") ?></label>
									<?php
									if ($bookingType == 0) :
										echo Text::plural('SR_NIGHTS', $this->lengthOfStay);
									else :
										echo Text::plural('SR_DAYS', $this->lengthOfStay + 1);
									endif;
									?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_STATUS") ?></label>
                                    <a href="#"
                                       id="state"
                                       data-type="select"
                                       data-pk="<?php echo $reservationId ?>"
                                       data-value="<?php echo $reservationState ?>"
                                       data-original-title="">
                                        <strong style="color: <?php echo $statusesColor[$reservationState] ?>">
	                                        <?php echo $statuses[$reservationState] ?></a>
                                        </strong>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_RESERVATION_ORIGIN") ?></label>
                                    <a href="#"
                                       id="origin"
                                       data-type="select"
                                       data-pk="<?php echo $reservationId ?>"
                                       data-value="<?php echo $originValue ?>"
                                       data-original-title=""><?php echo $originText ?></a>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_CREATED_DATE") ?></label>
									<?php
									echo HTMLHelper::_('date', $this->form->getValue('created_date'), $this->dateFormat, true);
									echo isset($this->createdByUser) ? Text::_("SR_CREATED_BY_LBL") . $this->createdByUser->get('username') : '';
									echo ' (<i title="' . Text::_('SR_IP_DESC') . '">' . Text::_('SR_IP') . ': ' . $this->form->getValue('customer_ip') . '</i>, <i title="' . Text::_('SR_LANGUAGE_DESC') . '">' . Text::_('SR_LANGUAGE') . ': ' . $this->form->getValue('customer_language') . '</i>, <i title="' . Text::_('SR_IS_MOBILE_DESC') . '">' . Text::_('SR_IS_MOBILE') . ': ' . ($isMobile === '1' ? Text::_('JYES') : (is_null($isMobile) ? 'N/A' : Text::_('JNO')) ) . '</i>)';
									?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_PAYMENT_TYPE") ?></label> <?php echo !empty($paymentMethodId) ? $paymentMethodLabel : 'N/A' ?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_RESERVATION_PAYMENT_STATUS") ?></label>
                                    <a href="#"
                                       id="payment_status"
                                       data-type="select"
                                       data-pk="<?php echo $reservationId ?>"
                                       data-value="<?php echo $paymentStatus ?>"
                                       data-original-title="">
	                                    <?php if (isset($paymentStatuses[$paymentStatus])): ?>
                                            <strong style="color: <?php echo $paymentsColor[$paymentStatus]; ?>">
			                                    <?php echo $paymentStatuses[$paymentStatus]; ?>
                                            </strong>
	                                    <?php else: ?>
		                                    <?php echo 'N/A'; ?>
	                                    <?php endif; ?>
                                    </a>

									<?php
									$channelPaymentCollect = $this->form->getValue('cm_payment_collect', '');
									if (SRPlugin::isEnabled('channelmanager') && !empty($channelPaymentCollect)) :
										echo ' (' . Text::_('SR_CHANNEL_PAYMENT_COLLECT_' . ($channelPaymentCollect == 0 ? 'PROPERTY' : 'CHANNEL')) . ')';
									endif;
									?>
                                </li>
                                <li>
                                    <label><?php echo Text::_("SR_RESERVATION_PAYMENT_TXN_ID") ?></label>
                                    <a href="#"
                                       id="payment_method_txn_id"
                                       data-type="text"
                                       data-pk="<?php echo $reservationId ?>"
                                       data-value="<?php echo $paymentMethodTxnId ?>"
                                       data-original-title=""><?php echo $paymentMethodTxnId ?? '' ?></a>
                                </li>
                                <li>
                                    <label><?php echo Text::_('SR_RESERVATION_COUPON_CODE') ?></label> <?php echo !empty($couponCode) ? $couponCode : 'N/A' ?>
                                </li>
                            </ul>
                        </div>

                        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                            <ul class="reservation-details">
                                <li><label><?php echo Text::_('SR_RESERVATION_SUB_TOTAL') ?></label>
                                    <span><?php echo $subTotal->format() ?></span></li>
								<?php if ($this->form->getValue('total_single_supplement', 0) > 0) : ?>
                                    <li><label><?php echo Text::_('SR_RESERVATION_TOTAL_SINGLE_SUPPLEMENT') ?></label>
                                        <span><?php echo $totalSingleSupplement->format() ?></span></li>
								<?php endif ?>
								<?php if (isset($isDiscountPreTax) && $isDiscountPreTax == 1) : ?>
                                    <li class="toggle-discount-sub-lines"><label><?php echo Text::_('SR_RESERVATION_TOTAL_DISCOUNT') ?></label>
                                        <span><?php echo '-' . $totalDiscount->format() ?></span></li>
									<?php echo $appliedDiscountHtml ?>
								<?php endif ?>
                                <li><label><?php echo Text::_('SR_RESERVATION_TAX') ?></label>
                                    <span><?php echo $tax->format() ?></span></li>
								<?php if (isset($isDiscountPreTax) && $isDiscountPreTax == 0) : ?>
                                    <li class="toggle-discount-sub-lines"><label><?php echo Text::_('SR_RESERVATION_TOTAL_DISCOUNT') ?></label>
                                        <span><?php echo '-' . $totalDiscount->format() ?></span></li>
                                    <?php echo $appliedDiscountHtml ?>
								<?php endif ?>
                                <li><label><?php echo Text::_('SR_RESERVATION_EXTRA_TAX_EXCL') ?></label>
                                    <span><?php echo $totalExtraPriceTaxExclDisplay->format() ?></span></li>
                                <li><label><?php echo Text::_('SR_RESERVATION_EXTRA_TAX_AMOUNT') ?></label>
                                    <span><?php echo $totalExtraTaxAmountDisplay->format() ?></span></li>
								<?php if (!empty($paymentMethodId)) : ?>
                                    <li>
                                        <label><?php echo Text::sprintf("SR_PAYMENT_METHOD_SURCHARGE_AMOUNT", $paymentMethodLabel) ?></label>
                                        <span><?php echo $paymentMethodSurcharge->format() ?></span></li>
                                    <li>
                                        <label><?php echo Text::sprintf("SR_PAYMENT_METHOD_DISCOUNT_AMOUNT", $paymentMethodLabel) ?></label>
                                        <span><?php echo '-' . $paymentMethodDiscount->format() ?></span></li>
								<?php endif ?>
                                <li><label><?php echo Text::_('SR_TOURIST_TAX_AMOUNT') ?></label>
                                    <span><?php echo $touristTax->format() ?></span></li>
                                <li><label><?php echo Text::_('SR_RESERVATION_GRAND_TOTAL') ?></label>
                                    <span><?php echo $grandTotal->format() ?></span></li>
                                <li><label><?php echo Text::_('SR_RESERVATION_DEPOSIT_AMOUNT') ?></label>
                                    <span><?php echo $depositAmount->format() ?></span></li>
                                <li>
                                    <label><?php echo Text::_('SR_RESERVATION_TOTAL_PAID') ?></label>
                                    <span>
									<a
                                            href="#"
                                            id="total_paid"
                                            data-type="text"
                                            data-pk="<?php echo $reservationId ?>"
                                            data-value="<?php echo $totalPaidAmount->getValue(true) ?>">
										<?php echo $totalPaidAmount->format() ?>
									</a>
									</span>
                                </li>
                                <li><label><?php echo Text::_('SR_RESERVATION_DUE_AMOUNT') ?></label> <span
                                            id="total_due"><?php echo $totalDueAmount->format() ?></span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                    <h3>
                        <?php echo Text::_('SR_CUSTOMER_INFO') ?>
	                    <?php if ($canEdit): ?>
		                    <?php if (SRPlugin::isEnabled('user') && $this->form->getValue('customer_id')): ?>
                                <a class="hasTooltip link-ico"
                                   href="<?php echo Route::_('index.php?option=com_solidres&task=customer.edit&id=' . $this->form->getValue('customer_id'), false); ?>"
                                   title="<?php echo Text::_('SR_VIEW_PROFILE', true); ?>" target="_blank">
                                    <i class="fa fa-address-card" aria-hidden="true"></i>
                                </a>
		                    <?php endif; ?>

		                    <?php if ($this->form->getValue('customer_id') > 0 || !empty($customerName)): ?>
			                    <?php
			                    $customerName = trim($this->form->getValue('customer_firstname') . ' ' . $this->form->getValue('customer_middlename') . ' ' . $this->form->getValue('customer_lastname'));
                                $filterCustomer = 'customer=' . ($this->form->getValue('customer_id') ? $this->form->getValue('customer_id') : urlencode($customerName)); ?>

                                <a class="hasTooltip link-ico"
                                   href="<?php echo Route::_('index.php?option=com_solidres&view=reservations&' . $filterCustomer, false); ?>"
                                   title="<?php echo Text::_('SR_VIEW_OTHER_RESERVATIONS', true); ?>"
                                   target="_blank">
                                    <i class="fa fa-search-plus" aria-hidden="true"></i>
                                </a>
		                    <?php endif; ?>
	                    <?php endif; ?>
                    </h3>
					<?php

					$assetId       = (int) $this->form->getValue('reservation_asset_id');
					$reservationId = (int) $this->form->getValue('id');
					$fields        = [];

					if ($fieldEnabled)
					{
						$app        = JFactory::getApplication();
						$scope      = $app->scope;
						$app->scope = 'com_solidres.manage';
						$fields     = SRCustomFieldHelper::findFields(['context' => 'com_solidres.customer'], $cid, $this->form->getValue('customer_language') ?: null);
						$app->scope = $scope;
					}

					if (count($fields)):
						$fieldsValues = SRCustomFieldHelper::getValues(['context' => 'com_solidres.customer.' . $reservationId]);
						SRCustomFieldHelper::setFieldDataValues($fieldsValues);
						$customFieldLength = count($fields);
						$partialNumber     = ceil($customFieldLength / 2);
						$rootUrl           = Uri::root(true);
						$token             = JSession::getFormToken();
						$renderValue       = function ($field) use ($rootUrl, $token) {
							$value = SRCustomFieldHelper::displayFieldValue($field->field_name);

							if ($field->type == 'file')
							{
								$file     = base64_encode($value);
								$fileName = basename($value);

								if (strpos($fileName, '_') !== false)
								{
									$parts    = explode('_', $fileName, 2);
									$fileName = $parts[1];
								}

								$value = '<a href="' . Route::_('index.php?option=com_solidres&task=customfield.downloadFile&file=' . $file . '&' . $token . '=1', false) . '" style="max-width: 180px" target="_blank">' . $fileName . '</a>';
							}

							return $value;
						};

						?>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                            <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                <ul class="reservation-details">
									<?php for ($i = 0; $i <= $partialNumber; $i++): ?>
                                        <li>
                                            <label><?php echo Text::_($fields[$i]->title); ?></label>
											<?php echo $renderValue($fields[$i]); ?>
                                        </li>
									<?php endfor; ?>
                                </ul>
                            </div>
                            <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                <ul class="reservation-details">
									<?php for ($i = $partialNumber + 1; $i < $customFieldLength; $i++): ?>
                                        <li>
                                            <label><?php echo Text::_($fields[$i]->title); ?></label>
											<?php echo $renderValue($fields[$i]); ?>
                                        </li>
									<?php endfor; ?>
                                </ul>
                            </div>
                        </div>
					<?php else: ?>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                            <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                <ul class="reservation-details">
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_TITLE") ?></label> <?php echo $this->form->getValue('customer_title') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_FIRSTNAME") ?></label> <?php echo $this->form->getValue('customer_firstname') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_MIDDLENAME") ?></label> <?php echo $this->form->getValue('customer_middlename') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_LASTNAME") ?></label> <?php echo $this->form->getValue('customer_lastname') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_EMAIL") ?></label>

                                        <?php if ($mail = $this->form->getValue('customer_email')): ?>
                                        <a href="mailto:<?php echo $mail ?>">
	                                        <?php echo $mail ?>
                                        </a>
                                        <?php endif; ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_PHONE") ?></label>
	                                    <?php if ($phone = $this->form->getValue('customer_phonenumber')): ?>
                                            <a href="tel:<?php echo $phone ?>">
			                                    <?php echo $phone ?>
                                            </a>
	                                    <?php endif; ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_MOBILEPHONE") ?></label>
	                                    <?php if ($phone = $this->form->getValue('customer_mobilephone')): ?>
                                            <a href="tel:<?php echo $phone ?>">
			                                    <?php echo $phone ?>
                                            </a>
	                                    <?php endif; ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_COMPANY") ?></label> <?php echo $this->form->getValue('customer_company') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_IP") ?></label> <?php echo $this->form->getValue('customer_ip', '') ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                <ul class="reservation-details">
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_ADDRESS1") ?></label> <?php echo $this->form->getValue('customer_address1') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_ADDRESS2") ?></label> <?php echo $this->form->getValue('customer_address2') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_CITY") ?></label> <?php echo $this->form->getValue('customer_city') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_CUSTOMER_ZIPCODE") ?></label> <?php echo $this->form->getValue('customer_zipcode') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_FIELD_COUNTRY_LABEL") ?></label> <?php echo $this->form->getValue('customer_country_name') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_FIELD_GEO_STATE_LABEL") ?></label> <?php echo $this->form->getValue('customer_geostate_name') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_VAT_NUMBER") ?></label> <?php echo $this->form->getValue('customer_vat_number') ?>
                                    </li>
                                    <li>
                                        <label><?php echo Text::_("SR_NOTES") ?></label><?php echo $this->form->getValue('note') ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
					<?php endif; ?>
                </div>
            </div>

			<?php
			$paymentData = $this->form->getValue('payment_data');
			if (!empty($paymentData) && $paymentMethodId == 'offline') :
				$paymentData = json_decode($paymentData);
				?>
                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                    <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                        <h3><?php echo Text::_("SR_CUSTOMER_PAYMENT_INFO") ?>
                            <a href="<?php echo Route::_('index.php?option=com_solidres&task=reservationbase.deletePaymentData&id=' . $reservationId . '&' . JSession::getFormToken() . '=1') ?>"
                               id="payment-data-delete-btn"
                               class="btn btn-mini"><i class="fa fa-times"
                                                       aria-hidden="true"></i> <?php echo Text::_('SR_DELETE_RESERVATION_PAYMENT_DATA') ?>
                            </a>
                        </h3>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                <ul>
									<?php
									foreach ($paymentData as $key => $value) :
										if ($key == 'cardnumber') :
											$value = str_pad($value, 16, 'X', STR_PAD_RIGHT);
										endif;
										echo '<li>' . Text::_('PLG_SOLIDRESPAYMENT_OFFLINE_' . $key) . ': ' . $value . '</li>';
									endforeach;
									?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
			<?php endif ?>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box booked_room_extra_info">

                    <h3><?php echo Text::_("SR_ROOM_EXTRA_INFO") ?></h3>

					<?php
					$reservedRoomDetails = $this->form->getValue('reserved_room_details', []);

                    if (empty($reservedRoomDetails)) :
	                    echo '<div class="alert alert-warning">' . Text::_('SR_NO_ASSIGNED_ROOMS') . '</div>';
                    else:
                        foreach ($reservedRoomDetails as $room) :
                            $totalRoomCost = 0;
                            ?>
                            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                    <?php
                                    $roomTypeLink = Route::_('index.php?option=com_solidres&view=roomtype&layout=edit&id=' . $room->room_type_id);
                                    echo '<h4><a href="' . $roomTypeLink . '">' . $room->room_type_name . ' (' . $room->room_label . ')</a></h4>'
                                    ?>
                                    <ul>
                                        <li>
                                            <p class="help-inline">
                                                <i class="fa fa-ticket"> </i>
                                                <?php echo strip_tags($room->tariff_title)
                                                    . (!empty($room->tariff_description) ? ' - ' . strip_tags($room->tariff_description) : '') ?>
                                            </p>
                                        </li>
                                        <?php if (isset($room->guest_fullname) && !empty($room->guest_fullname)) : ?>
                                            <li>
                                                <label><?php echo Text::_("SR_GUEST_FULLNAME") ?></label> <?php echo $room->guest_fullname ?>
                                            </li>
                                        <?php endif ?>
                                        <li>
                                            <?php
                                            if (is_array($room->other_info)) :
                                                foreach ($room->other_info as $info) :
                                                    if (substr($info->key, 0, 7) == 'smoking') :
                                                        echo '<label>' . Text::_('SR_' . $info->key) . '</label> ' . ($info->value == '' ? Text::_('SR_NO_PREFERENCES') : ($info->value == 1 ? Text::_('SR_YES') : Text::_('SR_NO')));
                                                    endif;
                                                endforeach;
                                            endif
                                            ?>
                                        </li>
                                        <li>
                                            <label><?php echo Text::_("SR_ADULT_NUMBER") ?></label> <?php echo $room->adults_number ?>
                                        </li>
                                        <?php if ($room->children_number > 0) : ?>
                                            <li>
                                                <label class="toggle_child_ages"><?php echo Text::_("SR_CHILDREN_NUMBER") ?><?php echo $room->children_number > 0 ? '<i class="icon-plus-2 fa fa-plus"></i>' : '' ?> </label> <?php echo $room->children_number ?>
                                                <?php
                                                if (is_array($room->other_info)) :
                                                    echo '<ul class="unstyled" id="booked_room_child_ages" style="display: none">';
                                                    foreach ($room->other_info as $info) :
                                                        if (substr($info->key, 0, 5) == 'child') :
                                                            echo '<li><label>' . Text::_('SR_' . $info->key) . '</label> ' . Text::plural('SR_CHILD_AGE_SELECTION', $info->value) . '</li>';
                                                        endif;
                                                    endforeach;
                                                    echo '</ul>';
                                                endif;
                                                ?>
                                            </li>
                                        <?php endif ?>

                                        <?php

                                        if (!empty($roomFields))
                                        {
                                            $roomFieldsValues = SRCustomFieldHelper::getValues(['context' => 'com_solidres.room.' . $room->id]);
                                            SRCustomFieldHelper::setFieldDataValues($roomFieldsValues);

                                            echo '<li class="page-header"></li>';

                                            foreach ($roomFields as $roomField)
                                            {
                                                echo '<li><label>' . Text::_($roomField->title) . '</label> ' . SRCustomFieldHelper::displayFieldValue($roomField, null, true) . '</li>';
                                            }
                                        }

                                        ?>
                                    </ul>
                                </div>
                                <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                                    <div class="booked_room_cost_wrapper">
                                        <?php
                                        $roomPriceCurrency = clone $baseCurrency;
                                        $roomPriceCurrency->setValue($room->room_price_tax_incl);
                                        $totalRoomCost += $room->room_price_tax_incl;
                                        ?>
                                        <ul class="unstyled">
                                            <li>
                                                <label>
                                                    <?php echo Text::_('SR_BOOKED_ROOM_COST') ?>
                                                </label>
                                                <span class="booked_room_cost"><?php echo $roomPriceCurrency->format() ?></span>
                                            </li>
                                            <?php
                                            if (isset($room->extras)) :
                                                foreach ($room->extras as $extra) :
                                                    ?>
                                                    <li>
                                                        <label><?php echo '<a href="' . Route::_('index.php?option=com_solidres&view=extra&layout=edit&id=' . $extra->extra_id) . '">' . $extra->extra_name . ' (x' . $extra->extra_quantity . ')</a>' ?></label>
                                                        <?php
                                                        $extraPriceCurrency = clone $baseCurrency;
                                                        $extraPriceCurrency->setValue($extra->extra_price);
                                                        $totalRoomCost += $extra->extra_price;
                                                        echo '<span class="booked_room_extra_cost">' . $extraPriceCurrency->format() . '</span>';
                                                        ?>
                                                    </li>
                                                <?php
                                                endforeach;
                                            endif; ?>
                                            <li>
                                                <label><strong><?php echo Text::_('SR_BOOKED_ROOM_COST_TOTAL') ?></strong></label>
                                                <span class="booked_room_cost">
                                                <strong>
                                                <?php
                                                $totalRoomCostCurrency = clone $baseCurrency;
                                                $totalRoomCostCurrency->setValue($totalRoomCost);
                                                echo $totalRoomCostCurrency->format();
                                                ?>
                                                </strong>
                                            </span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach;
                    endif;
                    ?>
                </div>
            </div>
			<?php
			if (SRPlugin::isEnabled('invoice')):
				$displayData = array(
					'invoiceTable' => $this->invoiceTable[0],
					'form'         => $this->form,
					'returnPage'   => ''
				);
				SRLayoutHelper::addIncludePath(SR_PLUGIN_INVOICE_PATH . '/layouts');
				echo SRLayoutHelper::render('invoices.invoice', $displayData);
			else :?>
                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                    <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                        <h3>Invoice</h3>
                        <div class="alert alert-info">
                            This feature allows you to create pdf attachment, generate invoices, manage invoices and
                            send them to your customers.
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin Solidres Invoice is not installed or enabled. <a
                                    target="_blank" href="https://www.solidres.com/subscribe/levels">Become a subscriber
                                and download it now.</a>
                        </div>
                    </div>
                </div>
			<?php endif; ?>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                    <h3><?php echo Text::_('SR_RESERVATION_OTHER_INFO') ?></h3>
					<?php
					$extras = $this->form->getValue('extras');
					if (isset($extras)) :
						echo '
						<table class="table table-condensed">
							<thead>
								<th>' . Text::_("SR_RESERVATION_ROOM_EXTRA_NAME") . '</th>
								<th>' . Text::_("SR_RESERVATION_ROOM_EXTRA_QUANTITY") . '</th>
								<th>' . Text::_("SR_RESERVATION_ROOM_EXTRA_PRICE") . '</th>
							</thead>
							<tbody>
											';
						foreach ($extras as $extra) :
							echo '<tr>';
							?>
                            <td><?php echo $extra->extra_name ?></td>
                            <td><?php echo $extra->extra_quantity ?></td>
                            <td>
								<?php
								$extraPriceCurrencyPerBooking = clone $baseCurrency;
								$extraPriceCurrencyPerBooking->setValue($extra->extra_price);
								echo $extraPriceCurrencyPerBooking->format();
								?>
                            </td>
							<?php
							echo '</tr>';
						endforeach;
						echo '
							</tbody>
						</table>';
					endif;
					?>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER; ?>">
                <div class="<?php echo SR_UI_GRID_COL_12; ?> reservation-detail-box">
                    <h3><?php echo Text::_('SR_PAYMENT_HISTORY'); ?></h3>
					<?php SolidresHelper::displayPaymentHistory($reservationId); ?>
                </div>
            </div>

            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                    <h3><?php echo Text::_('SR_RESERVATION_NOTE_BACKEND') ?></h3>
                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
                            <form id="reservationnote-form"
                                  action="index.php?option=com_solidres&task=reservationnote.save&format=json">
                                <textarea rows="5" name="text" class="form-control input-block-level"
                                          placeholder="<?php echo Text::_('SR_RESERVATION_NOTE_PLACEHOLDER') ?>"></textarea>
                                <label class="checkbox">
                                    <input type="checkbox" name="notify_customer" value="1">
									<?php echo Text::_("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER") ?>
                                </label>
                                <label class="checkbox">
                                    <input type="checkbox" name="visible_in_frontend" value="1">
									<?php echo Text::_("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND") ?>
                                </label>
                                <div class="processing nodisplay"></div>
                                <button type="submit" class="btn <?php echo SR_UI_BTN_DEFAULT ?>"><?php echo Text::_("SR_SUBMIT") ?></button>
                                <input name="reservation_id" type="hidden" value="<?php echo $reservationId ?>"/>
								<?php echo HTMLHelper::_('form.token'); ?>

                            </form>
                        </div>
                        <div class="<?php echo SR_UI_GRID_COL_6 ?> reservation-note-holder">
							<?php
							$notes = $this->form->getValue('notes');
							if (!empty($notes)) :
								foreach ($notes as $note) :
									?>
                                    <div class="reservation-note-item">
                                        <p class="info">
											<?php echo $note->created_date ?> by <?php echo $note->username ?>
                                        </p>
                                        <p>
											<?php echo Text::_("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER") ?>
                                            : <?php echo $note->notify_customer == 1 ? Text::_('JYES') : Text::_('JNO') ?>
                                            |
											<?php echo Text::_("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND") ?>
                                            : <?php echo $note->visible_in_frontend == 1 ? Text::_('JYES') : Text::_('JNO') ?></p>
                                        <p>
											<?php echo $note->text ?>
                                        </p>
                                    </div>
								<?php
								endforeach;
							endif;
							?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                <div class="<?php echo SR_UI_GRID_COL_12 ?> reservation-detail-box">
                    <h3><?php echo Text::_('SR_STREAM'); ?></h3>
					<?php if (SRPlugin::isEnabled('stream')): ?>
						<?php SolidresStreamHelper::displayByScope('reservation', $this->form->getValue('id')); ?>
					<?php else: ?>
                        <div class="alert alert-info">
                            This feature allows you listen to all Solidres's events and record them
                        </div>
                        <div class="alert alert-success">
                            <strong>Notice:</strong> plugin <strong>Stream</strong> is not installed or enabled.
                            <a target="_blank"
                               href="https://www.solidres.com/subscribe/levels">Become
                                a subscriber and download it now.</a>
                        </div>
					<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?> powered">
            <p>Powered by <a href="https://www.solidres.com" target="_blank">Solidres</a></p>
        </div>
    </div>
</div>
<form action="<?php Route::_('index.php?option=com_solidres&view=reservations'); ?>" method="post" name="adminForm"
      id="item-form" class="">
    <input type="hidden" name="task" value=""/>
    <input type="hidden" name="id" value="<?php echo $id > 0 ? $id : '' ?>"/>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
