<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;

/**
 * View to edit a reservation asset.
 *
 * @package       Solidres
 * @subpackage    ReservationAsset
 * @since         0.1.0
 */
class SolidresViewReservationAsset extends JViewLegacy
{
	protected $form;

	public function display($tpl = null)
	{
		$this->form = $this->get('Form');

		if ($errors = $this->get('Errors'))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		$this->lat           = $this->form->getValue('lat', '');
		$this->lng           = $this->form->getValue('lng', '');
		$this->solidresMedia = SRFactory::get('solidres.media.media');

		HTMLHelper::_('stylesheet', 'com_solidres/assets/main.min.css', array('version' => SRVersion::getHashVersion(), 'relative' => true));
		SRHtml::_('jquery.geocomplete');
		JFactory::getDocument()->addScriptDeclaration('
			Solidres.jQuery(function($){
				$("#geocomplete").geocomplete({
					map: ".map_canvas",
					details: "",
					location: ' . (!empty($this->lat) && !empty($this->lng) ? json_encode(array($this->lat, $this->lng)) : 'false') . ',
					markerOptions: {
						draggable: true
					}
				});

				$("#geocomplete").bind("geocode:dragged", function(event, latLng){
					$("#update").attr("data-lat", latLng.lat());
					$("#update").attr("data-lng", latLng.lng());
					$("#update").show();
				});

				$("#geocomplete").bind("geocode:result", function(event, result){
					var lat = result.geometry.location.lat();
					var lng = result.geometry.location.lng();
					lat = lat.toString().substr(0, 17);
					lng = lng.toString().substr(0, 17);
					$("input#jform_lat").val(lat);
					$("input#jform_lng").val(lng);
					$("#update").attr("data-lat", lat);
					$("#update").attr("data-lng", lng);
					$("#update").show();
				});

				$("#update").click(function(){
					$("input#jform_lat").val($(this).attr("data-lat"));
					$("input#jform_lng").val($(this).attr("data-lng"));
				});

				$("#reset").click(function(){
					$("#geocomplete").geocomplete("resetMarker");
					$("#update").hide();
					return false;
				});

				$("#find").click(function(){
					$("#geocomplete").trigger("geocode");
				});

				$(".geocoding").keyup(function() {
					var str = [];
					$(".geocoding").each(function() {
						var val = $(this).val();
						if (val != "") {
							str.push(val);
						}
					});
					$("#geocomplete").val(str.join(", "));
				});
			});
		');

		JLoader::register('SRSystemHelper', JPATH_LIBRARIES . '/solidres/system/helper.php');

		if (SR_ISJ3)
		{
			HTMLHelper::_('behavior.tabstate');
		}

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$user       = JFactory::getUser();
		$id         = $this->form->getValue('id');
		$isNew      = ($id == 0);
		$checkedOut = !($this->form->getValue('checked_out') == 0 || $this->form->getValue('checked_out') == $user->get('id'));
		$canDo      = SolidresHelper::getActions('', $id);

		if ($isNew)
		{
			ToolBarHelper::title(JText::_('SR_ADD_NEW_ASSET'));
		}
		else
		{
			ToolBarHelper::title(JText::sprintf('SR_EDIT_ASSET', $this->form->getValue('name')));
		}

		// If not checked out, can save the item.
		if (!$checkedOut && $canDo->get('core.edit'))
		{
			ToolBarHelper::apply('reservationasset.apply');
			ToolBarHelper::save('reservationasset.save');
			ToolBarHelper::save2new('reservationasset.save2new');
		}

		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
		{
			ToolBarHelper::save2copy('reservationasset.save2copy');
		}

		if ($menuId = (int) $this->form->getValue('menu_id'))
		{
			$bar    = JToolBar::getInstance();
			$app    = JApplicationCms::getInstance('site');
			$router = $app::getRouter('site');
			$uri    = $router->build('index.php?Itemid=' . $menuId);

			$bar->appendButton('Link', 'eye', 'SR_VIEW_MENU_IN_FRONEND', str_replace('administrator/', '', $uri->toString()));
		}

		ToolbarHelper::cancel('reservationasset.cancel', empty($id) ? 'JToolbar_Cancel' : 'JToolbar_Close');

		SRToolBarHelper::mediaManager();

		if (SR_ISJ4)
		{
			ToolbarHelper::inlinehelp();
		}
	}
}
