<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JLoader::register('SolidresHelper', JPATH_COMPONENT_ADMINISTRATOR . '/helpers/helper.php');
JLoader::register('SolidresControllerReservationBase', JPATH_COMPONENT_ADMINISTRATOR . '/controllers/reservationbase.json.php');

use Joomla\CMS\Plugin\PluginHelper;

/**
 * Controller to handle one-page reservation form
 *
 * @package       Solidres
 * @subpackage    Reservation
 * @since         0.1.0
 */
class SolidresControllerReservation extends SolidresControllerReservationBase
{
	public function removeCoupon()
	{
		$context = 'com_solidres.reservation.process';
		$status  = false;

		$currentAppliedCoupon = $this->app->getUserState($context . '.coupon');

		if ($currentAppliedCoupon['coupon_id'] == $this->app->input->get('id', 0, 'int'))
		{
			$this->app->setUserState($context . '.coupon', null);
			$status = true;
		}

		$response = array('status' => $status, 'message' => '');

		echo json_encode($response);

		$this->app->close();
	}

	public function requestBooking()
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		try
		{
			JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables');
			$assetTable = JTable::getInstance('ReservationAsset', 'SolidresTable');
			$assetId    = $this->input->getInt('assetId');

			if ($assetTable->load($assetId))
			{
				$name    = $this->input->getString('fullname');
				$phone   = $this->input->getString('phone');
				$email   = $this->input->getString('email');
				$message = $this->input->getString('message');
				$params  = new Joomla\Registry\Registry($assetTable->params);

				if ($params->get('use_captcha'))
				{
					JPluginHelper::importPlugin('captcha', 'recaptcha');
					$results = JFactory::getApplication()->triggerEvent('onCheckAnswer');

					if (in_array(false, $results, true))
					{
						throw new Exception('Invalid captcha');
					}
				}

				$recipients = array();

				if ($assetTable->get('email') && filter_var($assetTable->get('email'), FILTER_VALIDATE_EMAIL))
				{
					$recipients[] = $assetTable->get('email');
				}

				$additional = explode(',', $params->get('additional_notification_emails'));

				if (count($additional))
				{
					foreach ($additional as $mail)
					{
						if (filter_var($mail, FILTER_VALIDATE_EMAIL))
						{
							$recipients[] = $mail;
						}
					}
				}

				if (empty($recipients))
				{
					throw new Exception('Recipients not found.');
				}

				$mailer = JFactory::getMailer();
				$mailer->setSender(array(
					$this->app->get('mailfrom'),
					$this->app->get('fromname')
				));

				$mailer->addRecipient($recipients);
				$mailer->isHtml(false);
				$mailer->setSubject(JText::plural('SR_INQUIRY_FORM_SEND_MAIL_SUBJECT_PLURAL', strtoupper($name), strtoupper($assetTable->name)));
				$body = $params->get('email_content_format');

				if (empty($body))
				{
					$body = 'Hi,
									You have a new booking inquiry for ' . ucfirst($assetTable->name) . ' via ' . $this->app->get('sitename') . ':
									Name: ' . $name . '
									Email: ' . $email . '
									Phone: ' . $phone . '
									Message: ' . $message . '
									Cheers,';
				}
				else
				{
					$body = str_replace(
						array('{site_name}', '{asset_name}', '{name}', '{phone}', '{email}', '{message}'),
						array($this->app->get('sitename'), ucfirst($assetTable->name), $name, $phone, $email, $message),
						$body
					);
				}

				$mailer->setBody($body);

				if ($mailer->send())
				{
					$response = array(
						'status'  => 'success',
						'message' => JText::_('SR_INQUIRY_FORM_SEND_MAIL_SUCCESS_MESSAGE')
					);
				}

			}
		}
		catch (Exception $e)
		{
			$response = array(
				'status'  => 'error',
				'message' => $e->getMessage()
			);
		}

		echo json_encode($response);

		$this->app->close();
	}

	public function fetchPaymentStatus()
	{
		JSession::checkToken('GET') or jexit(JText::_('JINVALID_TOKEN'));

		PluginHelper::importPlugin('solidrespayment');

		$reservationId          = $this->input->get('id', 0, 'uint');
		$reservationCode        = $this->input->get('code', '', 'string');
		$solidresConfig         = JComponentHelper::getParams('com_solidres');
		$confirmedPaymentStatus = $solidresConfig->get('confirm_payment_state', 1);

		if ($reservationId > 0 && !empty($reservationCode))
		{
			JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables');
			$reservationTable = JTable::getInstance('Reservation', 'SolidresTable');

			if ($reservationTable->load($reservationId) && $reservationTable->code == $reservationCode)
			{
				$isConfirmed = $reservationTable->payment_status == $confirmedPaymentStatus;

				$this->app->triggerEvent('onReservationCheckConfirmed', [$this->context, $reservationTable, &$isConfirmed]);

				echo json_encode([
					'completed' => $isConfirmed ? 1 : 0
				]);
			}
		}

		$this->app->close();
	}
}