<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * Content Component Route Helper
 *
 * @static
 * @package     Joomla.Site
 * @subpackage  com_content
 * @since       1.5
 */
abstract class SolidresHelperRoute
{
	protected static $lookup = array();

	protected static $lang_lookup = array();

	public static function getReservationAssetRoute($id, $roomTypeId = null, $language = 0, $data = [], $config = [])
	{
		$view = $config['view'] ?? 'reservationasset';

		// view => id
		$needles = array();
		if (SRPlugin::isEnabled('hub'))
		{
			$needles = array(
				$view => array((int) $id)
			);
		}

		$link = "index.php?option=com_solidres&view=$view&id=$id";

		if (!empty($data))
		{
			$link .= '&' . http_build_query($data);
		}

		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();

			if (isset(self::$lang_lookup[$language]))
			{
				$link                .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}

		if (isset($roomTypeId) && $view == 'reservationasset')
		{
			$link .= '#srt_' . $roomTypeId;
		}

		return $link;
	}

	public static function getRoomTypeRoute($id, $language = 0)
	{
		$needles = array(
			'roomtype' => array((int) $id)
		);

		$link = 'index.php?option=com_solidres&view=roomtype&id=' . $id;

		if ($language && $language != "*" && JLanguageMultilang::isEnabled())
		{
			self::buildLanguageLookup();

			if (isset(self::$lang_lookup[$language]))
			{
				$link                .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}

		return $link;
	}

	protected static function buildLanguageLookup()
	{
		if (count(self::$lang_lookup) == 0)
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('a.sef AS sef')
				->select('a.lang_code AS lang_code')
				->from('#__languages AS a');

			$db->setQuery($query);
			$langs = $db->loadObjectList();

			foreach ($langs as $lang)
			{
				self::$lang_lookup[$lang->lang_code] = $lang->sef;
			}
		}
	}

	protected static function _findItem($needles = null)
	{
		$app      = JFactory::getApplication();
		$menus    = $app->getMenu('site');
		$language = $needles['language'] ?? '*';

		// Prepare the reverse lookup array.
		if (!isset(self::$lookup[$language]))
		{
			self::$lookup[$language] = array();

			$component = JComponentHelper::getComponent('com_solidres');

			$attributes = array('component_id');
			$values     = array($component->id);

			if ($language != '*')
			{
				$attributes[] = 'language';
				$values[]     = array($needles['language'], '*');
			}

			$items = $menus->getItems($attributes, $values);

			foreach ($items as $item)
			{
				if (isset($item->query) && isset($item->query['view']))
				{
					$view = $item->query['view'];

					if (!isset(self::$lookup[$language][$view]))
					{
						self::$lookup[$language][$view] = array();
					}

					if (isset($item->query['id']))
					{

						// here it will become a bit tricky
						// language != * can override existing entries
						// language == * cannot override existing entries
						if (!isset(self::$lookup[$language][$view][$item->query['id']]) || $item->language != '*')
						{
							self::$lookup[$language][$view][$item->query['id']] = $item->id;
						}
					}
					else
					{
						self::$lookup[$language][$view][0] = $item->id;
					}
				}
			}
		}

		if ($needles)
		{
			foreach ($needles as $view => $ids)
			{
				if (isset(self::$lookup[$language][$view]))
				{
					foreach ($ids as $id)
					{
						if (isset(self::$lookup[$language][$view][(int) $id]))
						{
							return self::$lookup[$language][$view][(int) $id];
						}
					}
				}
			}
		}

		// If not found, return the HUB search page
		$component  = JComponentHelper::getComponent('com_solidres');
		$attributes = array('component_id');
		$values     = array($component->id);

		if ($language != '*')
		{
			$attributes[] = 'language';
			$values[]     = array($needles['language'], '*');
		}

		$items = $menus->getItems($attributes, $values);
		foreach ($items as $item)
		{
			if ($item->query['view'] == 'search')
			{
				return $item->id;
			}
		}

		// Check if the active menuitem matches the requested language
		$active = $menus->getActive();
		if ($active && $active->component == 'com_solidres' && ($language == '*' || in_array($active->language, array('*', $language)) || !JLanguageMultilang::isEnabled()))
		{
			return $active->id;
		}

		// If not found, return language specific home link
		$default = $menus->getDefault($language);

		return !empty($default->id) ? $default->id : null;
	}

	public static function getPartnerRoute($partnerId = null, $language = '*', $layout = 'default')
	{
		if (null === $partnerId)
		{
			$partnerId = SRUtilities::getPartnerId();
		}

		$partnerId = (int) $partnerId;
		$needles   = ['partner' => [$partnerId, 0]];
		$link      = 'index.php?option=com_solidres&view=partner&id=' . $partnerId;

		if ($language
			&& $language !== '*'
			&& JLanguageMultilang::isEnabled()
		)
		{
			self::buildLanguageLookup();

			if (isset(self::$lang_lookup[$language]))
			{
				$link                .= '&lang=' . self::$lang_lookup[$language];
				$needles['language'] = $language;
			}
		}

		if ('default' !== $layout)
		{
			$link .= '&layout=' . $layout;
		}

		if ($item = self::_findItem($needles))
		{
			$link .= '&Itemid=' . $item;
		}

		return $link;
	}
}
