<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/asset/checkinoutform_style1.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

?>

<div class="inner sr-datepickers">
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <label for="checkin_roomtype">
				<?php echo JText::_('SR_SEARCH_CHECKIN_DATE') ?>
            </label>
            <div class="checkin_roomtype datefield <?php echo SR_UI != 'bs2' ? 'form-control' : '' ?>" data-placeholder="<?php echo JText::_('SR_CHECKIN_PLACEHOLDER') ?>">
				<?php echo JText::_('SR_CHECKIN_PLACEHOLDER') ?>
                <i class="fa fa-calendar"></i>
            </div>
            <div class="checkin_datepicker_inline datepicker_inline" style="display: none"></div>
			<?php // this field must always be "Y-m-d" as it is used internally only ?>
            <input type="hidden" name="checkin" value=""/>
        </div>
        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <label for="checkout_roomtype">
				<?php echo JText::_('SR_SEARCH_CHECKOUT_DATE') ?>
            </label>
            <div class="checkout_roomtype datefield <?php echo SR_UI != 'bs2' ? 'form-control' : '' ?> disabledCalendar"
                 data-placeholder="<?php echo JText::_('SR_CHECKOUT_PLACEHOLDER') ?>">
				<?php echo JText::_('SR_CHECKOUT_PLACEHOLDER') ?>
                <i class="fa fa-calendar"></i>
            </div>
            <div class="checkout_datepicker_inline datepicker_inline" style="display: none"></div>
			<?php // this field must always be "Y-m-d" as it is used internally only ?>
            <input type="hidden" name="checkout" value=""/>
        </div>
    </div>
    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_12 ?>">
            <input type="hidden" name="fts" value="<?php echo time() ?>"/>

            <button type="button"
                    class="btn btn-block btn-primary primary searchbtn"
                    data-roomtypeid="<?php echo $displayData['roomTypeId'] ?>"
                    data-tariffid="<?php echo $displayData['tariff']->id ?>"
                    disabled>
                <i class="fa fa-search "></i> <?php echo JText::_('SR_SEARCH') ?>
            </button>
        </div>
    </div>
</div>