<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/asset/guestform.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

extract($displayData);

$subLayout = SRLayoutHelper::getInstance();
$subLayout->addIncludePath(JPATH_COMPONENT . '/components/com_solidres/layouts');

?>

<form enctype="multipart/form-data"
      id="sr-reservation-form-guest"
      class="sr-reservation-form form-stacked sr-validate"
      action="<?php echo JUri::base() ?>index.php?option=com_solidres&task=reservation<?php echo $isSite ? '' : 'base' ?>.process&step=guestinfo&format=json"
      method="POST">

    <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-top">

        <div class="<?php echo SR_UI_GRID_COL_8 ?>">
            <div class="inner">
				<?php if ($isSite) : ?>
                    <p><?php echo JText::_('SR_GUEST_INFO_STEP_NOTICE') ?></p>
				<?php endif ?>
            </div>
        </div>

        <div class="<?php echo SR_UI_GRID_COL_4 ?>">
            <div class="inner">
                <div class="btn-group">
                    <?php
                    $returnUrl = $reservationDetails->room['return'] ?? '';
                    if (!empty($returnUrl) && 1 == $type) :
                    ?>
                        <a class="btn <?php echo SR_UI_BTN_DEFAULT ?>" href="<?php echo base64_decode($returnUrl) ?>">
                            <i class="fa fa-arrow-left"></i> <?php echo JText::_('SR_BACK') ?>
                        </a>
                        <button data-step="guestinfo" type="submit" class="btn btn-success notxtsubs">
                            <i class="fa fa-lock"></i> <?php echo JText::_('SR_BUTTON_RESERVATION_FINAL_SUBMIT') ?>
                        </button>
                    <?php else: ?>
                        <button type="button" class="btn <?php echo SR_UI_BTN_DEFAULT ?> reservation-navigate-back" data-step="guestinfo"
                                data-prevstep="room">
                            <i class="fa fa-arrow-left"></i> <?php echo JText::_('SR_BACK') ?>
                        </button>
                        <button data-step="guestinfo" type="submit" class="btn btn-success">
                            <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                        </button>
                    <?php endif ?>
                </div>
            </div>
        </div>
    </div>

	<?php if ($isSite) : ?>
        <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                <div class="inner">
                    <h3><?php echo JText::_('SR_GUEST_INFORMATION') ?></h3>
                </div>
            </div>
        </div>
	<?php endif ?>

    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <div class="inner">
                <fieldset>
					<?php if (isset($guestFields[0])): ?>
						<?php echo $guestFields[0]; ?>
					<?php else: ?>
                        <div class="form-group">
                            <label for="firstname">
								<?php echo JText::_("SR_CUSTOMER_TITLE") ?>
                            </label>
							<?php
							echo JHtml::_("select.genericlist", $customerTitles, "jform[customer_title]", array("class" => 'form-control input-block-level', 'required'), "value", "text", $selectedCustomerTitle, "")
							?>
                        </div>
                        <div class="form-group">
                            <label for="firstname">
								<?php echo JText::_("SR_FIRSTNAME") ?>
                            </label>
                            <input id="firstname"
                                   required
                                   name="jform[customer_firstname]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_firstname"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="middlename">
								<?php echo JText::_("SR_MIDDLENAME") ?>
                            </label>
                            <input id="middlename"
                                   name="jform[customer_middlename]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_middlename"] ?? "" ?>"/>

                        </div>
                        <div class="form-group">
                            <label for="lastname">
								<?php echo JText::_("SR_LASTNAME") ?>
                            </label>
                            <input id="lastname"
                                   required
                                   name="jform[customer_lastname]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_lastname"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="email">
								<?php echo JText::_("SR_EMAIL") ?>
                            </label>
                            <input id="email"
                                   required
                                   name="jform[customer_email]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_email"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="confirm-email">
								<?php echo JText::_('SR_CONFIRM_EMAIL') ?>
                            </label>
                            <input id="confirm-email"
                                   required
                                   name="jform[customer_email2]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest['customer_email2'] ?? '' ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="phonenumber">
								<?php echo JText::_("SR_PHONENUMBER") ?>
                            </label>
                            <input id="phonenumber"
                                   required
                                   name="jform[customer_phonenumber]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_phonenumber"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="mobilephone">
								<?php echo JText::_("SR_MOBILEPHONE") ?>
                            </label>
                            <input id="mobilephone"
                                   name="jform[customer_mobilephone]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_mobilephone"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="company">
								<?php echo JText::_("SR_COMPANY") ?>
                            </label>
                            <input id="company"
                                   name="jform[customer_company]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_company"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="address1">
								<?php echo JText::_("SR_ADDRESS_1") ?>
                            </label>
                            <input id="address1"
                                   required
                                   name="jform[customer_address1]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_address1"] ?? "" ?>"/>

                        </div>
                        <div class="form-group">
                            <label for="address2">
								<?php echo JText::_("SR_ADDRESS_2") ?>
                            </label>
                            <input id="address2"
                                   name="jform[customer_address2]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_address2"] ?? "" ?>"/>
                        </div>
					<?php endif; ?>
                </fieldset>
            </div>
        </div>

        <div class="<?php echo SR_UI_GRID_COL_6 ?>">
            <div class="inner">
                <fieldset>
					<?php if (isset($guestFields[1])): ?>
						<?php echo $guestFields[1]; ?>
					<?php else: ?>
                        <div class="form-group">
                            <label for="vat_number">
								<?php echo JText::_("SR_VAT_NUMBER") ?>
                            </label>
                            <input id="vat_number"
                                   name="jform[customer_vat_number]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_vat_number"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="city"><?php echo JText::_("SR_CITY") ?></label>
                            <input id="city"
                                   required
                                   name="jform[customer_city]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_city"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="zip"><?php echo JText::_("SR_ZIP") ?></label>
                            <input id="zip"
                                   name="jform[customer_zipcode]"
                                   type="text"
                                   class="form-control input-block-level"
                                   value="<?php echo $reservationDetails->guest["customer_zipcode"] ?? "" ?>"/>
                        </div>
                        <div class="form-group">
                            <label for="jform[country_id]"><?php echo JText::_("SR_COUNTRY") ?></label>

							<?php
							$selectedCountryId = $reservationDetails->guest["customer_country_id"] ?? 0;
							echo JHtml::_("select.genericlist", $countries, "jform[customer_country_id]", array("class" => "country_select form-control input-block-level", 'required' => 'required'), "value", "text", $selectedCountryId, "country");
							?>
                        </div>
                        <div class="form-group">
                            <label for="jform[customer_geo_state_id]"><?php echo JText::_("SR_STATE") ?></label>
							<?php
							$selectedGeoStateId = $reservationDetails->guest["customer_geo_state_id"] ?? 0;

							echo JHtml::_("select.genericlist", $geoStates, "jform[customer_geo_state_id]", array("class" => "state_select form-control input-block-level"), "value", "text", $selectedGeoStateId, "state");
							?>
                        </div>
                        <div class="form-group">
                            <label for="note"><?php echo JText::_("SR_NOTE") ?></label>
                            <textarea id="note" name="jform[note]" rows="10" cols="30"
                                      placeholder="<?php echo JText::_("SR_RESERVATION_NOTE") ?>"
                                      class="form-control input-block-level"><?php echo $reservationDetails->guest["note"] ?? "" ?></textarea>
                        </div>
					<?php endif; ?>
					<?php if (SRPlugin::isEnabled('user') && $user->get('id') <= 0 && (!$disableCustomerRegistration)) : ?>
                        <div class="form-group">
                            <label class="checkbox">
                                <input id="register_an_account_form"
                                       type="checkbox"
                                       <?php echo $forceCustomerRegistration ? 'checked disabled style="display:none"' : '' ?>
                                > <?php echo JText::_('SR_REGISTER_WITH_US_TEXT') ?>
                            </label>
                            <div class="register_an_account_form" <?php echo $forceCustomerRegistration ? '' : 'style="display: none"' ?>>
                                <div class="form-group">
                                    <label for="username">
										<?php echo JText::_("SR_USERNAME") ?>
                                    </label>
                                    <input id="username"
                                           name="jform[customer_username]"
                                           type="text"
                                           class="form-control input-block-level"
                                           <?php echo $forceCustomerRegistration ? 'required' : '' ?>
                                           value=""/>
                                </div>
                                <div class="form-group">
                                    <label for="password">
										<?php echo JText::_("SR_PASSWORD") ?>
                                    </label>
                                    <input id="password"
                                           name="jform[customer_password]"
                                           type="password"
                                           class="form-control input-block-level"
                                           <?php echo $forceCustomerRegistration ? 'required' : '' ?>
                                           value=""
                                           autocomplete="off"
                                    />
                                </div>

                                <?php if (JPluginHelper::isEnabled('system', 'privacyconsent')): ?>
                                <div class="<?php echo SR_UI_FORM_ROW; ?>">
                                    <label class="checkbox inline">
                                        <input name="jform[privacyConsent]"
                                               type="checkbox"
                                               value="1"
                                               id="privacy-consent"
                                        />
		                                <?php echo JText::_('SR_PRIVACY_CONSENT_NOTE'); ?>
                                    </label>
                                </div>
                                <?php endif; ?>

                            </div>
                        </div>
					<?php endif ?>
                </fieldset>
            </div>
        </div>
    </div>

	<?php echo $subLayout->render('asset.guestform_extras', $displayData); ?>

	<?php echo $subLayout->render('asset.payments', $displayData); ?>

    <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-bottom">
        <div class="<?php echo SR_UI_GRID_COL_8 ?>">
            <div class="inner">
				<?php if ($isSite) : ?>
                    <p><?php echo JText::_('SR_GUEST_INFO_STEP_NOTICE') ?></p>
				<?php endif ?>
            </div>
        </div>
        <div class="<?php echo SR_UI_GRID_COL_4 ?>">
            <div class="inner">
                <div class="btn-group">
	                <?php
	                $returnUrl = $reservationDetails->room['return'] ?? '';
	                if (!empty($returnUrl) && 1 == $type) :
	                ?>
                        <a class="btn <?php echo SR_UI_BTN_DEFAULT ?>" href="<?php echo base64_decode($returnUrl) ?>">
                            <i class="fa fa-arrow-left"></i> <?php echo JText::_('SR_BACK') ?>
                        </a>
                        <button data-step="guestinfo" type="submit" class="btn btn-success notxtsubs">
                            <i class="fa fa-lock"></i> <?php echo JText::_('SR_BUTTON_RESERVATION_FINAL_SUBMIT') ?>
                        </button>
	                <?php else: ?>
                        <button type="button" class="btn <?php echo SR_UI_BTN_DEFAULT ?> reservation-navigate-back" data-step="guestinfo"
                                data-prevstep="room">
                            <i class="fa fa-arrow-left"></i> <?php echo JText::_('SR_BACK') ?>
                        </button>
                        <button data-step="guestinfo" type="submit" class="btn btn-success">
                            <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                        </button>
	                <?php endif ?>

                </div>
            </div>
        </div>
    </div>

	<?php echo JHtml::_("form.token") ?>
    <input type="hidden" name="jform[next_step]" value="confirmation"/>
    <?php if ($type == 1) : ?>
    <input type="hidden" name="jform[static]" value="1"/>
    <?php endif ?>
</form>