<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/asset/roomtypeform_extras.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.12.1
 */

defined('_JEXEC') or die;

extract($displayData);

if (is_array($extras) && count($extras) > 0) :
    echo '<h5 class="extras_toggle" data-target="' . $identity . '" title="' . JText::_('SR_EXTRAS_TOGGLE_HINT') . '">' . JText::_('SR_EXTRAS') . ' <span class="fa fa-sort"></span></h5>';
	foreach ($extras as $extra) :
		if (8 == $extra->charge_type && !$extra->allow_early_arrival) :
			continue;
		endif;
		$extraInputCommonName = 'jform[room_types][' . $roomTypeId . '][' . $tariffId . '][' . $i . '][extras][' . $extra->id . ']';
		$checked              = '';
		$disabledCheckbox     = '';
		$disabledSelect       = 'disabled="disabled"';
		$alreadySelected      = false;
		if (isset($currentRoomIndex['extras'])) :
			$alreadySelected = array_key_exists($extra->id, (array) $currentRoomIndex['extras']);
		endif;

		if ($extra->mandatory == 1 || $alreadySelected) :
			$checked = 'checked="checked"';
		endif;

		if ($extra->mandatory == 1) :
			$disabledCheckbox = 'disabled="disabled"';
			$disabledSelect   = 'disabled="disabled"';
		endif;

		if ($alreadySelected && $extra->mandatory == 0) :
			$disabledSelect = '';
		endif;
		?>
		<div class="<?php echo SR_UI_GRID_CONTAINER ?>">
			<div class="<?php echo SR_UI_GRID_COL_12 ?> extras_row_roomtypeform extras_row_roomtypeform_<?php echo $identity ?>"
			     id="extras_row_roomtypeform_<?php echo $identity ?>_<?php echo $extra->id ?>"
                 style="<?php echo $extrasDefaultVisibility ? '' : 'display: none' ?>">

				<input <?php echo $checked ?> <?php echo $disabledCheckbox ?> type="checkbox"
				                                                              data-target="extra_<?php echo $identity ?>_<?php echo $extra->id ?>"
				                                                              data-extraid="<?php echo $extra->id ?>"
				/>
				<?php if ($extra->mandatory == 1) : ?>
					<input type="hidden" name="<?php echo $extraInputCommonName ?>[quantity]"
					       value="1"/>
				<?php endif ?>

				<select class="<?php echo SR_UI_GRID_COL_2 ?> form-control extra_quantity trigger_tariff_calculating"
				        id="extra_<?php echo $identity ?>_<?php echo $extra->id ?>"
				        data-raid="<?php echo $assetId ?>"
				        data-roomtypeid="<?php echo $roomTypeId ?>"
				        data-tariffid="<?php echo $tariffId ?>"
				        data-adjoininglayer="<?php echo $adjoiningLayer ?>"
				        data-roomindex="<?php echo $i ?>"
				        data-max="<?php echo isset($tariff->p_max) && $tariff->p_max > 0 ? $tariff->p_max : $roomType->occupancy_max ?>"
				        data-min="<?php echo isset($tariff->p_min) && $tariff->p_min > 0 ? $tariff->p_min : 0 ?>"
				        data-identity="<?php echo $identity ?>"
				        name="<?php echo $extraInputCommonName ?>[quantity]"
					<?php echo $disabledSelect ?>>
					<?php
					for ($quantitySelection = 1; $quantitySelection <= $extra->max_quantity; $quantitySelection++) :
						$checked = '';
						if (isset($currentRoomIndex['extras'][$extra->id]['quantity'])) :
							$checked = ($currentRoomIndex['extras'][$extra->id]['quantity'] == $quantitySelection) ? 'selected' : '';
						endif;
						?>
						<option <?php echo $checked ?>
							value="<?php echo $quantitySelection ?>"><?php echo $quantitySelection ?></option>
					<?php
					endfor;
					?>
				</select>
				<span>
                    <?php echo $extra->name ?>
                    <a href="javascript:void(0)"
                       class="toggle_extra_details"
                       data-target="extra_details_<?php echo $tariffId ?>_<?php echo $i ?>_<?php echo $extra->id ?>">
                        <?php echo JText::_('SR_EXTRA_MORE_DETAILS') ?>
                    </a>
                </span>
				<span class="extra_details"
				      id="extra_details_<?php echo $tariffId ?>_<?php echo $i ?>_<?php echo $extra->id ?>"
				      style="display: none">
                <?php if ($extra->charge_type == 3 || $extra->charge_type == 5 || $extra->charge_type == 6) : ?>
                    <span>
                        <?php echo JText::_('SR_EXTRA_PRICE_ADULT') . ': ' . $extra->currencyAdult->format() . ' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) . ')' ?>
                    </span>
                    <span>
                        <?php echo JText::_('SR_EXTRA_PRICE_CHILD') . ': ' . $extra->currencyChild->format() . ' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) . ')' ?>
                    </span>
                <?php elseif ($extra->charge_type == 7 || $extra->charge_type == 8) : ?>
                    <span>
                        <?php echo JText::sprintf('SR_EXTRA_PRICE_DAILY_RATE', $extra->name, ($extra->price * 100)) . ' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) . ')' ?>
                    </span>
                <?php else : ?>
                    <span>
                        <?php echo JText::_('SR_EXTRA_PRICE') . ': ' . $extra->currency->format() . ' (' . JText::_(SRExtra::$chargeTypes[$extra->charge_type]) . ')' ?>
                    </span>
                <?php endif; ?>

                    <span>
                        <?php echo $extra->description ?>
                    </span>
                </span>
			</div>
		</div>
	<?php
	endforeach;
endif;