<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/asset/roomtypeform_style3.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

extract($displayData);

$subLayout = SRLayoutHelper::getInstance();
$subLayout->addIncludePath(JPATH_COMPONENT . '/components/com_solidres/layouts');
$pMax = isset($tariff->p_max) && $tariff->p_max > 0 ? $tariff->p_max : $roomType->occupancy_max;
$pMin = isset($tariff->p_min) && $tariff->p_min > 0 ? $tariff->p_min : 0;
$inputNamePrefix = "jform[room_types][$roomTypeId][$tariffId][$i]";
$costPrefix = $roomType->params['is_exclusive'] ? JText::_('SR_COST') : JText::_($roomType->is_private ? 'SR_ROOM' : 'SR_BED') . ' ' . ($i + 1);
?>

    <div class="room-form">
        <div class="<?php echo SR_UI_GRID_CONTAINER ?> room-form-item">
            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                <div class="<?php echo SR_UI_GRID_CONTAINER ?> room_index_form_heading">
                    <div class="inner">
                        <h4><?php echo $costPrefix ?>: <span class="tariff_<?php echo $identity ?>">0</span>
                            <a href="javascript:void(0)"
                               class="toggle_breakdown"
                               data-target="<?php echo $identity ?>">
								<?php echo JText::_('SR_VIEW_TARIFF_BREAKDOWN') ?>
                            </a>
                        </h4>
                        <span style="display: none" class="breakdown" id="breakdown_<?php echo $identity ?>"></span>
                    </div>
                </div>
                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?> occupancy-selection">
                            <div class="inner">
								<?php if ($roomType->params['show_adult_option'] == 1) : ?>
                                    <select
                                            data-raid="<?php echo $assetId ?>"
                                            data-roomtypeid="<?php echo $roomTypeId ?>"
                                            data-tariffid="<?php echo $tariffId ?>"
                                            data-adjoininglayer="<?php echo $adjoiningLayer ?>"
                                            data-roomindex="<?php echo $i ?>"
                                            data-max="<?php echo $pMax ?>"
                                            data-min="<?php echo $pMin ?>"
                                            name="<?php echo $inputNamePrefix ?>[adults_number]"
                                            required
                                            data-identity="<?php echo $identity ?>"
                                            class="<?php echo SR_UI_GRID_COL_6 ?> adults_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $tariffId ?>_<?php echo $roomTypeId ?> occupancy_adult_<?php echo $identity ?> trigger_tariff_calculating">
										<?php echo $htmlAdultSelection ?>
                                    </select>
								<?php else :
									if (!$showGuestOption) : ?>
                                        <input type="hidden"
                                               data-raid="<?php echo $assetId ?>"
                                               data-roomtypeid="<?php echo $roomTypeId ?>"
                                               data-tariffid="<?php echo $tariffId ?>"
                                               data-adjoininglayer="<?php echo $adjoiningLayer ?>"
                                               data-roomindex="<?php echo $i ?>"
                                               data-max="<?php echo $pMax ?>"
                                               data-min="<?php echo $pMin ?>"
                                               name="<?php echo $inputNamePrefix ?>[adults_number]"
                                               class="<?php echo SR_UI_GRID_COL_6 ?> adults_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $tariffId ?>_<?php echo $roomTypeId ?> occupancy_adult_<?php echo $identity ?> trigger_tariff_calculating"
                                               value="1"
                                               data-identity="<?php echo $identity ?>"
                                        />
									<?php endif ?>
								<?php endif ?>
								<?php if ($roomType->params['show_child_option'] == 1 && $roomType->occupancy_child > 0) : ?>
                                    <select
                                            data-raid="<?php echo $assetId ?>"
                                            data-roomtypeid="<?php echo $roomTypeId ?>"
                                            data-roomindex="<?php echo $i ?>"
                                            data-max="<?php echo $pMax ?>"
                                            data-min="<?php echo $pMin ?>"
                                            data-tariffid="<?php echo $tariffId ?>"
                                            data-adjoininglayer="<?php echo $adjoiningLayer ?>"
                                            data-identity="<?php echo $identity ?>"
                                            name="<?php echo $inputNamePrefix ?>[children_number]"
                                            class="<?php echo SR_UI_GRID_COL_6 ?> children_number occupancy_max_constraint occupancy_max_constraint_<?php echo $i ?>_<?php echo $tariffId ?>_<?php echo $roomTypeId ?> reservation-form-child-quantity trigger_tariff_calculating occupancy_child_<?php echo $identity ?>">
										<?php echo $htmlChildSelection ?>
                                    </select>
								<?php endif ?>
								<?php if ($showGuestOption) : ?>
                                    <select
                                            data-raid="<?php echo $assetId ?>"
                                            data-roomtypeid="<?php echo $roomTypeId ?>"
                                            data-tariffid="<?php echo $tariffId ?>"
                                            data-adjoininglayer="<?php echo $adjoiningLayer ?>"
                                            data-roomindex="<?php echo $i ?>"
                                            data-max="<?php echo $pMax ?>"
                                            data-min="<?php echo $pMin ?>"
                                            name="<?php echo $inputNamePrefix ?>[guests_number]"
                                            required
                                            data-identity="<?php echo $identity ?>"
                                            class="<?php echo SR_UI_GRID_COL_6 ?> guests_number trigger_tariff_calculating">
										<?php echo $htmlGuestSelection ?>
                                    </select>
								<?php endif; ?>
                                <div class="alert alert-warning"
                                     id="error_<?php echo $i ?>_<?php echo $tariffId ?>_<?php echo $roomTypeId ?>"
                                     style="display: none">
									<?php echo JText::sprintf('SR_ROOM_OCCUPANCY_CONSTRAINT_NOT_SATISFIED', $tariff->p_min, $tariff->p_max) ?>
                                </div>
                                <div
                                        class="child-age-details <?php echo(empty($htmlChildrenAges) ? 'nodisplay' : '') ?>">
                                    <p><?php echo JText::_('SR_AGE_OF_CHILD_AT_CHECKOUT') ?></p>
                                    <ul class="unstyled list-unstyled"><?php echo $htmlChildrenAges ?></ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                        <div class="inner">
							<?php if ($roomType->params['show_guest_name_field'] == 1) : ?>
                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                        <input name="<?php echo $inputNamePrefix ?>[guest_fullname]"
											<?php echo $roomType->params['guest_name_optional'] == 0 ? 'required' : '' ?>
                                               type="text"
                                               class="form-control <?php echo SR_UI_GRID_COL_12 ?>"
                                               value="<?php echo(isset($currentRoomIndex['guest_fullname']) ? $currentRoomIndex['guest_fullname'] : '') ?>"
                                               placeholder="<?php echo JText::_('SR_GUEST_NAME') ?>"/>
                                    </div>
                                </div>
							<?php endif ?>

							<?php if (!empty($htmlSmokingOption)) : ?>
                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
										<?php echo $htmlSmokingOption ?>
                                    </div>
                                </div>
							<?php endif ?>

                            <!-- Room Form -->
	                        <?php

	                        if (!empty($roomFields))
	                        {
		                        foreach ($roomFields as $roomField)
		                        {
			                        $field = clone $roomField;
			                        $field->field_name = 'roomFields][' . $tariffId . '][' . $field->id . '][' . $i;
			                        $field->inputId    = 'roomFields-' . $tariffId . '-' . $field->id . '-' . $i;
			                        $field->id         = $field->inputId;

			                        if (isset($reservationDetails->room['roomFields'][$tariffId][$roomField->id][$i]))
			                        {
				                        $field->value = $reservationDetails->room['roomFields'][$tariffId][$roomField->id][$i];
			                        }

			                        echo SRCustomFieldHelper::render($field);
			                        unset($field);
		                        }
	                        }

	                        ?>

	                        <?php echo $subLayout->render('asset.roomtypeform_extras', $displayData); ?>

                            <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                    <button data-step="room" type="submit"
                                            class="btn btn-success input-block-level">
                                        <i class="fa fa-arrow-right"></i>
										<?php echo JText::_('SR_NEXT') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>