<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/layouts/com_solidres/joomla/toolbar/standard.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('JPATH_BASE') or die;

use Joomla\CMS\Factory;

if (SR_ISJ4)
{
    extract($displayData, EXTR_OVERWRITE);

    /**
     * Layout variables
     * -----------------
     * @var   string  $id
     * @var   string  $onclick
     * @var   string  $class
     * @var   string  $text
     * @var   string  $btnClass
     * @var   string  $tagName
     * @var   string  $htmlAttributes
     * @var   string  $task             The task which should be executed
     * @var   bool    $listCheck        Boolean, whether selection from a list is needed
     * @var   string  $form             CSS selector for a target form
     * @var   bool    $formValidation   Whether the form need to be validated before run the task
     * @var   string  $message          Confirmation message before run the task
     */

    Factory::getDocument()->getWebAssetManager()
        ->useScript('core')
        ->useScript('webcomponent.toolbar-button');

    $tagName  = $tagName ?? 'button';

    $taskAttr = '';
    $idAttr   = !empty($id)             ? ' id="' . $id . '"' : '';
    $listAttr = !empty($listCheck)      ? ' list-selection' : '';
    $formAttr = !empty($form)           ? ' form="' . $this->escape($form) . '"' : '';
    $validate = !empty($formValidation) ? ' form-validation' : '';
    $msgAttr  = !empty($message)        ? ' confirm-message="' . $this->escape($message) . '"' : '';

    if (!empty($task))
    {
        $taskAttr = ' task="' . $task . '"';
    }
    elseif (!empty($onclick))
    {
        $htmlAttributes .= ' onclick="' . $onclick . '"';
    }

    ?>

    <joomla-toolbar-button <?php echo $idAttr . $taskAttr . $listAttr . $formAttr . $validate . $msgAttr; ?>>
        <?php if (!empty($group)) : ?>
            <a href="#" class="dropdown-item">
                <span class="<?php echo trim($class ?? ''); ?>"></span>
                <?php echo $text ?? ''; ?>
            </a>
        <?php else : ?>
        <<?php echo $tagName; ?>
        class="<?php echo $btnClass ?? ''; ?>"
        <?php echo $htmlAttributes ?? ''; ?>
        >
        <span class="<?php echo trim($class ?? ''); ?>" aria-hidden="true"></span>
        <?php echo $text ?? ''; ?>
    </<?php echo $tagName; ?>>
    <?php endif; ?>
    </joomla-toolbar-button>

    <?php
}
else
{
    JHtml::_('behavior.core');

    $doTask      = $displayData['doTask'];
    $class       = $displayData['class'];
    $text        = $displayData['text'];
    $btnClass    = $displayData['btnClass'];
    $iconMapping = array(
        'icon-new'              => 'fa fa-plus-circle',
        'icon-new icon-white'   => 'fa fa-plus-square-o',
        'icon-apply icon-white' => 'fa fa-pencil-square-o',
        'icon-edit'             => 'fa fa-edit',
        'icon-publish'          => 'fa fa-check',
        'icon-unpublish'        => 'fa fa-close',
        'icon-trash'            => 'fa fa-trash',
        'icon-copy'             => 'fa fa-copy',
        'icon-cancel'           => 'fa fa-times-circle',
        'icon-save'             => 'fa fa-check',
        'icon-download'         => 'fa fa-download',
        'icon-save-new'         => 'fa fa-plus',
        'icon-save-copy'        => 'fa fa-clone',
        'icon-delete'           => 'fa fa-remove'
    );

    ?>
    <button onclick="<?php echo $doTask; ?>" class="<?php echo SR_UI_BTN_DEFAULT ?> btn-sm <?php echo $btnClass; ?>">
        <span class="<?php //echo trim($class); ?> <?php echo $iconMapping[trim($class)] ?>"></span>
        <?php echo $text; ?>
    </button>

    <?php
}