<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

/*
 * This layout file can be overridden by copying to:
 *
 * /templates/TEMPLATENAME/html/com_solidres/reservationasset/default_roomtype.php
 *
 * However, occasionally we will need to update template/layout related files and it is the template developers'
 * responsibility to update the overridden files (if any) to maintain full compatibility with Solidres.
 *
 * We do not provide support if any of the overridden files are out of date and are not compatible with Solidres.
 *
 * @version 2.8.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

$this->document->addScriptDeclaration('
    Solidres.jQuery(function($){
        $(".carousel").carousel();
    });
');

if (!$this->isAmending) :
    echo SRLayoutHelper::render('asset.coupon_form', array(
        'asset'   => $this->item,
        'coupon'  => $this->coupon,
        'isFresh' => $this->isFresh
    ));
endif;

$layout = SRLayoutHelper::getInstance();
?>

<a id="book-form"></a>

<?php if (!empty($this->item->email) || !empty($this->item->params['show_inquiry_form'])): ?>
	<?php echo $this->loadTemplate('inquiry_form'); ?>
<?php endif; ?>
<?php if (isset($this->item->params['show_inline_checkavailability_form'])
	&& $this->item->params['show_inline_checkavailability_form'] == 1
	&& !$this->disableOnlineBooking
    && !$this->isAmending
) : ?>
    <div id="asset-checkavailability-form">
        <div class="inner">
			<?php echo $this->loadTemplate('checkavailability'); ?>
        </div>
    </div>
<?php endif ?>

<?php if ($this->isAmending) : ?>
<h2><?php echo JText::_('SR_AMENDING_HEADING') ?></h2>
<?php endif ?>

<?php if (!$this->disableOnlineBooking) : ?>
    <div class="wizard wizard-default">
        <ul class="<?php echo SR_UI_GRID_CONTAINER ?> steps list-inline">
            <li data-target="#step1"
                class="list-inline-item active reservation-tab reservation-tab-room <?php echo SR_UI_GRID_COL_4 ?>">
                <span class="badge badge-info">1</span><?php echo JText::_('SR_STEP_ROOM_AND_RATE') ?><span
                        class="chevron"></span></li>
            <li data-target="#step2"
                class="list-inline-item reservation-tab reservation-tab-guestinfo <?php echo SR_UI_GRID_COL_4 ?>"><span
                        class="badge bg-secondary">2</span><?php echo JText::_('SR_STEP_GUEST_INFO_AND_PAYMENT') ?><span
                        class="chevron"></span></li>
            <li data-target="#step3"
                class="list-inline-item reservation-tab reservation-tab-confirmation <?php echo SR_UI_GRID_COL_4 ?>">
                <span class="badge bg-secondary">3</span><?php echo JText::_('SR_STEP_CONFIRMATION') ?></li>
        </ul>
    </div>
<?php endif ?>

<div class="step-content">
    <div class="step-pane active" id="step1">
        <!-- Tab 1 -->
        <div class="reservation-single-step-holder room room-default">
			<?php
            if ($this->prioritizingRoomTypeId == 0) :
                echo $this->loadTemplate('searchinfo');
            endif;
            ?>
            <form enctype="multipart/form-data"
                  id="sr-reservation-form-room"
                  class="sr-reservation-form"
                  action="<?php echo JUri::base() ?>index.php?option=com_solidres&task=reservation.process&step=room&format=json"
                  method="POST">
				<?php if (count($this->item->roomTypes) > 0) : ?>
					<?php if (!$this->isFresh) : ?>
                        <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-top"
                             style="<?php echo $this->isSingular ? 'display: none' : '' ?>">
                            <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                                <div class="inner">
                                    <p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
                                </div>
                            </div>
                            <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                                <div class="inner">
                                    <div class="btn-group">
                                        <button data-step="room" type="submit" class="btn btn-success">
                                            <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
					<?php endif ?>

					<?php
					$count = 1;
					$prioritizingRoomTypeName = '';
					$countNotPrioritizing = 0;
					if ($this->prioritizingRoomTypeId > 0) :
						$countNotPrioritizing = count($this->item->roomTypes) - 1;
                    endif;

					foreach ($this->item->roomTypes as $roomType) :
						if (isset($roomType->defaultTariffBreakDown)) :
							$defaultTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
							foreach ($roomType->defaultTariffBreakDown as $key => $breakDownDetails) :
								if ($key % 7 == 0 && $key == 0) :
									$defaultTariffBreakDownHtml .= '<tr>';
                                elseif ($key % 7 == 0) :
									$defaultTariffBreakDownHtml .= '</tr><tr>';
								endif;
								$tmpKey                     = key($breakDownDetails);
								$defaultTariffBreakDownHtml .= '<td><p>' . $this->dayMapping[$tmpKey] . '</p><span class=\"' . $this->tariffNetOrGross . '\">' . $breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format() . '</span>';
							endforeach;
							$defaultTariffBreakDownHtml .= '</tr></table>';

							$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".default_tariff_break_down_' . $roomType->id . '").popover({
							html: true,
							content: "' . $defaultTariffBreakDownHtml . '",
							title: "' . JText::_('SR_TARIFF_BREAK_DOWN') . '",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
						endif;

						if (isset($roomType->complexTariffBreakDown)) :
							$complexTariffBreakDownHtml = '<table class=\"tariff-break-down\">';
							foreach ($roomType->complexTariffBreakDown as $key => $breakDownDetails) :
								if ($key % 7 == 0 && $key == 0) :
									$complexTariffBreakDownHtml .= '<tr>';
                                elseif ($key % 7 == 0) :
									$complexTariffBreakDownHtml .= '</tr><tr>';
								endif;
								$tmpKey                     = key($breakDownDetails);
								$complexTariffBreakDownHtml .= '<td><p>' . $this->dayMapping[$tmpKey] . '</p><span class=\"' . $this->tariffNetOrGross . '\">' . $breakDownDetails[$tmpKey][$this->tariffNetOrGross]->format() . '</span>';
							endforeach;

							$complexTariffBreakDownHtml .= '</tr></table>';
							$this->document->addScriptDeclaration('
					Solidres.jQuery(function($){
						$(".complex_tariff_break_down_' . $roomType->id . '").popover({
							html: true,
							content: "' . $complexTariffBreakDownHtml . '",
							title: "' . JText::_('SR_TARIFF_BREAK_DOWN') . '",
							placement: "bottom",
							trigger: "click"
						});
					});
				');
						endif;

						$this->document->addScriptDeclaration('
				Solidres.jQuery(function($){
					$(".sr-photo-' . $roomType->id . '").colorbox({rel:"sr-photo-' . $roomType->id . '", transition:"fade", width: "98%", height: "98%", className: "colorbox-w"});
				});
			');

						$rowCSSClass                        = ($count % 2) ? ' even' : ' odd';
						$rowCSSClass                        .= $roomType->featured == 1 ? ' featured' : '';
						$rowCSSClass                        .= ' room_type_row';
						$currentSelectedRoomNumberPerTariff = array();

						if (!is_array($roomType->params)) :
							$roomType->params = json_decode($roomType->params, true);
						endif;

						$skipRoomForm       = (bool) ($roomType->params['skip_room_form'] ?? false);
						$isExclusive        = (bool) ($roomType->params['is_exclusive'] ?? false);
						$showRemainingRooms = (bool) ($roomType->params['show_number_remaining_rooms'] ?? true);
						$showMoreInfo       = (bool) ($roomType->params['show_more_info_button'] ?? true);
						$regex              = '#<hr(.*)id="system-readmore"(.*)\/>#iU';
						$intro              = $full = '';

						if (preg_match($regex, $roomType->description))
						{
							list($intro, $full) = preg_split($regex, $roomType->description, 2);

							$roomType->text = $intro;
						}
						else
						{
							$roomType->text = $roomType->description;
						}

						JFactory::getApplication()->triggerEvent('onContentPrepare', array('com_solidres.roomtype', &$roomType, &$roomType->params, 0));

						$isPrioritizingRoomType = false;
						if ($this->prioritizingRoomTypeId == $roomType->id) :
							$isPrioritizingRoomType = true;
							$rowCSSClass .= " prioritizing";
							$prioritizingRoomTypeName = $roomType->name;
						endif;

					    if ($this->prioritizingRoomTypeId > 0 && $count == 2) :
                            if ($countNotPrioritizing > 1) :
                                $msg = 'SR_PRIORITIZING_ROOMTYPE_NOTICE';
                            else:
	                            $msg = 'SR_PRIORITIZING_ROOMTYPE_NOTICE_1';
                            endif;

                            echo '<div class="prioritizing-roomtype-notice">' . JText::sprintf($msg, $prioritizingRoomTypeName, $countNotPrioritizing) . '</div>';
                        endif;
						?>

                        <div class="<?php echo SR_UI_GRID_CONTAINER ?> <?php echo $rowCSSClass ?> "
                             id="room_type_row_<?php echo $roomType->id ?>"
                             <?php echo $this->prioritizingRoomTypeId > 0 && !$isPrioritizingRoomType ? 'style="display: none"' : '' ?>
                        >
                            <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_12 ?>">
                                        <div class="inner">
                                            <h4 class="roomtype_name" id="srt_<?php echo $roomType->id ?>">
									<span class="badge bg-secondary">
										<?php echo $roomType->occupancy_max > 0 ? $roomType->occupancy_max : (int) $roomType->occupancy_adult + (int) $roomType->occupancy_child ?>
                                        <i class="fa fa-user"></i>
									</span>

												<?php echo $roomType->name; ?>
												<?php if ($roomType->featured == 1) : ?>
                                                    <span class="label label-info"><?php echo JText::_('SR_FEATURED_ROOM_TYPE') ?></span>
												<?php endif ?>
                                                <?php if ($isPrioritizingRoomType) : ?>
                                                    <span class="label label-warning"><?php echo JText::_('SR_PRIORITIZING_ROOM_TYPE') ?></span>
                                                <?php endif ?>
                                            </h4>
                                        </div>
                                    </div>
                                </div>

                                <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                    <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                                        <div class="inner">
	                                        <?php
	                                        if (!empty($roomType->media)) :
		                                        echo $layout->render('solidres.carousel', [
			                                        'id'            => 'carousel' . $roomType->id,
			                                        'items'         => $roomType->media,
			                                        'objectId'      => $roomType->id,
			                                        'objectName'    => $roomType->name,
			                                        'solidresMedia' => $this->solidresMedia,
			                                        'linkItem'      => true,
			                                        'size'          => 'roomtype_medium'
		                                        ]);
	                                        endif;
	                                        ?>
                                        </div>
                                    </div>

                                    <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                                        <div class="inner">
                                            <div class="roomtype_desc">
                                                <?php
                                                if (!empty($intro) && !empty($full)) :
                                                    $modalId = 'roomtype_desc_' . $roomType->id;
	                                                echo $roomType->text . '<a href="javascript:void(0)" data-toggle="modal" data-bs-toggle="modal" data-target="#' . $modalId . '" data-bs-target="#' . $modalId . '">' . Text::_('SR_READMORE') . '</a>';

	                                                echo HTMLHelper::_(
		                                                'bootstrap.renderModal',
		                                                $modalId,
		                                                [
			                                                'title'  => Text::_('SR_ABOUT_THIS_SPACE'),
			                                                'footer' => '<button type="button" class="btn btn-secondary" data-dismiss="modal" data-bs-dismiss="modal" aria-hidden="true">'
				                                                . Text::_("JLIB_HTML_BEHAVIOR_CLOSE") . '</button>'
		                                                ],
		                                                $roomType->text . $full
	                                                );
                                                else :
                                                    echo $roomType->text;
                                                endif;
                                                ?>
                                            </div>
											<?php
											if (!$this->isFresh && !empty($roomType->availableTariffs) && $showRemainingRooms) :
												if (isset($roomType->totalAvailableRoom) && $roomType->number_of_room > 1) :
													?>
                                                    <p>
									<span class="num_rooms_available_msg"
                                          id="num_rooms_available_msg_<?php echo $roomType->id ?>"
                                          data-original-text="<?php echo JText::plural('SR_WE_HAVE_X_' . ($roomType->is_private ? 'ROOM' : 'BED') . '_LEFT', $roomType->totalAvailableRoom) ?>">
										<?php echo JText::plural('SR_WE_HAVE_X_' . ($roomType->is_private ? 'ROOM' : 'BED') . '_LEFT', $roomType->totalAvailableRoom) ?>
									</span>
                                                    </p>
												<?php
												endif;
											endif;
											?>

											<?php if (!empty($roomType->facilities)): ?>
                                                <?php echo '<h3>' .  Text::_('SR_CUSTOMFIELD_FACILITIES') . '</h3>'; ?>
												<?php echo SRLayoutHelper::render('facility.facility', array('facilities' => $roomType->facilities)); ?>
											<?php endif; ?>

											<?php if ($showMoreInfo) : ?>
                                                <button type="button" class="btn <?php echo SR_UI_BTN_DEFAULT ?> toggle_more_desc"
                                                        data-target="<?php echo $roomType->id ?>">
                                                    <i class="fa fa-eye"></i>
													<?php echo JText::_('SR_SHOW_MORE_INFO') ?>
                                                </button>
											<?php endif ?>

											<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
                                                <button type="button" data-roomtypeid="<?php echo $roomType->id ?>"
                                                        class="btn <?php echo SR_UI_BTN_DEFAULT ?> load-calendar">
                                                    <i class="fa fa-calendar"></i> <?php echo JText::_('SR_AVAILABILITY_CALENDAR_VIEW') ?>
                                                </button>
											<?php endif ?>

											<?php if (SRPlugin::isEnabled('complextariff') && $this->showTariffs) : ?>
                                                <button type="button" data-roomtypeid="<?php echo $roomType->id ?>"
                                                        class="btn <?php echo SR_UI_BTN_DEFAULT ?> toggle-tariffs">
													<?php if ($this->showTariffs && $this->defaultTariffVisibility == 1) : ?>
                                                        <i class="fa fa-compress"></i> <?php echo JText::_('SR_HIDE_TARIFFS') ?>
													<?php else : ?>
                                                        <i class="fa fa-expand"></i> <?php echo JText::_('SR_SHOW_TARIFFS') ?>
													<?php endif ?>
                                                </button>
											<?php endif ?>

                                            <div class="unstyled more_desc" id="more_desc_<?php echo $roomType->id ?>"
                                                 style="display: none">
												<?php
												if (!empty($roomType->roomtype_custom_fields['room_facilities'])) :
													echo '<p><strong>' . JText::_('SR_ROOM_FACILITIES') . ':</strong> ' . $roomType->roomtype_custom_fields['room_facilities'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['room_size'])) :
													echo '<p><strong>' . JText::_('SR_ROOM_SIZE') . ':</strong> ' . $roomType->roomtype_custom_fields['room_size'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['bed_size'])) :
													echo '<p><strong>' . JText::_('SR_BED_SIZE') . ':</strong> ' . $roomType->roomtype_custom_fields['bed_size'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['taxes'])) :
													echo '<p><strong>' . JText::_('SR_TAXES') . ':</strong> ' . $roomType->roomtype_custom_fields['taxes'] . '</p>';
												endif;

												if (!empty($roomType->roomtype_custom_fields['prepayment'])) :
													echo '<p><strong>' . JText::_('SR_PREPAYMENT') . ':</strong> ' . $roomType->roomtype_custom_fields['prepayment'] . '</p>';
												endif;

												?>
                                            </div>
                                        </div>
                                    </div> <!-- end of span8 -->
                                </div> <!-- end of row-fluid -->

								<?php if ($this->config->get('availability_calendar_enable', 1)) : ?>
                                    <div class="<?php echo SR_UI_GRID_CONTAINER ?>">
                                        <div class="<?php echo SR_UI_GRID_COL_12 ?> availability-calendar"
                                             id="availability-calendar-<?php echo $roomType->id ?>"
                                             style="display: none">
                                        </div>
                                    </div>
								<?php endif ?>

								<?php if (SRPlugin::isEnabled('flexsearch')) :
									$layout->addIncludePath(SRPlugin::getLayoutPath('flexsearch'));
									echo $layout->render('roomtype.flexsearch', array('roomType' => $roomType, 'bookingType' => $this->item->booking_type, 'enableAutoScroll' => $this->enableAutoScroll));
								endif ?>

	                            <?php
	                            $ratePlansData = [
		                            'item'                    => $this->item,
		                            'roomType'                => $roomType,
		                            'isFresh'                 => $this->isFresh,
		                            'bookingType'             => $this->item->booking_type,
		                            'disableOnlineBooking'    => $this->disableOnlineBooking,
		                            'skipRoomForm'            => $skipRoomForm,
		                            'isExclusive'             => $isExclusive,
		                            'showRemainingRooms'      => $showRemainingRooms,
		                            'stayLength'              => $this->stayLength,
		                            'selectedRoomTypes'       => $this->selectedRoomTypes,
		                            'enableAutoScroll'        => $this->enableAutoScroll,
		                            'checkinFormatted'        => $this->checkinFormatted ?? null,
		                            'checkoutFormatted'       => $this->checkoutFormatted ?? null,
		                            'showTariffs'             => $this->showTariffs,
		                            'Itemid'                  => $this->itemid,
		                            'defaultTariffVisibility' => $this->defaultTariffVisibility,
		                            'showTaxIncl'             => $this->showTaxIncl
	                            ];
	                            echo $layout->render('asset.rateplans', $ratePlansData);
	                            ?>

                            </div>  <!-- end of span12 -->
                        </div> <!-- end of row-fluid -->
						<?php
						$count++;
					endforeach
					?>
				<?php
				else :
					?>
                    <div class="alert alert-warning">
						<?php
						echo JText::sprintf('SR_NO_ROOM_TYPES_MATCHED_SEARCH_CONDITIONS',
							$this->checkinFormatted,
							$this->checkoutFormatted
						);
						?>
                        <a class=""
                           href="<?php echo JRoute::_('index.php?option=com_solidres&task=reservationasset.startOver&id=' . $this->item->id) ?>"><i
                                    class="fa fa-refresh"></i> <?php echo JText::_('SR_SEARCH_RESET') ?></a>
                    </div>
				<?php
				endif;
				?>

				<?php if (!$this->isFresh && count($this->item->roomTypes) > 0) : ?>
                    <div class="<?php echo SR_UI_GRID_CONTAINER ?> button-row button-row-bottom"
                         style="<?php echo $this->isSingular ? 'display: none' : '' ?>">
                        <div class="<?php echo SR_UI_GRID_COL_8 ?>">
                            <div class="inner">
                                <p><?php echo JText::_('SR_ROOMINFO_STEP_NOTICE_MESSAGE') ?></p>
                            </div>
                        </div>
                        <div class="<?php echo SR_UI_GRID_COL_4 ?>">
                            <div class="inner">
                                <div class="btn-group">
                                    <button data-step="room" type="submit" class="btn btn-success">
                                        <i class="fa fa-arrow-right"></i> <?php echo JText::_('SR_NEXT') ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
				<?php endif ?>

                <input type="hidden" name="jform[raid]" value="<?php echo $this->item->id ?>"/>
                <input type="hidden" name="jform[next_step]" value="guestinfo"/>
                <input type="hidden" name="jform[return]" value="<?php echo base64_encode(Uri::getInstance()->toString()); ?>"/>

				<?php echo JHtml::_('form.token'); ?>
            </form>
        </div>
        <!-- /Tab 1 -->

    </div>

    <div class="step-pane" id="step2">
        <!-- Tab 2 -->
        <div class="reservation-single-step-holder guestinfo nodisplay" id="guestinfo">
        </div>
        <!-- /Tab 2 -->
    </div>

    <div class="step-pane" id="step3">
        <!-- Tab 3 -->
        <div class="reservation-single-step-holder confirmation nodisplay">
        </div>
        <!-- /Tab 3 -->
    </div>

</div>