<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * View to edit a customer.
 *
 * @package       Solidres
 * @subpackage    Customer
 * @since         0.1.0
 */
class SolidresViewCustomer extends SRViewLegacy
{
	protected $state;
	protected $form;

	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->form  = $this->get('Form');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', array('version' => SRVersion::getHashVersion(), 'relative' => true));

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user  = JFactory::getUser();
		$id    = $this->form->getValue('id');
		$isNew = ($id == 0);
		$canDo = SolidresHelper::getActions('', $id);

		if ($isNew)
		{
			JToolBarHelper::title(JText::_('SR_ADD_NEW_CUSTOMER'), 'generic.png');
		}
		else
		{
			JToolBarHelper::title(JText::sprintf('SR_EDIT_CUSTOMER', $this->form->getValue('username')), 'generic.png');
		}

		// If not checked out, can save the item.
		if (/*!$checkedOut && */
		$canDo->get('core.edit'))
		{
			JToolBarHelper::apply('customer.apply', 'JToolbar_Apply');
			JToolBarHelper::save('customer.save', 'JToolbar_Save');
			JToolBarHelper::addNew('customer.save2new', 'JToolbar_Save_and_new');

			if ($canDo->get('core.admin') || $user->id == $this->form->getValue('user_id'))
			{
				$bar     = JToolbar::getInstance('toolbar');
				$html    = array();
				$onClick = 'if(confirm(\'' . JText::_('SR_API_KEY_GENERATE_CONFIRM') . '\')) Joomla.submitbutton(\'customer.generateKeys\')';
				if (SR_ISJ4)
				{
					$html[] = '<joomla-toolbar-button>';
				}
				$html[]  = '<button type="button" class="btn btn-primary btn-small" onclick="' . $onClick . '">';
				$html[]  = ' 	<i class="icon-key"></i> ' . JText::_('SR_API_GENERATE_KEYS');
				$html[]  = '</button>';

				if (SR_ISJ4)
				{
					$html[] = '</joomla-toolbar-button>';
				}
				$bar->appendButton('Custom', join("\n", $html), 'generateKeys');
			}
		}

		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
		{
			JToolBarHelper::custom('customer.save2copy', 'copy.png', 'copy_f2.png', 'JToolbar_Save_as_Copy', false);
		}

		if (empty($id))
		{
			JToolBarHelper::cancel('customer.cancel', 'JToolbar_Cancel');
		}
		else
		{
			JToolBarHelper::cancel('customer.cancel', 'JToolbar_Close');
		}

		JToolBarHelper::divider();
	}
}
