<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * View to edit a customer group.
 *
 * @package     Solidres
 * @subpackage	CustomerGroup
 * @since		0.1.0
 */
class SolidresViewCustomerGroup extends SRViewLegacy
{
	protected $state;
	protected $form;

	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->form			= $this->get('Form');

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', array('version' => SRVersion::getHashVersion(), 'relative' => true));

		$this->addToolbar();
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		include JPATH_COMPONENT.'/helpers/toolbar.php';
		$user		= JFactory::getUser();
		$id         = $this->form->getValue('id');
		$isNew		= ($id == 0);
		$canDo		= SolidresHelper::getActions('', $id);
		
		if($isNew)
        {
			JToolBarHelper::title(JText::_('SR_ADD_NEW_CUSTOMERGROUP'), 'generic.png');
		}
        else
        {
			JToolBarHelper::title(JText::sprintf('SR_EDIT_CUSTOMERGROUP', $this->form->getValue('name')), 'generic.png');
		}
		
		JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

		// If not checked out, can save the item.
		if (/*!$checkedOut && */$canDo->get('core.edit'))
        {
			JToolBarHelper::apply('customergroup.apply', 'JToolbar_Apply');
			JToolBarHelper::save('customergroup.save', 'JToolbar_Save');
			JToolBarHelper::addNew('customergroup.save2new', 'JToolbar_Save_and_new');
		}
		
		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
        {
			JToolBarHelper::custom('customergroup.save2copy', 'copy.png', 'copy_f2.png', 'JToolbar_Save_as_Copy', false);
		}
		
		if (empty($id))
        {
			JToolBarHelper::cancel('customergroup.cancel', 'JToolbar_Cancel');
		}
        else
        {
			JToolBarHelper::cancel('customergroup.cancel', 'JToolbar_Close');
		}

		JToolBarHelper::divider();
	}
}
