<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * View to edit a Reservation in front end
 *
 * @package     Solidres
 * @subpackage	Reservation
 * @since		0.6.0
 */
class SolidresViewMyReservation extends SRViewLegacy
{
	protected $state;
	protected $form;
	protected $returnPage;
	protected $invoiceTable;
	protected $id;
	protected $reservationAssetId;
	public $itemid = 0;
	protected $fields = [];

	public function display($tpl = null)
	{
		$this->state              = $this->get( 'State' );
		$this->form               = $this->get( 'Form' );
		$this->returnPage         = $this->getModel()->getReturnPage();
		$this->id                 = $this->form->getValue( 'id' );
		$this->reservationAssetId = $this->form->getValue( 'reservation_asset_id' );
		$app                      = JFactory::getApplication();
		$this->itemid             = $app->input->get( 'Itemid', 0 );
		$formParams               = $this->form->getValue( 'params' );
		$language                 = JFactory::getLanguage();

		if (!in_array($this->form->getValue('payment_method_id'), array('paylater', 'bankwire')))
		{
			$language->load('plg_solidrespayment_'.$this->form->getValue('payment_method_id'), JPATH_ADMINISTRATOR, null, 1);
		}

		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		JText::script("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER");
		JText::script("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND");

		JHtml::_('stylesheet', 'com_solidres/assets/main.min.css', ['version' => SRVersion::getHashVersion(), 'relative' => true]);
		$language->load('plg_solidres_invoice', JPATH_ADMINISTRATOR, null, 1);
		$language->load('com_solidres', JPATH_ADMINISTRATOR . '/components/com_solidres', null, 1);

		$authorised = $formParams->{'access-edit'};

		if ($authorised !== true)
		{
			$app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
			$app->setHeader('status', 403, true);

			return false;
		}

		$solidresRoomType = SRFactory::get('solidres.roomtype.roomtype');
		$this->lengthOfStay = (int)$solidresRoomType->calculateDateDiff($this->form->getValue('checkin'), $this->form->getValue('checkout'));
		$this->config = JComponentHelper::getParams('com_solidres');
		$this->showPoweredByLink = $this->config->get('show_solidres_copyright', '1');
		$this->dateFormat        = $this->config->get('date_format', 'd-m-Y');

		if (SRPlugin::isEnabled('invoice'))
		{
			JPluginHelper::importPlugin('solidres');
			$this->invoiceTable = $app->triggerEvent('onSolidresLoadReservation', array($this->form->getValue('id')));
		}

		if (SRPlugin::isEnabled('hub'))
		{
			SRLayoutHelper::addIncludePath(array(
				SRPlugin::getLayoutPath('hub').'/layouts'
			));
		}

		SRLayoutHelper::addIncludePath(array(
			SRPlugin::getLayoutPath('user').'/layouts',
			SRPlugin::getSitePath('user').'/layouts'
		));

		if (SRPlugin::isEnabled('customfield'))
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('a.category_id')
				->from($db->quoteName('#__sr_reservation_assets', 'a'))
				->where('a.id = ' . (int) $this->reservationAssetId);
			$db->setQuery($query);

			if ($cid = $db->loadResult())
			{
				$this->fields = SRCustomFieldHelper::findFields(['context' => 'com_solidres.customer'], [$cid]);
			}
		}

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JLoader::register('Joomla\\CMS\\Toolbar\\ToolbarHelper', JPATH_LIBRARIES . '/src/Toolbar/ToolbarHelper.php');
		JToolBarHelper::back();

		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables');
		$tableAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
		$tableAsset->load($this->reservationAssetId);
		$this->canAmend = true;
		$this->canCancel = true;

		$propertyParams = json_decode($tableAsset->params, true);
		$amendThreshold = isset($propertyParams['amend_threshold']) && !empty($propertyParams['amend_threshold']) ? $propertyParams['amend_threshold'] : 15;
		$cancelThreshold = isset($propertyParams['cancel_threshold']) && !empty($propertyParams['cancel_threshold']) ? $propertyParams['cancel_threshold'] : 15;

		$this->amendUntil = (new DateTime($this->form->getValue('checkin')))
			->sub(new DateInterval('P' . $amendThreshold . 'D'));
		$this->cancelUntil = (new DateTime($this->form->getValue('checkin')))
			->sub(new DateInterval('P' . $cancelThreshold . 'D'));

		$checkIn  = new DateTime($this->form->getValue('checkin'));
		$today    = new DateTime(date('Y-m-d'));
		$interval = $checkIn->diff($today)->format('%a');

		if ($interval < $amendThreshold || $this->amendUntil < $today)
		{
			$this->canAmend = false;
		}

		if ($interval < $cancelThreshold
			|| $this->cancelUntil < $today
			|| $this->form->getValue('state') == JComponentHelper::getParams('com_solidres')->get('cancel_state', 4)
			|| !JFactory::getUser()->authorise('core.edit.state', 'com_solidres'))
		{
			$this->canCancel = false;
		}

		if ($this->canCancel)
		{
			JToolBarHelper::link('index.php?option=com_solidres&task=myreservation.cancelReservation&Itemid='.$this->itemid.'&id='.$this->form->getValue('id') . '&return=' . $this->returnPage, 'SR_CANCEL_RESERVATION', 'cancel-circle');
		}

		$this->canAmend = false;
		if ($this->canAmend)
		{
			JToolBarHelper::link('index.php?option=com_solidres&task=myreservation.amend&Itemid='.$this->itemid.'&id='.$this->form->getValue('id') . '&return=' . $this->returnPage, 'JTOOLBAR_AMEND', 'edit');
		}
	}
}
