<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * Custom script to hook into installation process
 *
 */
class plgUserSolidresInstallerScript
{
	function install($parent)
	{
	}

	function uninstall($parent)
	{		
	}

	function update($parent)
	{
		$filelist = array(
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customer.json.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customer.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customergroup.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customergroups.json.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customergroups.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customers.json.php',
			JPATH_SITE . '/administrator/components/com_solidres/controllers/customers.php',
			JPATH_SITE . '/administrator/components/com_solidres/models/forms/customer.xml',
			JPATH_SITE . '/administrator/components/com_solidres/models/forms/customergroup.xml',
			JPATH_SITE . '/administrator/components/com_solidres/models/forms/filter_customergroups.xml',
			JPATH_SITE . '/administrator/components/com_solidres/models/forms/filter_customers.xml',
			JPATH_SITE . '/administrator/components/com_solidres/models/customer.php',
			JPATH_SITE . '/administrator/components/com_solidres/models/customergroup.php',
			JPATH_SITE . '/administrator/components/com_solidres/models/customergroups.php',
			JPATH_SITE . '/administrator/components/com_solidres/models/customers.php',
			JPATH_SITE . '/administrator/components/com_solidres/tables/customer.php',
			JPATH_SITE . '/administrator/components/com_solidres/tables/customergroup.php',
			JPATH_SITE . '/components/com_solidres/controllers/myprofile.json.php',
			JPATH_SITE . '/components/com_solidres/controllers/myprofile.php',
			JPATH_SITE . '/components/com_solidres/controllers/myreservation.php',
			JPATH_SITE . '/components/com_solidres/controllers/user.json.php',
			JPATH_SITE . '/components/com_solidres/layouts/asset/changedates.php',
			JPATH_SITE . '/components/com_solidres/layouts/customer/navbar.php',
			JPATH_SITE . '/components/com_solidres/models/forms/myprofile.xml',
			JPATH_SITE . '/components/com_solidres/models/forms/myreservation.xml',
			JPATH_SITE . '/components/com_solidres/models/myprofile.php',
			JPATH_SITE . '/components/com_solidres/models/myreservation.php',
			JPATH_SITE . '/components/com_solidres/models/myreservations.php',
			JPATH_SITE . '/components/com_solidres/views/reservationasset/tmpl/default_login.php',
			JPATH_SITE . '/components/com_solidres/views/reservationasset/tmpl/default_userinfo.php',
			JPATH_SITE . '/administrator/language/en-GB/en-GB.plg_user_solidres.ini',
			JPATH_SITE . '/administrator/language/en-GB/en-GB.plg_user_solidres.sys.ini',
		);

		foreach ($filelist as $file)
		{
			if(JFile::exists($file))
			{
				JFile::delete($file);
			}
		}

		$folderList = array(
			JPATH_SITE . '/administrator/components/com_solidres/views/customer',
			JPATH_SITE . '/administrator/components/com_solidres/views/customergroup',
			JPATH_SITE . '/components/com_solidres/views/customer',
			JPATH_SITE . '/components/com_solidres/views/myprofile',
			JPATH_SITE . '/components/com_solidres/views/myreservation',
			// Since 2.11.1
			JPATH_SITE . '/plugins/user/solidres/libraries/maxmind',
		);

		foreach ($folderList as $folder)
		{
			if(JFolder::exists($folder))
			{
				JFolder::delete($folder);
			}
		}
	}

	function preflight($type, $parent)
	{
	}

	function postflight($type, $parent)
	{
		echo '<p>'. JText::_('Solidres - User plugin is installed successfully.') .'</p>';

		$dbo = JFactory::getDbo();

		$query = $dbo->getQuery(true);

		$query->clear();
		$query->update($dbo->quoteName('#__extensions'));
		$query->set('enabled = 1');
		$query->where("element = 'solidres'");
		$query->where("type = 'plugin'");
		$query->where("folder = 'user'");

		$dbo->setQuery($query);

		$result = $dbo->execute();
		if(!$result) 
		{
			JError::raiseWarning(-1, 'plgUserSolidres: publishing failed');
		}
		else
		{
			echo '<p>'. JText::_('Solidres - User plugin is published successfully.') .'</p>';
		}
	}
}