<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
?>

<div class="<?php echo SR_UI_GRID_CONTAINER ?>">
    <div class="<?php echo SR_UI_GRID_COL_6 ?>">
        <form id="reservationnote-form"
              action="index.php?option=com_solidres&task=reservationnote.save&format=json">
            <textarea rows="5" name="text" class="form-control input-block-level"
                      placeholder="<?php echo Text::_('SR_RESERVATION_NOTE_PLACEHOLDER') ?>"></textarea>
            <label class="checkbox">
                <input type="checkbox" name="notify_customer" value="1">
				<?php echo Text::_("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER") ?>
            </label>
            <label class="checkbox">
                <input type="checkbox" name="visible_in_frontend" value="1">
				<?php echo Text::_("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND") ?>
            </label>
            <div class="processing nodisplay"></div>
            <button type="submit" class="btn <?php echo SR_UI_BTN_DEFAULT ?>"><?php echo Text::_("SR_SUBMIT") ?></button>
            <input name="reservation_id" type="hidden" value="<?php echo $this->reservationId ?>"/>
			<?php echo HTMLHelper::_('form.token'); ?>

        </form>
    </div>
    <div class="<?php echo SR_UI_GRID_COL_6 ?> reservation-note-holder">
		<?php
		$notes = $this->form->getValue('notes');
		if (!empty($notes)) :
			foreach ($notes as $note) :
				?>
                <div class="reservation-note-item">
                    <p class="info">
						<?php echo $note->created_date ?> by <?php echo $note->username ?>
                    </p>
                    <p>
						<?php echo Text::_("SR_RESERVATION_NOTE_NOTIFY_CUSTOMER") ?>
                        : <?php echo $note->notify_customer == 1 ? Text::_('JYES') : Text::_('JNO') ?>
                        |
						<?php echo Text::_("SR_RESERVATION_NOTE_DISPLAY_IN_FRONTEND") ?>
                        : <?php echo $note->visible_in_frontend == 1 ? Text::_('JYES') : Text::_('JNO') ?></p>
                    <p>
						<?php echo $note->text ?>
                    </p>
                </div>
			<?php
			endforeach;
        else:
            echo '<p class="alert alert-info">' . Text::_('SR_NO_NOTES') . '</p>';
		endif;
		?>
    </div>
</div>