<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2016 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

namespace Solidres\Api\Library;

defined('_JEXEC') or die;

class Account extends ApiAuthentication
{
	public function getItems()
	{
		$query = $this->db->getQuery(true)
			->select('a.name')
			->from($this->db->quoteName('#__sr_reservation_assets', 'a'))
			->where('a.state = 1');

		if ($this->partnerId)
		{
			$query->where('a.partner_id = ' . $this->partnerId);
		}

		return [
			[
				'textKey'  => 'SR_NAME',
				'value' => $this->user->name,
			],
			[
				'textKey'  => 'SR_USERNAME',
				'value' => $this->user->username,
			],
			[
				'textKey'  => 'SR_EMAIL',
				'value' => $this->user->email,
			],
			[
				'textKey'  => 'SR_USER_TYPE',
				'value' => $this->partnerId ? '_SR_PARTNER' : '_SR_ADMIN',
			],
			[
				'textKey'  => 'SR_TIMEZONE',
				'value' => $this->user->getTimezone()->getName(),
			],
			[
				'textKey'  => 'SR_PROPERTIES',
				'value' => join(', ', $this->db->setQuery($query)->loadColumn()),
			],
		];
	}
}
