<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

$partnerName       = $this->form->getValue('partner_name');
$address           = array('address_1', 'address_2', 'city', 'postcode');
$geocoding_address = array();
foreach ($address as $add) :
	if ($this->form->getValue($add, '') != '') :
		$geocoding_address[] = $this->form->getValue($add);
	endif;
endforeach;

echo $this->form->renderField('name');
echo $this->form->renderField('alternative_name');
echo $this->form->renderField('alias'); 
echo $this->form->renderField('category_id'); 
echo $this->form->renderField('category_name'); 
echo $this->form->renderField('tags'); 
echo $this->form->renderField('partner_id');
echo $this->form->renderField('address_1');
echo $this->form->renderField('address_2');
echo $this->form->renderField('city');
echo $this->form->renderField('postcode');
echo $this->form->renderField('email');
echo $this->form->renderField('website');
echo $this->form->renderField('phone');
echo $this->form->renderField('fax');
echo $this->form->renderField('country_id');
echo $this->form->renderField('geo_state_id');
echo $this->form->renderField('currency_id');
echo $this->form->renderField('price_includes_tax');
echo $this->form->renderField('tax_id');
echo $this->form->renderField('booking_type');

?>

<div class="coordinates">
    <div class="<?php echo SR_UI_FORM_ROW ?>">
	    <?php echo SR_ISJ4 ? '<div class="control-label">' : '' ?>
        <label class="control-label"></label>
	    <?php echo SR_ISJ4 ? '</div>' : '' ?>
        <div class="<?php echo SR_UI_FORM_FIELD ?>">
            <div class="map_canvas"></div>
            <input id="geocomplete" type="text" placeholder="" class="form-control"
                   value="<?php echo implode(',', $geocoding_address) ?>"/>
            <button class="btn btn-default" id="find" type="button"><?php echo Text::_('SR_GEOCODING_FIND') ?></button>
            <button class="btn btn-default" data-lat="<?php echo !empty($this->lat) ? $this->lat : '' ?>"
                    data-lng="<?php echo !empty($this->lng) ? $this->lng : '' ?>" id="update" type="button"
                    style="display:none;"><?php echo Text::_('SR_GEOCODING_UPDATE') ?></button>
        </div>
    </div>

    <?php echo $this->form->renderField('lat'); ?>
    <?php echo $this->form->renderField('lng'); ?>
</div>

<?php echo $this->form->renderField('description'); ?>