<?php
/**
 ------------------------------------------------------------------------
 SOLIDRES - Accommodation booking extension for Joomla
 ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

/**
 * Customer table class
 *
 * @package       Solidres
 * @subpackage    Customer
 * @since         0.1.0
 */
class SolidresTableCustomer extends JTable
{
	function __construct(JDatabaseDriver $db)
	{
		parent::__construct('#__sr_customers', 'id', $db);
	}

	/**
	 * Method to delete a row from the database table by primary key value.
	 *
	 * @param   mixed $pk     An optional primary key value to delete.  If not set the
	 *                        instance property value is used.
	 *
	 * @return  boolean  True on success.
	 */
	public function delete($pk = null)
	{
		$k     = $this->_tbl_key;
		$pk    = (is_null($pk)) ? $this->$k : $pk;
		$query = $this->_db->getQuery(true);
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_users/models', 'UsersModel');

		// If no primary key is given, return false.
		if ($pk === null)
		{
			return false;
		}

		// Take care of Reservation
		$query->update($this->_db->quoteName('#__sr_reservations'))
			->set('customer_id = NULL')
			->where('customer_id = ' . $this->_db->quote($pk));
		$this->_db->setQuery($query)->execute();

		// Take care of Customer Fields
		$query->clear();
		$query->delete()->from($this->_db->quoteName('#__sr_customer_fields'))
			->where('user_id = ' . $this->_db->quote($pk));
		$this->_db->setQuery($query)->execute();

		// Take care of relation ship with Reservation Asset
		$query->clear();
		$query->update($this->_db->quoteName('#__sr_reservation_assets'))
			->set('partner_id = NULL')
			->where('partner_id = ' . $this->_db->quote($pk));
		$this->_db->setQuery($query)->execute();

		// Also remove corresponding Joomla users
		$userModel = JModelLegacy::getInstance('User', 'UsersModel', array('ignore_request' => true));
		$userModel->delete($this->user_id);

		/*$query->clear();
		$query->update('#__sr_feedbacks');
		$query->set('customer_id = NULL');
		$query->where('customer_id = '.$this->_db->quote($pk));
		$this->_db->setQuery($query);
		if (!$this->_db->execute()) {
			$e = new JException(JText::sprintf('JLIB_DATABASE_ERROR_PUBLISH_FAILED', get_class($this), $this->_db->getErrorMsg()));
			$this->setError($e);
			return false;
		}*/

		// Delete it
		return parent::delete($pk);
	}

	public function store($updateNulls = false)
	{
		$user   = clone JFactory::getUser();
		$app    = JFactory::getApplication();
		$access = $user->authorise('core.admin') || $user->id == $this->user_id;

		if (empty($this->user_id) || !$user->load($this->user_id))
		{
			$this->setError(JText::_('SR_API_ERROR_USER_NOT_FOUND'));

			return false;
		}

		if($access)
		{
			if ((empty($this->api_key) && (empty($this->api_secret)) || $app->input->getBool('userGenerateKeys')))
			{
				$this->api_key    = sha1(JCrypt::genRandomBytes(40).$this->id);
				$this->api_secret = sha1(JCrypt::genRandomBytes(40));
				$table            = clone $this;
				while ($table->load(array('api_secret' => $this->api_secret)))
				{
					$this->api_secret = sha1(JCrypt::genRandomBytes(40));
				}

				$app->enqueueMessage(JText::_('SR_API_KEY_GENERATE_SUCCESS'));
			}
		}

		return parent::store($updateNulls);
	}
}

