<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */


defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

/**
 * @var array $displayData
 * @var JFormFieldSolidres_Map $field
 */

extract($displayData);
/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->useStyle('com_solidres.leaflet-css');
$wa->useStyle('com_solidres.leaflet-search-css');
$wa->useScript('com_solidres.leaflet-js');
$wa->useScript('com_solidres.leaflet-search-js');
$latFieldId = $field->getAttribute('latFieldId', '');
$lngFieldId = $field->getAttribute('lngFieldId', '');
$address    = $field->getAttribute('geocodingAddress', '');
?>
<div id="<?php echo $field->id ?>-container">
    <div id="<?php echo $field->id ?>-map" style="width: 100%; height: 400px"></div>
    <script>
        window.addEventListener('load', function () {
            const latFieldId = '<?php echo $latFieldId ?>';
            const lngFieldId = '<?php echo $lngFieldId ?>';
            const latField = latFieldId ? document.getElementById(latFieldId) : null;
            const lngField = lngFieldId ? document.getElementById(lngFieldId) : null;
            const latLngValue = latField && lngField
                ? [parseFloat(latField.value) || 41.575730, parseFloat(lngField.value) || 13.002411]
                : [41.575730, 13.002411];
            const map = new L.Map('<?php echo $field->id ?>-map', { zoom: 15, center: new L.latLng(latLngValue) });
            const popup = L.popup();
            const controlSearch = new L.Control.Search({

                url: 'https://nominatim.openstreetmap.org/search?format=json&q={s}',
                jsonpParam: 'json_callback',
                propertyName: 'display_name',
                propertyLoc: ['lat', 'lon'],
                marker: { icon: true, circle: false },
                firstTipSubmit: true,
                minLength: 2,
                textErr: '<?php echo Text::_('SR_ERR_LOCATION_NOT_FOUND', true); ?>',
                textCancel: '<?php echo Text::_('SR_CANCEL', true); ?>',
                textPlaceholder: '<?php echo Text::_('SR_MAP_SEARCH', true); ?>',
                moveToLocation: function (latLng, title, map) {
                    map.setView(latLng, 15);
                    popup.setLatLng(latLng)
                        .setContent(title)
                        .openOn(map);

                    if (latField) {
                        latField.value = latLng.lat;
                    }

                    if (lngField) {
                        lngField.value = latLng.lng;
                    }
                }
            });

            map.addLayer(new L.TileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'));
            map.addControl(controlSearch);

            if (latField && lngField) {
                const setView = () => map.setView({ lat: latField.value, lng: lngField.value }, 15);
                latField.addEventListener('change', setView, false);
                lngField.addEventListener('change', setView, false);
                map.setView(latLngValue, 15);
                L.marker(latLngValue).addTo(map);
            }

        });
    </script>
</div>
