INSERT INTO `#__sr_customer_groups` (`id`, `name`, `state`) VALUES
  (1, 'Regular Customer', 1),
  (2, 'Silver Customer', 1),
  (3, 'Gold Customer', 1),
  (4, 'Premium Customer', 1),
  (5, 'Diamond Customer', 1);


INSERT INTO `#__users` (`id`, `name`, `username`, `email`, `password`, `block`, `sendEmail`, `registerDate`, `lastvisitDate`, `activation`, `params`, `lastResetTime`, `resetCount`) VALUES
  (90001, 'David  Jones', 'david', 'davidjones@localhost.dev', '404d92dfd6af3f22c5b4cdb04d8ab5fb:yInMUoQr1YR26Yrld2XOp56K4uB9VUqq', 0, 0, '2012-10-08 04:26:46', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', 0),
  (90002, 'Wilson  Miller', 'wilsonmiller', 'wilsonmiller@localhost.dev', 'b0b76c68bc9a09cf658027780828b330:ErzYI78Xlk4e6NgKPriYCy8UPLaLQcXO', 0, 0, '2012-10-08 04:32:37', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', 0),
  (90003, 'Kaito  Kazuki', 'kaitokazuki', 'kaitokazuki@localhost.dev', '40fb510d32dc6e7f709240c7f01d5e65:JomakywHd0ynnsxooLlYfsU3AWUTrgtj', 0, 0, '2012-10-08 04:34:58', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', 0),
  (90004, 'Chan  Jiao', 'chanjiao', 'chanjiao@localhost.dev', '83ab0b5708cc133c1443b11bd23d1e2e:iq5w6mIr5bsiT5akzXCJcDo2tr4rLh7f', 0, 0, '2012-10-08 04:37:18', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', 0),
  (90005, 'Kenneth  Edward', 'kennethedward', 'kennethedward@localhost.dev', '3d8410b43c0987b452a2ce0c85d55356:1JuSojyPE9AOMBJG4C6SB3UJdyFYOvgf', 0, 0, '2012-10-08 04:38:48', '0000-00-00 00:00:00', '', '{}', '0000-00-00 00:00:00', 0);


INSERT INTO `#__user_usergroup_map` (`user_id`, `group_id`) VALUES
  (90001, 2),
  (90002, 2),
  (90003, 2),
  (90004, 2),
  (90005, 2);


INSERT INTO `#__sr_customers` (`id`, `customer_group_id`, `user_id`, `customer_code`, `firstname`, `middlename`, `lastname`, `vat_number`, `company`, `phonenumber`, `address1`, `address2`, `city`, `zipcode`, `country_id`, `geo_state_id`) VALUES
  (31, 1, 90001, 'UY4568', 'David', '', 'Jones', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
  (32, 2, 90002, 'JH3356', 'Wilson', '', 'Miller', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
  (33, 3, 90003, 'AX2244', 'Kaito', '', 'Kazuki', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
  (34, 4, 90004, 'OW4523', 'Chan', '', 'Jiao', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
  (35, 5, 90005, 'KE9999', 'Kenneth', '', 'Edward', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


INSERT INTO `#__sr_currencies` (`id`, `currency_name`, `currency_code`, `state`, `exchange_rate`, `sign`, `filter_range`) VALUES
  (1, 'US Dollar', 'USD', 1, 1, '$', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (2, 'Euro', 'EUR', 1, 0.9, '€', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (3, 'Great Britain Pound', 'GBP', 1, 0.7, '£', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (4, 'Japanese Yen', 'JPY', 1, 113.87, '¥', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (5, 'Bulgarian Lev', 'BGN', 1, 1.75, 'лв', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (6, 'Czech Koruna', 'CZK', 1, 24.25, 'Kč', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (7, 'Danish Krone', 'DKK', 1, 6.68, 'kr', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (8, 'Hungarian Forint', 'HUF', 1, 277.80, 'Ft', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (9, 'Polish Złoty', 'PLN', 1, 3.85, 'zł', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (10, 'Romanian Leu', 'RON', 1, 4.01, 'lei', '0-49\r\n50-99\r\n100-149\r\n150-199\r\n200-plus'),
  (11, 'Afghan afghani', 'AFN', 0, 0, '؋', NULL),
  (12, 'Albanian lek', 'ALL', 0, 0, 'Lek', NULL),
  (13, 'Algerian dinar', 'DZD', 0, 0, 'د.ج', NULL),
  (14, 'Angolan kwanza', 'AOA', 0, 0, 'Kz ', NULL),
  (15, 'Argentine peso', 'ARS', 0, 0, '$', NULL),
  (16, 'Armenian dram', 'AMD', 0, 0, 'դր.', NULL),
  (17, 'Aruban florin', 'AWG', 0, 0, 'ƒ', NULL),
  (18, 'Australian dollar', 'AUD', 0, 0, '$', NULL),
  (19, 'Azerbaijani manat', 'AZN', 0, 0, 'ман', NULL),
  (20, 'Bahamian dollar', 'BSD', 0, 0, '$', NULL),
  (21, 'Bahraini dinar', 'BHD', 0, 0, 'ب.د', NULL),
  (22, 'Bangladeshi taka', 'BDT', 0, 0, '৳', NULL),
  (23, 'Barbadian dollar', 'BBD', 0, 0, '$', NULL),
  (24, 'Belarusian ruble', 'BYR', 0, 0, 'p.', NULL),
  (25, 'Belize dollar', 'BZD', 0, 0, 'BZ$', NULL),
  (26, 'Bermudian dollar', 'BMD', 0, 0, '$', NULL),
  (27, 'Bhutanese ngultrum', 'BTN', 0, 0, 'BTN', NULL),
  (28, 'Bolivian boliviano', 'BOB', 0, 0, '$b', NULL),
  (29, 'Bond Markets', 'XBA', 0, 0, 'XBA', NULL),
  (30, 'Bosnia and Herzegovina convert', 'BAM', 0, 0, 'KM', NULL),
  (31, 'Botswana pula', 'BWP', 0, 0, 'P', NULL),
  (32, 'Brazilian real', 'BRL', 0, 0, 'R$', NULL),
  (33, 'Brunei dollar', 'BND', 0, 0, '$', NULL),
  (34, 'Burundian franc', 'BIF', 0, 0, 'Fr ', NULL),
  (35, 'Cambodian riel', 'KHR', 0, 0, '៛', NULL),
  (36, 'Canadian dollar', 'CAD', 0, 0, '$', NULL),
  (37, 'Cape Verdean escudo', 'CVE', 0, 0, '$', NULL),
  (38, 'Cayman Islands dollar', 'KYD', 0, 0, '$', NULL),
  (39, 'Central African CFA franc', 'XAF', 0, 0, 'Fr ', NULL),
  (40, 'CFP franc', 'XPF', 0, 0, 'Fr ', NULL),
  (41, 'Chilean peso', 'CLP', 0, 0, '$', NULL),
  (42, 'Chinese renminbi yuan', 'CNY', 0, 0, '元', NULL),
  (43, 'Codes specif', 'XTS', 0, 0, 'XTS', NULL),
  (44, 'Colombian peso', 'COP', 0, 0, '$', NULL),
  (45, 'Comorian franc', 'KMF', 0, 0, 'Fr ', NULL),
  (46, 'Congolese franc', 'CDF', 0, 0, 'Fr ', NULL),
  (47, 'Costa Rican colón', 'CRC', 0, 0, '₡', NULL),
  (48, 'Croatian kuna', 'HRK', 0, 0, 'kn', NULL),
  (49, 'Cuban peso', 'CUP', 0, 0, '₱', NULL),
  (50, 'Djiboutian franc', 'DJF', 0, 0, 'Fr ', NULL),
  (51, 'Dominican peso', 'DOP', 0, 0, 'RD$', NULL),
  (52, 'East Caribbean dollar', 'XCD', 0, 0, '$', NULL),
  (53, 'Egyptian pound', 'EGP', 0, 0, '£', NULL),
  (54, 'Eritrean nakfa', 'ERN', 0, 0, 'Nfk ', NULL),
  (55, 'Estonian kroon', 'EEK', 0, 0, 'kr', NULL),
  (56, 'Ethiopian birr', 'ETB', 0, 0, 'ETB', NULL),
  (57, 'European Mon', 'XBB', 0, 0, 'XBB', NULL),
  (58, 'European Uni', 'XBD', 0, 0, 'XBD', NULL),
  (59, 'European Uni', 'XBC', 0, 0, 'XBC', NULL),
  (60, 'Falkland pound', 'FKP', 0, 0, '£', NULL),
  (61, 'Fijian dollar', 'FJD', 0, 0, '$', NULL),
  (62, 'Gambian dalasi', 'GMD', 0, 0, 'D ', NULL),
  (63, 'Georgian lari', 'GEL', 0, 0, 'ლ', NULL),
  (64, 'Ghanaian cedi', 'GHS', 0, 0, '₵', NULL),
  (65, 'Gibraltar pound', 'GIP', 0, 0, '£', NULL),
  (66, 'Gold', 'XAU', 0, 0, 'Gold', NULL),
  (67, 'Guatemalan quetzal', 'GTQ', 0, 0, 'Q', NULL),
  (68, 'Guinea-Bissa', 'GWP', 0, 0, 'GWP', NULL),
  (69, 'Guinean franc', 'GNF', 0, 0, 'Fr ', NULL),
  (70, 'Guyanese dollar', 'GYD', 0, 0, '$', NULL),
  (71, 'Haitian gourde', 'HTG', 0, 0, 'G ', NULL),
  (72, 'Honduran lempira', 'HNL', 0, 0, 'L', NULL),
  (73, 'Hong Kong dollar', 'HKD', 0, 0, '元', NULL),
  (74, 'Icelandic króna', 'ISK', 0, 0, 'kr', NULL),
  (75, 'Indian rupee', 'INR', 0, 0, '₨', NULL),
  (76, 'Indonesian rupiah', 'IDR', 0, 0, 'Rp', NULL),
  (77, 'Iranian rial', 'IRR', 0, 0, '﷼', NULL),
  (78, 'Iraqi dinar', 'IQD', 0, 0, 'ع.د', NULL),
  (79, 'Israeli new sheqel', 'ILS', 0, 0, '₪', NULL),
  (80, 'Jamaican dollar', 'JMD', 0, 0, 'J$', NULL),
  (81, 'Jordanian dinar', 'JOD', 0, 0, 'د.ا', NULL),
  (82, 'Kazakhstani tenge', 'KZT', 0, 0, 'лв', NULL),
  (83, 'Kenyan shilling', 'KES', 0, 0, 'Sh ', NULL),
  (84, 'Kuwaiti dinar', 'KWD', 0, 0, 'د.ك', NULL),
  (85, 'Kyrgyzstani som', 'KGS', 0, 0, 'лв', NULL),
  (86, 'Lao kip', 'LAK', 0, 0, '₭', NULL),
  (87, 'Latvian lats', 'LVL', 0, 0, 'Ls', NULL),
  (88, 'Lebanese pound', 'LBP', 0, 0, '£', NULL),
  (89, 'Lesotho loti', 'LSL', 0, 0, 'L ', NULL),
  (90, 'Liberian dollar', 'LRD', 0, 0, '$', NULL),
  (91, 'Libyan dinar', 'LYD', 0, 0, 'ل.د', NULL),
  (92, 'Lithuanian litas', 'LTL', 0, 0, 'Lt', NULL),
  (93, 'Macanese pataca', 'MOP', 0, 0, 'P ', NULL),
  (94, 'Macedonian denar', 'MKD', 0, 0, 'ден', NULL),
  (95, 'Malagasy ariary', 'MGA', 0, 0, 'MGA', NULL),
  (96, 'Malawian kwacha', 'MWK', 0, 0, 'MK ', NULL),
  (97, 'Malaysian ringgit', 'MYR', 0, 0, 'RM', NULL),
  (98, 'Maldivian rufiyaa', 'MVR', 0, 0, 'ރ.', NULL),
  (99, 'Mauritanian ouguiya', 'MRO', 0, 0, 'UM ', NULL),
  (100, 'Mauritian rupee', 'MUR', 0, 0, '₨', NULL),
  (101, 'Mexican peso', 'MXN', 0, 0, '$', NULL),
  (102, 'Mexican Unid', 'MXV', 0, 0, 'MXV', NULL),
  (103, 'Moldovan leu', 'MDL', 0, 0, 'L ', NULL),
  (104, 'Mongolian tögrög', 'MNT', 0, 0, '₮', NULL),
  (105, 'Moroccan dirham', 'MAD', 0, 0, 'د.م.', NULL),
  (106, 'Mozambican metical', 'MZN', 0, 0, 'MT', NULL),
  (107, 'Mvdol', 'BOV', 0, 0, 'BOV', NULL),
  (108, 'Myanmar kyat', 'MMK', 0, 0, 'K ', NULL),
  (109, 'Namibian dollar', 'NAD', 0, 0, '$', NULL),
  (110, 'Nepalese rupee', 'NPR', 0, 0, '₨', NULL),
  (111, 'Netherlands Antillean gulden', 'ANG', 0, 0, 'ƒ', NULL),
  (112, 'New Taiwan dollar', 'TWD', 0, 0, 'NT$', NULL),
  (113, 'New Zealand dollar', 'NZD', 0, 0, '$', NULL),
  (114, 'Nicaraguan córdoba', 'NIO', 0, 0, 'C$', NULL),
  (115, 'Nigerian naira', 'NGN', 0, 0, '₦', NULL),
  (116, 'North Korean won', 'KPW', 0, 0, '₩', NULL),
  (117, 'Norwegian krone', 'NOK', 0, 0, 'kr', NULL),
  (118, 'Omani rial', 'OMR', 0, 0, '﷼', NULL),
  (119, 'Pakistani rupee', 'PKR', 0, 0, '₨', NULL),
  (120, 'Palladium', 'XPD', 0, 0, 'XPD', NULL),
  (121, 'Panamanian balboa', 'PAB', 0, 0, 'B/.', NULL),
  (122, 'Papua New Guinean kina', 'PGK', 0, 0, 'K ', NULL),
  (123, 'Paraguayan guaraní', 'PYG', 0, 0, '₲', NULL),
  (124, 'Peruvian nuevo sol', 'PEN', 0, 0, 'S/.', NULL),
  (125, 'Philippine peso', 'PHP', 0, 0, '₱', NULL),
  (126, 'Platinum', 'XPT', 0, 0, 'XPT', NULL),
  (127, 'Qatari riyal', 'QAR', 0, 0, '﷼', NULL),
  (128, 'Russian ruble', 'RUB', 0, 0, 'руб', NULL),
  (129, 'Rwandan franc', 'RWF', 0, 0, 'Fr ', NULL),
  (130, 'Saint Helenian pound', 'SHP', 0, 0, '£', NULL),
  (131, 'Salvadoran colón', 'SVC', 0, 0, '$', NULL),
  (132, 'Samoan tala', 'WST', 0, 0, 'T ', NULL),
  (133, 'São Tomé and Príncipe dobra', 'STD', 0, 0, 'Db ', NULL),
  (134, 'Saudi riyal', 'SAR', 0, 0, '﷼', NULL),
  (135, 'SDR', 'XDR', 0, 0, 'XDR', NULL),
  (136, 'Serbian dinar', 'RSD', 0, 0, 'Дин.', NULL),
  (137, 'Seychellois rupee', 'SCR', 0, 0, '₨', NULL),
  (138, 'Sierra Leonean leone', 'SLL', 0, 0, 'Le ', NULL),
  (139, 'Silver', 'XAG', 0, 0, 'XAG', NULL),
  (140, 'Singapore dollar', 'SGD', 0, 0, '$', NULL),
  (141, 'Slovak koruna', 'SKK', 0, 0, 'Sk ', NULL),
  (142, 'Solomon Islands dollar', 'SBD', 0, 0, '$', NULL),
  (143, 'Somali shilling', 'SOS', 0, 0, 'S', NULL),
  (144, 'South African rand', 'ZAR', 0, 0, 'R', NULL),
  (145, 'South Korean won', 'KRW', 0, 0, '₩', NULL),
  (146, 'Sri Lankan rupee', 'LKR', 0, 0, '₨', NULL),
  (147, 'Sudanese pound', 'SDG', 0, 0, '£ ', NULL),
  (148, 'Surinamese dollar', 'SRD', 0, 0, '$', NULL),
  (149, 'Swazi lilangeni', 'SZL', 0, 0, 'L ', NULL),
  (150, 'Swedish krona', 'SEK', 0, 0, 'kr', NULL),
  (151, 'Swiss franc', 'CHF', 0, 0, 'CHF', NULL),
  (152, 'Syrian pound', 'SYP', 0, 0, '£', NULL),
  (153, 'Tajikistani somoni', 'TJS', 0, 0, 'ЅМ', NULL),
  (154, 'Tanzanian shilling', 'TZS', 0, 0, 'Sh ', NULL),
  (155, 'Thai baht', 'THB', 0, 0, '฿', NULL),
  (156, 'The codes as', 'XXX', 0, 0, 'XXX', NULL),
  (157, 'Tongan paʻanga', 'TOP', 0, 0, 'T$ ', NULL),
  (158, 'Trinidad and Tobago dollar', 'TTD', 0, 0, 'TT$', NULL),
  (159, 'Tunisian dinar', 'TND', 0, 0, 'د.ت', NULL),
  (160, 'Turkish new lira', 'TRY', 0, 0, 'YTL', NULL),
  (161, 'Turkmenistani manat', 'TMM', 0, 0, 'm ', NULL),
  (162, 'Ugandan shilling', 'UGX', 0, 0, 'Sh ', NULL),
  (163, 'UIC-Franc', 'XFU', 0, 0, 'XFU', NULL),
  (164, 'Ukrainian hryvnia', 'UAH', 0, 0, '₴', NULL),
  (165, 'Unidad de Va', 'COU', 0, 0, 'COU', NULL),
  (166, 'Unidades de ', 'CLF', 0, 0, 'CLF', NULL),
  (167, 'United Arab Emirates dirham', 'AED', 0, 0, 'د.إ', NULL),
  (168, 'Uruguay Peso', 'UYI', 0, 0, 'UYI', NULL),
  (169, 'Uruguayan peso', 'UYU', 0, 0, '$', NULL),
  (170, 'US Dollar (Next Day)', 'USN', 0, 0, '$', NULL),
  (171, 'US Dollar (Second Day)', 'USS', 0, 0, '$', NULL),
  (172, 'Uzbekistani som', 'UZS', 0, 0, 'лв', NULL),
  (173, 'Vanuatu vatu', 'VUV', 0, 0, 'Vt ', NULL),
  (174, 'Venezuelan bolívar', 'VEF', 0, 0, 'Bs', NULL),
  (175, 'Vietnamese Dong', 'VND', 0, 0, '₫', NULL),
  (176, 'West African CFA franc', 'XOF', 0, 0, 'Fr ', NULL),
  (177, 'WIR Euro', 'CHE', 0, 0, '€', NULL),
  (178, 'WIR Franc', 'CHW', 0, 0, 'CHW', NULL),
  (179, 'Yemeni rial', 'YER', 0, 0, '﷼', NULL),
  (180, 'Zambian kwacha', 'ZMK', 0, 0, 'ZK ', NULL),
  (181, 'Zimbabwean dollar', 'ZWD', 0, 0, 'Z$', NULL);


INSERT INTO `#__sr_taxes` (`id`, `name`, `rate`, `state`, `country_id`, `geo_state_id`) VALUES
  (1, 'VAT', 0.1, 1, 224, NULL),
  (2, 'Surtaxes', 0.05, 1, 224, NULL),
  (3, 'Occupancy Tax', 0.05, 1, 224, NULL),
  (4, 'Federal Tax', 0.04, 1, 224, NULL);


INSERT INTO `#__sr_reservation_assets` (`id`, `asset_id`, `category_id`, `name`, `alias`, `address_1`, `address_2`, `city`, `postcode`, `phone`, `description`, `email`, `website`, `featured`, `fax`, `rating`, `geo_state_id`, `country_id`, `created_date`, `modified_date`, `created_by`, `modified_by`, `state`, `checked_out`, `checked_out_time`, `ordering`, `archived`, `approved`, `access`, `params`, `language`, `hits`, `metatitle`, `metakey`, `metadesc`, `metadata`, `partner_id`, `lat`, `lng`, `default`, `deposit_required`, `deposit_is_percentage`, `deposit_amount`, `deposit_by_stay_length`, `currency_id`, `tax_id`, `booking_type`) VALUES
  (8, 97, NULL, 'Sunflower', 'sunflower', '1234 Collins Avenue, Miami Beach', '', 'Florida ', '33139', '123-456-789', '<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n<hr id="system-readmore" />\r\n<p>I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now. When, while the lovely</p>', 'sunflower@solidres.com', 'http://www.sunflower.sf', 0, '888-888-888', 5, NULL, 224, '2012-07-21 09:43:41', '2014-03-24 04:19:54', 0, 0, 1, 0, '0000-00-00 00:00:00', 8, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":"logo.png"}', '*', 2066, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 25.783537, -80.131210, 1, 0, 1, 0.00, 0, 1, NULL, 0),
  (9, 129, NULL, 'Lychee', 'lychee', '717 Raffles Boulevard, Marina Square, Marina Bay', '', 'Singapore', '00195', '123-456-789', '<p>Just 500 metres from St. Peter''s Square and the Vatican Museums, Marco al Vaticano offers modern apartments in Rome.</p>\r\n<hr id="system-readmore" />\r\n<p>Featuring a terrace, the property is a 5-minute walk from Ottaviano Metro stop which takes you to the Spanish Steps and Roma Termini Station. With free Wi-Fi, the air-conditioned apartments have a fully equipped kitchen and a flat-screen TV. The private bathroom includes a shower. Marco al Vaticano is 2 km from the Pantheon, while the Colosseum is 3.5 km away.</p>', 'lychee@solidres.com', 'http://www.lychee.lc', 0, '888-888-888', 5, NULL, 189, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 1, 0, '0000-00-00 00:00:00', 9, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":"logo.png"}', '', 146, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 1.280285, 103.856453, 0, 0, 1, 0.00, 0, 1, NULL, 0),
  (10, 126, NULL, 'Chesnut', 'chesnut', 'Via Firenze 1423, Station Termini', '', 'Rome', '00184', '123-456-789', '<p>Old Town Apartments offers accommodations with kitchen facilities in different areas of the center of Rome. Apartments vary <hr id="system-readmore" /> in size, and each provides easy access to public transportation services. Apartments are in historic buildings near Rome''s main attractions. Each features a full kitchen or kitchenette, a private bathroom, and a TV. Check-in is done at the Old Town office in Via Firenze 43. Here guests will be given instructions on how to reach the chosen apartment. The staff can also arrange a pick-up service from both airports.</p>', 'chesnut@solidres.com', 'http://www.chesnut.cs', 0, '888-888-888', 4, NULL, 106, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 1, 0, '0000-00-00 00:00:00', 10, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":"logo.png"}', '', 443, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 41.901554, 12.502005, 0, 0, 1, 0.00, 0, 1, NULL, 0),
  (11, 127, NULL, 'Lavender', 'lavender', 'Via Vespasiano 122, Vatican', '', 'Rome', '039595', '123-456-789', '<p>The 5-star Pan Pacific Singapore has direct access to Marina Square Mall and Suntec Convention Centre. It is at the gateway of <hr id="system-readmore" /> Singapore’s Central Business and Financial Districts and it features an outdoor pool, 6 dining options and free Wi-Fi throughout the hotel.</p>\r\n<p>The spacious rooms at Singapore Pan Pacific showcase full-length windows featuring panoramic views of the city. All rooms come equipped with flat-screen satellite TVs and have marble bathrooms and work desks.</p>\r\n<p>Guests can exercise at the fitness center or the 2 tennis courts. Massage services and therapies are available at St. Gregory Spa. Car rentals and a tour desk are available.</p>\r\n<p>An outdoor breakfast is available at Brunch Café. Other dining options include Keyaki Japanese Restaurant, Hai Tien Lo Cantonese Restaurant and Rang Mahal Indian Restaurant. Drinks and snacks are served at Keyaki Bar and Atrium Deli. Pan Pacific Singapore is a 5-minute walk from Promenade MRT Station. Changi International Airport is a 20-minute drive from the hotel.</p>', 'lavender@solidres.com', 'http://www.lavender.lv', 0, '888-888-888', 5, NULL, 106, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 1, 0, '0000-00-00 00:00:00', 11, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":"logo.png"}', '', 232, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 41.909058, 12.456822, 0, 0, 1, 0.00, 0, 1, NULL, 0),
  (12, 128, NULL, 'Lotus', 'lotus', '11 Tanglin Road, Orchard', '', 'Singapore', '247911', '123-456-789', '<p>Signature 24-hour St. Regis Butler Service, exclusive Bentleys with chauffeurs, and an award-winning spa are some of the luxuries <hr id="system-readmore" /> one can expect at The St. Regis Singapore. The 5-star hotel also has a premier gallery which houses some of Asia''s finest art collections.</p>\r\n<p>The European-style rooms include a flat-screen TV, DVD player and Bose surround sound system. Fragrant teabags by TWG, as well as feather pillows, are provided. The French marble bathroom has double sinks, a separate soaking tub, rain showers and Laboratoire Rem</p>', 'lotus@solidres.com', 'http://www.lotus.lt', 0, '888-888-888', 3, NULL, 189, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 1, 0, '0000-00-00 00:00:00', 12, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":"logo.png"}', '', 139, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 1.306366, 103.826355, 0, 0, 1, 0.00, 0, 1, NULL, 0),
  (13, 130, NULL, 'Mango', 'mango', '2090 Bayport Drive, Tampa', '', 'Florida ', '33607', '123-456-789', '<p>This Tampa hotel is 1 mile from the Tampa International Airport and 8 miles from the Tampa Bay Times Forum. Two outdoor pools, 3 restaurants, and 24-hour fitness center are available throughout their stay.</p>\r\n<p>All guest rooms include a flat-screen cable TV, an iPod docking station, and a sitting area at the Grand Hyatt Tampa Bay. Coffee-making facilities and a desk are provided.</p>\r\n<p>Tampa Grand Hyatt guests can soak in the hot tub or schedule a massage. A 24-hour front desk and free local area transport service are available for added convenience.</p>\r\n<p>An Italian-inspired dinner can be found at Armani''s. Oystercatchers serves specialty cocktails highlighting fresh fruit and herbs like blackberries, strawberries, and basil. Special diets can be accommodated upon request. The 1823 Kitchen and Bar restaurant is also on site.</p>\r\n<p>Guests can explore the extensive Greek and Roman art collections of the Tampa Museum of Art, just 8 miles from the hotel. The wildlife and roller coasters of Busch Gardens Tampa are 17 miles away.</p>', 'mango@solidres.com', 'http://www.mango.mg', 0, '888-888-888', 4, NULL, 224, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 1, 0, '0000-00-00 00:00:00', 13, 0, 1, 1, '{"termsofuse":"13","privacypolicy":"14","disclaimer":"","only_show_reservation_form":"0","enable_coupon":"1","logo":""}', '', 3, '', '', '', '{"robots":"","author":"","rights":""}', NULL, 27.966927, -82.550362, 0, 0, 1, 0.00, 0, 1, NULL, 0);


INSERT INTO `#__sr_room_types` (`id`, `reservation_asset_id`, `name`, `alias`, `description`, `state`, `checked_out`, `checked_out_time`, `created_by`, `created_date`, `modified_by`, `modified_date`, `language`, `params`, `featured`, `ordering`, `occupancy_max`, `occupancy_adult`, `occupancy_child`, `smoking`) VALUES
  (15, 8, 'Colonial Superior', 'colonial-superior', '<p>This room measures 377 square feet (35 square meters). Complimentary wired and wireless Internet access keeps you connected, and the television is offered for your entertainment. <hr id="system-readmore" />A minibar and a refrigerator are provided. The private bathroom has a bathtub, as well as slippers, complimentary toiletries, and a hair dryer. Climate control, complimentary bottled water, and a safe are among the included amenities. Non-smoking. Free Wireless Internet. Breakfast Buffet.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2012-07-21 04:28:07', 0, '2014-11-26 04:10:53', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 10, 0, 2, 0, 0),
  (16, 8, 'Colonial River Deluxe', 'colonial-river-deluxe', '<p>Measuring 452-484 square feet (42-45 square meters). Complimentary wired and wireless Internet access keeps you connected, and the television is offered for your entertainment. <hr id="system-readmore" />A minibar and a refrigerator are provided. The private bathroom has a bathtub, as well as slippers, complimentary toiletries, and a hair dryer. Climate control, complimentary bottled water, and a safe are among the included amenities. Non-smoking. Free Wireless Internet. Breakfast Buffet.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2012-07-21 04:36:02', 0, '2014-11-26 04:10:18', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 11, 0, 3, 2, 0),
  (17, 8, 'Colonial Deluxe ', 'colonial-deluxe', '<p>Measuring 452-484 square feet (42-45 square meters). Complimentary wired and wireless Internet access keeps you connected, and the television is offered for your entertainment. <hr id="system-readmore" />A minibar and a refrigerator are provided. The private bathroom has a bathtub, as well as slippers, complimentary toiletries, and a hair dryer. Climate control, complimentary bottled water, and a safe are among the included amenities. Non-smoking. Free Wireless Internet. Breakfast Buffet.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2012-07-21 08:00:05', 0, '2014-11-25 08:57:52', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 12, 0, 2, 0, 0),
  (18, 8, 'Colonial Suite', 'colonial-suite', '<p>60 square meters. Windows open to view of the city and river. Living room. Desk. Television with premium cable/satellite channels. Complimentary wired and wireless Internet access. <hr id="system-readmore" /> In-room safe. Refrigerator and minibar. Ensuite bathroom with bathtub. Bath amenities include hair dryer, makeup/shaving mirror, and complimentary toiletries. Slippers. Iron/ironing board. Air conditioning.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2012-07-21 08:40:15', 0, '2014-11-25 09:22:04', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 13, 0, 2, 2, 0),
  (19, 8, 'Executive Deluxe', 'executive-deluxe', '<p>Television with premium cable/satellite channels. Complimentary wired and wireless Internet access. In-room safe. Refrigerator and minibar. Ensuite bathroom with bathtub. <hr id="system-readmore" />  Internet access. Bath amenities include hair dryer, makeup/shaving mirror, and complimentary toiletries. Slippers. Iron/ironing board. Air conditioning.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2012-07-21 08:46:16', 0, '2014-11-25 09:30:11', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 14, 0, 2, 2, 0),
  (20, 10, 'Clemente One-Bedroom Apartment ', 'clemente-one-bedroom-apartment', '<p>Set on the 3d floor of an elegant building, just minutes from the Colosseum and the Imperial Forum.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 09:28:05', 0, '2014-11-26 03:56:34', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 15, 0, 4, 0, 0),
  (21, 9, 'Leonardo One-Bedroom Apartment ', 'leonardo-one-bedroom-apartment', '<p>In the Monti district near Cavour Metro Station, line B, one stop from Termini Train Station. <br /> <br />On the 3d floor of a building with no elevator.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 09:30:50', 0, '2014-11-26 04:08:32', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 16, 0, 2, 2, 0),
  (22, 10, 'Two-Bedroom Apartment with Park View ', 'two-bedroom-apartment-with-park-view', '<p>Large apartment on the 3d floor of a residential building with an elevator. Rome Termini Train Station is one metro (subway) stop away.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 09:32:46', 0, '2014-11-26 04:06:37', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 17, 0, 6, 2, 0),
  (23, 9, 'Ninfeo Studio Apartment ', 'ninfeo-studio-apartment', '<p>Near Manzoni Metro Station, line A, within easy reach of the Colosseum and Roma Termini Train Station.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 10:14:17', 0, '2014-11-26 04:05:12', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 18, 0, 2, 1, 0),
  (24, 12, 'Grand Deluxe Twin Room ', 'grand-deluxe-twin-room', '<p>Enjoying scenic views of Tanglin Road and the Botanical Gardens, this spacious room features silk wallpaper and a Jim Thompson sofa. A 42-inch flat-screen TV, DVD player and a writing desk are included. The French marble bathroom has a separate bathtub and relaxing rain showers.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 10:17:50', 0, '2014-11-26 04:05:37', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 19, 0, 2, 2, 0),
  (25, 12, 'Lady Astor Deluxe Twin Room', 'lady-astor-deluxe-twin-room', '<p>This luxuriously decorated room with its signature linens and Jim Thompson silk pillows, features window seats and a green marble-topped coffee table.</p>\r\n<p>The Lady Astor Room also includes a 40-inch flat-screen TV, DVD player and Bose surround system. The French marble bathroom comes with a separate bathtub and rain showers.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 10:21:07', 0, '2014-11-26 04:08:10', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 20, 0, 2, 1, 0),
  (26, 11, 'Panoramic King Room ', 'panoramic-king-room', '<p>Featuring panoramic views of the city skyline from its floor-to-ceiling windows, each room includes a 32-inch LCD TV, desk with ergonomic Herman Miller chair, Nespresso machine and minibar. The private bathroom includes speakers, a rain shower and Kaldewei bathtub.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-07-02 10:24:16', 0, '2014-11-26 04:07:43', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 21, 0, 2, 1, 0),
  (27, 11, 'Queen Room', 'queen-room', '<p>This spacious room features a cable TV, air conditioning, free Wi-Fi and an iPod docking station.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-08-04 04:41:00', 0, '2014-11-26 04:06:13', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 22, 0, 2, 1, 0),
  (28, 13, 'King Room', 'king-room', '<p>This room includes a flat-screen cable TV, a sitting area and coffee-making facilities.</p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-11-26 03:13:25', 0, '2014-11-26 04:09:47', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 23, 0, 2, 0, 0),
  (29, 13, 'Casita Double', 'casita-double', '<p>This room features a small refrigerator, a flat-screen cable TV and coffee-making facilities. A patio is also included. </p>', 1, 0, '0000-00-00 00:00:00', 0, '2014-11-26 03:21:57', 0, '2014-11-26 04:09:02', '*', '{"show_smoking_option":"1","show_child_option":"1"}', 0, 24, 0, 2, 2, 0);


INSERT INTO `#__sr_coupons` (`id`, `state`, `coupon_name`, `coupon_code`, `amount`, `is_percent`, `valid_from`, `valid_to`, `customer_group_id`, `reservation_asset_id`, `valid_from_checkin`, `valid_to_checkin`, `quantity`, `params`) VALUES
  (1, 1, 'Valentine', 'VLT', 20, 0, '2011-02-01', '2020-02-01', NULL, NULL, '2011-02-01', '2020-02-01', 50, '{"article":"","image":""}'),
  (2, 1, 'Christmas', 'CHR', 15, 1, '2011-12-01', '2020-12-01', NULL, NULL, '2011-12-01', '2020-12-01', 50, '{"article":"","image":""}'),
  (3, 1, 'New Year', 'NYR', 10, 1, '2011-01-01', '2020-12-01', NULL, NULL, '2011-01-01', '2020-01-01', 50, '{"article":"","image":""}'),
  (4, 1, 'Woman''s Day', 'WMD', 30, 0, '2012-03-01', '2020-03-01', NULL, NULL, '2012-03-01', '2020-03-01', 50, '{"article":"","image":""}'),
  (5, 1, 'Summer Holiday', 'SHD', 10, 1, '2012-07-01', '2020-10-24', NULL, NULL, '2012-07-01', '2020-10-24', 50, '{"article":"16","image":"img4.jpg"}'),
  (6, 1, 'Special Sunday', 'SPS', 25, 1, '2014-10-01', '2020-11-30', NULL, NULL, '2014-10-01', '2020-11-30', 20, '{"article":"16","image":"img1.jpg"}'),
  (7, 1, 'Day Spa Offer', 'DSO', 15, 0, '2014-10-01', '2020-10-31', NULL, NULL, '2014-10-01', '2020-12-31', 50, '{"article":"16","image":"img2.jpg"}'),
  (8, 1, '2 Nights Stay', '2NS', 50, 0, '2014-10-01', '2020-10-31', NULL, NULL, '2014-10-01', '2020-11-30', 100, '{"article":"16","image":"img3.jpg"}');


INSERT INTO `#__sr_coupon_item_xref` (`coupon_id`, `item_id`) VALUES
  (6, 8),
  (7, 8),
  (8, 8),
  (1, 9),
  (2, 10),
  (3, 11),
  (4, 12),
  (5, 13);


INSERT INTO `#__sr_media` (`id`, `type`, `value`, `name`, `created_date`, `modified_date`, `created_by`, `modified_by`, `mime_type`, `size`) VALUES
  (1, 'IMAGE', 'hotel_sample_1.jpg', 'hotel_sample_1.jpg', '2012-09-07 03:05:00', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 92565),
  (2, 'IMAGE', 'hotel_sample_2.jpg', 'hotel_sample_2.jpg', '2012-09-07 03:05:01', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 365011),
  (3, 'IMAGE', 'hotel_sample_3.jpg', 'hotel_sample_3.jpg', '2012-09-07 03:05:01', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 537281),
  (4, 'IMAGE', 'hotel_sample_4.jpg', 'hotel_sample_4.jpg', '2012-09-07 03:05:02', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 82480),
  (5, 'IMAGE', 'hotel_sample_5.jpg', 'hotel_sample_5.jpg', '2012-09-07 03:05:02', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 685284),
  (6, 'IMAGE', 'hotel_sample_6.jpg', 'hotel_sample_6.jpg', '2012-09-07 03:05:03', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 1008552),
  (7, 'IMAGE', 'hotel_sample_7.jpg', 'hotel_sample_7.jpg', '2012-09-07 03:05:04', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 30735),
  (8, 'IMAGE', 'hotel_sample_8.jpg', 'hotel_sample_8.jpg', '2012-09-07 03:05:04', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 129852),
  (9, 'IMAGE', 'hotel_sample_9.jpg', 'hotel_sample_9.jpg', '2012-09-07 03:05:05', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 273128),
  (10, 'IMAGE', 'hotel_sample_10.jpg', 'hotel_sample_10.jpg', '2012-09-07 03:05:06', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 60243),
  (11, 'IMAGE', 'hotel_sample_11.jpg', 'hotel_sample_11.jpg', '2012-09-07 03:05:06', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 1155508),
  (12, 'IMAGE', 'hotel_sample_12.jpg', 'hotel_sample_12.jpg', '2012-09-07 03:05:07', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 577485),
  (13, 'IMAGE', 'hotel_sample_13.jpg', 'hotel_sample_13.jpg', '2012-09-07 03:05:08', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 481832),
  (14, 'IMAGE', 'hotel_sample_14.jpg', 'hotel_sample_14.jpg', '2012-09-07 03:05:09', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 76248),
  (15, 'IMAGE', 'hotel_sample_15.jpg', 'hotel_sample_15.jpg', '2012-09-07 03:05:09', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 30439),
  (16, 'IMAGE', 'hotel_sample_16.jpg', 'hotel_sample_16.jpg', '2012-09-07 03:05:10', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 154914),
  (17, 'IMAGE', 'hotel_sample_17.jpg', 'hotel_sample_17.jpg', '2012-09-07 03:16:34', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 219293),
  (18, 'IMAGE', 'hotel_sample_18.jpg', 'hotel_sample_18.jpg', '2012-09-07 03:16:35', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 2430634),
  (19, 'IMAGE', 'hotel_sample_19.jpg', 'hotel_sample_19.jpg', '2012-09-07 03:16:39', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 6443822),
  (20, 'IMAGE', 'hotel_sample_20.jpg', 'hotel_sample_20.jpg', '2012-09-07 03:16:45', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 3925100),
  (21, 'IMAGE', 'hotel_sample_21.jpg', 'hotel_sample_21.jpg', '2012-09-07 03:16:49', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 3192027),
  (22, 'IMAGE', 'hotel_sample_22.jpg', 'hotel_sample_22.jpg', '2012-09-07 03:27:19', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 535906),
  (23, 'IMAGE', 'hotel_sample_23.jpg', 'hotel_sample_23.jpg', '2012-09-07 03:27:22', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 722604),
  (24, 'IMAGE', 'hotel_sample_24.jpg', 'hotel_sample_24.jpg', '2012-09-07 03:27:23', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 1364680),
  (25, 'IMAGE', 'hotel_sample_25.jpg', 'hotel_sample_25.jpg', '2012-09-07 03:27:25', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 2365965),
  (71, 'IMAGE', 'hotel_sample_26.jpg', 'hotel_sample_26.jpg', '2014-11-25 08:52:48', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 111694),
  (72, 'IMAGE', 'hotel_sample_27.jpg', 'hotel_sample_27.jpg', '2014-11-25 08:52:49', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 135863),
  (73, 'IMAGE', 'hotel_sample_28.jpg', 'hotel_sample_28.jpg', '2014-11-25 08:52:49', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 138376),
  (74, 'IMAGE', 'hotel_sample_29.jpg', 'hotel_sample_29.jpg', '2014-11-25 08:52:50', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 106184),
  (75, 'IMAGE', 'hotel_sample_30.jpg', 'hotel_sample_30.jpg', '2014-11-25 08:52:50', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 114907),
  (76, 'IMAGE', 'hotel_sample_31.jpg', 'hotel_sample_31.jpg', '2014-11-25 08:52:51', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 144014),
  (77, 'IMAGE', 'hotel_sample_32.jpg', 'hotel_sample_32.jpg', '2014-11-25 08:52:51', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 128339),
  (78, 'IMAGE', 'hotel_sample_33.jpg', 'hotel_sample_33.jpg', '2014-11-25 08:52:52', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 120160),
  (79, 'IMAGE', 'hotel_sample_34.jpg', 'hotel_sample_34.jpg', '2014-11-25 08:52:52', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 150446),
  (80, 'IMAGE', 'hotel_sample_35.jpg', 'hotel_sample_35.jpg', '2014-11-25 08:52:53', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 85427),
  (81, 'IMAGE', 'hotel_sample_36.jpg', 'hotel_sample_36.jpg', '2014-11-25 08:52:53', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 100897),
  (82, 'IMAGE', 'hotel_sample_37.jpg', 'hotel_sample_37.jpg', '2014-11-25 08:52:54', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 105235),
  (83, 'IMAGE', 'hotel_sample_38.jpg', 'hotel_sample_38.jpg', '2014-11-25 08:52:54', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 141538),
  (84, 'IMAGE', 'hotel_sample_39.jpg', 'hotel_sample_39.jpg', '2014-11-25 08:52:55', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 143419),
  (85, 'IMAGE', 'hotel_sample_40.jpg', 'hotel_sample_40.jpg', '2014-11-25 08:52:55', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 131105),
  (86, 'IMAGE', 'hotel_sample_41.jpg', 'hotel_sample_41.jpg', '2014-11-25 08:54:53', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 147549),
  (87, 'IMAGE', 'hotel_sample_42.jpg', 'hotel_sample_42.jpg', '2014-11-25 08:54:54', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 128298),
  (88, 'IMAGE', 'hotel_sample_43.jpg', 'hotel_sample_43.jpg', '2014-11-25 08:54:54', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 79509),
  (89, 'IMAGE', 'hotel_sample_44.jpg', 'hotel_sample_44.jpg', '2014-11-25 08:54:55', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 151567),
  (90, 'IMAGE', 'hotel_sample_45.jpg', 'hotel_sample_45.jpg', '2014-11-25 08:54:55', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 126635),
  (91, 'IMAGE', 'hotel_sample_46.jpg', 'hotel_sample_46.jpg', '2014-11-25 08:54:56', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 101939),
  (92, 'IMAGE', 'hotel_sample_47.jpg', 'hotel_sample_47.jpg', '2014-11-25 08:54:56', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 131689),
  (93, 'IMAGE', 'hotel_sample_48.jpg', 'hotel_sample_48.jpg', '2014-11-25 08:54:57', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 144756),
  (94, 'IMAGE', 'hotel_sample_49.jpg', 'hotel_sample_49.jpg', '2014-11-25 08:54:57', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 133626),
  (95, 'IMAGE', 'hotel_sample_50.jpg', 'hotel_sample_50.jpg', '2014-11-25 08:54:58', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 134611),
  (96, 'IMAGE', 'img1.jpg', 'img1.jpg', '2014-11-25 08:54:58', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 58636),
  (97, 'IMAGE', 'img2.jpg', 'img2.jpg', '2014-11-25 08:54:59', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 40979),
  (98, 'IMAGE', 'img3.jpg', 'img3.jpg', '2014-11-25 08:54:59', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 41032),
  (99, 'IMAGE', 'img4.jpg', 'img4.jpg', '2014-11-25 08:55:00', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 40024),
  (100, 'IMAGE', 'img5.jpg', 'img5.jpg', '2014-11-25 08:55:00', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 114542),
  (101, 'IMAGE', 'img6.jpg', 'img6.jpg', '2014-11-25 08:55:01', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 118045),
  (102, 'IMAGE', 'img7.jpg', 'img7.jpg', '2014-11-25 08:55:01', '0000-00-00 00:00:00', 0, 0, 'image/jpeg', 86107),
  (103, 'IMAGE', 'logo.png', 'logo.png', '2014-11-25 08:55:01', '0000-00-00 00:00:00', 0, 0, 'image/png', 5463);


INSERT INTO `#__sr_extras` (`id`, `name`, `state`, `description`, `created_date`, `modified_date`, `created_by`, `modified_by`, `price`, `price_adult`, `price_child`, `ordering`, `max_quantity`, `daily_chargable`, `reservation_asset_id`, `mandatory`, `charge_type`, `tax_id`, `params`) VALUES
  (1, 'Wine', 1, '<p>Wine for your sweet valentine</p>', '2011-05-07 08:58:50', '2011-05-07 09:10:20', 0, 0, '100.00', '0.00', '0.00', 1, 10, 1, 11, 0, 0, NULL, '{"article":"","image":""}'),
  (2, 'Beer', 1, '<p>Beer</p>', '2011-05-07 09:11:12', '0000-00-00 00:00:00', 0, 0, '50.00', '0.00', '0.00', 1, 10, 1, 10, 0, 0, NULL, '{"article":"","image":""}'),
  (3, 'Flower', 1, '<p>Flower</p>', '2011-05-07 09:14:36', '0000-00-00 00:00:00', 0, 0, '25.00', '0.00', '0.00', 1, 20, 1, 9, 0, 0, NULL, '{"article":"","image":""}'),
  (4, 'Airport pickup', 1, '<p>We will pick you up at the airport</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '45.00', '0.00', '0.00', 2, 10, 1, 8, 0, 1, NULL, '{"article":"15","image":"img5.jpg"}'),
  (5, 'Buffet Breakfast', 1, '<p>Daily International Buffet Breakfast</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '75.00', '0.00', '0.00', 3, 10, 1, 8, 0, 0, NULL, '{"article":"15","image":"img7.jpg"}'),
  (6, 'Spa Packages', 1, '<p>Spa Packages</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '50.00', '0.00', '0.00', 4, 5, 1, 8, 1, 0, NULL, '{"article":"15","image":"img6.jpg"}'),
  (7, 'Extra adult', 1, '<p>Add extra adult to current room (using extra bed)</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '35.00', '0.00', '0.00', 5, 1, 1, 13, 0, 0, NULL, '{"article":"","image":""}'),
  (8, 'Extra child', 1, '<p>Add extra child to current room (using current bed)</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '20.00', '0.00', '0.00', 6, 1, 1, 12, 0, 0, NULL, '{"article":"","image":""}'),
  (9, 'Room cleaning', 1, '<p>Room cleaning service (Mandatory)</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '20.00', '0.00', '0.00', 7, 1, 1, 8, 1, 0, NULL, '{"article":"15","image":"extra2.jpg"}'),
  (10, 'Beverage Services', 1, '<p>Beverage Services</p>', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, '150.00', '0.00', '0.00', 8, 1, 1, 8, 1, 0, NULL, '{"article":"","image":""}');


INSERT INTO `#__sr_tariffs` (`id`, `currency_id`, `customer_group_id`, `valid_from`, `valid_to`, `room_type_id`, `title`, `description`, `d_min`, `d_max`, `d_interval`, `p_min`, `p_max`, `type`, `limit_checkin`, `state`, `mode`) VALUES
  (6, 1, NULL, '2014-06-01', '2020-08-31', 18, 'Enjoy the summer', 'Our special tariff for you sunny summer!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (7, 1, NULL, '2014-12-01', '2020-12-31', 18, 'Happy new year - Non refundable', 'Happy new year!', 1, 10, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (8, 1, NULL, '2014-06-01', '2020-08-31', 16, 'Summer Holiday', 'Enjoy your summer holiday at our hotel!', 1, 10, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (12, 1, NULL, '2014-06-01', '2020-08-31', 15, 'Summer Holiday - 2 Nights Stay!', 'Enjoy your summer holiday at our hotel!', 2, 6, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (13, 1, NULL, '2014-02-01', '2020-09-28', 19, 'Valentine', 'Special tariff for couple!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (41, 1, NULL, '2014-07-01', '2020-12-31', 20, 'Free Sunday', 'One night gratis! Book now a stay of minimum 2 nights and get your Sunday night for free!', 1, 10, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (42, 1, NULL, '2014-07-01', '2020-11-30', 17, 'Summer Big Offer', 'Enjoy a variety of our beach activities during your stay!', 2, 2, 0, NULL, NULL, 3, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (45, 1, NULL, '2014-07-01', '2020-12-31', 22, 'Happy new year', 'Happy new year!', 1, 5, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (48, 1, NULL, '2014-07-01', '2020-01-01', 23, 'Summer Holiday', 'Enjoy your summer holiday at our hotel!', 2, 5, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (52, 1, NULL, '2014-07-01', '2020-12-01', 24, 'Enjoy the summer - Breakfast included', 'Enjoy a variety of our beach activities during your stay!', 1, 5, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (55, 1, NULL, '2014-07-01', '2020-12-01', 25, 'Summer Holiday', 'Enjoy your summer holiday at our hotel!', 3, 3, 0, NULL, NULL, 2, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\"]', 1, 0),
  (58, 1, NULL, '2014-07-01', '2020-12-01', 26, 'Summer Big Offer', 'Enjoy a variety of our beach activities during your stay!', 1, 10, 0, NULL, NULL, 0, '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (68, 1, NULL, '0000-00-00', '0000-00-00', 17, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (70, 1, NULL, '0000-00-00', '0000-00-00', 18, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (71, 1, NULL, '0000-00-00', '0000-00-00', 15, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (72, 1, NULL, '0000-00-00', '0000-00-00', 19, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (73, 1, NULL, '0000-00-00', '0000-00-00', 20, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (80, 1, NULL, '0000-00-00', '0000-00-00', 27, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (81, 1, NULL, '2014-07-01', '2020-07-16', 27, 'Summer Offers', 'Enjoy your summer holiday at our hotel!', 1, 5, 0, NULL, NULL, 0, '[\"1\",\"2\",\"3\",\"4\",\"5\"]', 1, 0),
  (82, 1, NULL, '2014-07-01', '2020-07-02', 17, 'Summer Big Offer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (83, 1, NULL, '2014-07-01', '2020-07-01', 16, 'Summer Holiday - FREE cancellation', 'Enjoy your summer holiday at our hotel!', 2, 2, 0, NULL, NULL, 2, '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (84, 1, NULL, '2014-11-01', '2020-11-02', 15, 'Summer Offers', 'Enjoy your summer holiday at our hotel!', 1, 10, 0, NULL, NULL, 1, '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (85, 1, NULL, '2014-11-25', '2020-11-26', 19, 'Special Sunday!', 'Our special tariff for you sunny summer!', 1, 5, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (86, 1, NULL, '2014-07-01', '2020-07-02', 20, 'Summer Holiday - 2 Nights Stay!', 'Enjoy your summer holiday at our hotel!', 2, 2, 0, NULL, NULL, 3, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (87, 1, NULL, '2014-07-01', '2020-07-02', 22, 'Summer Holiday - FREE cancellation', 'Enjoy your summer holiday at our hotel!', 1, 10, 0, NULL, NULL, 0, '[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (88, 1, NULL, '2014-07-01', '2020-07-10', 26, 'Summer Big Offer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (89, 1, NULL, '0000-00-00', '0000-00-00', 26, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (90, 1, NULL, '2014-07-01', '2020-07-31', 27, 'Summer Holiday - 2 Nights Stay!', 'Our special tariff for you sunny summer!', 2, 2, 0, NULL, NULL, 2, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (91, 1, NULL, '2014-07-01', '2020-07-24', 24, 'Enjoy the summer - FREE cancellation', 'Enjoy your summer holiday at our hotel!', 1, 10, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (92, 1, NULL, '0000-00-00', '0000-00-00', 24, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (93, 1, NULL, '0000-00-00', '0000-00-00', 25, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (94, 1, NULL, '2014-07-17', '2020-07-17', 25, 'Summer Holiday - 2 Nights Stay!', 'Enjoy your summer holiday at our hotel!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (95, 1, NULL, '0000-00-00', '0000-00-00', 21, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (96, 1, NULL, '2014-07-01', '2020-09-30', 21, 'Enjoy the summer', 'Enjoy this great summer at our hotels!', 3, 3, 0, NULL, NULL, 3, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (97, 1, NULL, '2014-07-01', '2020-07-02', 21, 'Enjoy the summer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (99, 1, NULL, '0000-00-00', '0000-00-00', 23, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (100, 1, NULL, '2014-07-15', '2020-07-16', 23, 'Special Sunday!', 'Our special tariff for you sunny summer!', 1, 5, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (101, 1, NULL, '0000-00-00', '0000-00-00', 22, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (102, 1, NULL, '0000-00-00', '0000-00-00', 16, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (103, 1, NULL, '0000-00-00', '0000-00-00', 28, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (104, 1, NULL, '0000-00-00', '0000-00-00', 29, '', '', NULL, NULL, 0, NULL, NULL, 0, '', 1, 0),
  (105, 1, NULL, '2014-11-05', '2020-11-06', 28, 'Summer Holiday', 'Enjoy your summer holiday at our hotel!', 1, 10, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (106, 1, NULL, '2014-11-26', '2020-11-27', 28, 'Summer Holiday - 2 Nights Stay!', 'Enjoy your summer holiday at our hotel!', 2, 2, 0, NULL, NULL, 2, '[\"1\",\"2\",\"3\",\"4\",\"5\"]', 1, 0),
  (107, 1, NULL, '2014-11-25', '2020-11-26', 29, 'Enjoy the summer', 'Enjoy a variety of our beach activities during your stay!', 1, 5, 0, NULL, NULL, 0, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0),
  (108, 1, NULL, '2014-11-01', '2020-11-02', 29, 'Enjoy the summer - Breakfast included', 'Enjoy a variety of our beach activities during your stay!', 1, 10, 0, NULL, NULL, 1, '[\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\"]', 1, 0);


INSERT INTO `#__sr_tariff_details` (`id`, `tariff_id`, `price`, `w_day`, `guest_type`, `from_age`, `to_age`) VALUES
  (36, 6, '155.00', 0, 'adult1', NULL, NULL),
  (37, 6, '135.00', 1, 'adult1', NULL, NULL),
  (38, 6, '135.00', 2, 'adult1', NULL, NULL),
  (39, 6, '135.00', 3, 'adult1', NULL, NULL),
  (40, 6, '135.00', 4, 'adult1', NULL, NULL),
  (41, 6, '135.00', 5, 'adult1', NULL, NULL),
  (42, 6, '155.00', 6, 'adult1', NULL, NULL),
  (43, 6, '145.00', 0, 'adult2', NULL, NULL),
  (44, 6, '125.00', 1, 'adult2', NULL, NULL),
  (45, 6, '125.00', 2, 'adult2', NULL, NULL),
  (46, 6, '125.00', 3, 'adult2', NULL, NULL),
  (47, 6, '125.00', 4, 'adult2', NULL, NULL),
  (48, 6, '125.00', 5, 'adult2', NULL, NULL),
  (49, 6, '145.00', 6, 'adult2', NULL, NULL),
  (50, 6, '75.00', 0, 'child1', 10, 17),
  (51, 6, '70.00', 1, 'child1', 10, 17),
  (52, 6, '70.00', 2, 'child1', 10, 17),
  (53, 6, '70.00', 3, 'child1', 10, 17),
  (54, 6, '70.00', 4, 'child1', 10, 17),
  (55, 6, '70.00', 5, 'child1', 10, 17),
  (56, 6, '75.00', 6, 'child1', 10, 17),
  (57, 6, '60.00', 0, 'child2', 0, 9),
  (58, 6, '55.00', 1, 'child2', 0, 9),
  (59, 6, '55.00', 2, 'child2', 0, 9),
  (60, 6, '55.00', 3, 'child2', 0, 9),
  (61, 6, '55.00', 4, 'child2', 0, 9),
  (62, 6, '55.00', 5, 'child2', 0, 9),
  (63, 6, '60.00', 6, 'child2', 0, 9),
  (64, 7, '170.00', 0, NULL, NULL, NULL),
  (65, 7, '160.00', 1, NULL, NULL, NULL),
  (66, 7, '160.00', 2, NULL, NULL, NULL),
  (67, 7, '160.00', 3, NULL, NULL, NULL),
  (68, 7, '160.00', 4, NULL, NULL, NULL),
  (69, 7, '160.00', 5, NULL, NULL, NULL),
  (70, 7, '165.00', 6, NULL, NULL, NULL),
  (71, 8, '150.00', 0, NULL, NULL, NULL),
  (72, 8, '140.00', 1, NULL, NULL, NULL),
  (73, 8, '140.00', 2, NULL, NULL, NULL),
  (74, 8, '140.00', 3, NULL, NULL, NULL),
  (75, 8, '140.00', 4, NULL, NULL, NULL),
  (76, 8, '140.00', 5, NULL, NULL, NULL),
  (77, 8, '145.00', 6, NULL, NULL, NULL),
  (99, 12, '177.00', 0, 'adult1', NULL, NULL),
  (100, 12, '155.00', 1, 'adult1', NULL, NULL),
  (101, 12, '155.00', 2, 'adult1', NULL, NULL),
  (102, 12, '155.00', 3, 'adult1', NULL, NULL),
  (103, 12, '155.00', 4, 'adult1', NULL, NULL),
  (104, 12, '155.00', 5, 'adult1', NULL, NULL),
  (105, 12, '166.00', 6, 'adult1', NULL, NULL),
  (106, 12, '177.00', 0, 'adult2', NULL, NULL),
  (107, 12, '155.00', 1, 'adult2', NULL, NULL),
  (108, 12, '155.00', 2, 'adult2', NULL, NULL),
  (109, 12, '155.00', 3, 'adult2', NULL, NULL),
  (110, 12, '155.00', 4, 'adult2', NULL, NULL),
  (111, 12, '155.00', 5, 'adult2', NULL, NULL),
  (112, 12, '166.00', 6, 'adult2', NULL, NULL),
  (113, 13, '125.00', 0, 'adult1', NULL, NULL),
  (114, 13, '125.00', 1, 'adult1', NULL, NULL),
  (115, 13, '125.00', 2, 'adult1', NULL, NULL),
  (116, 13, '125.00', 3, 'adult1', NULL, NULL),
  (117, 13, '125.00', 4, 'adult1', NULL, NULL),
  (118, 13, '125.00', 5, 'adult1', NULL, NULL),
  (119, 13, '125.00', 6, 'adult1', NULL, NULL),
  (120, 13, '120.00', 0, 'adult2', NULL, NULL),
  (121, 13, '120.00', 1, 'adult2', NULL, NULL),
  (122, 13, '120.00', 2, 'adult2', NULL, NULL),
  (123, 13, '120.00', 3, 'adult2', NULL, NULL),
  (124, 13, '120.00', 4, 'adult2', NULL, NULL),
  (125, 13, '120.00', 5, 'adult2', NULL, NULL),
  (126, 13, '120.00', 6, 'adult2', NULL, NULL),
  (127, 13, '85.00', 0, 'child1', 10, 17),
  (128, 13, '85.00', 1, 'child1', 10, 17),
  (129, 13, '85.00', 2, 'child1', 10, 17),
  (130, 13, '85.00', 3, 'child1', 10, 17),
  (131, 13, '85.00', 4, 'child1', 10, 17),
  (132, 13, '85.00', 5, 'child1', 10, 17),
  (133, 13, '85.00', 6, 'child1', 10, 17),
  (134, 13, '70.00', 0, 'child2', 0, 9),
  (135, 13, '70.00', 1, 'child2', 0, 9),
  (136, 13, '70.00', 2, 'child2', 0, 9),
  (137, 13, '70.00', 3, 'child2', 0, 9),
  (138, 13, '70.00', 4, 'child2', 0, 9),
  (139, 13, '70.00', 5, 'child2', 0, 9),
  (140, 13, '70.00', 6, 'child2', 0, 9),
  (330, 41, '125.00', 0, NULL, NULL, NULL),
  (331, 41, '125.00', 1, NULL, NULL, NULL),
  (332, 41, '125.00', 2, NULL, NULL, NULL),
  (333, 41, '125.00', 3, NULL, NULL, NULL),
  (334, 41, '125.00', 4, NULL, NULL, NULL),
  (335, 41, '125.00', 5, NULL, NULL, NULL),
  (336, 41, '125.00', 6, NULL, NULL, NULL),
  (372, 45, '220.00', 0, NULL, NULL, NULL),
  (373, 45, '220.00', 1, NULL, NULL, NULL),
  (374, 45, '220.00', 2, NULL, NULL, NULL),
  (375, 45, '220.00', 3, NULL, NULL, NULL),
  (376, 45, '220.00', 4, NULL, NULL, NULL),
  (377, 45, '220.00', 5, NULL, NULL, NULL),
  (378, 45, '220.00', 6, NULL, NULL, NULL),
  (393, 48, '250.00', 0, NULL, NULL, NULL),
  (394, 48, '250.00', 1, NULL, NULL, NULL),
  (395, 48, '250.00', 2, NULL, NULL, NULL),
  (396, 48, '250.00', 3, NULL, NULL, NULL),
  (397, 48, '250.00', 4, NULL, NULL, NULL),
  (398, 48, '250.00', 5, NULL, NULL, NULL),
  (399, 48, '250.00', 6, NULL, NULL, NULL),
  (470, 58, '255.00', 0, NULL, NULL, NULL),
  (471, 58, '255.00', 1, NULL, NULL, NULL),
  (472, 58, '255.00', 2, NULL, NULL, NULL),
  (473, 58, '255.00', 3, NULL, NULL, NULL),
  (474, 58, '255.00', 4, NULL, NULL, NULL),
  (475, 58, '255.00', 5, NULL, NULL, NULL),
  (476, 58, '255.00', 6, NULL, NULL, NULL),
  (540, 68, '180.00', 0, NULL, NULL, NULL),
  (541, 68, '175.00', 1, NULL, NULL, NULL),
  (542, 68, '175.00', 2, NULL, NULL, NULL),
  (543, 68, '175.00', 3, NULL, NULL, NULL),
  (544, 68, '175.00', 4, NULL, NULL, NULL),
  (545, 68, '175.00', 5, NULL, NULL, NULL),
  (546, 68, '180.00', 6, NULL, NULL, NULL),
  (554, 70, '122.00', 0, NULL, NULL, NULL),
  (555, 70, '133.00', 1, NULL, NULL, NULL),
  (556, 70, '144.00', 2, NULL, NULL, NULL),
  (557, 70, '155.00', 3, NULL, NULL, NULL),
  (558, 70, '166.00', 4, NULL, NULL, NULL),
  (559, 70, '177.00', 5, NULL, NULL, NULL),
  (560, 70, '188.00', 6, NULL, NULL, NULL),
  (561, 71, '155.00', 0, NULL, NULL, NULL),
  (562, 71, '166.00', 1, NULL, NULL, NULL),
  (563, 71, '155.00', 2, NULL, NULL, NULL),
  (564, 71, '166.00', 3, NULL, NULL, NULL),
  (565, 71, '155.00', 4, NULL, NULL, NULL),
  (566, 71, '166.00', 5, NULL, NULL, NULL),
  (567, 71, '155.00', 6, NULL, NULL, NULL),
  (568, 72, '133.00', 0, NULL, NULL, NULL),
  (569, 72, '144.00', 1, NULL, NULL, NULL),
  (570, 72, '133.00', 2, NULL, NULL, NULL),
  (571, 72, '144.00', 3, NULL, NULL, NULL),
  (572, 72, '133.00', 4, NULL, NULL, NULL),
  (573, 72, '144.00', 5, NULL, NULL, NULL),
  (574, 72, '133.00', 6, NULL, NULL, NULL),
  (575, 73, '125.00', 0, NULL, NULL, NULL),
  (576, 73, '125.00', 1, NULL, NULL, NULL),
  (577, 73, '125.00', 2, NULL, NULL, NULL),
  (578, 73, '125.00', 3, NULL, NULL, NULL),
  (579, 73, '125.00', 4, NULL, NULL, NULL),
  (580, 73, '125.00', 5, NULL, NULL, NULL),
  (581, 73, '125.00', 6, NULL, NULL, NULL),
  (624, 80, '205.00', 0, NULL, NULL, NULL),
  (625, 80, '205.00', 1, NULL, NULL, NULL),
  (626, 80, '205.00', 2, NULL, NULL, NULL),
  (627, 80, '205.00', 3, NULL, NULL, NULL),
  (628, 80, '205.00', 4, NULL, NULL, NULL),
  (629, 80, '205.00', 5, NULL, NULL, NULL),
  (630, 80, '205.00', 6, NULL, NULL, NULL),
  (631, 81, '189.00', 0, NULL, NULL, NULL),
  (632, 81, '189.00', 1, NULL, NULL, NULL),
  (633, 81, '189.00', 2, NULL, NULL, NULL),
  (634, 81, '189.00', 3, NULL, NULL, NULL),
  (635, 81, '189.00', 4, NULL, NULL, NULL),
  (636, 81, '189.00', 5, NULL, NULL, NULL),
  (637, 81, '189.00', 6, NULL, NULL, NULL),
  (638, 82, '145.00', 0, 'adult1', NULL, NULL),
  (639, 82, '145.00', 1, 'adult1', NULL, NULL),
  (640, 82, '145.00', 2, 'adult1', NULL, NULL),
  (641, 82, '145.00', 3, 'adult1', NULL, NULL),
  (642, 82, '145.00', 4, 'adult1', NULL, NULL),
  (643, 82, '145.00', 5, 'adult1', NULL, NULL),
  (644, 82, '145.00', 6, 'adult1', NULL, NULL),
  (645, 82, '135.00', 0, 'adult2', NULL, NULL),
  (646, 82, '135.00', 1, 'adult2', NULL, NULL),
  (647, 82, '135.00', 2, 'adult2', NULL, NULL),
  (648, 82, '135.00', 3, 'adult2', NULL, NULL),
  (649, 82, '135.00', 4, 'adult2', NULL, NULL),
  (650, 82, '135.00', 5, 'adult2', NULL, NULL),
  (651, 82, '135.00', 6, 'adult2', NULL, NULL),
  (659, 84, '199.00', 0, 'adult1', NULL, NULL),
  (660, 84, '199.00', 1, 'adult1', NULL, NULL),
  (661, 84, '199.00', 2, 'adult1', NULL, NULL),
  (662, 84, '199.00', 3, 'adult1', NULL, NULL),
  (663, 84, '199.00', 4, 'adult1', NULL, NULL),
  (664, 84, '199.00', 5, 'adult1', NULL, NULL),
  (665, 84, '199.00', 6, 'adult1', NULL, NULL),
  (666, 84, '189.00', 0, 'adult2', NULL, NULL),
  (667, 84, '189.00', 1, 'adult2', NULL, NULL),
  (668, 84, '189.00', 2, 'adult2', NULL, NULL),
  (669, 84, '189.00', 3, 'adult2', NULL, NULL),
  (670, 84, '189.00', 4, 'adult2', NULL, NULL),
  (671, 84, '189.00', 5, 'adult2', NULL, NULL),
  (672, 84, '189.00', 6, 'adult2', NULL, NULL),
  (673, 85, '190.00', 0, NULL, NULL, NULL),
  (674, 85, '180.00', 1, NULL, NULL, NULL),
  (675, 85, '180.00', 2, NULL, NULL, NULL),
  (676, 85, '180.00', 3, NULL, NULL, NULL),
  (677, 85, '180.00', 4, NULL, NULL, NULL),
  (678, 85, '180.00', 5, NULL, NULL, NULL),
  (679, 85, '190.00', 6, NULL, NULL, NULL),
  (708, 87, '235.00', 0, NULL, NULL, NULL),
  (709, 87, '235.00', 1, NULL, NULL, NULL),
  (710, 87, '235.00', 2, NULL, NULL, NULL),
  (711, 87, '235.00', 3, NULL, NULL, NULL),
  (712, 87, '235.00', 4, NULL, NULL, NULL),
  (713, 87, '235.00', 5, NULL, NULL, NULL),
  (714, 87, '235.00', 6, NULL, NULL, NULL),
  (715, 89, '275.00', 0, NULL, NULL, NULL),
  (716, 89, '275.00', 1, NULL, NULL, NULL),
  (717, 89, '275.00', 2, NULL, NULL, NULL),
  (718, 89, '275.00', 3, NULL, NULL, NULL),
  (719, 89, '275.00', 4, NULL, NULL, NULL),
  (720, 89, '275.00', 5, NULL, NULL, NULL),
  (721, 89, '275.00', 6, NULL, NULL, NULL),
  (722, 88, '275.00', 0, 'adult1', NULL, NULL),
  (723, 88, '275.00', 1, 'adult1', NULL, NULL),
  (724, 88, '275.00', 2, 'adult1', NULL, NULL),
  (725, 88, '275.00', 3, 'adult1', NULL, NULL),
  (726, 88, '275.00', 4, 'adult1', NULL, NULL),
  (727, 88, '275.00', 5, 'adult1', NULL, NULL),
  (728, 88, '275.00', 6, 'adult1', NULL, NULL),
  (729, 88, '265.00', 0, 'adult2', NULL, NULL),
  (730, 88, '265.00', 1, 'adult2', NULL, NULL),
  (731, 88, '265.00', 2, 'adult2', NULL, NULL),
  (732, 88, '265.00', 3, 'adult2', NULL, NULL),
  (733, 88, '265.00', 4, 'adult2', NULL, NULL),
  (734, 88, '265.00', 5, 'adult2', NULL, NULL),
  (735, 88, '265.00', 6, 'adult2', NULL, NULL),
  (736, 88, '135.00', 0, 'child1', 0, 17),
  (737, 88, '135.00', 1, 'child1', 0, 17),
  (738, 88, '135.00', 2, 'child1', 0, 17),
  (739, 88, '135.00', 3, 'child1', 0, 17),
  (740, 88, '135.00', 4, 'child1', 0, 17),
  (741, 88, '135.00', 5, 'child1', 0, 17),
  (742, 88, '135.00', 6, 'child1', 0, 17),
  (750, 52, '200.00', 0, NULL, NULL, NULL),
  (751, 52, '200.00', 1, NULL, NULL, NULL),
  (752, 52, '200.00', 2, NULL, NULL, NULL),
  (753, 52, '200.00', 3, NULL, NULL, NULL),
  (754, 52, '200.00', 4, NULL, NULL, NULL),
  (755, 52, '200.00', 5, NULL, NULL, NULL),
  (756, 52, '200.00', 6, NULL, NULL, NULL),
  (757, 91, '10.00', 0, NULL, NULL, NULL),
  (758, 91, '10.00', 1, NULL, NULL, NULL),
  (759, 91, '1.00', 2, NULL, NULL, NULL),
  (760, 91, '0.00', 3, NULL, NULL, NULL),
  (761, 91, '10.00', 4, NULL, NULL, NULL),
  (762, 91, '1.00', 5, NULL, NULL, NULL),
  (763, 91, '1.00', 6, NULL, NULL, NULL),
  (764, 92, '377.00', 0, NULL, NULL, NULL),
  (765, 92, '377.00', 1, NULL, NULL, NULL),
  (766, 92, '377.00', 2, NULL, NULL, NULL),
  (767, 92, '377.00', 3, NULL, NULL, NULL),
  (768, 92, '377.00', 4, NULL, NULL, NULL),
  (769, 92, '377.00', 5, NULL, NULL, NULL),
  (770, 92, '377.00', 6, NULL, NULL, NULL),
  (771, 91, '155.00', 0, 'adult1', NULL, NULL),
  (772, 91, '155.00', 1, 'adult1', NULL, NULL),
  (773, 91, '155.00', 2, 'adult1', NULL, NULL),
  (774, 91, '155.00', 3, 'adult1', NULL, NULL),
  (775, 91, '155.00', 4, 'adult1', NULL, NULL),
  (776, 91, '155.00', 5, 'adult1', NULL, NULL),
  (777, 91, '155.00', 6, 'adult1', NULL, NULL),
  (778, 91, '155.00', 0, 'adult2', NULL, NULL),
  (779, 91, '155.00', 1, 'adult2', NULL, NULL),
  (780, 91, '155.00', 2, 'adult2', NULL, NULL),
  (781, 91, '155.00', 3, 'adult2', NULL, NULL),
  (782, 91, '155.00', 4, 'adult2', NULL, NULL),
  (783, 91, '155.00', 5, 'adult2', NULL, NULL),
  (784, 91, '155.00', 6, 'adult2', NULL, NULL),
  (785, 91, '65.00', 0, 'child1', 6, 17),
  (786, 91, '65.00', 1, 'child1', 6, 17),
  (787, 91, '65.00', 2, 'child1', 6, 17),
  (788, 91, '65.00', 3, 'child1', 6, 17),
  (789, 91, '65.00', 4, 'child1', 6, 17),
  (790, 91, '65.00', 5, 'child1', 6, 17),
  (791, 91, '65.00', 6, 'child1', 6, 17),
  (792, 91, '35.00', 0, 'child2', 0, 5),
  (793, 91, '35.00', 1, 'child2', 0, 5),
  (794, 91, '35.00', 2, 'child2', 0, 5),
  (795, 91, '35.00', 3, 'child2', 0, 5),
  (796, 91, '35.00', 4, 'child2', 0, 5),
  (797, 91, '35.00', 5, 'child2', 0, 5),
  (798, 91, '35.00', 6, 'child2', 0, 5),
  (799, 93, '409.00', 0, NULL, NULL, NULL),
  (800, 93, '409.00', 1, NULL, NULL, NULL),
  (801, 93, '409.00', 2, NULL, NULL, NULL),
  (802, 93, '409.00', 3, NULL, NULL, NULL),
  (803, 93, '409.00', 4, NULL, NULL, NULL),
  (804, 93, '409.00', 5, NULL, NULL, NULL),
  (805, 93, '409.00', 6, NULL, NULL, NULL),
  (806, 94, '199.00', 0, 'adult1', NULL, NULL),
  (807, 94, '199.00', 1, 'adult1', NULL, NULL),
  (808, 94, '199.00', 2, 'adult1', NULL, NULL),
  (809, 94, '199.00', 3, 'adult1', NULL, NULL),
  (810, 94, '199.00', 4, 'adult1', NULL, NULL),
  (811, 94, '199.00', 5, 'adult1', NULL, NULL),
  (812, 94, '199.00', 6, 'adult1', NULL, NULL),
  (813, 94, '179.00', 0, 'adult2', NULL, NULL),
  (814, 94, '179.00', 1, 'adult2', NULL, NULL),
  (815, 94, '179.00', 2, 'adult2', NULL, NULL),
  (816, 94, '179.00', 3, 'adult2', NULL, NULL),
  (817, 94, '179.00', 4, 'adult2', NULL, NULL),
  (818, 94, '179.00', 5, 'adult2', NULL, NULL),
  (819, 94, '179.00', 6, 'adult2', NULL, NULL),
  (820, 94, '149.00', 0, 'child1', 0, 17),
  (821, 94, '149.00', 1, 'child1', 0, 17),
  (822, 94, '149.00', 2, 'child1', 0, 17),
  (823, 94, '149.00', 3, 'child1', 0, 17),
  (824, 94, '149.00', 4, 'child1', 0, 17),
  (825, 94, '149.00', 5, 'child1', 0, 17),
  (826, 94, '149.00', 6, 'child1', 0, 17),
  (827, 95, '120.00', 0, NULL, NULL, NULL),
  (828, 95, '120.00', 1, NULL, NULL, NULL),
  (829, 95, '120.00', 2, NULL, NULL, NULL),
  (830, 95, '120.00', 3, NULL, NULL, NULL),
  (831, 95, '120.00', 4, NULL, NULL, NULL),
  (832, 95, '120.00', 5, NULL, NULL, NULL),
  (833, 95, '120.00', 6, NULL, NULL, NULL),
  (856, 97, '155.00', 0, 'adult1', NULL, NULL),
  (857, 97, '155.00', 1, 'adult1', NULL, NULL),
  (858, 97, '155.00', 2, 'adult1', NULL, NULL),
  (859, 97, '155.00', 3, 'adult1', NULL, NULL),
  (860, 97, '155.00', 4, 'adult1', NULL, NULL),
  (861, 97, '155.00', 5, 'adult1', NULL, NULL),
  (862, 97, '155.00', 6, 'adult1', NULL, NULL),
  (863, 97, '150.00', 0, 'adult2', NULL, NULL),
  (864, 97, '150.00', 1, 'adult2', NULL, NULL),
  (865, 97, '150.00', 2, 'adult2', NULL, NULL),
  (866, 97, '150.00', 3, 'adult2', NULL, NULL),
  (867, 97, '150.00', 4, 'adult2', NULL, NULL),
  (868, 97, '150.00', 5, 'adult2', NULL, NULL),
  (869, 97, '150.00', 6, 'adult2', NULL, NULL),
  (870, 97, '80.00', 0, 'child1', 10, 17),
  (871, 97, '80.00', 1, 'child1', 10, 17),
  (872, 97, '80.00', 2, 'child1', 10, 17),
  (873, 97, '80.00', 3, 'child1', 10, 17),
  (874, 97, '80.00', 4, 'child1', 10, 17),
  (875, 97, '80.00', 5, 'child1', 10, 17),
  (876, 97, '80.00', 6, 'child1', 10, 17),
  (877, 97, '50.00', 0, 'child2', 0, 9),
  (878, 97, '50.00', 1, 'child2', 0, 9),
  (879, 97, '50.00', 2, 'child2', 0, 9),
  (880, 97, '50.00', 3, 'child2', 0, 9),
  (881, 97, '50.00', 4, 'child2', 0, 9),
  (882, 97, '50.00', 5, 'child2', 0, 9),
  (883, 97, '50.00', 6, 'child2', 0, 9),
  (891, 99, '180.00', 0, NULL, NULL, NULL),
  (892, 99, '180.00', 1, NULL, NULL, NULL),
  (893, 99, '180.00', 2, NULL, NULL, NULL),
  (894, 99, '180.00', 3, NULL, NULL, NULL),
  (895, 99, '180.00', 4, NULL, NULL, NULL),
  (896, 99, '180.00', 5, NULL, NULL, NULL),
  (897, 99, '180.00', 6, NULL, NULL, NULL),
  (898, 100, '178.00', 0, 'adult1', NULL, NULL),
  (899, 100, '178.00', 1, 'adult1', NULL, NULL),
  (900, 100, '178.00', 2, 'adult1', NULL, NULL),
  (901, 100, '178.00', 3, 'adult1', NULL, NULL),
  (902, 100, '178.00', 4, 'adult1', NULL, NULL),
  (903, 100, '178.00', 5, 'adult1', NULL, NULL),
  (904, 100, '178.00', 6, 'adult1', NULL, NULL),
  (905, 100, '168.00', 0, 'adult2', NULL, NULL),
  (906, 100, '168.00', 1, 'adult2', NULL, NULL),
  (907, 100, '168.00', 2, 'adult2', NULL, NULL),
  (908, 100, '168.00', 3, 'adult2', NULL, NULL),
  (909, 100, '168.00', 4, 'adult2', NULL, NULL),
  (910, 100, '168.00', 5, 'adult2', NULL, NULL),
  (911, 100, '168.00', 6, 'adult2', NULL, NULL),
  (912, 100, '130.00', 0, 'child1', 0, 17),
  (913, 100, '130.00', 1, 'child1', 0, 17),
  (914, 100, '130.00', 2, 'child1', 0, 17),
  (915, 100, '130.00', 3, 'child1', 0, 17),
  (916, 100, '130.00', 4, 'child1', 0, 17),
  (917, 100, '130.00', 5, 'child1', 0, 17),
  (918, 100, '130.00', 6, 'child1', 0, 17),
  (919, 101, '135.00', 0, NULL, NULL, NULL),
  (920, 101, '135.00', 1, NULL, NULL, NULL),
  (921, 101, '135.00', 2, NULL, NULL, NULL),
  (922, 101, '135.00', 3, NULL, NULL, NULL),
  (923, 101, '135.00', 4, NULL, NULL, NULL),
  (924, 101, '135.00', 5, NULL, NULL, NULL),
  (925, 101, '135.00', 6, NULL, NULL, NULL),
  (926, 102, '170.00', 0, NULL, NULL, NULL),
  (927, 102, '170.00', 1, NULL, NULL, NULL),
  (928, 102, '170.00', 2, NULL, NULL, NULL),
  (929, 102, '170.00', 3, NULL, NULL, NULL),
  (930, 102, '170.00', 4, NULL, NULL, NULL),
  (931, 102, '170.00', 5, NULL, NULL, NULL),
  (932, 102, '170.00', 6, NULL, NULL, NULL),
  (933, 42, '200.00', 8, 'adult1', NULL, NULL),
  (934, 42, '190.00', 8, 'adult2', NULL, NULL),
  (935, 83, '300.00', 8, NULL, NULL, NULL),
  (936, 86, '210.00', 8, 'adult1', NULL, NULL),
  (937, 86, '209.00', 8, 'adult2', NULL, NULL),
  (938, 86, '189.00', 8, 'adult3', NULL, NULL),
  (939, 86, '189.00', 8, 'adult4', NULL, NULL),
  (940, 90, '286.00', 8, NULL, NULL, NULL),
  (941, 55, '409.00', 8, NULL, NULL, NULL),
  (942, 96, '300.00', 8, 'adult1', NULL, NULL),
  (943, 96, '290.00', 8, 'adult2', NULL, NULL),
  (944, 96, '150.00', 8, 'child1', 10, 17),
  (945, 96, '100.00', 8, 'child2', 0, 9),
  (946, 103, '210.00', 0, NULL, NULL, NULL),
  (947, 103, '180.00', 1, NULL, NULL, NULL),
  (948, 103, '180.00', 2, NULL, NULL, NULL),
  (949, 103, '180.00', 3, NULL, NULL, NULL),
  (950, 103, '180.00', 4, NULL, NULL, NULL),
  (951, 103, '180.00', 5, NULL, NULL, NULL),
  (952, 103, '210.00', 6, NULL, NULL, NULL),
  (953, 104, '220.00', 0, NULL, NULL, NULL),
  (954, 104, '220.00', 1, NULL, NULL, NULL),
  (955, 104, '220.00', 2, NULL, NULL, NULL),
  (956, 104, '220.00', 3, NULL, NULL, NULL),
  (957, 104, '220.00', 4, NULL, NULL, NULL),
  (958, 104, '220.00', 5, NULL, NULL, NULL),
  (959, 104, '220.00', 6, NULL, NULL, NULL),
  (960, 105, '200.00', 0, 'adult1', NULL, NULL),
  (961, 105, '200.00', 1, 'adult1', NULL, NULL),
  (962, 105, '200.00', 2, 'adult1', NULL, NULL),
  (963, 105, '200.00', 3, 'adult1', NULL, NULL),
  (964, 105, '200.00', 4, 'adult1', NULL, NULL),
  (965, 105, '200.00', 5, 'adult1', NULL, NULL),
  (966, 105, '200.00', 6, 'adult1', NULL, NULL),
  (967, 105, '190.00', 0, 'adult2', NULL, NULL),
  (968, 105, '190.00', 1, 'adult2', NULL, NULL),
  (969, 105, '190.00', 2, 'adult2', NULL, NULL),
  (970, 105, '190.00', 3, 'adult2', NULL, NULL),
  (971, 105, '190.00', 4, 'adult2', NULL, NULL),
  (972, 105, '190.00', 5, 'adult2', NULL, NULL),
  (973, 105, '190.00', 6, 'adult2', NULL, NULL),
  (974, 106, '390.00', 8, NULL, NULL, NULL),
  (975, 107, '210.00', 0, NULL, NULL, NULL),
  (976, 107, '200.00', 1, NULL, NULL, NULL),
  (977, 107, '200.00', 2, NULL, NULL, NULL),
  (978, 107, '200.00', 3, NULL, NULL, NULL),
  (979, 107, '200.00', 4, NULL, NULL, NULL),
  (980, 107, '200.00', 5, NULL, NULL, NULL),
  (981, 107, '210.00', 6, NULL, NULL, NULL),
  (982, 108, '240.00', 0, 'adult1', NULL, NULL),
  (983, 108, '240.00', 1, 'adult1', NULL, NULL),
  (984, 108, '240.00', 2, 'adult1', NULL, NULL),
  (985, 108, '240.00', 3, 'adult1', NULL, NULL),
  (986, 108, '240.00', 4, 'adult1', NULL, NULL),
  (987, 108, '240.00', 5, 'adult1', NULL, NULL),
  (988, 108, '240.00', 6, 'adult1', NULL, NULL),
  (989, 108, '235.00', 0, 'adult2', NULL, NULL),
  (990, 108, '235.00', 1, 'adult2', NULL, NULL),
  (991, 108, '235.00', 2, 'adult2', NULL, NULL),
  (992, 108, '235.00', 3, 'adult2', NULL, NULL),
  (993, 108, '235.00', 4, 'adult2', NULL, NULL),
  (994, 108, '235.00', 5, 'adult2', NULL, NULL),
  (995, 108, '235.00', 6, 'adult2', NULL, NULL),
  (996, 108, '150.00', 0, 'child1', 10, 17),
  (997, 108, '150.00', 1, 'child1', 10, 17),
  (998, 108, '150.00', 2, 'child1', 10, 17),
  (999, 108, '150.00', 3, 'child1', 10, 17),
  (1000, 108, '150.00', 4, 'child1', 10, 17),
  (1001, 108, '150.00', 5, 'child1', 10, 17),
  (1002, 108, '150.00', 6, 'child1', 10, 17),
  (1003, 108, '125.00', 0, 'child2', 0, 9),
  (1004, 108, '125.00', 1, 'child2', 0, 9),
  (1005, 108, '125.00', 2, 'child2', 0, 9),
  (1006, 108, '125.00', 3, 'child2', 0, 9),
  (1007, 108, '125.00', 4, 'child2', 0, 9),
  (1008, 108, '125.00', 5, 'child2', 0, 9),
  (1009, 108, '125.00', 6, 'child2', 0, 9);


INSERT INTO `#__sr_rooms` (`id`, `label`, `room_type_id`) VALUES
  (33, 'X001', 15),
  (34, 'X002', 15),
  (35, 'X003', 15),
  (36, 'X004', 15),
  (37, 'V101', 16),
  (38, 'V102', 16),
  (39, 'V201', 16),
  (40, 'V202', 16),
  (41, 'CD01', 17),
  (42, 'CD02', 17),
  (43, 'CD03', 17),
  (44, 'CD04', 17),
  (45, 'CD05', 17),
  (46, 'CD05', 17),
  (47, 'CS001', 18),
  (48, 'CS002', 18),
  (49, 'CS003', 18),
  (50, 'CS004', 18),
  (51, 'CS005', 18),
  (52, 'ED001', 19),
  (53, 'ED002', 19),
  (54, 'ED003', 19),
  (55, 'ED004', 19),
  (56, 'CO001', 20),
  (57, 'CO002', 20),
  (58, 'CO003', 20),
  (59, 'CO004', 20),
  (60, 'CO005', 20),
  (61, 'LO001', 21),
  (62, 'LO002', 21),
  (63, 'LO003', 21),
  (64, 'AP001', 22),
  (65, 'AP002', 22),
  (66, 'AP003', 22),
  (67, 'AP004', 22),
  (68, 'AP005', 22),
  (69, 'NS001', 23),
  (70, 'NS002', 23),
  (71, 'NS003', 23),
  (72, 'NS004', 23),
  (73, 'GD001', 24),
  (74, 'GD002', 24),
  (75, 'GD003', 24),
  (76, 'LA001', 25),
  (77, 'LA002', 25),
  (78, 'LA003', 25),
  (79, 'LA004', 25),
  (80, 'LA005', 25),
  (81, 'PK001', 26),
  (82, 'PK002', 26),
  (83, 'PK003', 26),
  (84, 'QR001', 27),
  (85, 'QR002', 27),
  (86, 'QR003', 27),
  (87, 'QR004', 27),
  (88, 'KR001', 28),
  (89, 'KR002', 28),
  (90, 'KR003', 28),
  (91, 'KR004', 28),
  (92, 'KR005', 28),
  (93, 'CD001', 29),
  (94, 'CD002', 29),
  (95, 'CD003', 29),
  (96, 'CD004', 29),
  (97, 'PK004', 26),
  (98, 'GD004', 24),
  (99, 'LO004', 21),
  (100, 'LO005', 21);


INSERT INTO `#__sr_media_reservation_assets_xref` (`media_id`, `reservation_asset_id`, `weight`) VALUES
  (1, 10, 0),
  (1, 13, 0),
  (2, 10, 1),
  (2, 13, 1),
  (3, 10, 2),
  (4, 10, 3),
  (5, 8, 1),
  (6, 11, 0),
  (7, 11, 1),
  (8, 11, 2),
  (9, 11, 3),
  (10, 12, 0),
  (11, 12, 1),
  (11, 13, 2),
  (12, 8, 2),
  (13, 12, 2),
  (14, 8, 0),
  (15, 12, 3),
  (16, 9, 0),
  (17, 8, 4),
  (18, 9, 1),
  (19, 9, 2),
  (20, 9, 3),
  (21, 10, 4),
  (21, 13, 3),
  (22, 8, 3),
  (23, 11, 4),
  (24, 8, 5),
  (24, 13, 4),
  (25, 12, 4),
  (71, 10, 5),
  (72, 10, 6),
  (73, 10, 7),
  (74, 10, 8),
  (75, 11, 5),
  (76, 11, 6),
  (77, 11, 7),
  (78, 11, 8),
  (79, 12, 5),
  (80, 12, 6),
  (81, 12, 7),
  (82, 12, 8),
  (83, 9, 4),
  (84, 9, 5),
  (85, 9, 6),
  (86, 9, 7),
  (87, 13, 5),
  (88, 13, 6),
  (89, 13, 7),
  (90, 13, 8),
  (91, 10, 9),
  (92, 11, 9),
  (93, 12, 9),
  (94, 9, 8),
  (95, 9, 9),
  (95, 13, 9);

INSERT INTO `#__sr_media_roomtype_xref` (`media_id`, `room_type_id`, `weight`) VALUES
  (21, 17, 0),
  (72, 17, 1),
  (73, 17, 2),
  (74, 17, 3),
  (75, 17, 4),
  (23, 18, 0),
  (76, 18, 1),
  (80, 18, 2),
  (81, 18, 3),
  (82, 18, 4),
  (25, 19, 0),
  (78, 19, 1),
  (87, 19, 2),
  (88, 19, 3),
  (89, 19, 4),
  (21, 20, 0),
  (76, 20, 1),
  (77, 20, 2),
  (78, 20, 3),
  (79, 20, 4),
  (25, 23, 0),
  (72, 23, 1),
  (74, 23, 2),
  (88, 23, 3),
  (93, 23, 4),
  (22, 24, 0),
  (87, 24, 1),
  (88, 24, 2),
  (89, 24, 3),
  (90, 24, 4),
  (23, 27, 0),
  (83, 27, 1),
  (84, 27, 2),
  (85, 27, 3),
  (86, 27, 4),
  (25, 22, 0),
  (71, 22, 1),
  (72, 22, 2),
  (73, 22, 3),
  (74, 22, 4),
  (22, 26, 0),
  (75, 26, 1),
  (80, 26, 2),
  (81, 26, 3),
  (82, 26, 4),
  (24, 25, 0),
  (86, 25, 1),
  (87, 25, 2),
  (89, 25, 3),
  (91, 25, 4),
  (21, 21, 0),
  (71, 21, 1),
  (73, 21, 2),
  (75, 21, 3),
  (92, 21, 4),
  (24, 29, 0),
  (76, 29, 1),
  (78, 29, 2),
  (81, 29, 3),
  (82, 29, 4),
  (25, 28, 0),
  (74, 28, 1),
  (75, 28, 2),
  (86, 28, 3),
  (87, 28, 4),
  (22, 16, 0),
  (71, 16, 1),
  (79, 16, 2),
  (85, 16, 3),
  (90, 16, 4),
  (24, 15, 0),
  (77, 15, 1),
  (83, 15, 2),
  (84, 15, 3),
  (86, 15, 4);


INSERT INTO `#__sr_reservation_asset_fields` (`reservation_asset_id`, `field_key`, `field_value`, `ordering`) VALUES
  (8, 'reservationasset_extra_fields.accepted_credit_cards', '{lang en}American Express, Visa, Euro/Mastercard, Diners Club, Maestro\r\nThe hotel reserves the right to pre-authorise credit cards prior to arrival..{/lang}\r\n{lang it}American Express, Visa, Euro / Mastercard, Diners, Maestro\r\nL''hotel si riserva il diritto di controllare le carte di credito prima dell''arrivo di appartenenza.{/lang}\r\n{lang de}American Express, Visa, Euro / Mastercard, Diners Club, Maestro\r\nDas Hotel behält sich das Recht vor, eine Autorisierung der Kreditkarte vor Anreise vorzunehmen.{/lang}\r\n{lang fr}American Express, Visa, Euro / Mastercard, Diners Club, Maestro\r\nL''hôtel se réserve le droit d''effectuer une pré-autorisation de la carte de crédit avant la date d''arrivée.{/lang}', 11),
  (9, 'reservationasset_extra_fields.accepted_credit_cards', 'American Express, Visa, Euro/Mastercard, Diners Club, Maestro. The hotel reserves the right to pre-authorise credit cards prior to arrival..', 11),
  (10, 'reservationasset_extra_fields.accepted_credit_cards', 'American Express, Visa, Euro/Mastercard, Diners Club, Maestro. The hotel reserves the right to pre-authorise credit cards prior to arrival.. ', 11),
  (11, 'reservationasset_extra_fields.accepted_credit_cards', 'American Express, Visa, Euro/Mastercard, Diners Club, Maestro. The hotel reserves the right to pre-authorise credit cards prior to arrival..', 11),
  (12, 'reservationasset_extra_fields.accepted_credit_cards', 'American Express, Visa, Euro/Mastercard, Diners Club, Maestro. The hotel reserves the right to pre-authorise credit cards prior to arrival.. ', 11),
  (13, 'reservationasset_extra_fields.accepted_credit_cards', 'American Express, Visa, Euro/Mastercard, Diners Club, Maestro. The hotel reserves the right to pre-authorise credit cards prior to arrival..', 11),
  (8, 'reservationasset_extra_fields.activities', '{lang en}Sauna, Fitness Center, Casino, Spa , Massage, Pool Table, Hot Tub, BBQ Facilities, Outdoor Swimming Pool, Outdoor Swimming Pool (All Year).{/lang}\r\n{lang it}Sauna, centro fitness, casinò, spa, massaggi, biliardo, vasca idromassaggio, accessori per barbecue, piscina all''aperto, piscina all''aperto (tutto l''anno).{/lang}\r\n{lang fr}Sauna, centre de remise en forme, casino, spa, massages, billard, bain à remous, installations pour barbecue, piscine extérieure, piscine extérieure (toute l''année).{/lang}\r\n{lang de}Sauna, Fitness-Center, Casino, Spa, Massage, Billard, Whirlpool, Grillmöglichkeiten, Außenpool, Außenpool (ganzjährig){/lang}', 2),
  (9, 'reservationasset_extra_fields.activities', 'Sauna, Fitness Center, Spa, Massage, Hot Tub, Turkish/Steam Bath ', 2),
  (10, 'reservationasset_extra_fields.activities', 'Tennis Court, Fitness Center, Spa, Massage ', 2),
  (11, 'reservationasset_extra_fields.activities', 'Tennis Court, Sauna, Fitness Center, Spa, Massage, Hot Tub, Turkish/Steam Bath ', 2),
  (12, 'reservationasset_extra_fields.activities', 'Newspapers, Tennis Court, Fitness Center, Spa, Massage ', 2),
  (13, 'reservationasset_extra_fields.activities', 'Tennis Court, Fitness Center, Massage, Hot Tub', 2),
  (8, 'reservationasset_extra_fields.cancellation_prepayment', '{lang en}Cancellation and prepayment policies vary according to room type. Please check the room conditions when selecting your room above. {/lang}\r\n{lang it}Condizioni relative alla cancellazione e al pagamento anticipato variano a seconda della tipologia di alloggio. Verifica le condizioni della camera quando si seleziona la tua stanza di sopra.{/lang}\r\n{lang fr}Les conditions d''annulation et de prépaiement varient en fonction du type de chambre. S''il vous plaît vérifier les conditions de la pièce lorsque vous choisissez votre chambre au-dessus{/lang}\r\n{lang de}Die Stornierungs-und Vorauszahlungsbedingungen ändern sich je nach Zimmerkategorie. Bitte lesen Sie die Bedingungen bei der Auswahl Ihres Zimmers oben{/lang}', 8),
  (9, 'reservationasset_extra_fields.cancellation_prepayment', 'Cancellation and prepayment policies vary according to apartment type. Please enter the dates of your stay and check what conditions apply to your preferred room. ', 8),
  (10, 'reservationasset_extra_fields.cancellation_prepayment', 'Cancellation and prepayment policies vary according to apartment type. Please check the Apartment Conditions when selecting your apartment above. ', 8),
  (11, 'reservationasset_extra_fields.cancellation_prepayment', 'Cancellation and prepayment policies vary according to room type. Please enter the dates of your stay and check what conditions apply to your preferred room. ', 8),
  (12, 'reservationasset_extra_fields.cancellation_prepayment', 'Cancellation and prepayment policies vary according to room type. Please check what room conditions may apply when selecting your room above. ', 8),
  (13, 'reservationasset_extra_fields.cancellation_prepayment', 'Cancellation and prepayment policies vary according to room type. Please check what room conditions may apply when selecting your room above.', 8),
  (8, 'reservationasset_extra_fields.checkin_time', '{lang en}From 14:00 hours.{/lang} {lang it}Dalle ore 14:00.{/lang}{lang de}Ab 14:00 Uhr.{/lang}{lang fr}À partir de 14:00 heures{/lang}', 6),
  (9, 'reservationasset_extra_fields.checkin_time', '12:30 - 20:00 ', 6),
  (10, 'reservationasset_extra_fields.checkin_time', '15:00 - 21:00 ', 6),
  (11, 'reservationasset_extra_fields.checkin_time', 'From 15:00 ', 6),
  (12, 'reservationasset_extra_fields.checkin_time', 'From 15:00', 6),
  (13, 'reservationasset_extra_fields.checkin_time', 'From 15:00', 6),
  (8, 'reservationasset_extra_fields.checkout_time', '{lang en}Until 12:00 hours.{/lang} {lang it}Fino alle ore 12:00.{/lang}{lang ge}Bis 12:00 Uhr.{/lang}{lang fr}Jusqu''à 12:00 heures{/lang}', 7),
  (9, 'reservationasset_extra_fields.checkout_time', '06:00 - 10:30 ', 7),
  (10, 'reservationasset_extra_fields.checkout_time', '07:00 - 11:00 ', 7),
  (11, 'reservationasset_extra_fields.checkout_time', 'Until 12:00 ', 7),
  (12, 'reservationasset_extra_fields.checkout_time', 'Until 12:00', 7),
  (13, 'reservationasset_extra_fields.checkout_time', 'Until 12:00', 7),
  (8, 'reservationasset_extra_fields.children_and_extra_beds', '{lang en}Free! All children under 12 years stay free of charge when using existing beds.\r\nFree! One child under 2 years stays free of charge in a baby cot.\r\nOne older child or adult is charged USD 69.30 per night and person in an extra bed.{/lang}\r\n{lang it}Gratis! Tutti i bambini di età inferiore a 12 anni soggiornano gratuitamente nel letto dei genitori.\r\nGratis! Un bambino di età inferiore a 2 anni soggiorna gratuitamente pernottando nella culla.\r\nUn bambino di età superiore o adulto paga USD 69,30 per persona a notte pernottando nel letto supplementare.{/lang}\r\n{lang fr}Gratuit! Tous les enfants de moins de 12 ans séjournent à titre gracieux pour l''utilisation des lits bébés.\r\nGratuit! Un enfant de moins de 2 ans séjournent à titre gracieux d''un lit bébé.\r\nUn enfant plus âgé ou adulte est facturé 69,30 USD par nuit et par personne pour un lit d''appoint.{/lang}\r\n{lang de}Kostenlos! Alle Kinder unter 12 Jahren zahlen keinen Aufpreis in einem der vorhandenen Betten.\r\nKostenlos! Ein Kind unter 2 Jahren zahlt keinen Aufpreis für ein Babybett.\r\nEin älteres Kind oder Erwachsener zahlt USD 69,30 pro Nacht und Person für ein Zustellbett.{/lang}', 9),
  (9, 'reservationasset_extra_fields.children_and_extra_beds', 'One child under 3 years is charged EUR 15 per person per night in a crib.\r\n\r\nOne older child or adult is charged EUR 25 per person per night in an extra bed.\r\n\r\nThe maximum number of cribs in a room is 1.\r\n\r\nThe maximum number of extra beds in a room is 1.\r\n\r\nAny type of extra bed or crib is upon request and needs to be confirmed by management.\r\n\r\nAdditional fees are not calculated automatically in the total cost and will have to be paid for separately during your stay.', 9),
  (10, 'reservationasset_extra_fields.children_and_extra_beds', ' Free! One child under 4 years stays free of charge when using existing beds.\r\n\r\nOne child under 3 years is charged EUR 20 per night in a crib.\r\n\r\nOne older child or adult is charged EUR 20 per night in an extra bed.\r\n\r\nThe maximum number of extra beds/cribs in a room is 1.\r\n\r\nAny type of extra bed or crib is upon request and needs to be confirmed by management.\r\n\r\nAdditional fees are not calculated automatically in the total cost and will have to be paid for separately during your stay.', 9),
  (11, 'reservationasset_extra_fields.children_and_extra_beds', ' Free! Up to two children under 11 years stay free of charge when using existing beds.\r\n\r\nFree! One child under 2 years stays free of charge in a crib.\r\n\r\nOne older child or adult is charged SGD 80 per person per night in an extra bed.\r\n\r\nThe maximum number of extra beds/cribs in a room is 1.\r\n\r\nAny type of extra bed or crib is upon request and needs to be confirmed by management.\r\n\r\nAdditional fees are not calculated automatically in the total cost and will have to be paid for separately during your stay.', 9),
  (12, 'reservationasset_extra_fields.children_and_extra_beds', ' Free! One child under 3 years stays free of charge when using existing beds.\r\n\r\nFree! One child under 2 years stays free of charge in a crib.\r\n\r\nOne older child or adult is charged SGD 117.70 per person per night in an extra bed.\r\n\r\nThe maximum number of extra beds/cribs in a room is 1.\r\n\r\nAdditional fees are not calculated automatically in the total cost and will have to be paid for separately during your stay.', 9),
  (13, 'reservationasset_extra_fields.children_and_extra_beds', 'All children are welcome.\r\nFree! One child under 21 years stays free of charge when using existing beds.  \r\nOne older child or adult is charged USD 25 per night when using existing beds.\r\nExtra beds are not available.\r\nCribs are not available.\r\nThere is no capacity for extra beds in the room.\r\nAdditional fees are not calculated automatically in the total cost and will have to be paid for separately during your stay.', 9),
  (8, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (9, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (10, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (11, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (12, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (13, 'reservationasset_extra_fields.facebook_link', '#', 12),
  (8, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (9, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (10, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (11, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (12, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (13, 'reservationasset_extra_fields.facebook_show', '1', 13),
  (8, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (9, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (10, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (11, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (12, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (13, 'reservationasset_extra_fields.foursquare_link', '', 22),
  (8, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (9, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (10, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (11, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (12, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (13, 'reservationasset_extra_fields.foursquare_show', '1', 23),
  (8, 'reservationasset_extra_fields.general', '{lang en}Restaurant, Bar, 24-hour front desk, Newspapers, Garden, Terrace, Non-smoking rooms, Lift/elevator, Express check-in/check-out, Safety deposit box, Heating, Luggage storage, Air conditioning {/lang}\r\n\r\n{lang it}Ristorante, bar, reception 24 ore su scrivania, quotidiani, giardino, terrazza, cassetta di sicurezza, riscaldamento, deposito bagagli, aria condizionata Camere per non fumatori, Ascensore / ascensore, check-{/lang}\r\n\r\n{lang fr}Restaurant, bar, réception ouverte 24 heures, journaux, jardin, terrasse, chambres non-fumeurs, Ascenseur / ascenseur, coffre, coffre-fort, chauffage, bagagerie, climatisation{/lang}\r\n\r\n{lang de}Restaurant, Bar, 24-Stunden-Rezeption, Zeitungen, Garten, Terrasse, Nichtraucherzimmer, Lift / Aufzug, Express-Check-in/out, Safe, Heizung, Gepäckaufbewahrung, Klimaanlage{/lang}', 1),
  (9, 'reservationasset_extra_fields.general', 'Non-smoking Rooms, Family Rooms, Elevator, Soundproof Rooms, Heating, Air Conditioning, Designated Smoking Area ', 1),
  (10, 'reservationasset_extra_fields.general', 'Family Rooms, Heating, Ironing facilities ', 1),
  (11, 'reservationasset_extra_fields.general', 'Newspapers, Safe, Shops (on site), Non-smoking Rooms, Elevator, All Spaces Non-Smoking (Public and Private), Designated Smoking Area ', 1),
  (12, 'reservationasset_extra_fields.general', 'Non-smoking Rooms, Facilities for Disabled Guests, Elevator, Safe, Stores in Hotel, Air Conditioning, Designated Smoking Area, Carpeted, Safe ', 1),
  (13, 'reservationasset_extra_fields.general', 'Newspapers, Safe, Shops (on site), Non-smoking Rooms, Facilities for Disabled Guests, Elevator, Heating, Tile/Marble floor, Laptop safe, Ironing facilities, Air conditioning, Safe, Iron', 1),
  (8, 'reservationasset_extra_fields.internet', '{lang en}Free! WiFi is available in all areas and is free of charge. {/lang}\r\n{lang it}Gratis! WiFi è disponibile in tutte le aree ed è gratuita.{/lang}\r\n{lang fr}Gratuit! WiFi est disponible dans tous les domaines et est gratuite.{/lang}\r\n{lang de}Kostenlos! WiFi ist in allen Bereichen und ist kostenfrei.{/lang}\r\n', 4),
  (9, 'reservationasset_extra_fields.internet', 'Free! Wi-Fi is available in all areas and is free of charge. ', 4),
  (10, 'reservationasset_extra_fields.internet', 'Wi-Fi is available in the hotel rooms and costs EUR 5 per 24 hours.', 4),
  (11, 'reservationasset_extra_fields.internet', 'Free! Wi-Fi is available in all areas and is free of charge.\r\n\r\nFree! Wired internet is available in all areas and is free of charge. ', 4),
  (12, 'reservationasset_extra_fields.internet', 'Wired internet is available in the hotel rooms and costs SGD 17.12 per 24 hours.\r\n\r\nWi-Fi is available in the hotel rooms and costs SGD 17.12 per 24 hours.\r\n\r\nFree! Wi-Fi is available in public areas and is free of charge', 4),
  (13, 'reservationasset_extra_fields.internet', 'WiFi is available in the hotel rooms and costs USD 9.99 per 24 hours.\r\nWiFi is available in public areas and costs USD 9.99 per 24 hours.', 4),
  (8, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (9, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (10, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (11, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (12, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (13, 'reservationasset_extra_fields.linkedin_link', '#', 16),
  (8, 'reservationasset_extra_fields.linkedin_show', '1', 17),
  (9, 'reservationasset_extra_fields.linkedin_show', '0', 17),
  (10, 'reservationasset_extra_fields.linkedin_show', '0', 17),
  (11, 'reservationasset_extra_fields.linkedin_show', '0', 17),
  (12, 'reservationasset_extra_fields.linkedin_show', '1', 17),
  (13, 'reservationasset_extra_fields.linkedin_show', '0', 17),
  (8, 'reservationasset_extra_fields.parking', '{lang en}Private parking is possible on site (reservation is needed) and costs USD 7.50 per day.{/lang}\r\n{lang it}Parcheggio privato disponibile in loco (senza prenotazione) e costa USD 7.50 al giorno.{/lang}\r\n{lang fr}Un parking privé est disponible sur place (uniquement sur réservation) au tarif de 7,50 USD par jour.{/lang}\r\n{lang de}Private Parkplätze stehen am Hotel (Reservierung erforderlich) zur Verfügung und kosten USD 7,50 pro Tag.{/lang}', 5),
  (9, 'reservationasset_extra_fields.parking', 'Private parking is available at a location nearby (reservation is needed) and costs EUR 30 per day.', 5),
  (10, 'reservationasset_extra_fields.parking', 'No parking available.', 5),
  (11, 'reservationasset_extra_fields.parking', 'Free! Free public parking is available on site (reservation is not needed). ', 5),
  (12, 'reservationasset_extra_fields.parking', 'Free! Free private parking is available on site (reservation is not needed). ', 5),
  (13, 'reservationasset_extra_fields.parking', 'Free! Free public parking is available on site (reservation is not needed).', 5),
  (8, 'reservationasset_extra_fields.pets', '{lang en}Pets are not allowed.{/lang}{lang fr}Les animaux ne sont pas autorisés.{/lang}{lang it}Gli animali non sono ammessi.{/lang}{lang de}Haustiere sind nicht erlaubt.{/lang}', 10),
  (9, 'reservationasset_extra_fields.pets', 'Free! Pets are allowed on request. No extra charges. ', 10),
  (10, 'reservationasset_extra_fields.pets', 'Pets are not allowed.', 10),
  (11, 'reservationasset_extra_fields.pets', 'Pets are not allowed.', 10),
  (12, 'reservationasset_extra_fields.pets', 'Pets are not allowed.', 10),
  (13, 'reservationasset_extra_fields.pets', 'Pets are not allowed.', 10),
  (8, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (9, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (10, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (11, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (12, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (13, 'reservationasset_extra_fields.pinterest_link', '', 26),
  (8, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (9, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (10, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (11, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (12, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (13, 'reservationasset_extra_fields.pinterest_show', '1', 27),
  (8, 'reservationasset_extra_fields.services', '{lang en}Room Service, Meeting/Banquet Facilities, Business Center, Babysitting/Child Services, Laundry, Dry Cleaning, Hair/Beauty Salon, Ironing Service, Currency Exchange, Souvenir/Gift Shop, Shoeshine, Car Rental, Tour Desk, Fax/Photocopying, Ticket Service{/lang}\r\n{lang it}Servizio in camera, Sale riunioni / banchetti, Centro business, Servizio baby / sitter, servizio lavanderia, lavaggio a secco, barbiere / salone di bellezza, servizio stireria, cambio valuta, negozio di souvenir / regali, lustrascarpe, Autonoleggio, Banco escursioni, Fax / Fotocopie, Ticket servizio{/lang}\r\n{lang fr}Service en chambre, salles de réunions / banquets, centre d''affaires, garde / enfants, blanchisserie, nettoyage à sec, Cheveux / salon de beauté, service de repassage, service de change, boutique de souvenirs / cadeaux, service de cireur, location de voitures, bureau d''excursions, fax / photocopies, billetterie service{/lang}\r\n{lang de}Zimmerservice, Konferenz-/ Veranstaltungsräume, Business Center, Babysitting / Kinderbetreuung, Wäscheservice, chemische Reinigung, Haar / Schönheitssalon, Bügelservice, Währungsumtausch, Souvenir / Gift Shop, Schuhputzmaschine, Autovermietung, Informationsschalter für Ausflüge, Fax / Fotokopierer, Ticket Dienst{/lang}', 3),
  (9, 'reservationasset_extra_fields.services', 'Airport Shuttle (Surcharge) ', 3),
  (10, 'reservationasset_extra_fields.services', 'Airport Shuttle, Shuttle Service (Surcharge), Ironing Service', 3),
  (11, 'reservationasset_extra_fields.services', 'Room Service, 24-Hour Front Desk, Express Check-in/Check-out, Baggage Storage, Concierge Service, Babysitting/Child Services, Laundry, Dry Cleaning, Ironing Service, Shoeshine, Suit Press, Meeting/Banquet Facilities, Business Center, Fax/Photocopying ', 3),
  (12, 'reservationasset_extra_fields.services', '24-Hour Front Desk, Baggage Storage, Room Service, Meeting/Banquet Facilities, Business Center, Laundry, Dry Cleaning, Ironing Service, Currency Exchange, Souvenir/Gift Shop, Shoeshine, Fax/Photocopying, Concierge Service, Private Check-in/Check-out, Suit Press, Airport Shuttle (Surcharge), Wake-up service ', 3),
  (13, 'reservationasset_extra_fields.services', 'Room Service, Vending Machine (drinks), Vending Machine (snacks), Shuttle Service (free), Airport Shuttle (free), 24-Hour Front Desk, Express Check-in/Check-out, Currency Exchange, Baggage Storage, ATM on site, Concierge Service, Babysitting/Child Services, Dry Cleaning, Meeting/Banquet Facilities, Business Center, Fax/Photocopying, Souvenir/Gift Shop, VIP Room Facilities, Wake-up service', 3),
  (8, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (9, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (10, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (11, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (12, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (13, 'reservationasset_extra_fields.slideshare_link', '', 28),
  (8, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (9, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (10, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (11, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (12, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (13, 'reservationasset_extra_fields.slideshare_show', '1', 29),
  (8, 'reservationasset_extra_fields.tumblr_link', '#', 20),
  (9, 'reservationasset_extra_fields.tumblr_link', '', 20),
  (10, 'reservationasset_extra_fields.tumblr_link', '', 20),
  (11, 'reservationasset_extra_fields.tumblr_link', '', 20),
  (12, 'reservationasset_extra_fields.tumblr_link', '#', 20),
  (13, 'reservationasset_extra_fields.tumblr_link', '', 20),
  (8, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (9, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (10, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (11, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (12, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (13, 'reservationasset_extra_fields.tumblr_show', '1', 21),
  (8, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (9, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (10, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (11, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (12, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (13, 'reservationasset_extra_fields.twitter_link', '#', 14),
  (8, 'reservationasset_extra_fields.twitter_show', '1', 15),
  (9, 'reservationasset_extra_fields.twitter_show', '1', 15),
  (10, 'reservationasset_extra_fields.twitter_show', '1', 15),
  (11, 'reservationasset_extra_fields.twitter_show', '1', 15),
  (12, 'reservationasset_extra_fields.twitter_show', '0', 15),
  (13, 'reservationasset_extra_fields.twitter_show', '1', 15),
  (8, 'reservationasset_extra_fields.vimeo_link', '', 30),
  (9, 'reservationasset_extra_fields.vimeo_link', '#', 30),
  (10, 'reservationasset_extra_fields.vimeo_link', '', 30),
  (11, 'reservationasset_extra_fields.vimeo_link', '', 30),
  (12, 'reservationasset_extra_fields.vimeo_link', '', 30),
  (13, 'reservationasset_extra_fields.vimeo_link', '', 30),
  (8, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (9, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (10, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (11, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (12, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (13, 'reservationasset_extra_fields.vimeo_show', '1', 31),
  (8, 'reservationasset_extra_fields.youtube_link', '', 32),
  (9, 'reservationasset_extra_fields.youtube_link', '#', 32),
  (10, 'reservationasset_extra_fields.youtube_link', '#', 32),
  (11, 'reservationasset_extra_fields.youtube_link', '#', 32),
  (12, 'reservationasset_extra_fields.youtube_link', '', 32),
  (13, 'reservationasset_extra_fields.youtube_link', '#', 32),
  (8, 'reservationasset_extra_fields.youtube_show', '1', 33),
  (9, 'reservationasset_extra_fields.youtube_show', '1', 33),
  (10, 'reservationasset_extra_fields.youtube_show', '1', 33),
  (11, 'reservationasset_extra_fields.youtube_show', '1', 33),
  (12, 'reservationasset_extra_fields.youtube_show', '1', 33),
  (13, 'reservationasset_extra_fields.youtube_show', '1', 33);


INSERT INTO `#__sr_room_type_coupon_xref` (`room_type_id`, `coupon_id`) VALUES
  (21, 1),
  (23, 1),
  (20, 2),
  (22, 2),
  (26, 3),
  (27, 3),
  (24, 4),
  (25, 4),
  (17, 5),
  (18, 5),
  (19, 5),
  (28, 5),
  (29, 5),
  (15, 6),
  (17, 6),
  (15, 7),
  (16, 7),
  (17, 7),
  (18, 7),
  (19, 7),
  (15, 8),
  (17, 8),
  (18, 8),
  (19, 8);


INSERT INTO `#__sr_room_type_extra_xref` (`room_type_id`, `extra_id`) VALUES
  (26, 1),
  (27, 1),
  (20, 2),
  (22, 2),
  (21, 3),
  (23, 3),
  (15, 5),
  (17, 5),
  (18, 5),
  (19, 5),
  (15, 6),
  (16, 6),
  (17, 6),
  (28, 7),
  (29, 7),
  (24, 8),
  (25, 8),
  (16, 9),
  (18, 9),
  (15, 10),
  (17, 10),
  (19, 10);


INSERT INTO `#__sr_room_type_fields` (`room_type_id`, `field_key`, `field_value`, `ordering`) VALUES
  (15, 'roomtype_custom_fields.bed_size', '2 Twin Or 1 Queen', 7),
  (15, 'roomtype_custom_fields.breakfast_included', '0', 2),
  (15, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (15, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (15, 'roomtype_custom_fields.room_facilities', 'Balcony, Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Ironing facilities, Sitting area, Interconnecting room(s) available, Sofa, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom, Slippe', 5),
  (15, 'roomtype_custom_fields.room_size', '35 square meters.', 6),
  (15, 'roomtype_custom_fields.taxes', '10 % VAT, 5 % service charge.', 3),
  (16, 'roomtype_custom_fields.bed_size', '1 Twin, 1 Full. ', 7),
  (16, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (16, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (16, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (16, 'roomtype_custom_fields.room_facilities', 'Balcony, View , Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Ironing facilities, Sitting area, Interconnecting room(s) available, Sofa, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom,', 5),
  (16, 'roomtype_custom_fields.room_size', '45 square meters.', 6),
  (16, 'roomtype_custom_fields.taxes', '10 % VAT, 5 % service charge.', 3),
  (17, 'roomtype_custom_fields.bed_size', '2 Twin Or 1 Full.', 7),
  (17, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (17, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (17, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (17, 'roomtype_custom_fields.room_facilities', 'Balcony, View , Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Ironing facilities, Sitting area, Interconnecting room(s) available, Sofa, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom.', 5),
  (17, 'roomtype_custom_fields.room_size', '35 square meters.', 6),
  (17, 'roomtype_custom_fields.taxes', '10 % VAT, 5 % service charge.', 3),
  (18, 'roomtype_custom_fields.bed_size', '1 King.', 7),
  (18, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (18, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (18, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (18, 'roomtype_custom_fields.room_facilities', 'Balcony, View , Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Ironing facilities, Sitting area, Interconnecting room(s) available, Sofa, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom.', 5),
  (18, 'roomtype_custom_fields.room_size', '66 square meters.', 6),
  (18, 'roomtype_custom_fields.taxes', '10 % VAT, 5 % service charge.', 3),
  (19, 'roomtype_custom_fields.bed_size', '2 Twin Or 1 Queen.', 7),
  (19, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (19, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (19, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (19, 'roomtype_custom_fields.room_facilities', 'Balcony, View , Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Ironing facilities, Sitting area, Interconnecting room(s) available, Sofa, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom,', 5),
  (19, 'roomtype_custom_fields.room_size', '35 square meters.', 6),
  (19, 'roomtype_custom_fields.taxes', '10 % VAT, 5 % service charge.', 3),
  (20, 'roomtype_custom_fields.bed_size', '1 sofa bed, 1 queen', 7),
  (20, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (20, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (20, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (20, 'roomtype_custom_fields.room_facilities', 'Air conditioning, Ironing facilities, Sitting area, Washing machine, Heating, Shower, Hairdryer, Toilet, Bathroom, TV, Kitchenette, Refrigerator, Electric kettle, Kitchenware, Oven, Stovetop, Toaster, Coffee machine', 5),
  (20, 'roomtype_custom_fields.room_size', '60 m', 6),
  (20, 'roomtype_custom_fields.taxes', '10 % VAT', 3),
  (21, 'roomtype_custom_fields.bed_size', '1 sofa bed, 1 queen', 7),
  (21, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (21, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (21, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (21, 'roomtype_custom_fields.room_facilities', ' Air conditioning, Iron, Ironing facilities, Sitting area, Washing machine, Heating, Sofa, Shower, Hairdryer, Toilet, Bathroom, TV, Kitchenette, Refrigerator, Dishwasher, Dining area, Electric kettle, Kitchenware, Oven, Stovetop, Toaster', 5),
  (21, 'roomtype_custom_fields.room_size', '50 m', 6),
  (21, 'roomtype_custom_fields.taxes', '10 % VAT', 3),
  (22, 'roomtype_custom_fields.bed_size', 'Bedroom 1: 2 twin,  Bedroom 2: 1 queen , Living room: 1 twin - 1 sofa bed', 7),
  (22, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (22, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (22, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (22, 'roomtype_custom_fields.room_facilities', 'City view, TV, Air conditioning, Ironing facilities, Sitting area, Fan, Washing machine, Heating, Shower, Hairdryer, Toilet, Bathroom, Refrigerator, Kitchen, Dining area, Kitchenware, Oven, Stovetop, Toaster, Coffee machine', 5),
  (22, 'roomtype_custom_fields.room_size', '80 m', 6),
  (22, 'roomtype_custom_fields.taxes', '10 % VAT', 3),
  (23, 'roomtype_custom_fields.bed_size', '1 sofa bed, 1 queen', 7),
  (23, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (23, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (23, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (23, 'roomtype_custom_fields.room_facilities', 'Air conditioning, Iron, Ironing facilities, Sitting area, Washing machine, Heating, Sofa, Tile/Marble floor, Hardwood/Parquet floors, Shower, Hairdryer, Toilet, Bathroom, TV, Kitchenette, Refrigerator, Microwave, Kitchenware, Stovetop, Toaster', 5),
  (23, 'roomtype_custom_fields.room_size', '30 m', 6),
  (23, 'roomtype_custom_fields.taxes', '10 % VAT', 3),
  (24, 'roomtype_custom_fields.bed_size', '2 Full', 7),
  (24, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (24, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (24, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (24, 'roomtype_custom_fields.room_facilities', 'View, Pay-per-view channels, Telephone, Radio, DVD Player, CD Player, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Desk, Sitting area, Carpeted, Interconnecting room(s) available, Sofa, Wardrobe/Closet, Shower, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom, Minibar, Wake-up service ', 5),
  (24, 'roomtype_custom_fields.room_size', '52 m', 6),
  (24, 'roomtype_custom_fields.taxes', '7 % VAT, 10.70 % service charge.', 3),
  (25, 'roomtype_custom_fields.bed_size', '2 Full', 7),
  (25, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (25, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (25, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (25, 'roomtype_custom_fields.room_facilities', ' Safe, Air conditioning, Desk, Sitting area, Carpeted, Sofa, Wardrobe/Closet, Shower, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom, Pay-per-view channels, Telephone, Radio, DVD Player, CD Player, Satellite channels, Cable channels, Flat-screen TV, Minibar, Wake-up service ', 5),
  (25, 'roomtype_custom_fields.room_size', '56 m', 6),
  (25, 'roomtype_custom_fields.taxes', '7 % VAT, 10.70 % service charge.', 3),
  (26, 'roomtype_custom_fields.bed_size', '2 twin Or 1 king', 7),
  (26, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (26, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (26, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (26, 'roomtype_custom_fields.room_facilities', ' City view, TV, Telephone, Radio, Satellite channels, Cable channels, Flat-screen TV, Safe, Air conditioning, Iron, Desk, Ironing facilities, Sitting area, Carpeted, Interconnecting room(s) available, Wardrobe/Closet, Shower, Bathtub, Hairdryer, Bathrobe, Free toiletries, Toilet, Bathroom, Slippers, Minibar, Electric kettle, Coffee machine, Wake-up service, Alarm clock', 5),
  (26, 'roomtype_custom_fields.room_size', '41 m', 6),
  (26, 'roomtype_custom_fields.taxes', '7 % VAT, 10.70 % service charge.', 3),
  (27, 'roomtype_custom_fields.bed_size', '1 queen', 7),
  (27, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (27, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (27, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (27, 'roomtype_custom_fields.room_facilities', ' City view, Telephone, Cable channels, Laptop safe, Flat-screen TV, iPod dock, Safe, Air conditioning, Desk, Ironing facilities, Washing machine, Soundproof, Wardrobe/Closet, Clothes rack, Shower, Hairdryer, Free toiletries, Toilet, Bathroom, Slippers, Bidet, Refrigerator, Electric kettle, Outdoor furniture, Outdoor dining area', 5),
  (27, 'roomtype_custom_fields.room_size', '19 m', 6),
  (27, 'roomtype_custom_fields.taxes', '7 % VAT, 10.70 % service charge.', 3),
  (28, 'roomtype_custom_fields.bed_size', '1 king', 7),
  (28, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (28, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (28, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (28, 'roomtype_custom_fields.room_facilities', 'Safe, Air conditioning, Iron, Desk, Ironing facilities, Heating, Carpeted, Tile/Marble floor, Hairdryer, Free toiletries, Toilet, Bathroom, Bathtub or shower, Telephone, Radio, Cable channels, Laptop safe, Flat-screen TV, iPod dock, Refrigerator, Coffee machine, Wake-up service, Alarm clock', 5),
  (28, 'roomtype_custom_fields.room_size', '28 m²', 6),
  (28, 'roomtype_custom_fields.taxes', '12 % VAT', 3),
  (29, 'roomtype_custom_fields.bed_size', '2 Full', 7),
  (29, 'roomtype_custom_fields.breakfast_included', '1', 2),
  (29, 'roomtype_custom_fields.free_cancellation', '1', 1),
  (29, 'roomtype_custom_fields.prepayment', 'The total price of the reservation will be charged on the day of booking.', 4),
  (29, 'roomtype_custom_fields.room_facilities', 'Patio, TV, Telephone, Radio, Cable channels, Laptop safe, iPod dock, Safe, Air conditioning, Iron, Desk, Ironing facilities, Fan, Heating, Tile/Marble floor, Hairdryer, Free toiletries, Toilet, Bathroom, Bathtub or shower, Refrigerator, Coffee machine, Wake-up service, Alarm clock', 5),
  (29, 'roomtype_custom_fields.room_size', '28 m²', 6),
  (29, 'roomtype_custom_fields.taxes', '12 % VAT', 3);


INSERT INTO `#__sr_reservations` (`id`, `state`, `customer_id`, `created_date`, `modified_date`, `modified_by`, `created_by`, `payment_method_id`, `payment_method_txn_id`, `payment_method_surcharge`, `payment_method_discount`, `payment_status`, `payment_data`, `code`, `coupon_id`, `coupon_code`, `customer_title`, `customer_firstname`, `customer_middlename`, `customer_lastname`, `customer_email`, `customer_phonenumber`, `customer_mobilephone`, `customer_company`, `customer_address1`, `customer_address2`, `customer_city`, `customer_zipcode`, `customer_country_id`, `customer_geo_state_id`, `customer_vat_number`, `customer_ip`, `customer_coordinates`, `checkin`, `checkout`, `currency_id`, `currency_code`, `total_price`, `total_price_tax_incl`, `total_price_tax_excl`, `total_extra_price`, `total_extra_price_tax_incl`, `total_extra_price_tax_excl`, `total_discount`, `note`, `reservation_asset_id`, `reservation_asset_name`, `deposit_amount`, `total_paid`, `discount_pre_tax`, `tax_amount`, `tourist_tax_amount`, `booking_type`, `total_single_supplement`, `token`, `origin`, `accessed_date`, `target`, `cm_id`, `cm_creation_date`, `cm_modification_date`, `cm_channel_order_id`, `is_approved`) VALUES
  (1, 0, NULL, '2013-08-15 04:19:43', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '9ee95667', NULL, NULL, '', 'Billy', '', 'Tom', 'contact@solidres.com', '123456', NULL, 'Tommy', '123 Street Name', '', 'abc', '0808', 224, 0, NULL, NULL, NULL, '2013-11-05', '2013-11-07', 1, 'USD', 466.24, 466.24, 376.00, 20.00, 20.00, 20.00, NULL, 'We need quite room if possible. Thank you in advance', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (2, 5, NULL, '2013-08-15 04:40:32', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'ab6b37bb', NULL, NULL, 'Mr.', 'Jacky', '', 'Ricky', 'contact@solidres.com', '123456', NULL, '', '456 Street Name', '', 'abc', '0808', 106, 0, NULL, NULL, NULL, '2013-11-05', '2013-11-07', 1, 'USD', 600.16, 600.16, 484.00, 20.00, 20.00, 20.00, NULL, 'We\'d prefer rooms with double bed.', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (3, 0, NULL, '2013-01-30 08:01:12', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'a5b58c94', NULL, NULL, 'Ms.', 'Susan', '', 'Jane', 'susanjane@localhost.dev', '0111222333', NULL, '', '123 Junior Street', '', 'LA', '70000', 224, 6, NULL, NULL, NULL, '2013-01-30', '2013-01-31', 1, 'USD', 169.88, 169.88, 137.00, 20.00, 20.00, 20.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (4, 0, NULL, '2013-01-30 08:04:00', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '944a0dc2', NULL, NULL, 'Mr.', 'Johan', '', 'Cruyff', 'johancruyff@localhost.dev', '998123456', NULL, '', '777 Street 5', '', 'Chartlotte', '123456', 224, 35, NULL, NULL, NULL, '2013-02-03', '2013-02-06', 1, 'USD', 651.00, 651.00, 525.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (5, 0, 32, '2013-01-30 08:10:35', '0000-00-00 00:00:00', 0, 90002, 'paylater', NULL, 0.00, 0.00, 0, NULL, '9ebee0ad', NULL, NULL, 'Mr.', 'Wilson', '', 'Miller', 'wilsonmiller@localhost.dev', '123456789', NULL, '', '789 Street ABC', '', 'HCM', '08', 231, 0, NULL, NULL, NULL, '2013-02-10', '2013-02-14', 1, 'USD', 2827.20, 2827.20, 2280.00, 60.00, 60.00, 60.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (6, 0, 32, '2013-01-30 08:12:22', '0000-00-00 00:00:00', 0, 90002, 'paylater', NULL, 0.00, 0.00, 0, NULL, '01658078', NULL, NULL, 'Mr.', 'Wilson', '', 'Miller', 'wilsonmiller@localhost.dev', '123456789', NULL, '', '123456 Street ABC', '', 'DN', '065', 231, 0, NULL, NULL, NULL, '2013-03-13', '2013-03-14', 1, 'USD', 192.20, 192.20, 155.00, 100.00, 100.00, 100.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (7, 0, 33, '2013-01-30 08:13:47', '0000-00-00 00:00:00', 0, 90003, 'paylater', NULL, 0.00, 0.00, 0, NULL, '93119278', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '456456456', NULL, '', '333 Street YUI', '', 'HN', '04', 231, 0, NULL, NULL, NULL, '2013-02-18', '2013-02-22', 1, 'USD', 1041.60, 1041.60, 840.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (8, 0, 33, '2013-01-30 08:15:47', '0000-00-00 00:00:00', 0, 90003, 'paylater', NULL, 0.00, 0.00, 0, NULL, '3ab5e942', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-03-19', '2013-03-20', 1, 'USD', 414.16, 414.16, 334.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (9, 0, 35, '2013-01-30 08:20:35', '0000-00-00 00:00:00', 0, 90005, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'a0fab994', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-04-15', '2013-04-19', 1, 'USD', 2083.20, 2083.20, 1680.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (10, 0, 35, '2013-01-30 08:21:04', '0000-00-00 00:00:00', 0, 90005, 'paylater', NULL, 0.00, 0.00, 0, NULL, '2ecac208', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-03-26', '2013-03-30', 1, 'USD', 768.80, 768.80, 620.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (11, 0, 31, '2013-01-30 08:21:51', '0000-00-00 00:00:00', 0, 90001, 'paylater', NULL, 0.00, 0.00, 0, NULL, '26c745d6', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-02-25', '2013-02-28', 1, 'USD', 651.00, 651.00, 525.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (12, 0, 31, '2013-01-30 08:22:29', '0000-00-00 00:00:00', 0, 90001, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'e94aefc0', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-05-05', '2013-05-11', 1, 'USD', 3174.40, 3174.40, 2560.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (13, 0, 31, '2013-01-30 08:23:31', '0000-00-00 00:00:00', 0, 90001, 'paylater', NULL, 0.00, 0.00, 0, NULL, '74ab4c61', NULL, NULL, 'Mr.', 'Kaito', '', 'Kazuki', 'kaitokazuki@localhost.dev', '123456789', NULL, '', '246 Street Sunset', '', 'DT', '012', 231, 0, NULL, NULL, NULL, '2013-06-12', '2013-06-14', 1, 'USD', 414.16, 414.16, 334.00, 0.00, 0.00, 0.00, NULL, '', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (14, 0, NULL, '2013-08-01 09:45:13', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '7aa21f58', NULL, NULL, 'Mr.', 'Neur', 'Nuel', 'Man', 'Neur@localhost.dev', '841223456789', NULL, 'ABC', '343 berlin', '343 berlin', 'Berlin', '084', 231, 0, NULL, NULL, NULL, '2013-08-01', '2013-08-02', 1, 'USD', 78.12, 78.12, 63.00, 55.00, 55.00, 55.00, NULL, 'Customer comments.', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (15, 0, NULL, '2013-08-02 04:04:06', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '45ff4a54', NULL, NULL, 'Ms.', 'Bery', 'li', 'Frank', 'Bery@localhost.dev', '841223456789', NULL, 'dsad', '2 oxford', 'sdsda', 'hcm', '084', 231, 0, NULL, NULL, NULL, '2013-08-02', '2013-08-03', 1, 'USD', 78.12, 78.12, 63.00, 20.00, 20.00, 20.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (16, 0, NULL, '2013-08-03 08:57:39', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '3704fd74', NULL, NULL, 'Mr.', 'Baloteli', 'Mario', 'Mario', 'baloteli@localhost.dev', '841223456789', NULL, '8 San Marino', 'trung', 'sdsda', 'hcm', '084', 231, 0, NULL, NULL, NULL, '2013-07-01', '2013-07-02', 1, 'USD', 223.20, 223.20, 180.00, 130.00, 130.00, 130.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (17, 0, NULL, '2013-08-03 09:07:18', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '86e0d3e9', NULL, NULL, 'Mr.', 'Buffon', 'Gianlugi', 'Gianlugi', 'Gigi@localhost.dev', '841223456789', NULL, '6 Turin', ' 6 Turin', '6 Turin', 'Turin', '08', 235, 0, NULL, NULL, NULL, '2013-07-02', '2013-07-03', 1, 'USD', 156.24, 156.24, 126.00, 140.00, 140.00, 140.00, NULL, 'Pleased.', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (18, 0, NULL, '2013-08-03 09:12:25', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'e4f028f9', NULL, NULL, 'Ms.', 'Pes', 'Nami', 'Ko', 'pes2014@localhost.dev', '841223456789', NULL, 'dsad', '7 street', 'sdsda', 'ward', '084', 231, 0, NULL, NULL, NULL, '2013-07-02', '2013-07-03', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (19, 0, NULL, '2013-08-03 09:30:20', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'c0dc2955', NULL, NULL, 'Ms.', 'Bary', 'lad', 'Ga', 'Bary@localhost.dev', '841223456789', NULL, '', '8 Liverpool', '8 liverpool', 'Liverpool', '021', 216, 0, NULL, NULL, NULL, '2013-07-03', '2013-07-04', 1, 'USD', 190.96, 190.96, 154.00, 155.00, 155.00, 155.00, NULL, 'Ok.', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (20, 0, NULL, '2013-08-03 09:36:32', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '7b1a79ba', NULL, NULL, 'Ms.', 'Foo', 'Bar', 'Foo', 'Foo@localhost.dev', '841223456789', NULL, 'ABC', '8 street', '8 street', 'City', '087', 231, 0, NULL, NULL, NULL, '2013-07-09', '2013-07-10', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'Family', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (21, 0, NULL, '2013-08-03 09:38:35', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'fed877aa', NULL, NULL, 'Ms.', 'Solidres', 'abc', 'Solidres', 'Solidres@locahost.dev', '841223456789', NULL, 'dsad', 'Solidres', 'sdsda', 'hcm', '084', 231, 0, NULL, NULL, NULL, '2013-07-04', '2013-07-05', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (22, 0, NULL, '2013-08-03 09:49:55', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'ccc5cd20', NULL, NULL, 'Ms.', 'Ho', 'Li', 'Ching', 'li@localhost.dev', '841223456789', NULL, 'dsad', '9 street', 'sdsda', 'Moon', '084', 231, 0, NULL, NULL, NULL, '2013-07-05', '2013-07-06', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (23, 0, NULL, '2013-08-04 04:23:14', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'b99128d6', NULL, NULL, 'Mrs.', 'Ryy', 'Mon', 'To', 'Ryy@localhost.dev', '841223456789', NULL, 'dsad', '7 Ree', '7 Ree', 'park', '084', 231, 0, NULL, NULL, NULL, '2013-07-06', '2013-07-07', 1, 'USD', 78.12, 78.12, 63.00, 190.00, 190.00, 190.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (24, 0, NULL, '2013-08-04 04:25:12', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '2e2a7d4b', NULL, NULL, 'Ms.', 'war', 'stike', 'Ted', 'war@locahost.dev', '841223456789', NULL, 'Wall', '11 street', '11 street', 'Sunrise', '084', 231, 0, NULL, NULL, NULL, '2013-07-07', '2013-07-08', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (25, 0, NULL, '2013-08-04 08:05:47', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '1fe9c696', NULL, NULL, 'Ms.', 'Travel', 'Travel', 'Travel', 'Travel@locahost.dev', '841223456789', NULL, 'travel', '7 fast', '7 fast', 'Speed', '084', 231, 0, NULL, NULL, NULL, '2013-07-05', '2013-07-07', 1, 'USD', 156.24, 156.24, 126.00, 70.00, 70.00, 70.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (26, 0, NULL, '2013-08-04 08:07:50', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '54d29823', NULL, NULL, 'Ms.', 'Peter', 'Little', 'Mr', 'pee@locahost.dev', '841223456789', NULL, 'dsad', '9 bean', '9 bean', 'Soya', '078', 231, 0, NULL, NULL, NULL, '2012-08-04', '2012-08-05', 1, 'USD', 78.12, 78.12, 63.00, 70.00, 70.00, 70.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (27, 0, NULL, '2013-08-05 01:47:04', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '7abde189', NULL, NULL, 'Ms.', 'Orange', 'juice', 'fruit', 'orange@localhost.dev', '841223456789', NULL, '7 orange', '7 orange', 'sdasd', 'Fruit', '084', 231, 0, NULL, NULL, NULL, '2013-08-05', '2013-08-06', 1, 'USD', 78.12, 78.12, 63.00, 170.00, 170.00, 170.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (28, 0, NULL, '2013-08-05 02:06:26', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '5e88647e', NULL, NULL, 'Ms.', 'Banana', 'Fruit', 'Mr', 'Banana@localhost.dev', '841223456789', NULL, 'dsad', '7 Banana', '7 Banana', 'Fruit', '024', 231, 0, NULL, NULL, NULL, '2013-08-08', '2013-08-09', 1, 'USD', 66.96, 66.96, 54.00, 0.00, 0.00, 0.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (29, 0, NULL, '2013-08-06 01:43:57', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '2cb37fbd', NULL, NULL, 'Ms.', 'Strawberry', 'Fruit', 'Ms', 'Strawberry@locahost.dev', '841223456789', NULL, 'dsad', '8 Strawberry', '8 Strawberry', 'Fruit', '034', 231, 0, NULL, NULL, NULL, '2012-08-06', '2012-08-07', 1, 'USD', 223.20, 223.20, 180.00, 105.00, 105.00, 105.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (30, 0, NULL, '2013-08-06 01:57:44', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'ce3a5829', NULL, NULL, 'Ms.', 'Lemon', 'Fruit', 'Juice', 'lemon@localhost.dev', '841223456789', NULL, 'dsad', '4 lemon', '4 lemon', 'fruit', '084', 231, 0, NULL, NULL, NULL, '2012-07-06', '2012-07-07', 1, 'USD', 223.20, 223.20, 180.00, 70.00, 70.00, 70.00, NULL, 'dasd', 8, 'Sunflower', NULL, NULL, NULL, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (31, 0, NULL, '2015-07-16 09:00:21', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, 'd2387136', NULL, NULL, 'Mrs.', 'Chaney', 'Karyn Hardin', 'Contreras', 'qyruxux@gmail.com', '+749-77-9901884', '+412-36-7605380', 'Marquez Kramer Traders', 'Quo consectetur repudiandae qui iste placeat ', 'Veniam voluptatem iusto harum amet repudianda', 'Dignissimos nisi quia numquam quis', '19229', 85, 0, '715', NULL, NULL, '2015-07-24', '2015-07-25', 1, 'USD', 155.00, 155.00, 155.00, 0.00, 0.00, 0.00, 0.00, 'Perferendis aliquip lorem voluptatum anim reiciendis voluptas eos enim aliquip officia ipsam laborum. Ut quibusdam.', 9, 'Lychee', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (32, 0, NULL, '2015-07-16 09:01:28', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, 'f9aa6a53', NULL, NULL, 'Mr.', 'Ivana', 'Patricia Chandler', 'Curry', 'remyt@gmail.com', '+239-97-5454696', '+464-15-6112887', 'Booker and Chase Trading', 'Iste perferendis magna commodo officia labori', 'Laudantium pariatur Eum eum cumque irure lore', 'Consequat Sint assumenda excepturi impedit al', '44787', 198, 0, '884', NULL, NULL, '2015-09-15', '2015-09-16', 1, 'USD', 310.00, 310.00, 310.00, 0.00, 0.00, 0.00, 0.00, 'Eos hic fugiat animi, esse in et vel iusto ut est.', 9, 'Lychee', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (33, 0, NULL, '2015-07-16 09:03:04', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, 'eb2ed212', NULL, NULL, 'Mrs.', 'Olga', 'Yoshio Anthony', 'Mckenzie', 'vofeqaz@gmail.com', '+711-19-7314021', '+418-66-4639670', 'Pugh and Ross Traders', 'Ut veniam odio aliquam et sint adipisicing cu', 'Iusto omnis veniam molestiae pariatur', 'Dolor quas in in dolore sint ullam maxime et ', '33687', 15, 0, '525', NULL, NULL, '2015-07-24', '2015-07-25', 1, 'USD', 235.00, 235.00, 235.00, 50.00, 50.00, 50.00, 0.00, 'Optio, sunt inventore temporibus quia esse aperiam cupidatat a ut eaque aspernatur quis aliquam.', 10, 'Chesnut', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (34, 0, NULL, '2015-07-16 09:03:28', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '7829f7a2', NULL, NULL, 'Mrs.', 'Constance', 'Iola Wells', 'Duffy', 'hehizeluc@yahoo.com', '+558-36-3554502', '+836-22-7299859', 'Clay and Berger Trading', 'Deleniti in laboris non voluptatem Sed ducimu', 'Recusandae Qui et elit reprehenderit laborum ', 'Dolor in necessitatibus aute reprehenderit ea', '87257', 191, 0, '732', NULL, NULL, '2015-08-24', '2015-08-25', 1, 'USD', 125.00, 125.00, 125.00, 0.00, 0.00, 0.00, 0.00, 'Et aut error voluptas est, incididunt expedita delectus, doloremque debitis.', 10, 'Chesnut', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (35, 0, NULL, '2015-07-16 09:06:25', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, '74d94aff', NULL, NULL, 'Ms.', 'Philip', 'Marshall Jacobson', 'Wiggins', 'pizo@hotmail.com', '+251-87-3930233', '+649-75-2440442', 'Cotton Dominguez LLC', 'Laudantium proident id suscipit aut voluptas ', 'Tempore eius et non cupidatat', 'Laboris dolorum eius recusandae Eos quos simi', '93027', 196, 0, '699', NULL, NULL, '2015-10-12', '2015-10-13', 1, 'USD', 189.00, 189.00, 189.00, 200.00, 200.00, 200.00, 0.00, 'Molestias quos molestiae cupidatat aliquip minima eiusmod rerum est architecto minus ut.', 11, 'Lavender', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (36, 0, NULL, '2015-07-16 09:07:01', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, 'e3c9d0c2', NULL, NULL, 'Mrs.', 'Amber', 'Kellie Lancaster', 'Gross', 'fufocuryl@gmail.com', '+856-21-2467088', '+851-19-8391852', 'Pennington and Ewing Inc', 'Expedita ex aut aliqua Vel cillum id similiqu', 'Obcaecati laboris eveniet necessitatibus hic ', 'Nostrum magni illum consequatur Vel iste iust', '49604', 162, 0, '477', NULL, NULL, '2015-11-10', '2015-11-11', 1, 'USD', 530.00, 530.00, 530.00, 0.00, 0.00, 0.00, 0.00, 'Dicta eaque ut beatae eligendi quas aute ad autem cupidatat asperiores totam est.', 11, 'Lavender', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (37, 0, NULL, '2015-07-16 09:07:47', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, 'b712d129', NULL, NULL, 'Ms.', 'Gregory', 'Matthew Price', 'Mcpherson', 'soked@yahoo.com', '+672-26-3361599', '+781-72-5024101', 'Mcdaniel and Schwartz LLC', 'Dolor est ipsum qui eius fugiat incidunt volu', 'Delectus soluta lorem incididunt incidunt fug', 'Ut ut eligendi nemo sint sit qui itaque aliqu', '78621', 213, 0, '841', NULL, NULL, '2015-12-10', '2015-12-11', 1, 'USD', 310.00, 310.00, 310.00, 40.00, 40.00, 40.00, 0.00, 'Facilis earum quae libero omnis possimus, aliqua. Consequat. Omnis est.', 12, 'Lotus', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (38, 0, NULL, '2015-07-16 09:08:25', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, '770d03e4', NULL, NULL, 'Mrs.', 'Abbot', 'Hollee Cooke', 'Parks', 'kywu@hotmail.com', '+844-69-7557221', '+322-75-4537831', 'Noble and Howard Inc', 'Dignissimos asperiores beatae ea eu magna dol', 'Dolor in dolor voluptas quas labore facilis e', 'Pariatur Reprehenderit rerum aut adipisicing', '84833', 197, 0, '20', NULL, NULL, '2015-08-12', '2015-08-13', 1, 'USD', 199.00, 199.00, 199.00, 20.00, 20.00, 20.00, 0.00, 'Error laborum. Alias laborum provident, aut occaecat ut sed vel voluptatem reprehenderit beatae ad non cumque id.', 12, 'Lotus', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (39, 0, NULL, '2015-07-16 09:36:38', '0000-00-00 00:00:00', 0, 0, 'paylater', NULL, 0.00, 0.00, 0, NULL, '1e3ce8c9', NULL, NULL, 'Mr.', 'Xander', 'Ainsley Farmer', 'Burnett', 'bihegin@gmail.com', '+143-60-4047951', '+776-15-7280943', 'Norris Tucker Trading', 'Voluptas impedit ut earum et eum esse quas ma', 'Modi est architecto dignissimos autem nemo au', 'Magna ea corporis omnis excepturi dolorum', '77728', 216, 0, '707', NULL, NULL, '2015-08-30', '2015-09-02', 1, 'USD', 600.00, 600.00, 600.00, 35.00, 35.00, 35.00, 0.00, 'Facere in quos cillum enim dolore aut anim pariatur. Enim ipsam.', 13, 'Mango', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1),
  (40, 0, NULL, '2015-07-16 09:37:15', '0000-00-00 00:00:00', 0, 0, 'bankwire', NULL, 0.00, 0.00, 0, NULL, '1f4e1054', NULL, NULL, 'Mrs.', 'Josiah', 'Minerva Warner', 'Mcdaniel', 'mofe@gmail.com', '+226-23-3620662', '+881-68-9299075', 'Saunders Solis Plc', 'Et qui vitae sequi veniam ut voluptatem nobis', 'Blanditiis inventore laborum Aspernatur vel v', 'Nulla ut quo officiis quod necessitatibus eiu', '42630', 2, 0, '599', NULL, NULL, '2015-09-07', '2015-09-10', 1, 'USD', 600.00, 600.00, 600.00, 35.00, 35.00, 35.00, 0.00, 'Eius a aut aperiam nostrum fuga. Nulla sit, error id in et eius eligendi non pariatur? Minima soluta aspernatur.', 13, 'Mango', NULL, NULL, 0, 0.00, 0.00, 0, 0.00, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, 1);



INSERT INTO `#__sr_reservation_room_xref` (`id`, `reservation_id`, `room_id`, `room_label`, `adults_number`, `children_number`, `guest_fullname`, `room_price`, `room_price_tax_incl`, `room_price_tax_excl`, `tariff_id`, `tariff_title`, `tariff_description`) VALUES
  (1, 1, 47, 'CS001', 2, 2, 'Tom', '299.00', NULL, NULL, NULL, NULL, NULL),
  (2, 1, 52, 'ED001', 2, 2, 'Billy', '77.00', NULL, NULL, NULL, NULL, NULL),
  (3, 2, 33, 'X001', 2, 0, 'Tom', '121.00', NULL, NULL, NULL, NULL, NULL),
  (4, 2, 34, 'X002', 1, 0, 'Bill', '121.00', NULL, NULL, NULL, NULL, NULL),
  (5, 2, 35, 'X003', 2, 0, 'David', '121.00', NULL, NULL, NULL, NULL, NULL),
  (6, 2, 36, 'X004', 1, 0, 'Jacky', '121.00', NULL, NULL, NULL, NULL, NULL),
  (7, 1, 33, 'X001', 2, 0, 'Susan', '137.00', NULL, NULL, NULL, NULL, NULL),
  (8, 2, 37, 'V101', 1, 1, 'Johan', '525.00', NULL, NULL, NULL, NULL, NULL),
  (9, 3, 52, 'ED001', 2, 0, 'Wilson', '1140.00', NULL, NULL, NULL, NULL, NULL),
  (10, 3, 53, 'ED002', 1, 0, 'Jade', '1140.00', NULL, NULL, NULL, NULL, NULL),
  (11, 4, 41, 'CD01', 0, 0, 'Wilson', '155.00', NULL, NULL, NULL, NULL, NULL),
  (12, 5, 47, 'CS001', 0, 0, 'Kaito', '840.00', NULL, NULL, NULL, NULL, NULL),
  (13, 6, 33, 'X001', 2, 0, 'Kaito', '167.00', NULL, NULL, NULL, NULL, NULL),
  (14, 6, 34, 'X002', 0, 0, 'Kohsuke', '167.00', NULL, NULL, NULL, NULL, NULL),
  (15, 7, 47, 'CS001', 2, 0, 'Kenneth', '840.00', NULL, NULL, NULL, NULL, NULL),
  (16, 7, 48, 'CS002', 2, 0, 'Ben', '840.00', NULL, NULL, NULL, NULL, NULL),
  (17, 8, 41, 'CD01', 2, 0, 'Kaito', '620.00', NULL, NULL, NULL, NULL, NULL),
  (18, 9, 37, 'V101', 2, 0, 'David', '525.00', NULL, NULL, NULL, NULL, NULL),
  (19, 10, 47, 'CS001', 2, 0, 'Kaito', '1280.00', NULL, NULL, NULL, NULL, NULL),
  (20, 10, 48, 'CS002', 1, 0, 'Kohsuke', '1280.00', NULL, NULL, NULL, NULL, NULL),
  (21, 11, 33, 'X001', 2, 0, 'Kaito', '334.00', NULL, NULL, NULL, NULL, NULL),
  (22, 12, 33, 'X001', 1, 1, 'Kaito', '63.00', NULL, NULL, NULL, NULL, NULL),
  (23, 13, 33, 'X001', 1, 1, 'Kaito', '63.00', NULL, NULL, NULL, NULL, NULL),
  (24, 14, 52, 'ED001', 1, 2, 'Neur', '180.00', NULL, NULL, NULL, NULL, NULL),
  (25, 15, 33, 'X001', 1, 1, 'Bery', '63.00', NULL, NULL, NULL, NULL, NULL),
  (26, 15, 33, 'X001', 1, 1, 'Bery', '63.00', NULL, NULL, NULL, NULL, NULL),
  (27, 16, 37, 'V101', 1, 1, 'Baloteli', '54.00', NULL, NULL, NULL, NULL, NULL),
  (28, 17, 47, 'CS001', 1, 2, 'Buffon', '154.00', NULL, NULL, NULL, NULL, NULL),
  (29, 18, 37, 'V101', 1, 1, 'Pes', '54.00', NULL, NULL, NULL, NULL, NULL),
  (30, 19, 37, 'V101', 1, 1, 'Bary', '54.00', NULL, NULL, NULL, NULL, NULL),
  (31, 20, 37, 'V101', 3, 1, 'Foo', '54.00', NULL, NULL, NULL, NULL, NULL),
  (32, 21, 33, 'X001', 2, 1, 'Solidres', '63.00', NULL, NULL, NULL, NULL, NULL),
  (33, 22, 37, 'V101', 1, 1, 'Ho', '54.00', NULL, NULL, NULL, NULL, NULL),
  (34, 23, 33, 'X001', 1, 1, 'Ryy', '126.00', NULL, NULL, NULL, NULL, NULL),
  (35, 24, 33, 'X001', 1, 1, 'war', '63.00', NULL, NULL, NULL, NULL, NULL),
  (36, 25, 33, 'X001', 1, 1, 'Travel', '63.00', NULL, NULL, NULL, NULL, NULL),
  (37, 26, 37, 'V101', 1, 1, 'Pee', '54.00', NULL, NULL, NULL, NULL, NULL),
  (38, 27, 52, 'ED001', 1, 1, 'Orange', '180.00', NULL, NULL, NULL, NULL, NULL),
  (39, 28, 52, 'ED001', 1, 1, 'Banana', '180.00', NULL, NULL, NULL, NULL, NULL),
  (40, 31, 61, 'LO001', 1, 0, 'test', 155.00, 155.00, 155.00, 97, 'Enjoy the summer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!'),
  (41, 32, 61, 'LO001', 1, 0, 'test', 155.00, 155.00, 155.00, 97, 'Enjoy the summer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!'),
  (42, 32, 62, 'LO002', 1, 0, 'test', 155.00, 155.00, 155.00, 97, 'Enjoy the summer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!'),
  (43, 33, 64, 'AP001', 1, 0, 'test', 235.00, 235.00, 235.00, 87, 'Summer Holiday - FREE cancellation', 'Enjoy your summer holiday at our hotel!'),
  (44, 34, 56, 'CO001', 1, 0, 'test', 125.00, 125.00, 125.00, 41, 'Free Sunday', 'One night gratis! Book now a stay of minimum 2 nights and get your Sunday night for free!'),
  (45, 35, 84, 'QR001', 1, 1, 'test', 189.00, 189.00, 189.00, 81, 'Summer Offers', 'Enjoy your summer holiday at our hotel!'),
  (46, 36, 81, 'PK001', 1, 0, 'test', 255.00, 255.00, 255.00, 58, 'Summer Big Offer', 'Enjoy a variety of our beach activities during your stay!'),
  (47, 36, 82, 'PK002', 1, 0, 'test', 275.00, 275.00, 275.00, 88, 'Summer Big Offer - Buffet breakfast included', 'Enjoy a variety of our beach activities during your stay!'),
  (48, 37, 73, 'GD001', 1, 0, 'test', 155.00, 155.00, 155.00, 91, 'Enjoy the summer - FREE cancellation', 'Enjoy your summer holiday at our hotel!'),
  (49, 37, 74, 'GD002', 1, 0, 'test', 155.00, 155.00, 155.00, 91, 'Enjoy the summer - FREE cancellation', 'Enjoy your summer holiday at our hotel!'),
  (50, 38, 76, 'LA001', 1, 0, 'John', 199.00, 199.00, 199.00, 94, 'Summer Holiday - 2 Nights Stay!', 'Enjoy your summer holiday at our hotel!'),
  (51, 39, 88, 'KR001', 1, 0, 'test', 600.00, 600.00, 600.00, 105, 'Summer Holiday', 'Enjoy your summer holiday at our hotel!'),
  (52, 40, 93, 'CD001', 1, 0, 'David', 600.00, 600.00, 600.00, 107, 'Enjoy the summer', 'Enjoy a variety of our beach activities during your stay!');


INSERT INTO `#__sr_reservation_extra_xref` (`id`, `reservation_id`, `extra_id`, `extra_name`, `extra_quantity`, `extra_price`) VALUES
  (1, 1, 2, 'Airport pickup', 1, 20.00),
  (2, 2, 2, 'Airport pickup', 1, 20.00);


INSERT INTO `#__sr_reservation_room_details` (`id`, `reservation_room_id`, `key`, `value`) VALUES
  (1, 1, 'child1', '8'),
  (2, 1, 'child2', '12'),
  (3, 1, 'smoking', '1'),
  (4, 2, 'child1', '5'),
  (5, 2, 'child2', '9'),
  (6, 2, 'smoking', '0'),
  (7, 3, 'smoking', '0'),
  (8, 4, 'smoking', '1'),
  (9, 5, 'smoking', '0'),
(10, 6, 'smoking', ''),
(11, 40, 'smoking', ''),
(12, 41, 'smoking', ''),
(13, 42, 'smoking', ''),
(14, 43, 'smoking', ''),
(15, 44, 'smoking', '0'),
(16, 45, 'child1', '13'),
(17, 45, 'smoking', ''),
(18, 46, 'smoking', ''),
(19, 47, 'smoking', ''),
(20, 48, 'smoking', '0'),
(21, 49, 'smoking', '1'),
(22, 50, 'smoking', ''),
(23, 51, 'smoking', '0'),
(24, 52, 'smoking', '0');


INSERT INTO `#__sr_reservation_room_extra_xref` (`id`, `reservation_id`, `room_id`, `room_label`, `extra_id`, `extra_name`, `extra_quantity`, `extra_price`) VALUES
  (1, 1, 47, 'CS001', 5, 'Buffet Breakfast', 4, 25.00),
  (2, 1, 47, 'CS001', 7, 'Extra adult', 1, 33.00),
  (3, 1, 52, 'ED001', 5, 'Buffet Breakfast', 4, 25.00),
  (4, 1, 52, 'ED001', 7, 'Extra adult', 1, 33.00),
  (5, 1, 33, 'X001', 2, 'Airport pickup', 1, 20.00),
  (6, 3, 52, 'ED001', 2, 'Airport pickup', 1, 20.00),
  (7, 3, 52, 'ED001', 3, 'Flower', 1, 15.00),
  (8, 3, 52, 'ED001', 5, 'Buffet Breakfast', 1, 25.00),
  (9, 4, 41, 'CD01', 1, 'Wine', 1, 100.00),
  (10, 12, 33, 'X001', 2, '', 2, 0.00),
  (11, 12, 33, 'X001', 4, '', 3, 0.00),
  (12, 12, 33, 'X001', 5, '', 0, 0.00),
  (13, 12, 33, 'X001', 3, '', 0, 0.00),
  (14, 12, 33, 'X001', 1, '', 0, 0.00),
  (15, 13, 33, 'X001', 2, '', 1, 0.00),
  (16, 13, 33, 'X001', 4, '', 0, 0.00),
  (17, 13, 33, 'X001', 5, '', 0, 0.00),
  (18, 13, 33, 'X001', 3, '', 0, 0.00),
  (19, 13, 33, 'X001', 1, '', 0, 0.00),
  (20, 14, 52, 'ED001', 2, '', 2, 0.00),
  (21, 14, 52, 'ED001', 5, '', 3, 0.00),
  (22, 14, 52, 'ED001', 3, '', 1, 0.00),
  (23, 15, 33, 'X001', 2, '', 1, 0.00),
  (24, 15, 33, 'X001', 4, '', 1, 0.00),
  (25, 15, 33, 'X001', 5, '', 2, 0.00),
  (26, 15, 33, 'X001', 3, '', 1, 0.00),
  (27, 15, 33, 'X001', 1, '', 0, 0.00),
  (28, 15, 33, 'X001', 2, '', 0, 0.00),
  (29, 15, 33, 'X001', 4, '', 0, 0.00),
  (30, 15, 33, 'X001', 5, '', 2, 0.00),
  (31, 15, 33, 'X001', 3, '', 0, 0.00),
  (32, 15, 33, 'X001', 1, '', 0, 0.00),
  (33, 17, 47, 'CS001', 2, '', 3, 0.00),
  (34, 17, 47, 'CS001', 4, '', 1, 0.00),
  (35, 17, 47, 'CS001', 5, '', 3, 0.00),
  (36, 17, 47, 'CS001', 3, '', 1, 0.00),
  (37, 17, 47, 'CS001', 1, '', 0, 0.00),
  (38, 21, 33, 'X001', 2, '', 1, 0.00),
  (39, 21, 33, 'X001', 4, '', 1, 0.00),
  (40, 21, 33, 'X001', 5, '', 2, 0.00),
  (41, 21, 33, 'X001', 3, '', 1, 0.00),
  (42, 21, 33, 'X001', 1, '', 1, 0.00),
  (43, 23, 33, 'X001', 2, '', 1, 0.00),
  (44, 23, 33, 'X001', 4, '', 0, 0.00),
  (45, 23, 33, 'X001', 5, '', 2, 0.00),
  (46, 23, 33, 'X001', 3, '', 0, 0.00),
  (47, 23, 33, 'X001', 1, '', 0, 0.00),
  (48, 24, 33, 'X001', 2, '', 1, 0.00),
  (49, 24, 33, 'X001', 4, '', 0, 0.00),
  (50, 24, 33, 'X001', 5, '', 2, 0.00),
  (51, 24, 33, 'X001', 3, '', 0, 0.00),
  (52, 24, 33, 'X001', 1, '', 0, 0.00),
  (53, 25, 33, 'X001', 2, '', 1, 0.00),
  (54, 25, 33, 'X001', 4, '', 0, 0.00),
  (55, 25, 33, 'X001', 5, '', 2, 0.00),
  (56, 25, 33, 'X001', 3, '', 0, 0.00),
  (57, 25, 33, 'X001', 1, '', 1, 0.00),
  (58, 27, 52, 'ED001', 2, '', 2, 0.00),
  (59, 27, 52, 'ED001', 5, '', 2, 0.00),
  (60, 27, 52, 'ED001', 3, '', 1, 0.00),
  (61, 28, 52, 'ED001', 2, '', 1, 0.00),
  (62, 28, 52, 'ED001', 5, '', 2, 0.00),
  (63, 28, 52, 'ED001', 3, '', 0, 0.00),
  (64, 33, 64, 'AP001', 2, 'Beer', 1, 50.00),
  (65, 35, 84, 'QR001', 1, 'Wine', 2, 200.00),
  (66, 37, 73, 'GD001', 8, 'Extra child', 1, 20.00),
  (67, 37, 74, 'GD002', 8, 'Extra child', 1, 20.00),
  (68, 38, 76, 'LA001', 8, 'Extra child', 1, 20.00),
  (69, 39, 88, 'KR001', 7, 'Extra adult', 1, 35.00),
  (70, 40, 93, 'CD001', 7, 'Extra adult', 1, 35.00);


INSERT INTO `#__sr_config_data` (`id`, `scope_id`, `data_key`, `data_value`) VALUES
  (3110, 8, 'payments/paylater/paylater_enabled', '1'),
  (3111, 8, 'payments/paylater/paylater_is_default', '1'),
  (3112, 8, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3113, 8, 'payments/bankwire/bankwire_enabled', '1'),
  (3114, 8, 'payments/bankwire/bankwire_is_default', '0'),
  (3115, 8, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3116, 8, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3117, 8, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3118, 8, 'payments/paypal/paypal_enabled', '1'),
  (3119, 8, 'payments/paypal/paypal_is_default', '0'),
  (3120, 8, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment!'),
  (3121, 8, 'payments/paypal/paypal_merchant_id', ''),
  (3122, 8, 'payments/paypal/paypal_sandbox', '1'),
  (3123, 8, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3124, 8, 'payments/paypal/paypal_callback_text', ''),
  (3125, 8, 'payments/paypal/paypal_custom_logo_image', ''),
  (3126, 8, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3127, 8, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3128, 8, 'payments/paypal/paypal_payment_action', 'sale'),
  (3205, 10, 'payments/paylater/paylater_enabled', '1'),
  (3206, 10, 'payments/paylater/paylater_is_default', '1'),
  (3207, 10, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3208, 10, 'payments/bankwire/bankwire_enabled', '1'),
  (3209, 10, 'payments/bankwire/bankwire_is_default', '0'),
  (3210, 10, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3211, 10, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3212, 10, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3213, 10, 'payments/paypal/paypal_enabled', '1'),
  (3214, 10, 'payments/paypal/paypal_is_default', '0'),
  (3215, 10, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment.'),
  (3216, 10, 'payments/paypal/paypal_merchant_id', ''),
  (3217, 10, 'payments/paypal/paypal_sandbox', '1'),
  (3218, 10, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3219, 10, 'payments/paypal/paypal_callback_text', ''),
  (3220, 10, 'payments/paypal/paypal_custom_logo_image', ''),
  (3221, 10, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3222, 10, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3223, 10, 'payments/paypal/paypal_payment_action', 'sale'),
  (3224, 11, 'payments/paylater/paylater_enabled', '1'),
  (3225, 11, 'payments/paylater/paylater_is_default', '1'),
  (3226, 11, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3227, 11, 'payments/bankwire/bankwire_enabled', '1'),
  (3228, 11, 'payments/bankwire/bankwire_is_default', '0'),
  (3229, 11, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3230, 11, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3231, 11, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3232, 11, 'payments/paypal/paypal_enabled', '1'),
  (3233, 11, 'payments/paypal/paypal_is_default', '0'),
  (3234, 11, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment.'),
  (3235, 11, 'payments/paypal/paypal_merchant_id', ''),
  (3236, 11, 'payments/paypal/paypal_sandbox', '1'),
  (3237, 11, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3238, 11, 'payments/paypal/paypal_callback_text', ''),
  (3239, 11, 'payments/paypal/paypal_custom_logo_image', ''),
  (3240, 11, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3241, 11, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3242, 11, 'payments/paypal/paypal_payment_action', 'sale'),
  (3262, 9, 'payments/paylater/paylater_enabled', '1'),
  (3263, 9, 'payments/paylater/paylater_is_default', '1'),
  (3264, 9, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3265, 9, 'payments/bankwire/bankwire_enabled', '1'),
  (3266, 9, 'payments/bankwire/bankwire_is_default', '0'),
  (3267, 9, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3268, 9, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3269, 9, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3270, 9, 'payments/paypal/paypal_enabled', '1'),
  (3271, 9, 'payments/paypal/paypal_is_default', '0'),
  (3272, 9, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment.'),
  (3273, 9, 'payments/paypal/paypal_merchant_id', ''),
  (3274, 9, 'payments/paypal/paypal_sandbox', '1'),
  (3275, 9, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3276, 9, 'payments/paypal/paypal_callback_text', ''),
  (3277, 9, 'payments/paypal/paypal_custom_logo_image', ''),
  (3278, 9, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3279, 9, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3280, 9, 'payments/paypal/paypal_payment_action', 'sale'),
  (3281, 12, 'payments/paylater/paylater_enabled', '1'),
  (3282, 12, 'payments/paylater/paylater_is_default', '1'),
  (3283, 12, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3284, 12, 'payments/bankwire/bankwire_enabled', '1'),
  (3285, 12, 'payments/bankwire/bankwire_is_default', '0'),
  (3286, 12, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3287, 12, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3288, 12, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3289, 12, 'payments/paypal/paypal_enabled', '1'),
  (3290, 12, 'payments/paypal/paypal_is_default', '0'),
  (3291, 12, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment'),
  (3292, 12, 'payments/paypal/paypal_merchant_id', ''),
  (3293, 12, 'payments/paypal/paypal_sandbox', '1'),
  (3294, 12, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3295, 12, 'payments/paypal/paypal_callback_text', ''),
  (3296, 12, 'payments/paypal/paypal_custom_logo_image', ''),
  (3297, 12, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3298, 12, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3299, 12, 'payments/paypal/paypal_payment_action', 'sale'),
  (3395, 13, 'payments/paylater/paylater_enabled', '1'),
  (3396, 13, 'payments/paylater/paylater_is_default', '1'),
  (3397, 13, 'payments/paylater/paylater_frontend_message', 'You will be charged full booking amount when check in at our hotel. Thank you.'),
  (3398, 13, 'payments/bankwire/bankwire_enabled', '1'),
  (3399, 13, 'payments/bankwire/bankwire_is_default', '0'),
  (3400, 13, 'payments/bankwire/bankwire_frontend_message', 'If you select this payment method, we will send the bank wire instructions in the confirmation email so that you can complete the payment in order to fully confirm your reservation.'),
  (3401, 13, 'payments/bankwire/bankwire_accountname', 'Billy Billy'),
  (3402, 13, 'payments/bankwire/bankwire_accountdetails', 'Bank Name: ABCDEF<br />\r\nBank Address: 123 Street No<br />\r\nSwift Code: OOOPPP<br />\r\nAccount number: 123 456 789 <br />'),
  (3403, 13, 'payments/paypal/paypal_enabled', '1'),
  (3404, 13, 'payments/paypal/paypal_is_default', '0'),
  (3405, 13, 'payments/paypal/paypal_frontend_message', 'You will be redirected to Paypal website to complete payment!'),
  (3406, 13, 'payments/paypal/paypal_merchant_id', ''),
  (3407, 13, 'payments/paypal/paypal_sandbox', '1'),
  (3408, 13, 'payments/paypal/paypal_sandbox_merchant_id', ''),
  (3409, 13, 'payments/paypal/paypal_callback_text', ''),
  (3410, 13, 'payments/paypal/paypal_custom_logo_image', ''),
  (3411, 13, 'payments/paypal/paypal_custom_header_background_color', ''),
  (3412, 13, 'payments/paypal/paypal_custom_header_border_color', ''),
  (3413, 13, 'payments/paypal/paypal_payment_action', 'sale');

INSERT INTO `#__sr_origins` (`id`, `scope`, `state`, `tax_id`, `is_default`, `name`, `color`) VALUES
  (1,0,1,NULL,1,'Website', '#17748b'),
  (2,0,1,NULL,0,'Walk-in', '#05386B'),
  (3,0,1,NULL,0,'Phone', '#64458c'),
  (4,0,1,NULL,0,'Email', '#41B3A3'),
  (5,1,1,NULL,1,'Website', '#17748b'),
  (6,1,1,NULL,0,'Walk-in', '#05386B'),
  (7,1,1,NULL,0,'Phone', '#64458c'),
  (8,1,1,NULL,0,'Email', '#41B3A3');