<?php
/**
------------------------------------------------------------------------
SOLIDRES - Accommodation booking extension for Joomla
------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Factory;
use Solidres\Media\ImageUploaderHelper;

class JFormFieldSolidres_Media extends FormField
{
	protected $type = 'Solidres_Media';

	protected function getInput()
	{
		Factory::getDocument()->getWebAssetManager()
			->useStyle('com_solidres.image-uploader')
			->useScript('com_solidres.image-uploader');
		$mediaType = $this->getAttribute('mediaType', 'PROPERTY');
		$targetId  = $this->form->getValue('targetId', null, $this->form->getValue('id', null, 0));
		$name      = preg_replace(['/^jform\[|\]$/i', '/\]\[/'], ['', '.'], $this->name);
		$subPath    = strtolower($mediaType)[0] . '/' . $targetId;
		$value     = $this->value ? ImageUploaderHelper::getImage($subPath . '/' . $this->value, 'full', true) : '';

		return <<<HTML
<input type="hidden" name="$this->name" id="$this->id" value="$value"/>
<solidres-media-manager type="$mediaType" name="$name" target-id="$targetId" target-element-id="$this->id" single no-thumb></solidres-media-manager>
HTML;

	}
}
