<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres;

defined('JPATH_PLATFORM') or die;

use JLoader;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Solidres\Administrator\Controller\ReservationbaseController;
use Joomla\Component\Solidres\Administrator\Field\ChargetypeField;
use Joomla\Component\Solidres\Administrator\Field\CheckboxcouponField;
use Joomla\Component\Solidres\Administrator\Field\CheckboxextraField;
use Joomla\Component\Solidres\Administrator\Field\CountryField;
use Joomla\Component\Solidres\Administrator\Field\CouponField;
use Joomla\Component\Solidres\Administrator\Field\CurrencyField;
use Joomla\Component\Solidres\Administrator\Field\CustomerField;
use Joomla\Component\Solidres\Administrator\Field\CustomergroupField;
use Joomla\Component\Solidres\Administrator\Field\DefaulttariffField;
use Joomla\Component\Solidres\Administrator\Field\Editor\ShortcodeField;
use Joomla\Component\Solidres\Administrator\Field\GallerylistField;
use Joomla\Component\Solidres\Administrator\Field\GeostateField;
use Joomla\Component\Solidres\Administrator\Field\LanguageoverrideField;
use Joomla\Component\Solidres\Administrator\Field\Modal\SolidresField;
use Joomla\Component\Solidres\Administrator\Field\OriginField;
use Joomla\Component\Solidres\Administrator\Field\PartnerlistField;
use Joomla\Component\Solidres\Administrator\Field\PartnerusergroupField;
use Joomla\Component\Solidres\Administrator\Field\PaymentmethodsField;
use Joomla\Component\Solidres\Administrator\Field\RatingField;
use Joomla\Component\Solidres\Administrator\Field\ReservationassetField;
use Joomla\Component\Solidres\Administrator\Field\RoomsgroupField;
use Joomla\Component\Solidres\Administrator\Field\RoomtypeField;
use Joomla\Component\Solidres\Administrator\Field\Solidres\MapField;
use Joomla\Component\Solidres\Administrator\Field\Solidres\MediaField;
use Joomla\Component\Solidres\Administrator\Field\Solidres\MenuitemField;
use Joomla\Component\Solidres\Administrator\Field\StatusesField;
use Joomla\Component\Solidres\Administrator\Field\TaxField;
use Joomla\Component\Solidres\Administrator\Field\TextaddonField;
use Joomla\Component\Solidres\Administrator\Field\ThumbsizesField;
use Joomla\Component\Solidres\Administrator\Field\UidatepickerField;
use Joomla\Component\Solidres\Administrator\Helper\SideNavigationHelper;
use Joomla\Component\Solidres\Administrator\Helper\SolidresHelper;
use Joomla\Component\Solidres\Administrator\Model\CountriesModel;
use Joomla\Component\Solidres\Administrator\Model\CountryModel;
use Joomla\Component\Solidres\Administrator\Model\CouponModel;
use Joomla\Component\Solidres\Administrator\Model\CouponsModel;
use Joomla\Component\Solidres\Administrator\Model\CurrenciesModel;
use Joomla\Component\Solidres\Administrator\Model\CurrencyModel;
use Joomla\Component\Solidres\Administrator\Model\ExtraModel;
use Joomla\Component\Solidres\Administrator\Model\ExtrasModel;
use Joomla\Component\Solidres\Administrator\Model\OriginModel;
use Joomla\Component\Solidres\Administrator\Model\OriginsModel;
use Joomla\Component\Solidres\Administrator\Model\PaymenthistoryModel;
use Joomla\Component\Solidres\Administrator\Model\ReservationassetModel;
use Joomla\Component\Solidres\Administrator\Model\ReservationassetsModel;
use Joomla\Component\Solidres\Administrator\Model\ReservationModel;
use Joomla\Component\Solidres\Administrator\Model\ReservationnotesModel;
use Joomla\Component\Solidres\Administrator\Model\ReservationsModel;
use Joomla\Component\Solidres\Administrator\Model\RoomModel;
use Joomla\Component\Solidres\Administrator\Model\RoomtypeModel;
use Joomla\Component\Solidres\Administrator\Model\RoomtypesModel;
use Joomla\Component\Solidres\Administrator\Model\StateModel;
use Joomla\Component\Solidres\Administrator\Model\StatesModel;
use Joomla\Component\Solidres\Administrator\Model\StatusesModel;
use Joomla\Component\Solidres\Administrator\Model\StatusModel;
use Joomla\Component\Solidres\Administrator\Model\SystemModel;
use Joomla\Component\Solidres\Administrator\Model\TariffDetailsModel;
use Joomla\Component\Solidres\Administrator\Model\TariffModel;
use Joomla\Component\Solidres\Administrator\Model\TariffsModel;
use Joomla\Component\Solidres\Administrator\Model\TaxesModel;
use Joomla\Component\Solidres\Administrator\Model\TaxModel;
use Joomla\Component\Solidres\Administrator\Table\CountryTable;
use Joomla\Component\Solidres\Administrator\Table\CouponTable;
use Joomla\Component\Solidres\Administrator\Table\CurrencyTable;
use Joomla\Component\Solidres\Administrator\Table\CustomerTable;
use Joomla\Component\Solidres\Administrator\Table\ExtraTable;
use Joomla\Component\Solidres\Administrator\Table\OriginTable;
use Joomla\Component\Solidres\Administrator\Table\PaymentHistoryTable;
use Joomla\Component\Solidres\Administrator\Table\ReservationAssetTable;
use Joomla\Component\Solidres\Administrator\Table\ReservationExtraTable;
use Joomla\Component\Solidres\Administrator\Table\ReservationNoteTable;
use Joomla\Component\Solidres\Administrator\Table\ReservationTable;
use Joomla\Component\Solidres\Administrator\Table\RoomTable;
use Joomla\Component\Solidres\Administrator\Table\RoomTypeTable;
use Joomla\Component\Solidres\Administrator\Table\StateTable;
use Joomla\Component\Solidres\Administrator\Table\StatusTable;
use Joomla\Component\Solidres\Administrator\Table\TariffDetailsTable;
use Joomla\Component\Solidres\Administrator\Table\TariffTable;
use Joomla\Component\Solidres\Administrator\Table\TaxTable;
use Joomla\Component\Solidres\Administrator\Table\WishListTable;
use Joomla\Component\Solidres\Site\Helper\RouteHelper;
use Joomla\Component\Solidres\Site\Helper\WishListHelper;
use Joomla\Component\Solidres\Site\Service\Router;
use Joomla\Filesystem\File;
use Solidres\Extra\Extra;
use Solidres\Extra\ExtraBase;
use Solidres\HTML\Jquery;
use Solidres\Layout\LayoutHelper;
use Solidres\MVC\Controller\ControllerLegacy;
use Solidres\MVC\Model\AdminModel;
use Solidres\MVC\View\HtmlView;
use Solidres\Config\Config;
use Solidres\Currency\Currency;
use Solidres\HTML\HTMLHelper;
use Solidres\Omnipay\OmnipayAbstract;
use Solidres\Pagination\Pagination;
use Solidres\Plugin\ExtraPlugin;
use Solidres\Plugin\PaymentPlugin;
use Solidres\Plugin\Plugin;
use Solidres\Reservation\Reservation;
use Solidres\RoomType\RoomType;
use Solidres\Toolbar\ToolbarHelper;
use Solidres\Utility\Calendar;
use Solidres\Utility\Utility;
use Solidres\Coupon\Coupon;

/**
 * @package     Solidres
 * @since       4.0.0
 * @deprecated  will be removed in the next stabled version
 */
class ClassAlias
{
    public static function register()
    {
        // Since 4.0.0, Solidres user is a default plugin CORE, some plugins which call the SolidresTableCustomer without boot the Solidres user plugin will be broken
        JLoader::registerNamespace('Joomla\\Component\\Solidres\\Administrator', JPATH_PLUGINS . '/user/solidres/administrator/components/com_solidres/src');
        Factory::register('solidres.utilities.utilities', new Utility());
        $classAliases = [
            // Common libraries
            Factory::class                        => 'SRFactory',
            Utility::class                        => 'SRUtilities',
            Calendar::class                       => 'SRCalendar',
            Coupon::class                         => 'SRCoupon',
            Config::class                         => 'SRConfig',
            Currency::class                       => 'SRCurrency',
            ExtraBase::class                      => 'SRExtraBase',
            Extra::class                          => 'SRExtra',
            HTMLHelper::class                     => 'SRHtml',
            Jquery::class                         => 'SRHtmlJquery',
            PaymentPlugin::class                  => 'SRPayment',
            OmnipayAbstract::class                => 'SRPaymentOmnipayAbstract',
            Plugin::class                         => 'SRPlugin',
            ExtraPlugin::class                    => 'SRPluginLegacy',
            Reservation::class                    => 'SRReservation',
            RoomType::class                       => 'SRRoomType',
            LayoutHelper::class                   => 'SRLayoutHelper',
            ToolbarHelper::class                  => 'SRToolbarHelper',
            Version::class                        => 'SRVersion',
            Pagination::class                     => 'SRPagination',
            SolidresHelper::class                 => 'SolidresHelper',
            SideNavigationHelper::class           => 'SolidresHelperSideNavigation',
            RouteHelper::class                    => 'SolidresHelperRoute',
            Router::class                         => 'Solidres\\Site\\Service\\RouterView',
            WishListHelper::class                 => 'SRWishList',

            // CORE Field
            ShortcodeField::class                 => 'JFormFieldEditor_Shortcode',
            SolidresField::class                  => 'JFormFieldModal_Solidres',
            MapField::class                       => 'JFormFieldSolidres_Map',
            MediaField::class                     => 'JFormFieldSolidres_Media',
            MenuitemField::class                  => 'JFormFieldSolidres_Menuitem',
            ChargetypeField::class                => 'ChargeType',
            CheckboxcouponField::class            => 'CheckboxCoupon',
            CheckboxextraField::class             => 'CheckboxExtra',
            CountryField::class                   => 'Country',
            CouponField::class                    => 'Coupon',
            CurrencyField::class                  => 'Currency',
            CustomerField::class                  => 'Customer',
            CustomergroupField::class             => 'CustomerGroup',
            DefaulttariffField::class             => 'DefaultTariff',
            GallerylistField::class               => 'GalleryList',
            GeostateField::class                  => 'GeoState',
            LanguageoverrideField::class          => 'LanguageOverride',
            OriginField::class                    => 'Origin',
            PartnerlistField::class               => 'PartnerList',
            PartnerusergroupField::class          => 'PartnerUserGroup',
            PaymentmethodsField::class            => 'PaymentMethods',
            RatingField::class                    => 'Rating',
            ReservationassetField::class          => 'ReservationAsset',
            RoomsgroupField::class                => 'RoomsGroup',
            RoomtypeField::class                  => 'RoomType',
            StatusesField::class                  => 'Statuses',
            TaxField::class                       => 'Tax',
            TextaddonField::class                 => 'TextAddon',
            ThumbsizesField::class                => 'ThumbSizes',
            UidatepickerField::class              => 'UIDatepicker',

            // CORE MVC Factory
            // Controller aliases
            ControllerLegacy::class               => 'SRControllerLegacy',
            '\\Joomla\\Component\\Solidres\\' . ucfirst(
                \Joomla\CMS\Factory::getApplication()->getName()
            ) . '\\Controller\\DisplayController' => 'SolidresController',
            ReservationbaseController::class      => 'SolidresControllerReservationBase',

            // Table aliases
            CountryTable::class                   => 'SolidresTableCountry',
            CouponTable::class                    => 'SolidresTableCoupon',
            CurrencyTable::class                  => 'SolidresTableCurrency',
            ExtraTable::class                     => 'SolidresTableExtra',
            OriginTable::class                    => 'SolidresTableOrigin',
            PaymentHistoryTable::class            => 'SolidresTablePaymentHistory',
            ReservationAssetTable::class          => 'SolidresTableReservationAsset',
            ReservationExtraTable::class          => 'SolidresTableReservationExtra',
            ReservationNoteTable::class           => 'SolidresTableReservationNote',
            ReservationTable::class               => 'SolidresTableReservation',
            RoomTable::class                      => 'SolidresTableRoom',
            RoomTypeTable::class                  => 'SolidresTableRoomType',
            StateTable::class                     => 'SolidresTableState',
            StatusTable::class                    => 'SolidresTableStatus',
            TariffDetailsTable::class             => 'SolidresTableTariffDetails',
            TariffTable::class                    => 'SolidresTableTariff',
            TaxTable::class                       => 'SolidresTableTax',
            WishListTable::class                  => 'SolidresTableWishList',
            CustomerTable::class                  => 'SolidresTableCustomer',

            // Model aliases
            CountriesModel::class                 => 'SolidresModelCountries',
            CountryModel::class                   => 'SolidresModelCountry',
            CouponModel::class                    => 'SolidresModelCoupon',
            CouponsModel::class                   => 'SolidresModelCoupons',
            CurrenciesModel::class                => 'SolidresModelCurrencies',
            CurrencyModel::class                  => 'SolidresModelCurrency',
            ExtraModel::class                     => 'SolidresModelExtra',
            ExtrasModel::class                    => 'SolidresModelExtras',
            OriginModel::class                    => 'SolidresModelOrigin',
            OriginsModel::class                   => 'SolidresModelOrigins',
            PaymenthistoryModel::class            => 'SolidresModelPaymentHistory',
            ReservationassetModel::class          => 'SolidresModelReservationAsset',
            ReservationassetsModel::class         => 'SolidresModelReservationAssets',
            ReservationModel::class               => 'SolidresModelReservation',
            ReservationnotesModel::class          => 'SolidresModelReservationNotes',
            ReservationsModel::class              => 'SolidresModelReservations',
            RoomModel::class                      => 'SolidresModelRoom',
            RoomtypeModel::class                  => 'SolidresModelRoomType',
            RoomtypesModel::class                 => 'SolidresModelRoomTypes',
            StateModel::class                     => 'SolidresModelState',
            StatesModel::class                    => 'SolidresModelStates',
            StatusesModel::class                  => 'SolidresModelStatuses',
            StatusModel::class                    => 'SolidresModelStatus',
            SystemModel::class                    => 'SolidresModelSystem',
            TariffDetailsModel::class             => 'SolidresModelTariffDetails',
            TariffModel::class                    => 'SolidresModelTariff',
            TariffsModel::class                   => 'SolidresModelTariffs',
            TaxesModel::class                     => 'SolidresModelTaxes',
            TaxModel::class                       => 'SolidresModelTax',
            AdminModel::class                     => 'SRModelAdmin',

            // View aliases
            HtmlView::class                       => 'SRViewLegacy',
        ];

        foreach ($classAliases as $origin => $alias) {
            if (class_exists($origin) && !class_exists($alias)) {
                class_alias($origin, $alias);
            }
        }

        // Deprecated files
        $files = [
            JPATH_ADMINISTRATOR . '/components/com_solidres/helpers/layout.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/helpers/toolbar.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/helpers/helper.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/reservationassets.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/reservation.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/reservationasset.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/roomtype.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/coupon.php',
            JPATH_ADMINISTRATOR . '/components/com_solidres/models/extra.php',
            JPATH_SITE . '/components/com_solidres/helpers/route.php',
        ];

        foreach ($files as $file) {
            if (!is_file($file)) {
                File::write(
                    $file,
                    <<<PHP_CONTENT
<?php
/**
------------------------------------------------------------------------
SOLIDRES - Accommodation booking extension for Joomla
------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
------------------------------------------------------------------------
THIS FILE IS CREATED AUTOMATICALLY, DON'T CHANGE THIS FILE, IT WILL BE REMOVED IN THE NEXT STABLE VERSION 
 */
 
defined('_JEXEC') or die;
PHP_CONTENT

                );
            }
        }
    }
}
