<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Coupon;

defined('_JEXEC') or die;

use Joomla\Database\DatabaseInterface;
use Joomla\Registry\Registry;
use Joomla\CMS\Factory;
use Solidres\MVC\FactoryTrait;

class Coupon
{
    use FactoryTrait;

    protected ?DatabaseInterface $dbo = null;

    public function __construct()
    {
        $this->dbo = Factory::getContainer()->get(DatabaseInterface::class);
    }

    /**
     * Check a coupon code to see if it is valid to use.
     *
     * @param string $couponCode      The coupon code to check
     * @param int    $raId            The reservation asset id
     * @param int    $dateOfChecking  The date of checking
     * @param int    $checkin         The checkin date
     * @param int    $customerGroupId The customer group id
     *
     * @return  boolean
     * @since   0.1.0
     *
     */
    public function isValid($couponCode, $raId, $dateOfChecking, $checkin, $customerGroupId = null)
    {
        $model      = $this->createModel('Coupon');
        $tableAsset = $this->createTable('ReservationAsset');
        $coupon     = $model->getItem(['coupon_code' => $couponCode]);
        $tableAsset->load($raId);
        $registry = new Registry();
        $registry->loadString($tableAsset->params);
        $assetParams = $registry->toArray();

        if (!isset($assetParams['enable_coupon'])) {
            $assetParams['enable_coupon'] = 0;
        }

        $response = true;
        $inAssets = empty($coupon->reservation_asset_id) || in_array($raId, (array)$coupon->reservation_asset_id);

        if (
            $coupon->state != 1
            || !($coupon->valid_from <= $dateOfChecking && $dateOfChecking <= $coupon->valid_to)
            || !$inAssets
            || !($coupon->valid_from_checkin <= $checkin && $checkin <= $coupon->valid_to_checkin)
            || $coupon->customer_group_id != $customerGroupId
            || (!is_null($coupon->quantity) && $coupon->quantity == 0)
            || ($assetParams['enable_coupon'] == 0)
        ) {
            $response = false;
        }

        return $response;
    }

    /**
     * Check to see if the given coupon is applicable to the given room type/extra
     *
     * @param   $couponId
     * @param   $scopeId  int  Id of room type or extra
     * @param   $scope    string Either room_type or extra
     *
     * @return  bool
     * @since   0.1.0
     *
     */
    public function isApplicable($couponId, $scopeId, $scope = 'room_type')
    {
        $couponModel = $this->createModel('Coupon');
        $couponItem  = $couponModel->getItem($couponId);

        if (empty($couponItem->id)) {
            return false;
        }

        if (is_array($couponItem->reservation_asset_id) && !$couponItem->reservation_asset_id) {
            // This coupon is for all assets
            return true;
        }

        $query = $this->dbo->getQuery(true)
            ->select('COUNT(*)')
            ->from($this->dbo->quoteName('#__sr_' . $scope . '_coupon_xref'))
            ->where($this->dbo->quoteName($scope . '_id') . ' = ' . (int)$scopeId)
            ->where($this->dbo->quoteName('coupon_id') . ' = ' . (int)$couponId);
        $this->dbo->setQuery($query);

        return (bool)$this->dbo->loadResult();
    }
}