<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Event;

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

class ReservationChangeStateEvent extends SolidresBaseEvent
{
    public function getContext(): string
    {
        return $this->getArgument('context');
    }

    public function getOldState(): int
    {
        return (int)$this->getArgument('oldState');
    }

    public function getNewState(): int
    {
        return (int)$this->getArgument('newState');
    }

    public function getIdList(): array
    {
        return ArrayHelper::toInteger($this->getArgument('idList', []));
    }


}
