<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Event;

defined('_JEXEC') or die;

use Joomla\Component\Solidres\Administrator\Model\ReservationModel;
use Joomla\Component\Solidres\Administrator\Table\ReservationTable;

class ReservationSaveBaseEvent extends SolidresResultBaseEvent
{
    public function getData(): array {
        return $this->getArgument('data');
    }

    public function getModel(): ReservationModel {
        return $this->getArgument('model');
    }

    public function getTable(): ReservationTable {
        return $this->getArgument('subject');
    }

    public function getIsIsNew(): bool {
        return (bool) $this->getArgument('isNew');
    }
}
