<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Event;

defined('_JEXEC') or die;

use Joomla\Registry\Registry;
use stdClass;

class RoomTypeProcessFlexSearchEvent extends SolidresBaseEvent
{
    public function getContext(): string
    {
        return $this->getArgument('context');
    }

    public function getRoomType(): stdClass
    {
        return $this->getArgument('subject');
    }

    public function getCheckin(): string
    {
        return $this->getArgument('checkin');
    }

    public function getCheckout(): string
    {
        return $this->getArgument('checkout');
    }

    public function getItem(): stdClass
    {
        return $this->getArgument('item');
    }

    public function getState(): Registry
    {
        return $this->getArgument('state');
    }

    public function getBookingType() : string
    {
        return $this->getArgument('bookingType');
    }

    public function getRoomsOccupancyOptions(): mixed
    {
        return $this->getArgument('roomsOccupancyOptions');
    }

    public function getImposedTaxTypes() : array
    {
        return $this->getArgument('imposedTaxTypes');
    }
}
