<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Event;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use stdClass;

class SolidresBaseEvent extends Event
{
    protected static ?string $eventName = null;

    public function __construct(array $arguments = [])
    {
        $eventClassName = explode('\\', get_class($this));
        $eventClassName = $eventClassName[count($eventClassName) - 1];
        $name           = static::$eventName ?: 'on' . preg_replace('/^(On)|(Event)$/', '', $eventClassName);

        if (!array_key_exists('subject', $arguments)) {
            $arguments['subject'] = new stdClass();
        }

        parent::__construct($name, $arguments);
    }

    public function setName(string $name) : static {
        $this->name = $name;

        return $this;
    }

    public static function getDispatcher(): DispatcherInterface
    {
        return Factory::getApplication()->getDispatcher();
    }

    public static function dispatch(array $arguments = []): static
    {
        $className = get_called_class();
        $instance  = new $className($arguments);

        /** @var static $event */
        $event = static::getDispatcher()
            ->dispatch($instance->getName(), $instance);

        return $event;
    }
}
