<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Extra;

defined('_JEXEC') or die;

/**
 * Extra handler class
 *
 * @package       Solidres
 * @subpackage    Extra
 *
 * @since         0.8.0
 */
class Extra extends ExtraBase
{
    public function __construct($extraDetails = [])
    {
        parent::__construct($extraDetails);
    }

    public function calculateExtraCost()
    {
        $totalExtraCostTaxIncl = 0;
        $totalExtraCostTaxExcl = 0;
        $quantity              = 1;
        if (isset($this->quantity)) {
            $quantity = $this->quantity;
        }

        switch ($this->charge_type) {
            case 1: // Per booking
            case 0: // Per room or Per booking
            default:
                $totalExtraCostTaxIncl += $this->price_tax_incl * $quantity;
                $totalExtraCostTaxExcl += $this->price_tax_excl * $quantity;
        }

        return [
            'total_extra_cost_tax_incl' => $totalExtraCostTaxIncl,
            'total_extra_cost_tax_excl' => $totalExtraCostTaxExcl,
        ];
    }
}