<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres;

defined('_JEXEC') or die;

use RuntimeException;
use Joomla\CMS\Factory as CMSFactory;
use Solidres\Plugin\Plugin;

class Factory
{
    protected static array $aliases = [];

    public static function get(string $classPath)
    {
        if (isset(static::$aliases[$classPath])) {
            return static::$aliases[$classPath];
        }

        // B/C will remove in the next stabled version
        $className = '\\' . implode(
                '\\',
                array_map(
                    function ($part) {
                        return ucfirst($part);
                    },
                    explode('.', $classPath)
                )
            );

        if (class_exists($className)) {
            return new $className();
        }

        throw new RuntimeException('Invalid class name: ' . $className);
    }

    public static function register(string $interface, $instanceOrClass)
    {
        if (!isset(static::$aliases[$interface])) {
            static::$aliases[$interface] = $instanceOrClass;
        }

        return static::$aliases[$interface];
    }

    public static function getHashVersion(string $plugin, string $type = 'solidres'): ?string
    {
        $extension = CMSFactory::getApplication()->bootPlugin($plugin, $type);

        return $extension instanceof Plugin ? $extension->getVersion(true) : null;
    }
}