<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Layout;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\Path;

class LayoutHelper
{
    protected static array $includePaths = [];
    protected static LayoutHelper $instance;

    /**
     *
     * @return LayoutHelper
     *
     * @since      version
     * @deprecated 4.0.0 will remove in the next stabled version
     */
    public static function getInstance(): LayoutHelper
    {
        if (!isset(static::$instance)) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    public static function addIncludePath($paths = [])
    {
        settype($paths, 'array');

        foreach ($paths as $includePath) {
            if (in_array($includePath, self::$includePaths)) {
                unset(self::$includePaths[$includePath]);
            }

            array_unshift(self::$includePaths, $includePath);
        }
    }

    public static function resetPath()
    {
        self::addIncludePath(
            [
                JPATH_ADMINISTRATOR . '/components/com_solidres/layouts',
                JPATH_ROOT . '/components/com_solidres/layouts',
                JPATH_THEMES . '/' . Factory::getApplication()->getTemplate() . '/html/layouts/com_solidres',
            ]
        );

        return self::$includePaths;
    }

    public static function render($layoutId, $displayData = [], $reset = true)
    {
        if ($reset) {
            self::resetPath();
        }

        $rawPath = str_replace('.', '/', $layoutId) . '.php';
        $path    = Path::find(self::$includePaths, $rawPath);

        if (!empty($path)) {
            ob_start();
            include $path;

            return ob_get_clean();
        }

        return false;
    }
}
