<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\MVC\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\MVC\Controller\ApiController as BaseApiController;

class ApiController extends BaseApiController
{
    protected array $filtersList = [];

    public function displayList()
    {
        $this->populateModelState();

        return parent::displayList();
    }

    protected function populateModelState()
    {
        $apiFilterInfo = $this->input->get('filter', [], 'array');
        $inputFilter   = InputFilter::getInstance();
        $filtersList   = array_merge(['search' => 'STRING', 'published' => 'UINT'], $this->filtersList);

        foreach ($filtersList as $name => $filter) {
            if (array_key_exists($name, $apiFilterInfo)) {
                $this->modelState->set('filter.' . $name, $inputFilter->clean($apiFilterInfo[$name], $filter));
            }
        }

        $apiListInfo = $this->input->get('list', [], 'array');

        if (array_key_exists('ordering', $apiListInfo)) {
            $this->modelState->set('list.ordering', $inputFilter->clean($apiListInfo['ordering'], 'STRING'));
        }

        if (array_key_exists('direction', $apiListInfo)) {
            $this->modelState->set('list.direction', $inputFilter->clean($apiListInfo['direction'], 'STRING'));
        }
    }
}
