<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\MVC\Controller;

use Joomla\CMS\Access\Exception\NotAllowed;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\String\Inflector;
use RuntimeException;
use Solidres\Utility\Utility;

defined('_JEXEC') or die;

abstract class ApiControllerAccessAbstract extends ApiController
{
    abstract protected function getPropertyId(int $itemId): int;

    protected function allowEdit($data = [], $key = 'id')
    {
        if (!($canEdit = parent::allowEdit($data, $key))
            && PluginHelper::isEnabled('solidres', 'hub')
            && ($propertyId = $this->getPropertyId($data[$key]))
        ) {
            $canEdit = Utility::isAssetPartner($this->app->getIdentity()->id, $propertyId);
        }

        return $canEdit;
    }

    protected function allowAdd($data = [], $key = 'id')
    {
        if (!($canAdd = parent::allowAdd($data))
            && PluginHelper::isEnabled('solidres', 'hub')
            && Utility::getPartnerId()
        ) {
            $canAdd = true;
        }

        return $canAdd;
    }

    public function delete($id = null)
    {
        if ($id === null) {
            $id = $this->input->get('id', 0, 'UINT');
        }

        $user      = $this->app->getIdentity();
        $canDelete = $user->authorise('core.delete', 'com_solidres');

        if (!$canDelete
            && PluginHelper::isEnabled('solidres', 'hub')
            && ($propertyId = $this->getPropertyId((int)$id))
        ) {
            $canDelete = Utility::isAssetPartner($user->id, $propertyId);
        }

        if (!$canDelete) {
            throw new NotAllowed('JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED', 403);
        }

        $modelName = $this->input->get('model', Inflector::singularize($this->contentType));

        /** @var AdminModel $model */
        $model = $this->getModel($modelName, '', ['ignore_request' => true]);

        if (!$model) {
            throw new RuntimeException(Text::_('JLIB_APPLICATION_ERROR_MODEL_CREATE'));
        }

        // Remove the item.
        if (!$model->delete($id)) {
            if ($model->getError() !== false) {
                throw new RuntimeException($model->getError(), 500);
            }

            throw new RuntimeException(Text::_('JLIB_APPLICATION_ERROR_DELETE'), 500);
        }

        $this->app->setHeader('status', 204);
    }
}