<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\MVC;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\LegacyFactory;
use Joomla\CMS\MVC\Factory\MVCFactory;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Table\Table;
use Solidres\MVC\Controller\ControllerLegacy;

defined('_JEXEC') or die;

trait FactoryTrait
{
    private function addLegacyIncludePath()
    {
        static $done = false;

        if (!$done) {
            $done = true;

            foreach (ControllerLegacy::addIncludePath() as $pluginBasePath) {
                preg_match('/\/solidres\/([^\/]+)\//', $pluginBasePath, $matches);

                if (empty($matches[1])) {
                    continue;
                }

                $plugin      = $matches[1];
                $pluginPaths = [
                    JPATH_PLUGINS . '/solidres/' . $plugin . '/administrator/components/com_solidres',
                    JPATH_PLUGINS . '/solidres/' . $plugin . '/components/com_solidres',
                ];

                foreach ($pluginPaths as $pluginPath) {
                    if (is_dir($pluginPath . '/tables')) {
                        Table::addIncludePath($pluginPath . '/tables');
                    }

                    if (is_dir($pluginPath . '/models')) {
                        BaseDatabaseModel::addIncludePath($pluginPath . '/models', 'SolidresModel');
                    }
                }
            }
        }
    }

    public function getSolidresMVCFactory(): MVCFactory
    {
        return Factory::getApplication()
            ->bootComponent('com_solidres')
            ->getMVCFactory();
    }

    public function createModel($name, $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        if (!($model = $this->getSolidresMVCFactory()->createModel($name, $prefix, $config))) {
            // B/C
            $this->addLegacyIncludePath();
            $model = (new LegacyFactory())->createModel($name, 'SolidresModel', $config);
        }

        return $model;
    }

    public function createTable($name, $prefix = 'Administrator', $config = [])
    {
        if (!($table = $this->getSolidresMVCFactory()->createTable($name, $prefix, $config))) {
            // B/C
            $this->addLegacyIncludePath();
            $table = (new LegacyFactory())->createTable($name, 'SolidresTable', $config);
        }

        return $table;
    }

    public function getPluginLegacyController(string $name, string $client = '', array $config = []): ?BaseController
    {
        /**
         * For B/C
         * @since 4.0.0
         * @deprecated
         */

        FormHelper::addFieldPrefix('Joomla\\Component\\Solidres\\Administrator\\Field');
        FormHelper::addFieldPrefix('Joomla\\Component\\Solidres\\Site\\Field');

        if (!$this->app->isClient('api')) {
            $view   = strtolower($this->app->input->get('view', ''));
            $isSite = $this->app->isClient('site');

            foreach (ControllerLegacy::addIncludePath() as $pluginBasePath) {
                preg_match('/\/solidres\/([^\/]+)\//', $pluginBasePath, $matches);

                if (empty($matches[1])) {
                    continue;
                }

                $base               = JPATH_PLUGINS . '/solidres/' . $matches[1];
                $sitePath           = $base . '/components/com_solidres';
                $adminPath          = $base . '/administrator/components/com_solidres';
                $viewFile           = $view ? $pluginBasePath . '/views/' . $view . '/view.html.php' : '';
                $controllerFile     = $pluginBasePath . '/controllers/' . $name . '.php';
                $jsonControllerFile = $this->app->input->get('format') === 'json' ? $pluginBasePath . '/controllers/' . $name . '.json.php' : null;
                $isJsonController   = $jsonControllerFile && is_file($jsonControllerFile);
                $isPluginLegacy     = $name === 'display' ? is_file($viewFile) : is_file($controllerFile) || $isJsonController;

                if ($isPluginLegacy) {
                    if (is_file($controllerFile)) {
                        require_once $controllerFile;
                    } elseif ($isJsonController) {
                        require_once $jsonControllerFile;
                    }

                    if (is_file($viewFile)) {
                        require_once $viewFile;
                    }

                    Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_solidres/forms');
                    Form::addFieldPath(JPATH_ADMINISTRATOR . '/components/com_solidres/models/fields');

                    foreach ([$sitePath . '/models', $adminPath . '/models'] as $modelPath) {
                        if (is_dir($modelPath . '/forms')) {
                            Form::addFormPath($modelPath . '/forms');
                        }

                        if (is_dir($modelPath . '/fields')) {
                            Form::addFieldPath($modelPath . '/fields');
                        }
                    }

                    $config['base_path']  = $pluginBasePath;
                    $config['model_path'] = $pluginBasePath . '/models';
                    $config['view_path']  = $pluginBasePath . '/views';

                    if ($name === 'display') {
                        $config['name']         = 'solidres';
                        $displayControllerClass = 'Joomla\\Component\\Solidres\\' . ucfirst(
                                $this->app->getName()
                            ) . '\\Controller\\DisplayController';
                    } else {
                        unset($config['name']);
                        $displayControllerClass = 'SolidresController' . ucfirst($name);
                    }

                    return new $displayControllerClass($config);
                }
            }
        }

        return null;
    }
}