<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\MVC\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel as CMSAdminModel;
use Solidres\MVC\FactoryTrait;

abstract class AdminModel extends CMSAdminModel
{
    use FactoryTrait;

    public function getTable($name = '', $prefix = 'Administrator', $options = [])
    {
        if (empty($name)) {
            $name = ucfirst($this->getName());
        }

        return $this->createTable($name, $prefix, $options);
    }

    public function getForm($data = [], $loadData = true)
    {
        // Get the form.
        $name = $this->getName();
        $form = $this->loadForm('com_solidres.' . $name, $name, ['control' => 'jform', 'load_data' => $loadData]);

        if (empty($form)) {
            return false;
        }

        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $name = $this->getName();
        $data = Factory::getApplication()->getUserState('com_solidres.edit.' . $name . '.data', []);

        if (empty($data)) {
            $data = $this->getItem();
        }

        $this->preprocessData('com_solidres.' . $name, $data, 'solidres');

        return $data;
    }
}