<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\MVC\View;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\JsonApiView as BaseApiView;
use Joomla\Component\Solidres\Api\Serializer\SolidresSerializer;
use Joomla\Registry\Registry;

class JsonApiView extends BaseApiView
{
    protected array $jsonFields = ['params'];

    public function __construct($config = [])
    {
        if (!empty($this->fieldsToRenderList) && empty($this->fieldsToRenderItem)) {
            $this->fieldsToRenderItem = $this->fieldsToRenderList;
        }

        if (array_key_exists('contentType', $config)) {
            $this->serializer = new SolidresSerializer($config['contentType']);
        }

        parent::__construct($config);
    }

    protected function prepareItem($item)
    {
        if (!$item) {
            return $item;
        }

        foreach ($this->jsonFields as $jsonField) {
            if (property_exists($item, $jsonField)) {
                if ($item->{$jsonField} instanceof Registry) {
                    $item->{$jsonField} = $item->params->toArray();
                } elseif (!is_array($item->{$jsonField})) {
                    $item->{$jsonField} = json_decode($item->{$jsonField} ?: '{}', true);
                }
            }
        }

        return parent::prepareItem($item);
    }
}
