<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Omnipay;

defined('_JEXEC') or die;

use Joomla\CMS\Form\Form;
use Omnipay\Omnipay;
use Solidres\Plugin\PaymentPlugin;

abstract class OmnipayAbstract extends PaymentPlugin
{
    protected $autoloadLanguage = true;

    protected array $dataConfig;

    protected $gateway;

    protected string $returnUrl;

    public function __construct($subject, $config = [])
    {
        parent::__construct($subject, $config);
    }

    public function onSolidresPaymentNew($reservationData)
    {
        parent::onSolidresPaymentNew($reservationData);

        $autoload = JPATH_PLUGINS . '/' . $this->_type . '/' . $this->_name . '/vendor/autoload.php';

        if (is_file($autoload)) {
            require_once $autoload;
        }

        $this->gateway   = Omnipay::create($this->getGateWay());
        $this->returnUrl = $this->getReturnUrl($reservationData->id);
    }

    abstract protected function getGateWay();

    public function onSolidresPaymentCallback($paymentMethodId, $callbackData)
    {
        if ($paymentMethodId != $this->identifier || empty($callbackData)) {
            return false;
        }
    }

    public function onSolidresPaymentRefundDisplay(Form $reservation)
    {
        return;
    }

    public function onSolidresPaymentRefundCallback()
    {
        return;
    }

    abstract protected function getForm();
}
