<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Plugin;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Registry\Registry;
use Joomla\CMS\Form\Form;
use Solidres\Config\Config;

class ExtraPlugin extends Plugin
{
    protected bool $loadExperienceFromManifest = true;

    protected bool $loadAssetFromManifest = true;

    public function __construct(DispatcherInterface $dispatcher, array $config = [])
    {
        parent::__construct($dispatcher, $config);

        // B/C
        /** @deprecated */
        if (property_exists($this, 'asset')) {
            $this->loadAssetFromManifest = (bool)$this->asset;
        }

        // B/C
        /** @deprecated */
        if (property_exists($this, 'experience')) {
            $this->loadExperienceFromManifest = (bool)$this->experience;
        }
    }

    protected function getData($scopeId, $namespace = null)
    {
        $name = strtolower($this->_name);

        if (null === $namespace) {
            $namespace = 'plugins/' . $name;
        }

        $config = new Config(['scope_id' => $scopeId, 'data_namespace' => $namespace]);
        $data   = [];

        foreach ($config->getData() as $array) {
            [$key, $value] = $array;

            if (strpos($key, $namespace . '/') === 0) {
                $data[str_replace($namespace . '/', '', $key)] = $value;
            }
        }

        return $data;
    }

    protected function loadFile($form, $data, $namespace = null)
    {
        $name     = strtolower($this->_name);
        $load     = $form->loadFile(
            JPATH_PLUGINS . '/solidres/' . $name . '/' . $name . '.xml',
            true,
            '/extension/fields[@name="plugins"]'
        );
        $registry = new Registry($data);
        $id       = $registry->get('id');

        if ($load && $id) {
            $form->bind([
                    'plugins' => $this->getData($id, $namespace),
                ]
            );
        }

        return $load;
    }

    public function onReservationAssetPrepareForm($form, $data)
    {
        if ($this->loadAssetFromManifest) {
            $this->loadFile($form, $data);
        }
    }

    public function onReservationAssetAfterSave($data, $table, $result, $isNew)
    {
        if (!$this->loadAssetFromManifest || empty($data['plugins'])) {
            return;
        }

        $name     = strtolower($this->_name);
        $saveData = [];

        foreach ($data['plugins'] as $k => $v) {
            if (is_array($v) || is_object($v)) {
                $registry = new Registry($v);
                $v        = $registry->toString();
            }

            if (strpos($k, $name) === 0) {
                $saveData[$k] = $v;
            }
        }

        if (is_callable([$this, 'prepareSaveData'])) {
            call_user_func_array([$this, 'prepareSaveData'], [$table, &$saveData]);
        }

        if (count($saveData)) {
            $config = new Config(['scope_id' => $table->id, 'data_namespace' => 'plugins/' . $name]);

            $config->set($saveData);
        }
    }

    public function onContentPrepareForm(Form $form, $data)
    {
        if ($this->loadAssetFromManifest
            && $form->getName() === 'com_solidres.experience'
            && PluginHelper::isEnabled('solidres', 'experience')
        ) {
            $name      = strtolower($this->_name);
            $namespace = 'plugins/experience/' . $name;
            $this->loadFile($form, $data, $namespace);
        }
    }

    public function onContentAfterSave($context, $table, $isNew)
    {
        $data = $this->getApplication()->input->get('jform', [], 'array');

        if (!$this->loadExperienceFromManifest
            || $context !== 'com_solidres.experience'
            || empty($data['plugins'])
            || !is_array($data['plugins'])
            || !PluginHelper::isEnabled('solidres', 'experience')
        ) {
            return;
        }

        $name     = strtolower($this->_name);
        $saveData = [];

        foreach ($data['plugins'] as $k => $v) {
            if (is_array($v) || is_object($v)) {
                $registry = new Registry($v);
                $v        = $registry->toString();
            }

            if (strpos($k, $name) === 0) {
                $saveData[$k] = $v;
            }
        }

        if (is_callable([$this, 'prepareSaveData'])) {
            call_user_func_array([$this, 'prepareSaveData'], [$table, &$saveData]);
        }

        if (count($saveData)) {
            $config = new Config(['scope_id' => $table->id, 'data_namespace' => 'plugins/experience/' . $name]);
            $config->set($saveData);
        }
    }
}
