<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Plugin;

use Joomla\CMS\Event\Model\AfterSaveEvent;
use Joomla\CMS\Event\Model\PrepareFormEvent;

defined('_JEXEC') or die;

trait PaymentPluginAware
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onReservationCheckConfirmed'   => 'onReservationCheckConfirmed',
            'onReservationAssetPrepareForm' => 'assetPrepareForm',
            'onReservationAssetAfterSave'   => 'assetAfterSave',
        ];
    }

    public function assetPrepareForm(PrepareFormEvent $event) {
        if (method_exists($this, 'onReservationAssetPrepareForm')) {
            $this->onReservationAssetPrepareForm($event->getForm(), $event->getData());
        }
    }

    public function assetAfterSave(AfterSaveEvent $event) {
        if (method_exists($this, 'onReservationAssetAfterSave')) {
            $this->onReservationAssetAfterSave($event->getArgument('data'), $event->getArgument('subject'), true, $event->getIsNew());
        }
    }
}