<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Plugin;

defined('_JEXEC') or die;

use Exception;
use JLoader;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Event\Menu\AfterGetMenuTypeOptionsEvent;
use Joomla\CMS\Event\Model\AfterSaveEvent;
use Joomla\CMS\Event\Model\PrepareFormEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\User\CurrentUserInterface;
use Joomla\CMS\User\CurrentUserTrait;
use Joomla\Database\DatabaseAwareInterface;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Registry\Registry;
use RuntimeException;
use SimpleXMLElement;
use Solidres\Config\Config;
use Solidres\Layout\LayoutHelper;
use Solidres\MVC\Controller\ControllerLegacy;
use Solidres\MVC\FactoryTrait;
use Throwable;

class Plugin extends CMSPlugin implements DatabaseAwareInterface, CurrentUserInterface
{
    use DatabaseAwareTrait;

    use CurrentUserTrait;

    use FactoryTrait;

    protected static $plgVersion = null;
    protected static $plgHashVersion = null;

    protected $addIncludePath = true;
    protected $autoloadLanguage = true;
    protected string $rootPath;
    protected string $adminMVCPath;
    protected string $siteMVCPath;
    protected string $baseMVCPath;

    protected Registry $solidresConfig;
    protected bool $loadExperienceFromManifest = false;
    protected bool $loadAssetFromManifest = false;

    public function __construct(DispatcherInterface $dispatcher, array $config = [])
    {
        parent::__construct($dispatcher, $config);

        if (!$this->getApplication()) {
            $this->setApplication(Factory::getApplication());
        }

        try {
            $this->getDatabase();
        } catch (Throwable $e) {
            $this->setDatabase(Factory::getContainer()->get(DatabaseInterface::class));
        }

        $this->solidresConfig = ComponentHelper::getParams('com_solidres');
        $this->rootPath       = JPATH_PLUGINS . '/' . $this->_type . '/' . $this->_name;
        $client               = ucfirst($this->getApplication()->getName());
        $this->siteMVCPath    = $this->rootPath . '/components/com_solidres';
        $this->adminMVCPath   = $this->rootPath . '/administrator/components/com_solidres';
        $this->baseMVCPath    = $client === 'Site' ? $this->siteMVCPath : $this->adminMVCPath;

        if (is_dir($this->siteMVCPath . '/src')) {
            JLoader::registerNamespace('\\Joomla\\Component\\Solidres\\Site', $this->siteMVCPath . '/src');
        }

        if (is_dir($this->adminMVCPath . '/src')) {
            JLoader::registerNamespace('\\Joomla\\Component\\Solidres\\Administrator', $this->adminMVCPath . '/src');
        }

        if (is_dir($this->baseMVCPath . '/forms')) {
            Form::addFormPath($this->baseMVCPath . '/forms');
        }

        $manifest = $this->rootPath . '/' . $this->_name . '.xml';

        if (is_file($manifest)) {
            $xml                    = new SimpleXMLElement(file_get_contents($manifest));
            static::$plgVersion     = (string)$xml->version;
            static::$plgHashVersion = md5(static::$plgVersion);
        }
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getHashVersion()
    {
        return static::$plgHashVersion;
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getLayoutPath(string $plgName)
    {
        if ($plgName === 'user') {
            return JPATH_PLUGINS . '/user/solidres/layouts';
        }

        return JPATH_PLUGINS . '/solidres/' . $plgName . '/layouts';
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getTemplatePath($plgName)
    {
        $view = strtolower(Factory::getApplication()->input->getCmd('view'));

        return static::getBasePath($plgName) . '/views/' . $view . '/tmpl';
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getBasePath(string $plgName)
    {
        if (Factory::getApplication()->isClient('administrator')) {
            return static::getAdminPath($plgName);
        }

        return static::getSitePath($plgName);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getAdminPath(string $plgName)
    {
        if ($plgName === 'user') {
            return JPATH_PLUGINS . '/user/solidres/administrator/components/com_solidres';
        }

        return JPATH_PLUGINS . '/solidres/' . $plgName . '/administrator/components/com_solidres';
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getSitePath($plgName)
    {
        if ($plgName === 'user') {
            return JPATH_PLUGINS . '/user/solidres/components/com_solidres';
        }

        return JPATH_PLUGINS . '/solidres/' . $plgName . '/components/com_solidres';
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function getPluginPath(string $plgName)
    {
        if ($plgName === 'user') {
            return JPATH_PLUGINS . '/user/solidres';
        }

        return JPATH_PLUGINS . '/solidres/' . $plgName;
    }

    public function registerListeners()
    {
        parent::registerListeners();
        $dispatcher = $this->getDispatcher();

        // Remove legacy listeners
        $dispatcher->removeListener('onContentPrepareForm', [$this, 'onContentPrepareForm']);
        $dispatcher->removeListener('onContentAfterSave', [$this, 'onContentAfterSave']);
        $dispatcher->removeListener('onAfterGetMenuTypeOptions', [$this, 'onAfterGetMenuTypeOptions']);

        // Add new feature listeners
        $dispatcher->addListener('onContentPrepareForm', [$this, 'contentPrepareForm']);
        $dispatcher->addListener('onContentAfterSave', [$this, 'contentAfterSave']);
        $dispatcher->addListener('onAfterGetMenuTypeOptions', [$this, 'afterGetMenuTypeOptions']);
    }

    public function onReservationAssetPrepareForm($form, $data)
    {
        if ($this->loadAssetFromManifest) {
            $this->loadFile($form, $data);
        }
    }

    protected function loadFile($form, $data, $namespace = null)
    {
        $name     = strtolower($this->_name);
        $load     = $form->loadFile(
            JPATH_PLUGINS . '/solidres/' . $name . '/' . $name . '.xml',
            true,
            '/extension/fields[@name="plugins"]'
        );
        $registry = new Registry($data);
        $id       = $registry->get('id');

        if ($load && $id) {
            $form->bind([
                    'plugins' => $this->getData($id, $namespace),
                ]
            );
        }

        return $load;
    }

    protected function getData($scopeId, $namespace = null)
    {
        $name = strtolower($this->_name);

        if (null === $namespace) {
            $namespace = 'plugins/' . $name;
        }

        $config = new Config(['scope_id' => $scopeId, 'data_namespace' => $namespace]);
        $data   = [];

        foreach ($config->getData() as $array) {
            [$key, $value] = $array;

            if (strpos($key, $namespace . '/') === 0) {
                $data[str_replace($namespace . '/', '', $key)] = $value;
            }
        }

        return $data;
    }

    /**
     * @param $data
     * @param $table
     * @param $result
     * @param $isNew
     *
     *
     * @since      version
     * @deprecated 4.0.0
     */
    public function onReservationAssetAfterSave($data, $table, $result, $isNew)
    {
        $this->assetAfterSave(
            new AfterSaveEvent(
                'onReservationAssetAfterSave',
                [
                    'data'    => $data,
                    'subject' => $table,
                    'result'  => $result,
                    'isNew'   => $isNew,
                    'context' => 'com_solidres.reservationasset',
                ]
            )
        );
    }

    public function assetAfterSave(AfterSaveEvent $event)
    {
        $table = $event->getArgument('subject');
        $data  = $event->getArgument('data');

        if (!$this->loadAssetFromManifest || empty($data['plugins'])) {
            return;
        }

        $name     = strtolower($this->_name);
        $saveData = [];

        foreach ($data['plugins'] as $k => $v) {
            if (is_array($v) || is_object($v)) {
                $registry = new Registry($v);
                $v        = $registry->toString();
            }

            if (strpos($k, $name) === 0) {
                $saveData[$k] = $v;
            }
        }

        if (is_callable([$this, 'prepareSaveData'])) {
            call_user_func_array([$this, 'prepareSaveData'], [$table, &$saveData]);
        }

        if (count($saveData)) {
            $config = new Config(['scope_id' => $table->id, 'data_namespace' => 'plugins/' . $name]);

            $config->set($saveData);
        }
    }

    public function afterGetMenuTypeOptions(AfterGetMenuTypeOptionsEvent $event) {
        $files = $this->getMenuTypeOptions();
        $model = $event->getModel();

        if (count($files)) {
            $list = $event->getItems();
            foreach ($files as $view => $file) {
                $o              = new CMSObject();
                $o->title       = ucfirst(basename($file));
                $o->description = '';
                $o->request     = ['option' => 'com_solidres', 'view' => $view];

                if ($xml = simplexml_load_file($file)) {
                    // Look for the first view node off of the root node.
                    if ($menu = $xml->xpath('layout[1]')) {
                        $menu = $menu[0];

                        // If the view is hidden from the menu, discard it and move on to the next view.
                        if (!empty($menu['hidden']) && $menu['hidden'] == 'true') {
                            unset($xml);
                            unset($o);
                            continue;
                        }

                        // Populate the title and description if they exist.
                        if (!empty($menu['title'])) {
                            $o->title = trim((string)$menu['title']);
                        }

                        if (!empty($menu->message[0])) {
                            $o->description = trim((string)$menu->message[0]);
                        }
                    }

                    $model->addReverseLookupUrl($o);
                    array_push($list['com_solidres'], $o);
                }
            }

            $event->updateItems($list);
        }
    }

    /**
     * @param $list
     * @param $model
     *
     *
     * @since 4.0.0
     * @deprecated 4.0.0
     */
    public function onAfterGetMenuTypeOptions(&$list, $model)
    {
        $this->afterGetMenuTypeOptions(
            new AfterGetMenuTypeOptionsEvent(
                'onAfterGetMenuTypeOptions',
                ['subject' => $model, 'items' => $list]
            )
        );
    }

    protected function getMenuTypeOptions()
    {
        return [];
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public function onContentPrepareForm(Form $form, $data)
    {
        $this->contentPrepareForm(new PrepareFormEvent('onContentPrepareForm', ['subject' => $form, 'data' => $data]));
    }

    public function contentPrepareForm(PrepareFormEvent $event)
    {
        $form = $event->getForm();
        $data = $event->getData();

        if ($this->loadAssetFromManifest
            && $form->getName() === 'com_solidres.experience'
            && PluginHelper::isEnabled('solidres', 'experience')
        ) {
            $name      = strtolower($this->_name);
            $namespace = 'plugins/experience/' . $name;
            $this->loadFile($form, $data, $namespace);
        }

        $files = $this->getMenuTypeOptions();
        $view  = array_keys($files);

        if ($data instanceof Registry) {
            $registry = $data;
        } else {
            $registry = new Registry($data);
        }

        if (count($view)
            && $registry->get('request.option') == 'com_solidres'
            && in_array($registry->get('request.view'), $view)
        ) {
            $viewKey = $registry->get('request.view');
            $file    = $files[$viewKey];

            if ($form->loadFile($file, true, '/metadata') == false) {
                throw new Exception(Text::_('JERROR_LOADFILE_FAILED'));
            }
        }
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public static function isEnabled(string $plgName)
    {
        if ($plgName === 'user') {
            return PluginHelper::isEnabled('user', 'solidres');
        }

        return PluginHelper::isEnabled('solidres', $plgName);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public function onSolidresPluginRegister()
    {
        $this->defines();

        if ($this->addIncludePath) {
            ControllerLegacy::addIncludePath($this->_getBasePath());
        }
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    protected function defines()
    {
        $plugin        = strtoupper($this->getPluginName());
        $pluginPath    = 'SR_PLUGIN_' . $plugin . '_PATH';
        $pluginEnabled = 'SR_PLUGIN_' . $plugin . '_ENABLED';

        if (!defined($pluginEnabled)) {
            define($pluginEnabled, true);
        }

        if (!defined($pluginPath)) {
            if ($plugin === 'USER') {
                define($pluginPath, JPATH_PLUGINS . '/user/solidres');
            } else {
                define($pluginPath, JPATH_PLUGINS . '/solidres/' . $this->_name);
            }
        }

        $adminPath = 'SR_PLUGIN_' . $plugin . '_ADMINISTRATOR';

        if (!defined($adminPath)) {
            define($adminPath, $this->_getAdminPath());
        }

        $sitePath = 'SR_PLUGIN_' . $plugin . '_SITE';

        if (!defined($sitePath)) {
            define($sitePath, $this->_getSitePath());
        }

        $basePath = 'SR_PLUGIN_' . $plugin . '_BASE';

        if (!defined($basePath)) {
            define($basePath, $this->_getBasePath());
        }

        if ($this->addIncludePath) {
            $adminPath = $this->_getAdminPath();
            $basePath  = $this->_getBasePath();
            Table::addIncludePath($adminPath . '/tables');
            BaseDatabaseModel::addIncludePath($adminPath . '/models', 'SolidresModel');
            BaseDatabaseModel::addIncludePath($basePath . '/models', 'SolidresModel');
        }
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    protected function getPluginName()
    {
        return $this->_name === 'solidres' && $this->_type === 'user' ? 'user' : $this->_name;
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public function _getAdminPath()
    {
        return static::getAdminPath($this->_name);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    protected function _getSitePath()
    {
        return static::getSitePath($this->_name);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    protected function _getBasePath()
    {
        return static::getBasePath($this->_name);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    public function onContentAfterSave($context, $table, $isNew)
    {
        $this->contentAfterSave(new AfterSaveEvent('onContentAfterSave', ['subject' => $table, 'data' => $isNew, 'context' => $context]));
    }


    public function contentAfterSave(AfterSaveEvent $event)
    {
        $context = $event->getArgument('context');
        $table   = $event->getArgument('subject');
        $data    = $this->getApplication()->input->get('jform', [], 'array');

        if (!$this->loadExperienceFromManifest
            || $context !== 'com_solidres.experience'
            || empty($data['plugins'])
            || !is_array($data['plugins'])
            || !PluginHelper::isEnabled('solidres', 'experience')
        ) {
            return;
        }

        $name     = strtolower($this->_name);
        $saveData = [];

        foreach ($data['plugins'] as $k => $v) {
            if (is_array($v) || is_object($v)) {
                $registry = new Registry($v);
                $v        = $registry->toString();
            }

            if (strpos($k, $name) === 0) {
                $saveData[$k] = $v;
            }
        }

        if (is_callable([$this, 'prepareSaveData'])) {
            call_user_func_array([$this, 'prepareSaveData'], [$table, &$saveData]);
        }

        if (count($saveData)) {
            $config = new Config(['scope_id' => $table->id, 'data_namespace' => 'plugins/experience/' . $name]);
            $config->set($saveData);
        }
    }

    public function getVersion($hash = false): ?string
    {
        return $hash ? static::$plgHashVersion : static::$plgVersion;
    }

    public function __get($name)
    {
        switch ($name) {
            case 'app':
                return $this->getApplication();

            case 'db':
                return $this->getDatabase();
        }

        throw new RuntimeException('Unknown property: ' . $name);
    }

    protected function renderLayout($layoutId, $displayData = [])
    {
        LayoutHelper::addIncludePath($this->rootPath . '/layouts');

        return LayoutHelper::render($layoutId, $displayData);
    }

    /**
     *
     * @deprecated
     * @since 4.0.0
     */
    protected function setPluginName($name)
    {
        return $this->_name;
    }
}
