<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Solidres\Type;

defined('_JEXEC') or die;

use DOMElement;

interface CustomFieldHelperInterface
{
    public static function storeValues();

    public static function cleanValues($conditions = []);

    public static function getCustomFields();

    public static function render($field, $useJqueryValidate = true);

    public static function loadData($data = [], $context = null);

    public static function setContext($text = '');

    public static function getValues($conditions = []);

    public static function findValues($conditions = [], $categories = []);

    public static function findFields($conditions = [], $categories = [], $langTag = null);

    public static function find($conditions = [], $findInValue = false, $categories = [], $langTag = null);

    public static function getAllFieldTitles($ignoreTranslation = false);

    public static function translateField($field, $langTag = null);

    public static function buildField(DOMElement $fieldSet, $fieldObject);

    public static function buildFields($source, $group = null, array $ignoreFieldNames = [], $categories = []);

    public static function setFieldDataValues($dataValues = null);

    public static function displayFieldValue($field, $default = null, $force = false);
}
