<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Database\DatabaseInterface;
use Joomla\Input\Input;
use Joomla\Utilities\ArrayHelper;
use stdClass;

class CustomersController extends AdminController
{
    public function __construct(
        $config = [],
        ?MVCFactoryInterface $factory = null,
        ?CMSWebApplicationInterface $app = null,
        ?Input $input = null
    ) {
        parent::__construct($config, $factory, $app, $input);

        $this->registerTask('block', 'changeBlock');
        $this->registerTask('unblock', 'changeBlock');
    }

    public function getModel($name = 'Customer', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    /**
     * Method to change the block status on a record.
     *
     * @return  void
     *
     * @since   0.3.0
     */
    public function changeBlock()
    {
        $this->checkToken();
        $ids = $this->input->get('cid', [], 'array');
        $values = ['block' => 1, 'unblock' => 0];
        $task = $this->getTask();
        $value = ArrayHelper::getValue($values, $task, 0, 'int');
        $app = Factory::getApplication();

        // Convert from customer ID to Joomla user ID
        $joomlaUserIds = [];
        $customerTable = $this->factory->createTable('Customer', 'Administrator');

        foreach ($ids as $id) {
            $customerTable->load($id);
            $joomlaUserIds[] = $customerTable->user_id;
        }

        if (empty($joomlaUserIds)) {
            $app->enqueueMessage(Text::_('SR_CUSTOMERS_NO_ITEM_SELECTED'), 'error');
        } else {
            // Get the model.
            $model = $app->bootComponent('com_users')->getMVCFactory()->createModel(
                'User',
                'Administrator',
                ['ignore_request' => true]
            );

            // Change the state of the records.
            if (!$model->block($joomlaUserIds, $value)) {
                $app->enqueueMessage($model->getError(), 'error');
            } else {
                if ($value == 1) {
                    $this->setMessage(Text::plural('SR_N_CUSTOMERS_BLOCKED', count($joomlaUserIds)));
                } elseif ($value == 0) {
                    $this->setMessage(Text::plural('SR_N_CUSTOMERS_UNBLOCKED', count($joomlaUserIds)));
                }
            }
        }

        $this->setRedirect('index.php?option=com_solidres&view=customers');
    }

    public function find()
    {
        $searchTerm = $this->input->get('term', '', 'string');
        $db         = Factory::getContainer()->get(DatabaseInterface::class);
        $model      = $this->factory->createModel('Customers', 'Administrator', ['ignore_request' => true]);
        $model->setState(
            'list.select',
            '
		a.id as value,  
		CONCAT(u.name, " (", a.id, " - " , (CASE WHEN ' . $db->quoteName(
                'g.name'
            ) . ' IS NOT NULL THEN ' . $db->quoteName('g.name') . ' ELSE ' . $db->quote(
                Text::_('SR_GENERAL_CUSTOMER_GROUP')
            ) . ' END ), ") ") as label
	    '
        );
        $model->setState('filter.searchterm', $searchTerm);

        $items = $model->getItems();

        $results = [];

        foreach ($items as $item) {
            $result        = new stdClass();
            $result->label = $item->label;
            $result->value = $item->value;
            $results[]     = $result;
        }

        echo json_encode($results);

        $this->app->close();
    }
}
