<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

defined('_JEXEC') or die;

use JLoader;
use Joomla\CMS\Factory;
use Solidres\MVC\Model\AdminModel;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\User\User;
use SolidresStripeHelper;

class CustomerModel extends AdminModel
{
    public function __construct($config = [])
    {
        parent::__construct($config);

        $this->event_after_delete = 'onCustomerAfterDelete';

        $this->event_after_save = 'onCustomerAfterSave';

        $this->event_before_delete = 'onCustomerBeforeDelete';

        $this->event_before_save = 'onCustomerBeforeSave';

        $this->event_change_state = 'onCustomerChangeState';

        $this->text_prefix = strtoupper($this->option);
    }

    public function getForm($data = [], $loadData = true)
    {
        $form = $this->loadForm('com_solidres.customer', 'customer', ['control' => 'jform', 'load_data' => $loadData]);

        if (empty($form)) {
            return false;
        }


        if (PluginHelper::isEnabled('solidres', 'customfield') && $form->getGroup('Solidres_fields')) {
            foreach ($form->getFieldset('fields') as $field) {
                $form->removeField($field->getAttribute('name'));
            }
        }

        if (PluginHelper::isEnabled('solidrespayment', 'stripe')) {
            JLoader::register('SolidresStripeHelper', JPATH_PLUGINS . '/solidrespayment/stripe/helpers/stripe.php');
            $customerProfileFormPath = JPATH_PLUGINS . '/solidrespayment/stripe/form/customer_profile.xml';
            $form->loadFile($customerProfileFormPath);
            $form->setValue(
                'stripe_customer_id',
                null,
                SolidresStripeHelper::getStripeCustomerId($form->getValue('id'))
            );
        }

        return $form;
    }

    /**
     * Prepare and sanitise the table prior to saving.
     *
     * @since    1.6
     */
    protected function prepareTable($table)
    {
        if ($table->customer_group_id === '' || $table->customer_group_id === 'NULL') {
            $table->customer_group_id = null;
        }

        if ($table->geo_state_id === '') {
            $table->geo_state_id = null;
        }
    }

    protected function canDelete($record)
    {
        $user = Factory::getApplication()->getIdentity();

        return $user->authorise('core.delete', 'com_solidres.customer.' . (int)$record->id);
    }

    protected function canEditState($record)
    {
        $user = Factory::getApplication()->getIdentity();

        return $user->authorise('core.edit.state', 'com_solidres.customer.' . (int)$record->id);
    }


    /**
     * Method to get a single record.
     *
     * @param   int    The id of the primary key.
     *
     * @return    mixed    Object on success, false on failure.
     * @since    1.6
     */
    public function getItem($pk = null)
    {
        $item = parent::getItem($pk);

        if ($item->id) {
            $userTable          = User::getTable();
            $customerGroupTable = parent::getTable('Customergroup', 'Administrator', ['ignore_request' => true]);
            $userTable->load($item->user_id);
            $customerGroupTable->load($item->customer_group_id);
            $item->name                = $userTable->name;
            $item->username            = $userTable->username;
            $item->email               = $userTable->email;
            $item->customer_group_name = '';

            /** @var  $customerGroupTable Table */

            if ($customerGroupTable->id > 0) {
                $item->customer_group_name = $customerGroupTable->name;
            }
        }

        return $item;
    }

    public function getTable($name = 'Customer', $prefix = 'Administrator', $options = [])
    {
        return parent::getTable($name, $prefix, $options);
    }

    protected function getReorderConditions($table = null)
    {
        $condition   = [];
        $condition[] = 'customer_group_id = ' . (int)$table->customer_group_id;

        return $condition;
    }
}
