<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Model;

use Joomla\CMS\Factory;
use Solidres\MVC\Model\AdminModel;

defined('_JEXEC') or die;

class CustomergroupModel extends AdminModel
{
    public function getTable($name = 'Customergroup', $prefix = 'Administrator', $options = [])
    {
        return parent::getTable($name, $prefix, $options);
    }

    protected function canDelete($record)
    {
        $user = Factory::getApplication()->getIdentity();

        return $user->authorise('core.delete', 'com_solidres.customergroup.' . (int)$record->id);
    }

    protected function canEditState($record)
    {
        $user = Factory::getApplication()->getIdentity();

        return $user->authorise('core.edit.state', 'com_solidres.customergroup.' . (int)$record->id);
    }
}
