<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Administrator\Table;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\Utilities\ArrayHelper;
use Joomla\Database\DatabaseDriver;

class CustomerTable extends Table
{
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__sr_customers', 'id', $db);
    }

    /**
     * Method to delete a row from the database table by primary key value.
     *
     * @param mixed $pk       An optional primary key value to delete.  If not set the
     *                        instance property value is used.
     *
     * @return  boolean  True on success.
     */
    public function delete($pk = null)
    {
        $k     = $this->_tbl_key;
        $pk    = (is_null($pk)) ? $this->$k : $pk;
        $query = $this->_db->getQuery(true);

        // If no primary key is given, return false.
        if ($pk === null) {
            return false;
        }

        $customField = PluginHelper::isEnabled('solidres', 'customfield');
        $pk          = (int)$pk;
        // Get Reservation Ids
        $query->clear()
            ->select($this->_db->quoteName('id'))
            ->from($this->_db->quoteName('#__sr_reservations'))
            ->where($this->_db->quoteName('customer_id') . ' = ' . $pk);
        $assetResIds = $this->_db->setQuery($query)->loadColumn();

        if ($assetResIds) {
            if ($customField) {
                foreach ($assetResIds as $resId) {
                    $query->clear()
                        ->delete($this->_db->quoteName('#__sr_customfield_values'))
                        ->where(
                            $this->_db->quoteName('context') . ' = ' . $this->_db->quote(
                                'com_solidres.customer.' . $resId
                            )
                        );
                    $this->_db->setQuery($query)
                        ->execute();
                }
            }

            $assetResIds = implode(',', ArrayHelper::toInteger($assetResIds));
        }

        // Take care of Reservation
        $query->clear()
            ->update($this->_db->quoteName('#__sr_reservations'))
            ->set($this->_db->quoteName('customer_id') . ' = NULL')
            ->where($this->_db->quoteName('customer_id') . ' = ' . $pk);
        $this->_db->setQuery($query)->execute();

        // Take care of Customer Fields
        $query->clear()
            ->delete()->from($this->_db->quoteName('#__sr_customer_fields'))
            ->where('user_id = ' . $pk);
        $this->_db->setQuery($query)->execute();

        // Take care of relationship with Property
        $query->clear()
            ->update($this->_db->quoteName('#__sr_reservation_assets'))
            ->set($this->_db->quoteName('partner_id') . ' = NULL')
            ->where($this->_db->quoteName('partner_id') . ' = ' . $pk);
        $this->_db->setQuery($query)->execute();

        // Experience
        $expResIds = [];

        if (PluginHelper::isEnabled('solidres', 'experience')) {
            // Get Reservation Ids
            $query->clear()
                ->select($this->_db->quoteName('id'))
                ->from($this->_db->quoteName('#__sr_experience_reservations'))
                ->where($this->_db->quoteName('customer_id') . ' = ' . $pk);
            $expResIds = $this->_db->setQuery($query)->loadColumn();

            if ($expResIds) {
                if ($customField) {
                    foreach ($expResIds as $resId) {
                        $query->clear()
                            ->delete($this->_db->quoteName('#__sr_customfield_values'))
                            ->where(
                                $this->_db->quoteName('context') . ' = ' . $this->_db->quote(
                                    'com_solidres.experience.customer.' . $resId
                                )
                            );
                        $this->_db->setQuery($query)
                            ->execute();
                    }
                }

                $expResIds = implode(',', ArrayHelper::toInteger($expResIds));
            }

            $query->clear()
                ->update($this->_db->quoteName('#__sr_experiences'))
                ->set($this->_db->quoteName('partner_id') . ' = NULL')
                ->where($this->_db->quoteName('partner_id') . ' = ' . $pk);
            $this->_db->setQuery($query)->execute();

            $query->clear()
                ->update($this->_db->quoteName('#__sr_experience_reservations'))
                ->set($this->_db->quoteName('user_id') . ' = NULL')
                ->set($this->_db->quoteName('customer_id') . ' = NULL')
                ->where($this->_db->quoteName('customer_id') . ' = ' . $pk);
            $this->_db->setQuery($query)->execute();
        }

        // Purge all feedback
        if (PluginHelper::isEnabled('solidres', 'feedback')) {
            $fbIds = [];

            if ($assetResIds) {
                $query->clear()
                    ->select($this->_db->quoteName('id'))
                    ->from($this->_db->quoteName('#__sr_feedbacks'))
                    ->where($this->_db->quoteName('scope') . ' = 0')
                    ->where($this->_db->quoteName('reservation_id') . ' IN (' . $assetResIds . ')');
                $fbIds = array_merge($fbIds, $this->_db->setQuery($query)->loadColumn() ?: []);
            }

            if ($expResIds) {
                $query->clear()
                    ->select($this->_db->quoteName('id'))
                    ->from($this->_db->quoteName('#__sr_feedbacks'))
                    ->where($this->_db->quoteName('scope') . ' = 1')
                    ->where($this->_db->quoteName('reservation_id') . ' IN (' . $expResIds . ')');
                $fbIds = array_merge($fbIds, $this->_db->setQuery($query)->loadColumn() ?: []);
            }

            if ($fbIds) {
                $fbIds = implode(',', ArrayHelper::toInteger($fbIds));
                $query->clear()
                    ->delete($this->_db->quoteName('#__sr_feedback_scores'))
                    ->where($this->_db->quoteName('feedback_id') . ' IN (' . $fbIds . ')');
                $this->_db->setQuery($query)->execute();

                $query->clear()
                    ->delete($this->_db->quoteName('#__sr_feedback_attribute_xref'))
                    ->where($this->_db->quoteName('feedback_id') . ' IN (' . $fbIds . ')');
                $this->_db->setQuery($query)->execute();

                $query->clear()
                    ->delete($this->_db->quoteName('#__sr_feedbacks'))
                    ->where($this->_db->quoteName('id') . ' IN (' . $fbIds . ')');
                $this->_db->setQuery($query)->execute();
            }

            $query->clear()
                ->update($this->_db->quoteName('#__sr_experience_reservations'))
                ->set($this->_db->quoteName('user_id') . ' = NULL')
                ->set($this->_db->quoteName('customer_id') . ' = NULL')
                ->where($this->_db->quoteName('customer_id') . ' = ' . $pk);
            $this->_db->setQuery($query)->execute();
        }

        $userId = (int)$this->user_id;

        if ($customField) {
            $query->clear()
                ->delete($this->_db->quoteName('#__sr_customfield_values'))
                ->where(
                    $this->_db->quoteName('context') . ' = ' . $this->_db->quote(
                        'com_solidres.customer.profile.' . $userId
                    ),
                    'OR'
                )
                ->where($this->_db->quoteName('context') . ' = ' . $this->_db->quote('com_solidres.customer.' . $pk));
            $this->_db->setQuery($query)
                ->execute();
        }

        // Also remove corresponding Joomla users
        $userModel = Factory::getApplication()
            ->bootComponent('com_users')->getMVCFactory()
            ->createModel('User', 'Administrator', ['ignore_request' => true]);
        $userModel->delete($userId);

        // Delete it
        return parent::delete($pk);
    }
}

