<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\Controller;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\User\UserHelper;

defined('_JEXEC') or die;

/**
 * @package       Solidres
 * @subpackage    User
 * @since         0.8.0
 */
class UserController extends BaseController
{
    /**
     * Check to see if the username exists
     *
     * @return json
     */
    public function check()
    {
        $username = $this->input->getString('username', '');
        $id       = UserHelper::getUserId($username);
        $status   = true;

        if ($id) {
            $status = false;
        }

        echo json_encode($status);
        $this->app->close();
    }
}
