<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\Component\Solidres\Administrator\Model\ReservationModel;
use Joomla\Component\Solidres\Administrator\Table\CustomerTable;

class MyreservationModel extends ReservationModel
{
    public function getReturnPage()
    {
        $return = $this->getState('return_page');

        return $return ? base64_encode($return) : Route::_('index.php?option=com_solidres&view=customer', false);
    }

    public function getForm($data = [], $loadData = true)
    {
        $form = $this->loadForm(
            'com_solidres.reservation',
            'myreservation',
            ['control' => 'jform', 'load_data' => $loadData]
        );
        if (empty($form)) {
            return false;
        }

        return $form;
    }

    protected function populateState()
    {
        $app = Factory::getApplication();

        // Load state from the request.
        $pk = $app->input->getInt('id');
        $this->setState($this->getName() . '.id', $pk);

        $return = $app->input->get('return', null, 'base64');
        $this->setState('return_page', base64_decode($return));

        // Load the parameters.
        $params = $app->getParams();
        $this->setState('params', $params);

        $this->setState('layout', $app->input->get('layout'));
    }

    protected function loadFormData()
    {
        $data = parent::loadFormData();

        /** @var CustomerTable $tableCustomer */
        $tableCustomer = $this->getTable('Customer');
        $tableCustomer->load(['user_id' => Factory::getApplication()->getIdentity()->id]);

        // Check for a valid user and that they are the owner.
        if ($tableCustomer->id == $data->customer_id) {
            $data->params['access-edit'] = true;
        } else {
            $data->params['access-edit'] = false;
        }

        return $data;
    }
}
