<?php
/**
 * ------------------------------------------------------------------------
 * SOLIDRES - Accommodation booking extension for Joomla
 * ------------------------------------------------------------------------
 * @author    Solidres Team <contact@solidres.com>
 * @website   https://www.solidres.com
 * @copyright Copyright (C) 2013 Solidres. All Rights Reserved.
 * @license   GNU General Public License version 3, or later
 * ------------------------------------------------------------------------
 */

namespace Joomla\Component\Solidres\Site\View\Customer;

defined('_JEXEC') or die;

use Exception;
use JLoader;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Solidres\MVC\View\HtmlView as SolidresHtmlView;

class HtmlView extends SolidresHtmlView
{
    protected $state;
    protected $items;
    protected $pagination;
    protected $wishlist;
    protected $cancellationState;

    public function display($tpl = null)
    {
        $user   = $this->getCurrentUser();
        $app    = Factory::getApplication();
        $Itemid = $app->input->getUint('Itemid', 0);

        if ($user->guest) {
            $return = Uri::getInstance()->toString();
            $app->redirect(Route::_('index.php?option=com_users&view=login&return=' . base64_encode($return), false));

            return false;
        }

        if ($errors = $this->get('Errors')) {
            throw new Exception(implode(PHP_EOL, $errors), 500);
        }

        $solidresConfig          = ComponentHelper::getParams('com_solidres');
        $customerUserGroups      = $solidresConfig->get('customer_user_groups', []);
        $userGroups              = $user->getAuthorisedGroups();
        $access                  = false;
        $this->cancellationState = $solidresConfig->get('cancel_state', 4);

        foreach ($customerUserGroups as $customerUserGroup) {
            if (in_array($customerUserGroup, $userGroups)) {
                $access = true;
                break;
            }
        }

        if (!$access) {
            $app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
            $app->setHeader('status', 403, true);

            return false;
        }

        $mainActivity = $solidresConfig->get('main_activity', '');

        if ($mainActivity === '1'
            && PluginHelper::isEnabled('solidres', 'experience')
            && $app->input->get('view') === 'customer'
            && $this->getLayout() !== 'wishlist'
        ) {
            $app->redirect(Route::_("index.php?option=com_solidres&view=myexperiences&Itemid=$Itemid", false));
        }

        $mvcFactory    = $app->bootComponent('com_solidres')->getMVCFactory();
        $customerTable = $mvcFactory->createTable('Customer', 'Administrator');
        $customerTable->load(['user_id' => $user->get('id')]);

        $this->modelReservations = $mvcFactory->createModel('Myreservations', 'Site', ['ignore_request' => false]);
        $this->modelAsset        = $mvcFactory->createModel(
            'Reservationasset',
            'Administrator',
            ['ignore_request' => false]
        );
        $this->modelReservations->setState('list.ordering', 'r.created_date');
        $this->modelReservations->setState('list.direction', 'DESC');
        $this->modelReservations->setState('filter.customer_id', $customerTable->id ?? 0);
        $this->modelReservations->setState('filter.customer_email', $user->get('email'));
        $this->modelReservations->setState('filter.is_customer_dashboard', 1);
        $this->pagination   = $this->modelReservations->getPagination();
        $this->itemid       = Factory::getApplication()->input->get('Itemid');
        $this->reservations = $this->modelReservations->getItems();

        $this->unapprovedReservations = 0;
        if (!empty($this->reservations)) {
            foreach ($this->reservations as $reservation) {
                if (!$reservation->is_approved) {
                    $this->unapprovedReservations++;
                }
            }
        }

        // Get the filter locations list
        $this->filterLocations = $this->modelReservations->getLocations();
        $this->filterAssets    = $this->modelReservations->getAssets();

        if (PluginHelper::isEnabled('solidres', 'feedback') && $this->getLayout() == 'feedbacks') {
            $modelFeedback = $mvcFactory->createModel('Feedbacklist', 'Site');
            $modelFeedback->setState('filter.customer_id', $this->modelReservations->getState('filter.customer_id'));
            $modelFeedback->set('filterFormName', 'filter_feedbacks');
            $feedbackView = $mvcFactory->createView('Feedbacks', $this->getDocument()->getType(), 'Site');
            $feedbackView->setModel($modelFeedback, true);
            $feedbackView->set('items', $modelFeedback->getItems());
            $feedbackView->set('state', $modelFeedback->getState());
            $feedbackView->set('pagination', $modelFeedback->getPagination());
            $feedbackView->set('filterForm', $modelFeedback->getFilterForm());
            $feedbackView->set('activeFilters', $modelFeedback->getActiveFilters());
            $feedbackView->set(
                'formRoute',
                Route::_("index.php?option=com_solidres&view=customer&layout=feedbacks&Itemid=$Itemid", false)
            );
            $this->set('feedbackView', $feedbackView);
            $this->addTemplatePath(JPATH_PLUGINS . '/solidres/feedback/tmpl/feedbacks');
        }

        HTMLHelper::_('jquery.framework');
        HTMLHelper::_('bootstrap.framework');

        if (PluginHelper::isEnabled('solidres', 'hub') || PluginHelper::isEnabled('solidres', 'experience')) {
            $type         = Factory::getDocument()->getType();
            $wishListView = $mvcFactory->createView('Wishlist', $type, 'Site');

            if ($wishListView) {
                ob_start();
                $wishListView->display();
                $this->wishlist = ob_get_clean();
            }
        }

        parent::display($tpl);
    }
}
